/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.base.MoreObjects;
import com.mojang.serialization.MapCodec;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTripwire;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.event.block.BlockRedstoneEvent;

public class BlockTripwireHook
extends Block {
    public static final MapCodec<BlockTripwireHook> a = BlockTripwireHook.b(BlockTripwireHook::new);
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.e;
    public static final BlockStateBoolean c = BlockProperties.A;
    public static final BlockStateBoolean d = BlockProperties.a;
    protected static final int e = 1;
    protected static final int f = 42;
    private static final int g = 10;
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.c(Block.a(6.0, 0.0, 10.0, 10.0, 16.0));

    public MapCodec<BlockTripwireHook> a() {
        return a;
    }

    public BlockTripwireHook(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(c, false)).b(d, false));
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return h.get(state.c(b));
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection direction = state.c(b);
        BlockPosition blockPos = pos.a(direction.g());
        IBlockData blockState = level.a_(blockPos);
        return direction.o().d() && blockState.c((IBlockAccess)level, blockPos, direction);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction.g() == state.c(b) && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        EnumDirection[] nearestLookingDirections;
        IBlockData blockState = (IBlockData)((IBlockData)this.m().b(c, false)).b(d, false);
        World level = context.q();
        BlockPosition clickedPos = context.a();
        for (EnumDirection direction : nearestLookingDirections = context.f()) {
            EnumDirection opposite;
            if (!direction.o().d() || !(blockState = (IBlockData)blockState.b(b, opposite = direction.g())).a((IWorldReader)level, clickedPos)) continue;
            return blockState;
        }
        return null;
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack stack) {
        BlockTripwireHook.a(level, pos, state, false, false, -1, null);
    }

    public static void a(World level, BlockPosition pos, IBlockData hookState, boolean attaching, boolean shouldNotifyNeighbours, int searchRange, @Nullable IBlockData state) {
        Optional<EnumDirection> optionalValue = hookState.d(b);
        if (optionalValue.isPresent()) {
            EnumDirection direction = optionalValue.get();
            boolean flag = hookState.d(d).orElse(false);
            boolean flag1 = hookState.d(c).orElse(false);
            Block block = hookState.b();
            boolean flag2 = !attaching;
            boolean flag3 = false;
            int i2 = 0;
            IBlockData[] blockStates = new IBlockData[42];
            for (int i1 = 1; i1 < 42; ++i1) {
                BlockPosition blockPos = pos.a(direction, i1);
                IBlockData blockState = level.a_(blockPos);
                if (blockState.a(Blocks.gg)) {
                    if (blockState.c(b) != direction.g()) break;
                    i2 = i1;
                    break;
                }
                if (!blockState.a(Blocks.gh) && i1 != searchRange) {
                    blockStates[i1] = null;
                    flag2 = false;
                    continue;
                }
                if (i1 == searchRange) {
                    blockState = (IBlockData)MoreObjects.firstNonNull((Object)state, (Object)blockState);
                }
                boolean flag4 = blockState.c(BlockTripwire.d) == false;
                boolean poweredValue = blockState.c(BlockTripwire.b);
                flag3 |= flag4 && poweredValue;
                blockStates[i1] = blockState;
                if (i1 != searchRange) continue;
                level.a(pos, block, 10);
                flag2 &= flag4;
            }
            IBlockData blockState1 = (IBlockData)((IBlockData)block.m().c(d, flag2)).c(c, flag3 &= (flag2 &= i2 > 1));
            boolean cancelledEmitterHook = false;
            boolean cancelledReceiverHook = false;
            boolean wasPowered = flag1;
            boolean willBePowered = flag3;
            if (i2 > 0) {
                BlockPosition blockPosx = pos.a(direction, i2);
                if (wasPowered != willBePowered) {
                    int newCurrent = willBePowered ? 15 : 0;
                    BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, blockPosx), wasPowered ? 15 : 0, newCurrent);
                    event.callEvent();
                    boolean bl = cancelledReceiverHook = event.getNewCurrent() != newCurrent;
                }
                if (!cancelledReceiverHook) {
                    EnumDirection opposite = direction.g();
                    level.a(blockPosx, (IBlockData)blockState1.b(b, opposite), 3);
                    BlockTripwireHook.a(block, level, blockPosx, opposite);
                    BlockTripwireHook.a(level, blockPosx, flag2, flag3, flag, flag1);
                }
            }
            if (wasPowered != willBePowered) {
                int newCurrent = willBePowered ? 15 : 0;
                BlockRedstoneEvent event = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), wasPowered ? 15 : 0, newCurrent);
                event.callEvent();
                boolean bl = cancelledEmitterHook = event.getNewCurrent() != newCurrent;
            }
            if (!cancelledEmitterHook) {
                BlockTripwireHook.a(level, pos, flag2, flag3, flag, flag1);
                if (!attaching) {
                    if (GlobalConfiguration.get().unsupportedSettings.skipTripwireHookPlacementValidation || level.a_(pos).a(Blocks.gg)) {
                        level.a(pos, (IBlockData)blockState1.b(b, direction), 3);
                    }
                    if (shouldNotifyNeighbours) {
                        BlockTripwireHook.a(block, level, pos, direction);
                    }
                }
            }
            if (flag != flag2) {
                for (int i22 = 1; i22 < i2; ++i22) {
                    IBlockData blockState3;
                    BlockPosition blockPos1 = pos.a(direction, i22);
                    IBlockData blockState2 = blockStates[i22];
                    if (blockState2 == null || !(blockState3 = level.a_(blockPos1)).a(Blocks.gh) && !blockState3.a(Blocks.gg) || GlobalConfiguration.get().blockUpdates.disableTripwireUpdates && blockState3.a(Blocks.gh)) continue;
                    level.a(blockPos1, (IBlockData)blockState2.c(d, flag2), 3);
                }
            }
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        BlockTripwireHook.a(level, pos, state, false, true, -1, null);
    }

    private static void a(World level, BlockPosition pos, boolean attached, boolean powered, boolean wasAttached, boolean wasPowered) {
        if (powered && !wasPowered) {
            level.a(null, pos, SoundEffects.AO, SoundCategory.e, 0.4f, 0.6f);
            level.a(null, GameEvent.a, pos);
        } else if (!powered && wasPowered) {
            level.a(null, pos, SoundEffects.AN, SoundCategory.e, 0.4f, 0.5f);
            level.a(null, GameEvent.e, pos);
        } else if (attached && !wasAttached) {
            level.a(null, pos, SoundEffects.AM, SoundCategory.e, 0.4f, 0.7f);
            level.a(null, GameEvent.b, pos);
        } else if (!attached && wasAttached) {
            level.a(null, pos, SoundEffects.AP, SoundCategory.e, 0.4f, 1.2f / (level.A.i() * 0.2f + 0.9f));
            level.a(null, GameEvent.g, pos);
        }
    }

    private static void a(Block block, World level, BlockPosition pos, EnumDirection direction) {
        EnumDirection opposite = direction.g();
        Orientation orientation = ExperimentalRedstoneUtils.a(level, opposite, EnumDirection.b);
        level.a(pos, block, orientation);
        level.a(pos.a(opposite), block, orientation);
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (!movedByPiston) {
            boolean attachedValue = state.c(d);
            boolean poweredValue = state.c(c);
            if (attachedValue || poweredValue) {
                BlockTripwireHook.a(level, pos, state, true, false, -1, null);
            }
            if (poweredValue) {
                BlockTripwireHook.a(this, (World)level, pos, state.c(b));
            }
        }
    }

    @Override
    protected int a(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        return blockState.c(c) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData blockState, IBlockAccess blockAccess, BlockPosition pos, EnumDirection side) {
        if (!blockState.c(c).booleanValue()) {
            return 0;
        }
        return blockState.c(b) == side ? 15 : 0;
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }
}

