/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.entity.EntityInsideBlockEvent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.entity.Entity;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class BlockWitherRose
extends BlockFlowers {
    public static final MapCodec<BlockWitherRose> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockFlowers.b.forGetter(BlockFlowers::c), BlockWitherRose.t()).apply((Applicative)instance, BlockWitherRose::new));

    public MapCodec<BlockWitherRose> a() {
        return a;
    }

    public BlockWitherRose(Holder<MobEffectList> holder, float f2, BlockBase.Info properties) {
        this(BlockWitherRose.a(holder, f2), properties);
    }

    public BlockWitherRose(SuspiciousStewEffects suspiciousStewEffects, BlockBase.Info properties) {
        super(suspiciousStewEffects, properties);
    }

    @Override
    protected boolean b(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return super.b(state, level, pos) || state.a(Blocks.em) || state.a(Blocks.en) || state.a(Blocks.eo);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        VoxelShape shape = this.a(state, (IBlockAccess)level, pos, VoxelShapeCollision.a());
        Vec3D center = shape.a().f();
        double d2 = (double)pos.u() + center.d;
        double d1 = (double)pos.w() + center.f;
        for (int i2 = 0; i2 < 3; ++i2) {
            if (!random.h()) continue;
            level.a(Particles.ah, d2 + random.j() / 5.0, (double)pos.v() + (0.5 - random.j()), d1 + random.j() / 5.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, net.minecraft.world.entity.Entity entity, InsideBlockEffectApplier effectApplier) {
        if (!new EntityInsideBlockEvent((Entity)entity.getBukkitEntity(), (Block)CraftBlock.at(level, pos)).callEvent()) {
            return;
        }
        if (level instanceof WorldServer) {
            EntityLiving livingEntity;
            WorldServer serverLevel = (WorldServer)level;
            if (level.an() != EnumDifficulty.a && entity instanceof EntityLiving && !(livingEntity = (EntityLiving)entity).a(serverLevel, level.al().r())) {
                livingEntity.addEffect(this.b(), EntityPotionEffectEvent.Cause.WITHER_ROSE);
            }
        }
    }

    @Override
    public MobEffect b() {
        return new MobEffect(MobEffects.t, 40);
    }
}

