/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.tags.TagsItem;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.ChiseledBookShelfBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class ChiseledBookShelfBlock
extends BlockTileEntity {
    public static final MapCodec<ChiseledBookShelfBlock> a = ChiseledBookShelfBlock.b(ChiseledBookShelfBlock::new);
    private static final int d = 6;
    public static final int b = 3;
    public static final List<BlockStateBoolean> c = List.of(BlockProperties.bs, BlockProperties.bt, BlockProperties.bu, BlockProperties.bv, BlockProperties.bw, BlockProperties.bx);

    public MapCodec<ChiseledBookShelfBlock> a() {
        return a;
    }

    public ChiseledBookShelfBlock(BlockBase.Info properties) {
        super(properties);
        IBlockData blockState = (IBlockData)this.C.b().b(BlockFacingHorizontal.e, EnumDirection.c);
        for (BlockStateBoolean booleanProperty : c) {
            blockState = (IBlockData)blockState.b(booleanProperty, false);
        }
        this.l(blockState);
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            if (!stack.a(TagsItem.bb)) {
                return EnumInteractionResult.f;
            }
            OptionalInt hitSlot = this.a(hitResult, state);
            if (hitSlot.isEmpty()) {
                return EnumInteractionResult.e;
            }
            if (((Boolean)state.c(c.get(hitSlot.getAsInt()))).booleanValue()) {
                return EnumInteractionResult.f;
            }
            ChiseledBookShelfBlock.a(level, pos, player, chiseledBookShelfBlockEntity, stack, hitSlot.getAsInt());
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    @Override
    protected EnumInteractionResult a(IBlockData state, World level, BlockPosition pos, EntityHuman player, MovingObjectPositionBlock hitResult) {
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            OptionalInt hitSlot = this.a(hitResult, state);
            if (hitSlot.isEmpty()) {
                return EnumInteractionResult.e;
            }
            if (!((Boolean)state.c(c.get(hitSlot.getAsInt()))).booleanValue()) {
                return EnumInteractionResult.c;
            }
            ChiseledBookShelfBlock.a(level, pos, player, chiseledBookShelfBlockEntity, hitSlot.getAsInt());
            return EnumInteractionResult.a;
        }
        return EnumInteractionResult.e;
    }

    public OptionalInt a(MovingObjectPositionBlock hitReselt, IBlockData state) {
        return ChiseledBookShelfBlock.a(hitReselt, state.c(BlockFacingHorizontal.e)).map(vec2 -> {
            int i2 = vec2.k >= 0.5f ? 0 : 1;
            int section = ChiseledBookShelfBlock.a(vec2.j);
            return OptionalInt.of(section + i2 * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static Optional<Vec2F> a(MovingObjectPositionBlock hitResult, EnumDirection face) {
        EnumDirection direction = hitResult.c();
        if (face != direction) {
            return Optional.empty();
        }
        BlockPosition blockPos = hitResult.b().a(direction);
        Vec3D vec3 = hitResult.g().a(blockPos.u(), (double)blockPos.v(), (double)blockPos.w());
        double x2 = vec3.a();
        double y2 = vec3.b();
        double z2 = vec3.c();
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case EnumDirection.c -> Optional.of(new Vec2F((float)(1.0 - x2), (float)y2));
            case EnumDirection.d -> Optional.of(new Vec2F((float)x2, (float)y2));
            case EnumDirection.e -> Optional.of(new Vec2F((float)z2, (float)y2));
            case EnumDirection.f -> Optional.of(new Vec2F((float)(1.0 - z2), (float)y2));
            case EnumDirection.a, EnumDirection.b -> Optional.empty();
        };
    }

    public static int a(float x2) {
        float f2 = 0.0625f;
        float f1 = 0.375f;
        if (x2 < 0.375f) {
            return 0;
        }
        float f22 = 0.6875f;
        return x2 < 0.6875f ? 1 : 2;
    }

    private static void a(World level, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, ItemStack bookStack, int slot) {
        if (!level.C) {
            player.b(StatisticList.c.b(bookStack.h()));
            SoundEffect soundEvent = bookStack.a(Items.vG) ? SoundEffects.fe : SoundEffects.fd;
            blockEntity.a(slot, bookStack.b(1, (EntityLiving)player));
            level.a(null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
        }
    }

    private static void a(World level, BlockPosition pos, EntityHuman player, ChiseledBookShelfBlockEntity blockEntity, int slot) {
        if (!level.C) {
            ItemStack itemStack = blockEntity.a(slot, 1);
            SoundEffect soundEvent = itemStack.a(Items.vG) ? SoundEffects.fh : SoundEffects.fg;
            level.a(null, pos, soundEvent, SoundCategory.e, 1.0f, 1.0f);
            if (!player.gj().g(itemStack)) {
                player.a(itemStack, false);
            }
            level.a((Entity)player, GameEvent.c, pos);
        }
    }

    @Override
    @Nullable
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new ChiseledBookShelfBlockEntity(pos, state);
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(new IBlockState[]{BlockFacingHorizontal.e});
        c.forEach(property -> builder.a(new IBlockState[]{property}));
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        InventoryUtils.a(state, level, pos);
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)this.m().b(BlockFacingHorizontal.e, context.g().g());
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(BlockFacingHorizontal.e, rotation.a(state.c(BlockFacingHorizontal.e)));
    }

    @Override
    public IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(BlockFacingHorizontal.e)));
    }

    @Override
    protected boolean c_(IBlockData state) {
        return true;
    }

    @Override
    protected int a(IBlockData state, World level, BlockPosition pos) {
        int n2;
        if (level.A_()) {
            return 0;
        }
        TileEntity tileEntity = level.c_(pos);
        if (tileEntity instanceof ChiseledBookShelfBlockEntity) {
            ChiseledBookShelfBlockEntity chiseledBookShelfBlockEntity = (ChiseledBookShelfBlockEntity)tileEntity;
            n2 = chiseledBookShelfBlockEntity.j() + 1;
        } else {
            n2 = 0;
        }
        return n2;
    }
}

