/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockRedstoneEvent;

public class LightningRodBlock
extends RodBlock
implements IBlockWaterlogged {
    public static final MapCodec<LightningRodBlock> b = LightningRodBlock.b(LightningRodBlock::new);
    public static final BlockStateBoolean c = BlockProperties.I;
    public static final BlockStateBoolean d = BlockProperties.A;
    private static final int f = 8;
    public static final int e = 128;
    private static final int g = 200;

    public MapCodec<LightningRodBlock> a() {
        return b;
    }

    public LightningRodBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(BlockDirectional.a, EnumDirection.b)).b(c, false)).b(d, false));
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        Fluid fluidState = context.q().b_(context.a());
        boolean flag = fluidState.a() == FluidTypes.c;
        return (IBlockData)((IBlockData)this.m().b(BlockDirectional.a, context.k())).b(c, flag);
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(c).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        return super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(c) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected int a(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return state.c(d) != false ? 15 : 0;
    }

    @Override
    protected int b(IBlockData state, IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return state.c(d) != false && state.c(BlockDirectional.a) == direction ? 15 : 0;
    }

    public void d(IBlockData state, World level, BlockPosition pos) {
        boolean powered = state.c(d);
        int old = powered ? 15 : 0;
        int current = !powered ? 15 : 0;
        BlockRedstoneEvent eventRedstone = new BlockRedstoneEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), old, current);
        level.getCraftServer().getPluginManager().callEvent((Event)eventRedstone);
        if (eventRedstone.getNewCurrent() <= 0) {
            return;
        }
        level.a(pos, (IBlockData)state.b(d, true), 3);
        this.e(state, level, pos);
        level.a(pos, (Block)this, 8);
        level.c(3002, pos, state.c(BlockDirectional.a).o().ordinal());
    }

    private void e(IBlockData state, World level, BlockPosition pos) {
        EnumDirection opposite = state.c(BlockDirectional.a).g();
        level.a(pos.a(opposite), (Block)this, ExperimentalRedstoneUtils.a(level, opposite, null));
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        level.a(pos, (IBlockData)state.b(d, false), 3);
        this.e(state, level, pos);
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        if (level.ag() && (long)level.A.a(200) <= level.ae() % 200L && pos.v() == level.a(HeightMap.Type.b, pos.u(), pos.w()) - 1) {
            ParticleUtils.a(state.c(BlockDirectional.a).o(), level, pos, 0.125, Particles.aW, UniformInt.a(1, 2));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, boolean movedByPiston) {
        if (state.c(d).booleanValue()) {
            this.e(state, level, pos);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean movedByPiston) {
        if (!state.a(oldState.b()) && state.c(d).booleanValue() && !level.U().a(pos, this)) {
            level.a(pos, (IBlockData)state.b(d, false), 18);
        }
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockDirectional.a, d, c);
    }

    @Override
    protected boolean f_(IBlockData state) {
        return true;
    }
}

