/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IBlockFragilePlantElement;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyWallHeight;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class MossyCarpetBlock
extends Block
implements IBlockFragilePlantElement {
    public static final MapCodec<MossyCarpetBlock> a = MossyCarpetBlock.b(MossyCarpetBlock::new);
    public static final BlockStateBoolean b = BlockProperties.d;
    public static final BlockStateEnum<BlockPropertyWallHeight> c = BlockProperties.aa;
    public static final BlockStateEnum<BlockPropertyWallHeight> d = BlockProperties.Z;
    public static final BlockStateEnum<BlockPropertyWallHeight> e = BlockProperties.ab;
    public static final BlockStateEnum<BlockPropertyWallHeight> f = BlockProperties.ac;
    public static final Map<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> g = ImmutableMap.copyOf((Map)Maps.newEnumMap(Map.of(EnumDirection.c, c, EnumDirection.f, d, EnumDirection.d, e, EnumDirection.e, f)));
    private final Function<IBlockData, VoxelShape> h;

    public MapCodec<MossyCarpetBlock> a() {
        return a;
    }

    public MossyCarpetBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, true)).b(c, BlockPropertyWallHeight.a)).b(d, BlockPropertyWallHeight.a)).b(e, BlockPropertyWallHeight.a)).b(f, BlockPropertyWallHeight.a));
        this.h = this.b();
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return VoxelShapes.a();
    }

    public Function<IBlockData, VoxelShape> b() {
        Map<EnumDirection, VoxelShape> map = VoxelShapes.c(Block.a(16.0, 0.0, 10.0, 0.0, 1.0));
        Map<EnumDirection, VoxelShape> map1 = VoxelShapes.d(Block.c(16.0, 0.0, 1.0));
        return this.a((IBlockData blockState) -> {
            VoxelShape voxelShape = blockState.c(b) != false ? (VoxelShape)map1.get(EnumDirection.a) : VoxelShapes.a();
            block4: for (Map.Entry<EnumDirection, BlockStateEnum<BlockPropertyWallHeight>> entry : g.entrySet()) {
                switch ((BlockPropertyWallHeight)blockState.c(entry.getValue())) {
                    default: {
                        continue block4;
                    }
                    case b: {
                        voxelShape = VoxelShapes.a(voxelShape, (VoxelShape)map.get(entry.getKey()));
                        continue block4;
                    }
                    case c: 
                }
                voxelShape = VoxelShapes.a(voxelShape, (VoxelShape)map1.get(entry.getKey()));
            }
            return voxelShape.c() ? VoxelShapes.b() : voxelShape;
        });
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return this.h.apply(state);
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(b) != false ? this.h.apply(this.m()) : VoxelShapes.a();
    }

    @Override
    protected boolean e_(IBlockData state) {
        return true;
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.e());
        return state.c(b).booleanValue() ? !blockState.l() : blockState.a(this) && blockState.c(b) != false;
    }

    private static boolean o(IBlockData state) {
        if (state.c(b).booleanValue()) {
            return true;
        }
        for (BlockStateEnum<BlockPropertyWallHeight> enumProperty : g.values()) {
            if (state.c(enumProperty) == BlockPropertyWallHeight.a) continue;
            return true;
        }
        return false;
    }

    private static boolean a(IBlockAccess level, BlockPosition pos, EnumDirection direction) {
        return direction != EnumDirection.b && MultifaceBlock.a(level, pos, direction);
    }

    private static IBlockData a(IBlockData state, IBlockAccess level, BlockPosition pos, boolean tip) {
        BlockBase.BlockData blockState = null;
        BlockBase.BlockData blockState1 = null;
        tip |= state.c(b).booleanValue();
        for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
            BlockPropertyWallHeight wallSide;
            BlockStateEnum<BlockPropertyWallHeight> propertyForFace = MossyCarpetBlock.a(direction);
            BlockPropertyWallHeight blockPropertyWallHeight = MossyCarpetBlock.a(level, pos, direction) ? (tip ? BlockPropertyWallHeight.b : state.c(propertyForFace)) : (wallSide = BlockPropertyWallHeight.a);
            if (wallSide == BlockPropertyWallHeight.b) {
                if (blockState == null) {
                    blockState = level.a_(pos.d());
                }
                if (blockState.a(Blocks.uf) && blockState.c(propertyForFace) != BlockPropertyWallHeight.a && !blockState.c(b).booleanValue()) {
                    wallSide = BlockPropertyWallHeight.c;
                }
                if (!state.c(b).booleanValue()) {
                    if (blockState1 == null) {
                        blockState1 = level.a_(pos.e());
                    }
                    if (blockState1.a(Blocks.uf) && blockState1.c(propertyForFace) == BlockPropertyWallHeight.a) {
                        wallSide = BlockPropertyWallHeight.a;
                    }
                }
            }
            state = (IBlockData)state.b(propertyForFace, wallSide);
        }
        return state;
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        return MossyCarpetBlock.a(this.m(), (IBlockAccess)context.q(), context.a(), true);
    }

    public static void a(GeneratorAccess level, BlockPosition pos, RandomSource random, int flags) {
        IBlockData blockState = Blocks.uf.m();
        IBlockData updatedState = MossyCarpetBlock.a(blockState, (IBlockAccess)level, pos, true);
        level.a(pos, updatedState, flags);
        IBlockData blockState1 = MossyCarpetBlock.a((IBlockAccess)level, pos, random::h);
        if (!blockState1.l()) {
            level.a(pos.d(), blockState1, flags);
            IBlockData updatedState1 = MossyCarpetBlock.a(updatedState, (IBlockAccess)level, pos, true);
            level.a(pos, updatedState1, flags);
        }
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, @Nullable EntityLiving placer, ItemStack stack) {
        if (!level.C) {
            RandomSource random = level.G_();
            IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)level, pos, random::h);
            if (!blockState.l()) {
                level.a(pos.d(), blockState, 3);
            }
        }
    }

    private static IBlockData a(IBlockAccess level, BlockPosition pos, BooleanSupplier placeSide) {
        BlockPosition blockPos = pos.d();
        IBlockData blockState = level.a_(blockPos);
        boolean isPaleMossCarpet = blockState.a(Blocks.uf);
        if (!(isPaleMossCarpet && blockState.c(b).booleanValue() || !isPaleMossCarpet && !blockState.v())) {
            IBlockData blockState1 = (IBlockData)Blocks.uf.m().b(b, false);
            IBlockData updatedState = MossyCarpetBlock.a(blockState1, level, pos.d(), true);
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                BlockStateEnum<BlockPropertyWallHeight> propertyForFace = MossyCarpetBlock.a(direction);
                if (updatedState.c(propertyForFace) == BlockPropertyWallHeight.a || placeSide.getAsBoolean()) continue;
                updatedState = (IBlockData)updatedState.b(propertyForFace, BlockPropertyWallHeight.a);
            }
            return MossyCarpetBlock.o(updatedState) && updatedState != blockState ? updatedState : Blocks.a.m();
        }
        return Blocks.a.m();
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (!state.a(level, pos)) {
            return Blocks.a.m();
        }
        IBlockData updatedState = MossyCarpetBlock.a(state, level, pos, false);
        return !MossyCarpetBlock.o(updatedState) ? Blocks.a.m() : updatedState;
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d, e, f);
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return switch (rotation) {
            case EnumBlockRotation.c -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(e))).b(d, state.c(f))).b(e, state.c(c))).b(f, state.c(d));
            case EnumBlockRotation.d -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(d))).b(d, state.c(e))).b(e, state.c(f))).b(f, state.c(c));
            case EnumBlockRotation.b -> (IBlockData)((IBlockData)((IBlockData)((IBlockData)state.b(c, state.c(f))).b(d, state.c(c))).b(e, state.c(d))).b(f, state.c(e));
            default -> state;
        };
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return switch (mirror) {
            case EnumBlockMirror.b -> (IBlockData)((IBlockData)state.b(c, state.c(e))).b(e, state.c(c));
            case EnumBlockMirror.c -> (IBlockData)((IBlockData)state.b(d, state.c(f))).b(f, state.c(d));
            default -> super.a(state, mirror);
        };
    }

    @Nullable
    public static BlockStateEnum<BlockPropertyWallHeight> a(EnumDirection direction) {
        return g.get(direction);
    }

    @Override
    public boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
        return state.c(b) != false && !MossyCarpetBlock.a((IBlockAccess)level, pos, () -> true).l();
    }

    @Override
    public boolean a(World level, RandomSource random, BlockPosition pos, IBlockData state) {
        return true;
    }

    @Override
    public void a(WorldServer level, RandomSource random, BlockPosition pos, IBlockData state) {
        IBlockData blockState = MossyCarpetBlock.a((IBlockAccess)level, pos, () -> true);
        if (!blockState.l()) {
            level.a(pos.d(), blockState, 3);
        }
    }
}

