/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.MapCodec;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.EntityFallingBlock;
import net.minecraft.world.entity.projectile.EntityThrownTrident;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.IBlockWaterlogged;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class PointedDripstoneBlock
extends Block
implements Fallable,
IBlockWaterlogged {
    public static final MapCodec<PointedDripstoneBlock> a = PointedDripstoneBlock.b(PointedDripstoneBlock::new);
    public static final BlockStateEnum<EnumDirection> b = BlockProperties.bp;
    public static final BlockStateEnum<DripstoneThickness> c = BlockProperties.bq;
    public static final BlockStateBoolean d = BlockProperties.I;
    private static final int e = 11;
    private static final int f = 2;
    private static final float g = 0.02f;
    private static final float h = 0.12f;
    private static final int i = 11;
    private static final float D = 0.17578125f;
    private static final float R = 0.05859375f;
    private static final double S = 0.6;
    private static final float T = 1.0f;
    private static final int U = 40;
    private static final int V = 6;
    private static final float W = 2.5f;
    private static final int X = 2;
    private static final float Y = 5.0f;
    private static final float Z = 0.011377778f;
    private static final int aa = 7;
    private static final int ab = 10;
    private static final VoxelShape ac = Block.b(6.0, 0.0, 16.0);
    private static final VoxelShape ad = Block.b(6.0, 0.0, 11.0);
    private static final VoxelShape ae = Block.b(6.0, 5.0, 16.0);
    private static final VoxelShape af = Block.b(8.0, 0.0, 16.0);
    private static final VoxelShape ag = Block.b(10.0, 0.0, 16.0);
    private static final VoxelShape ah = Block.b(12.0, 0.0, 16.0);
    private static final double ai = ae.b(EnumDirection.EnumAxis.b);
    private static final float aj = (float)ah.b(EnumDirection.EnumAxis.a);
    private static final VoxelShape ak = Block.b(4.0, 0.0, 16.0);

    public MapCodec<PointedDripstoneBlock> a() {
        return a;
    }

    public PointedDripstoneBlock(BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.b)).b(c, DripstoneThickness.b)).b(d, false));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, c, d);
    }

    @Override
    protected boolean a(IBlockData state, IWorldReader level, BlockPosition pos) {
        return PointedDripstoneBlock.c(level, pos, state.c(b));
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        if (state.c(d).booleanValue()) {
            scheduledTickAccess.a(pos, FluidTypes.c, FluidTypes.c.a(level));
        }
        if (direction != EnumDirection.b && direction != EnumDirection.a) {
            return state;
        }
        EnumDirection direction1 = state.c(b);
        if (direction1 == EnumDirection.a && scheduledTickAccess.U().a(pos, this)) {
            return state;
        }
        if (direction == direction1.g() && !this.a(state, level, pos)) {
            if (direction1 == EnumDirection.a) {
                scheduledTickAccess.a(pos, this, 2);
            } else {
                scheduledTickAccess.a(pos, this, 1);
            }
            return state;
        }
        boolean flag = state.c(c) == DripstoneThickness.a;
        DripstoneThickness dripstoneThickness = PointedDripstoneBlock.a(level, pos, direction1, flag);
        return (IBlockData)state.b(c, dripstoneThickness);
    }

    @Override
    protected void a(World level, IBlockData state, MovingObjectPositionBlock hit, IProjectile projectile) {
        if (!level.C) {
            WorldServer serverLevel;
            BlockPosition blockPos = hit.b();
            if (level instanceof WorldServer && projectile.c(serverLevel = (WorldServer)level, blockPos) && projectile.a(serverLevel) && projectile instanceof EntityThrownTrident && projectile.dy().g() > 0.6) {
                if (!CraftEventFactory.callEntityChangeBlockEvent(projectile, blockPos, state.y().g())) {
                    return;
                }
                level.b(blockPos, true);
            }
        }
    }

    @Override
    public void a(World level, IBlockData state, BlockPosition pos, Entity entity, double fallDistance) {
        if (state.c(b) == EnumDirection.b && state.c(c) == DripstoneThickness.b) {
            entity.a(fallDistance + 2.5, 2.0f, level.al().w().eventBlockDamager(level, pos));
        } else {
            super.a(level, state, pos, entity, fallDistance);
        }
    }

    @Override
    public void a(IBlockData state, World level, BlockPosition pos, RandomSource random) {
        float randomFloat;
        if (PointedDripstoneBlock.o(state) && !((randomFloat = random.i()) > 0.12f)) {
            PointedDripstoneBlock.b(level, pos, state).filter(fluidInfo -> randomFloat < 0.02f || PointedDripstoneBlock.a(fluidInfo.b)).ifPresent(fluidInfo -> PointedDripstoneBlock.a(level, pos, state, fluidInfo.b));
        }
    }

    @Override
    protected void a(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        if (PointedDripstoneBlock.r(state) && !this.a(state, (IWorldReader)level, pos)) {
            level.b(pos, true);
        } else {
            PointedDripstoneBlock.a(state, level, pos);
        }
    }

    @Override
    protected void b(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        PointedDripstoneBlock.a(state, level, pos, random.i());
        if (random.i() < 0.011377778f && PointedDripstoneBlock.b(state, (IWorldReader)level, pos)) {
            PointedDripstoneBlock.c(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void a(IBlockData state, WorldServer level, BlockPosition pos, float randChance) {
        Optional<a> fluidAboveStalactite;
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !PointedDripstoneBlock.b(state, (IWorldReader)level, pos) || (fluidAboveStalactite = PointedDripstoneBlock.b(level, pos, state)).isEmpty())) {
            BlockPosition blockPos;
            float f2;
            FluidType fluid = fluidAboveStalactite.get().b;
            if (fluid == FluidTypes.c) {
                f2 = 0.17578125f;
            } else {
                if (fluid != FluidTypes.e) {
                    return;
                }
                f2 = 0.05859375f;
            }
            if (!(randChance >= f2) && (blockPos = PointedDripstoneBlock.a(state, level, pos, 11, false)) != null) {
                if (fluidAboveStalactite.get().c.a(Blocks.ts) && fluid == FluidTypes.c) {
                    IBlockData blockState = Blocks.ei.m();
                    if (CraftEventFactory.handleBlockFormEvent(level, fluidAboveStalactite.get().a, blockState, 3)) {
                        Block.a(fluidAboveStalactite.get().c, blockState, level, fluidAboveStalactite.get().a);
                        level.a(GameEvent.c, fluidAboveStalactite.get().a, GameEvent.a.a(blockState));
                        level.c(1504, blockPos, 0);
                    }
                } else {
                    BlockPosition blockPos1 = PointedDripstoneBlock.a((World)level, blockPos, fluid);
                    if (blockPos1 != null) {
                        level.c(1504, blockPos, 0);
                        int i2 = blockPos.v() - blockPos1.v();
                        int i1 = 50 + i2;
                        IBlockData blockState1 = level.a_(blockPos1);
                        level.a(blockPos1, blockState1.b(), i1);
                    }
                }
            }
        }
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        EnumDirection opposite;
        BlockPosition clickedPos;
        World level = context.q();
        EnumDirection direction = PointedDripstoneBlock.b((IWorldReader)level, clickedPos = context.a(), opposite = context.e().g());
        if (direction == null) {
            return null;
        }
        boolean flag = !context.h();
        DripstoneThickness dripstoneThickness = PointedDripstoneBlock.a((IWorldReader)level, clickedPos, direction, flag);
        return dripstoneThickness == null ? null : (IBlockData)((IBlockData)((IBlockData)this.m().b(b, direction)).b(c, dripstoneThickness)).b(d, level.b_(clickedPos).a() == FluidTypes.c);
    }

    @Override
    protected Fluid b_(IBlockData state) {
        return state.c(d) != false ? FluidTypes.c.a(false) : super.b_(state);
    }

    @Override
    protected VoxelShape d_(IBlockData state) {
        return VoxelShapes.a();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        VoxelShape voxelShape = switch (state.c(c)) {
            default -> throw new MatchException(null, null);
            case DripstoneThickness.a -> ac;
            case DripstoneThickness.b -> {
                if (state.c(b) == EnumDirection.a) {
                    yield ae;
                }
                yield ad;
            }
            case DripstoneThickness.c -> af;
            case DripstoneThickness.d -> ag;
            case DripstoneThickness.e -> ah;
        };
        return voxelShape.a(state.a(pos));
    }

    @Override
    protected boolean a_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return false;
    }

    @Override
    protected float ao_() {
        return aj;
    }

    @Override
    public void a(World level, BlockPosition pos, EntityFallingBlock fallingBlock) {
        if (!fallingBlock.ba()) {
            level.c(1045, pos, 0);
        }
    }

    @Override
    public DamageSource a(Entity entity) {
        return entity.dW().c(entity);
    }

    private static void a(IBlockData state, WorldServer level, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        IBlockData blockState = state;
        while (PointedDripstoneBlock.q(blockState)) {
            EntityFallingBlock fallingBlockEntity = EntityFallingBlock.a(level, mutableBlockPos, blockState);
            if (PointedDripstoneBlock.a(blockState, true)) {
                int max = Math.max(1 + pos.v() - mutableBlockPos.v(), 6);
                float f2 = 1.0f * (float)max;
                fallingBlockEntity.b(f2, 40);
                break;
            }
            mutableBlockPos.c(EnumDirection.a);
            blockState = level.a_(mutableBlockPos);
        }
    }

    @VisibleForTesting
    public static void c(IBlockData state, WorldServer level, BlockPosition pos, RandomSource random) {
        IBlockData blockState2;
        BlockPosition blockPos;
        IBlockData blockState1;
        IBlockData blockState = level.a_(pos.b(1));
        if (PointedDripstoneBlock.a(blockState, blockState1 = level.a_(pos.b(2))) && (blockPos = PointedDripstoneBlock.a(state, level, pos, 7, false)) != null && PointedDripstoneBlock.o(blockState2 = level.a_(blockPos)) && PointedDripstoneBlock.b(blockState2, level, blockPos)) {
            if (random.h()) {
                PointedDripstoneBlock.a(level, blockPos, EnumDirection.a);
            } else {
                PointedDripstoneBlock.b(level, blockPos);
            }
        }
    }

    private static void b(WorldServer level, BlockPosition pos) {
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 0; i2 < 10; ++i2) {
            mutableBlockPos.c(EnumDirection.a);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (!blockState.y().c()) {
                return;
            }
            if (PointedDripstoneBlock.a(blockState, EnumDirection.b) && PointedDripstoneBlock.b(blockState, level, (BlockPosition)mutableBlockPos)) {
                PointedDripstoneBlock.a(level, (BlockPosition)mutableBlockPos, EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.c((IWorldReader)level, (BlockPosition)mutableBlockPos, EnumDirection.b) && !level.A(mutableBlockPos.e())) {
                PointedDripstoneBlock.a(level, mutableBlockPos.e(), EnumDirection.b);
                return;
            }
            if (PointedDripstoneBlock.a((IBlockAccess)level, (BlockPosition)mutableBlockPos, blockState)) continue;
            return;
        }
    }

    private static void a(WorldServer server, BlockPosition pos, EnumDirection direction) {
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = server.a_(blockPos);
        if (PointedDripstoneBlock.a(blockState, direction.g())) {
            PointedDripstoneBlock.a(blockState, (GeneratorAccess)server, blockPos);
        } else if (blockState.l() || blockState.a(Blocks.J)) {
            PointedDripstoneBlock.createDripstone(server, blockPos, direction, DripstoneThickness.b, pos);
        }
    }

    private static void createDripstone(GeneratorAccess level, BlockPosition pos, EnumDirection direction, DripstoneThickness thickness, BlockPosition source) {
        IBlockData blockState = (IBlockData)((IBlockData)((IBlockData)Blocks.tb.m().b(b, direction)).b(c, thickness)).b(d, level.b_(pos).a() == FluidTypes.c);
        CraftEventFactory.handleBlockSpreadEvent(level, source, pos, blockState, 3);
    }

    private static void a(IBlockData state, GeneratorAccess level, BlockPosition pos) {
        BlockPosition blockPos1;
        BlockPosition blockPos;
        if (state.c(b) == EnumDirection.b) {
            blockPos = pos;
            blockPos1 = pos.d();
        } else {
            blockPos1 = pos;
            blockPos = pos.e();
        }
        PointedDripstoneBlock.createDripstone(level, blockPos1, EnumDirection.a, DripstoneThickness.a, pos);
        PointedDripstoneBlock.createDripstone(level, blockPos, EnumDirection.b, DripstoneThickness.a, pos);
    }

    public static void a(World level, BlockPosition pos, IBlockData state) {
        PointedDripstoneBlock.b(level, pos, state).ifPresent(fluidInfo -> PointedDripstoneBlock.a(level, pos, state, fluidInfo.b));
    }

    private static void a(World level, BlockPosition pos, IBlockData state, FluidType fluid) {
        Vec3D offset = state.a(pos);
        double d2 = 0.0625;
        double d1 = (double)pos.u() + 0.5 + offset.d;
        double d22 = (double)pos.v() + ai - 0.0625;
        double d3 = (double)pos.w() + 0.5 + offset.f;
        FluidType dripFluid = PointedDripstoneBlock.a(level, fluid);
        ParticleType particleOptions = dripFluid.a(TagsFluid.b) ? Particles.aO : Particles.aQ;
        level.a(particleOptions, d1, d22, d3, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPosition a(IBlockData state, GeneratorAccess level, BlockPosition pos, int maxIterations, boolean isTipMerge) {
        if (PointedDripstoneBlock.a(state, isTipMerge)) {
            return pos;
        }
        EnumDirection direction = state.c(b);
        BiPredicate<BlockPosition, IBlockData> biPredicate = (predPos, predState) -> predState.a(Blocks.tb) && predState.c(b) == direction;
        return PointedDripstoneBlock.a(level, pos, direction.f(), biPredicate, (IBlockData predState) -> PointedDripstoneBlock.a(predState, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static EnumDirection b(IWorldReader level, BlockPosition pos, EnumDirection dir) {
        EnumDirection direction;
        if (PointedDripstoneBlock.c(level, pos, dir)) {
            direction = dir;
        } else {
            if (!PointedDripstoneBlock.c(level, pos, dir.g())) {
                return null;
            }
            direction = dir.g();
        }
        return direction;
    }

    private static DripstoneThickness a(IWorldReader level, BlockPosition pos, EnumDirection dir, boolean isTipMerge) {
        EnumDirection opposite = dir.g();
        IBlockData blockState = level.a_(pos.a(dir));
        if (PointedDripstoneBlock.b(blockState, opposite)) {
            return !isTipMerge && blockState.c(c) != DripstoneThickness.a ? DripstoneThickness.b : DripstoneThickness.a;
        }
        if (!PointedDripstoneBlock.b(blockState, dir)) {
            return DripstoneThickness.b;
        }
        DripstoneThickness dripstoneThickness = blockState.c(c);
        if (dripstoneThickness != DripstoneThickness.b && dripstoneThickness != DripstoneThickness.a) {
            IBlockData blockState1 = level.a_(pos.a(opposite));
            return !PointedDripstoneBlock.b(blockState1, dir) ? DripstoneThickness.e : DripstoneThickness.d;
        }
        return DripstoneThickness.c;
    }

    public static boolean o(IBlockData state) {
        return PointedDripstoneBlock.q(state) && state.c(c) == DripstoneThickness.b && state.c(d) == false;
    }

    private static boolean b(IBlockData state, WorldServer level, BlockPosition pos) {
        EnumDirection direction = state.c(b);
        BlockPosition blockPos = pos.a(direction);
        IBlockData blockState = level.a_(blockPos);
        return blockState.y().c() && (blockState.l() || PointedDripstoneBlock.a(blockState, direction.g()));
    }

    private static Optional<BlockPosition> a(World level, BlockPosition pos, IBlockData state, int maxIterations) {
        EnumDirection direction = state.c(b);
        BiPredicate<BlockPosition, IBlockData> biPredicate = (predPos, predState) -> predState.a(Blocks.tb) && predState.c(b) == direction;
        return PointedDripstoneBlock.a(level, pos, direction.g().f(), biPredicate, (IBlockData predState) -> !predState.a(Blocks.tb), maxIterations);
    }

    private static boolean c(IWorldReader level, BlockPosition pos, EnumDirection dir) {
        BlockPosition blockPos = pos.a(dir.g());
        IBlockData blockState = level.a_(blockPos);
        return blockState.c((IBlockAccess)level, blockPos, dir) || PointedDripstoneBlock.b(blockState, dir);
    }

    private static boolean a(IBlockData state, boolean isTipMerge) {
        if (!state.a(Blocks.tb)) {
            return false;
        }
        DripstoneThickness dripstoneThickness = state.c(c);
        return dripstoneThickness == DripstoneThickness.b || isTipMerge && dripstoneThickness == DripstoneThickness.a;
    }

    private static boolean a(IBlockData state, EnumDirection dir) {
        return PointedDripstoneBlock.a(state, false) && state.c(b) == dir;
    }

    private static boolean q(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.a);
    }

    private static boolean r(IBlockData state) {
        return PointedDripstoneBlock.b(state, EnumDirection.b);
    }

    private static boolean b(IBlockData state, IWorldReader level, BlockPosition pos) {
        return PointedDripstoneBlock.q(state) && !level.a_(pos.d()).a(Blocks.tb);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    private static boolean b(IBlockData state, EnumDirection dir) {
        return state.a(Blocks.tb) && state.c(b) == dir;
    }

    @Nullable
    private static BlockPosition a(World level, BlockPosition pos, FluidType fluid) {
        Predicate<IBlockData> predicate = state -> state.b() instanceof AbstractCauldronBlock && ((AbstractCauldronBlock)state.b()).a(fluid);
        BiPredicate<BlockPosition, IBlockData> biPredicate = (predPos, predState) -> PointedDripstoneBlock.a((IBlockAccess)level, predPos, predState);
        return PointedDripstoneBlock.a(level, pos, EnumDirection.a.f(), biPredicate, predicate, 11).orElse(null);
    }

    @Nullable
    public static BlockPosition a(World level, BlockPosition pos) {
        BiPredicate<BlockPosition, IBlockData> biPredicate = (predPos, predState) -> PointedDripstoneBlock.a((IBlockAccess)level, predPos, predState);
        return PointedDripstoneBlock.a(level, pos, EnumDirection.b.f(), biPredicate, PointedDripstoneBlock::o, 11).orElse(null);
    }

    public static FluidType a(WorldServer level, BlockPosition pos) {
        return PointedDripstoneBlock.b(level, pos, level.a_(pos)).map(fluidInfo -> fluidInfo.b).filter(PointedDripstoneBlock::a).orElse(FluidTypes.a);
    }

    private static Optional<a> b(World level, BlockPosition pos, IBlockData state) {
        return !PointedDripstoneBlock.q(state) ? Optional.empty() : PointedDripstoneBlock.a(level, pos, state, 11).map(rootBlockPos -> {
            BlockPosition blockPos = rootBlockPos.d();
            IBlockData blockState = level.a_(blockPos);
            FluidType fluid = blockState.a(Blocks.ts) && !level.F_().i() ? FluidTypes.c : level.b_(blockPos).a();
            return new a(blockPos, fluid, blockState);
        });
    }

    private static boolean a(FluidType fluid) {
        return fluid == FluidTypes.e || fluid == FluidTypes.c;
    }

    private static boolean a(IBlockData dripstoneState, IBlockData state) {
        return dripstoneState.a(Blocks.tc) && state.a(Blocks.J) && state.y().b();
    }

    private static FluidType a(World level, FluidType fluid) {
        if (fluid.a(FluidTypes.a)) {
            return level.F_().i() ? FluidTypes.e : FluidTypes.c;
        }
        return fluid;
    }

    private static Optional<BlockPosition> a(GeneratorAccess level, BlockPosition pos, EnumDirection.EnumAxisDirection axis, BiPredicate<BlockPosition, IBlockData> positionalStatePredicate, Predicate<IBlockData> statePredicate, int maxIterations) {
        EnumDirection direction = EnumDirection.a(axis, EnumDirection.EnumAxis.b);
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = 1; i2 < maxIterations; ++i2) {
            mutableBlockPos.c(direction);
            IBlockData blockState = level.a_(mutableBlockPos);
            if (statePredicate.test(blockState)) {
                return Optional.of(mutableBlockPos.j());
            }
            if (!level.e(mutableBlockPos.v()) && positionalStatePredicate.test(mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean a(IBlockAccess level, BlockPosition pos, IBlockData state) {
        if (state.l()) {
            return true;
        }
        if (state.s()) {
            return false;
        }
        if (!state.y().c()) {
            return false;
        }
        VoxelShape collisionShape = state.g(level, pos);
        return !VoxelShapes.c(ak, collisionShape, OperatorBoolean.i);
    }

    record a(BlockPosition a, FluidType b, IBlockData c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "pos;fluid;sourceState", "a", "b", "c"}, this, o2);
        }
    }
}

