/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPosition;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.SculkBehaviour;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.material.FluidTypes;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class SculkBlock
extends DropExperienceBlock
implements SculkBehaviour {
    public static final MapCodec<SculkBlock> b = SculkBlock.b(SculkBlock::new);

    public MapCodec<SculkBlock> a() {
        return b;
    }

    public SculkBlock(BlockBase.Info properties) {
        super(ConstantInt.a(1), properties);
    }

    @Override
    public int a(SculkSpreader.a cursor, GeneratorAccess level, BlockPosition pos, RandomSource random, SculkSpreader spreader, boolean shouldConvertBlocks) {
        int charge = cursor.b();
        if (charge != 0 && random.a(spreader.f()) == 0) {
            BlockPosition pos1 = cursor.a();
            boolean flag = pos1.a(pos, (double)spreader.e());
            if (!flag && SculkBlock.a(level, pos1)) {
                IBlockData randomGrowthState;
                BlockPosition blockPos;
                int growthSpawnCost = spreader.d();
                if (random.a(growthSpawnCost) < charge && CraftEventFactory.handleBlockSpreadEvent(level, pos, blockPos = pos1.d(), randomGrowthState = this.a(level, blockPos, random, spreader.h()), 3)) {
                    level.a(null, pos1, randomGrowthState.A().e(), SoundCategory.e, 1.0f, 1.0f);
                }
                return Math.max(0, charge - growthSpawnCost);
            }
            return random.a(spreader.g()) != 0 ? charge : charge - (flag ? 1 : SculkBlock.a(spreader, pos1, pos, charge));
        }
        return charge;
    }

    private static int a(SculkSpreader spreader, BlockPosition cursorPos, BlockPosition rootPos, int charge) {
        int noGrowthRadius = spreader.e();
        float squared = MathHelper.l((float)Math.sqrt(cursorPos.j(rootPos)) - (float)noGrowthRadius);
        int squared1 = MathHelper.h(24 - noGrowthRadius);
        float min = Math.min(1.0f, squared / (float)squared1);
        return Math.max(1, (int)((float)charge * min * 0.5f));
    }

    private IBlockData a(GeneratorAccess level, BlockPosition pos, RandomSource random, boolean isWorldGeneration) {
        IBlockData blockState = random.a(11) == 0 ? (IBlockData)Blocks.rD.m().b(SculkShriekerBlock.d, isWorldGeneration) : Blocks.ry.m();
        return blockState.b(BlockProperties.I) && !level.b_(pos).c() ? (IBlockData)blockState.b(BlockProperties.I, true) : blockState;
    }

    private static boolean a(GeneratorAccess level, BlockPosition pos) {
        IBlockData blockState = level.a_(pos.d());
        if (blockState.l() || blockState.a(Blocks.J) && blockState.y().b(FluidTypes.c)) {
            int i2 = 0;
            for (BlockPosition blockPos : BlockPosition.c(pos.b(-4, 0, -4), pos.b(4, 2, 4))) {
                IBlockData blockState1 = level.a_(blockPos);
                if (blockState1.a(Blocks.ry) || blockState1.a(Blocks.rD)) {
                    ++i2;
                }
                if (i2 <= 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean d() {
        return false;
    }
}

