/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.HangingSignItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFacingHorizontal;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.EnumBlockSupport;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyWood;
import net.minecraft.world.level.block.state.properties.BlockStateEnum;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class WallHangingSignBlock
extends BlockSign {
    public static final MapCodec<WallHangingSignBlock> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPropertyWood.a.fieldOf("wood_type").forGetter(BlockSign::d), WallHangingSignBlock.t()).apply((Applicative)instance, WallHangingSignBlock::new));
    public static final BlockStateEnum<EnumDirection> b = BlockFacingHorizontal.e;
    private static final Map<EnumDirection.EnumAxis, VoxelShape> c = VoxelShapes.a(Block.a(16.0, 4.0, 14.0, 16.0));
    private static final Map<EnumDirection.EnumAxis, VoxelShape> e = VoxelShapes.a(VoxelShapes.a(c.get(EnumDirection.EnumAxis.c), Block.a(14.0, 2.0, 0.0, 10.0)));

    public MapCodec<WallHangingSignBlock> a() {
        return a;
    }

    public WallHangingSignBlock(BlockPropertyWood type, BlockBase.Info properties) {
        super(type, properties.a(type.e()));
        this.l((IBlockData)((IBlockData)this.C.b().b(b, EnumDirection.c)).b(BlockSign.d, false));
    }

    @Override
    protected EnumInteractionResult a(ItemStack stack, IBlockData state, World level, BlockPosition pos, EntityHuman player, EnumHand hand, MovingObjectPositionBlock hitResult) {
        TileEntitySign signBlockEntity;
        TileEntity tileEntity = level.c_(pos);
        return tileEntity instanceof TileEntitySign && this.a(state, player, hitResult, signBlockEntity = (TileEntitySign)tileEntity, stack) ? EnumInteractionResult.e : super.a(stack, state, level, pos, player, hand, hitResult);
    }

    private boolean a(IBlockData state, EntityHuman player, MovingObjectPositionBlock hitResult, TileEntitySign sign, ItemStack stack) {
        return !sign.a(sign.a(player), player) && stack.h() instanceof HangingSignItem && !this.a(hitResult, state);
    }

    private boolean a(MovingObjectPositionBlock hitResult, IBlockData state) {
        return hitResult.c().o() == state.c(b).o();
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return e.get(state.c(b).o());
    }

    @Override
    protected VoxelShape b_(IBlockData state, IBlockAccess level, BlockPosition pos) {
        return this.a(state, level, pos, VoxelShapeCollision.a());
    }

    @Override
    protected VoxelShape b(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return c.get(state.c(b).o());
    }

    public boolean b(IBlockData state, IWorldReader level, BlockPosition pos) {
        EnumDirection clockWise = state.c(b).h();
        EnumDirection counterClockWise = state.c(b).i();
        return this.a(level, state, pos.a(clockWise), counterClockWise) || this.a(level, state, pos.a(counterClockWise), clockWise);
    }

    public boolean a(IWorldReader level, IBlockData state, BlockPosition pos, EnumDirection direction) {
        IBlockData blockState = level.a_(pos);
        return blockState.a(TagsBlock.aC) ? blockState.c(b).o().a(state.c(b)) : blockState.a((IBlockAccess)level, pos, direction, EnumBlockSupport.a);
    }

    @Override
    @Nullable
    public IBlockData a(BlockActionContext context) {
        IBlockData blockState = this.m();
        Fluid fluidState = context.q().b_(context.a());
        World level = context.q();
        BlockPosition clickedPos = context.a();
        for (EnumDirection direction : context.f()) {
            EnumDirection opposite;
            if (!direction.o().d() || direction.o().a(context.k()) || !(blockState = (IBlockData)blockState.b(b, opposite = direction.g())).a((IWorldReader)level, clickedPos) || !this.b(blockState, (IWorldReader)level, clickedPos)) continue;
            return (IBlockData)blockState.b(BlockSign.d, fluidState.a() == FluidTypes.c);
        }
        return null;
    }

    @Override
    protected IBlockData a(IBlockData state, IWorldReader level, ScheduledTickAccess scheduledTickAccess, BlockPosition pos, EnumDirection direction, BlockPosition neighborPos, IBlockData neighborState, RandomSource random) {
        return direction.o() == state.c(b).h().o() && !state.a(level, pos) ? Blocks.a.m() : super.a(state, level, scheduledTickAccess, pos, direction, neighborPos, neighborState, random);
    }

    @Override
    public float h(IBlockData state) {
        return state.c(b).p();
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rotation) {
        return (IBlockData)state.b(b, rotation.a(state.c(b)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(b)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(b, BlockSign.d);
    }

    @Override
    public TileEntity a(BlockPosition pos, IBlockData state) {
        return new HangingSignBlockEntity(pos, state);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }

    @Override
    @Nullable
    public <T extends TileEntity> BlockEntityTicker<T> a(World level, IBlockData state, TileEntityTypes<T> blockEntityType) {
        return null;
    }
}

