/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.google.common.annotations.VisibleForTesting;
import net.minecraft.Optionull;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.SculkCatalystBlock;
import net.minecraft.world.level.block.SculkSpreader;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;

public class SculkCatalystBlockEntity
extends TileEntity
implements GameEventListener.b<CatalystListener> {
    private final CatalystListener a;

    public SculkCatalystBlockEntity(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.L, pos, blockState);
        this.a = new CatalystListener(blockState, new BlockPositionSource(pos));
    }

    @Override
    public void a(World level) {
        super.a(level);
        this.a.b.level = level;
    }

    public static void a(World level, BlockPosition pos, IBlockData state, SculkCatalystBlockEntity sculkCatalyst) {
        CraftEventFactory.sourceBlockOverride = sculkCatalyst.ax_();
        sculkCatalyst.a.d().a(level, pos, level.G_(), true);
        CraftEventFactory.sourceBlockOverride = null;
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.a.b.a(tag);
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        this.a.b.b(tag);
        super.b(tag, registries);
    }

    public CatalystListener a() {
        return this.a;
    }

    public static class CatalystListener
    implements GameEventListener {
        public static final int a = 8;
        final SculkSpreader b;
        private final IBlockData c;
        private final PositionSource d;

        public CatalystListener(IBlockData blockState, PositionSource positionSource) {
            this.c = blockState;
            this.d = positionSource;
            this.b = SculkSpreader.a();
        }

        @Override
        public PositionSource a() {
            return this.d;
        }

        @Override
        public int b() {
            return 8;
        }

        @Override
        public GameEventListener.a c() {
            return GameEventListener.a.b;
        }

        @Override
        public boolean a(WorldServer level, Holder<GameEvent> gameEvent, GameEvent.a context, Vec3D pos) {
            Entity entity;
            if (gameEvent.a(GameEvent.p) && (entity = context.a()) instanceof EntityLiving) {
                EntityLiving livingEntity = (EntityLiving)entity;
                if (!livingEntity.eL()) {
                    DamageSource lastDamageSource = livingEntity.eI();
                    int experienceReward = livingEntity.a(level, Optionull.a(lastDamageSource, DamageSource::d));
                    if (livingEntity.eo() && experienceReward > 0) {
                        this.b.a(BlockPosition.a(pos.a(EnumDirection.b, 0.5)), experienceReward);
                        this.a((World)level, livingEntity);
                    }
                    livingEntity.eK();
                    this.d.a(level).ifPresent(position -> this.a(level, BlockPosition.a(position), this.c, level.G_()));
                }
                return true;
            }
            return false;
        }

        @VisibleForTesting
        public SculkSpreader d() {
            return this.b;
        }

        public void a(WorldServer level, BlockPosition pos, IBlockData state, RandomSource random) {
            level.a(pos, (IBlockData)state.b(SculkCatalystBlock.b, true), 3);
            level.a(pos, state.b(), 8);
            level.a(Particles.K, (double)pos.u() + 0.5, (double)pos.v() + 1.15, (double)pos.w() + 0.5, 2, 0.2, 0.0, 0.2, 0.0);
            level.a(null, pos, SoundEffects.wQ, SoundCategory.e, 2.0f, 0.6f + random.i() * 0.4f);
        }

        private void a(World level, EntityLiving entity) {
            EntityLiving entityLiving = entity.er();
            if (entityLiving instanceof EntityPlayer) {
                EntityPlayer serverPlayer = (EntityPlayer)entityLiving;
                DamageSource damageSource = entity.eI() == null ? level.al().a(serverPlayer) : entity.eI();
                CriterionTriggers.Z.a(serverPlayer, entity, damageSource);
            }
        }
    }
}

