/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.inventory.InventoryHolder;
import org.slf4j.Logger;

public abstract class TileEntity {
    static boolean ignoreBlockEntityUpdates;
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY;
    public final CraftPersistentDataContainer persistentDataContainer;
    private static final Codec<TileEntityTypes<?>> d;
    private static final Logger e;
    private final TileEntityTypes<?> f;
    @Nullable
    protected World n;
    protected final BlockPosition o;
    protected boolean p;
    private IBlockData g;
    private DataComponentMap h = DataComponentMap.a;

    public TileEntity(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        this.f = type;
        this.o = pos.j();
        this.a(blockState);
        this.g = blockState;
        this.persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);
    }

    private void a(IBlockData state) {
        if (!this.b(state)) {
            throw new IllegalStateException("Invalid block entity " + this.k() + " state at " + String.valueOf(this.o) + ", got " + String.valueOf(state));
        }
    }

    public boolean b(IBlockData state) {
        return this.f.a(state);
    }

    public static BlockPosition a(ChunkCoordIntPair chunkPos, NBTTagCompound tag) {
        int intOr = tag.b("x", 0);
        int intOr1 = tag.b("y", 0);
        int intOr2 = tag.b("z", 0);
        if (chunkPos != null) {
            int sectionPosCoord = SectionPosition.a(intOr);
            int sectionPosCoord1 = SectionPosition.a(intOr2);
            if (sectionPosCoord != chunkPos.h || sectionPosCoord1 != chunkPos.i) {
                e.warn("Block entity {} found in a wrong chunk, expected position from chunk {}", (Object)tag, (Object)chunkPos);
                intOr = chunkPos.a(SectionPosition.b(intOr));
                intOr2 = chunkPos.b(SectionPosition.b(intOr2));
            }
        }
        return new BlockPosition(intOr, intOr1, intOr2);
    }

    @Nullable
    public World i() {
        return this.n;
    }

    public void a(World level) {
        this.n = level;
    }

    public boolean l() {
        return this.n != null;
    }

    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        this.persistentDataContainer.clear();
        NBTBase persistentDataTag = tag.a("PublicBukkitValues");
        if (persistentDataTag instanceof NBTTagCompound) {
            this.persistentDataContainer.putAll((NBTTagCompound)persistentDataTag);
        }
    }

    public final void c(NBTTagCompound tag, HolderLookup.a registries) {
        this.a(tag, registries);
        this.h = tag.a(a.a, (DynamicOps<NBTBase>)registries.a(DynamicOpsNBT.a)).orElse(DataComponentMap.a);
    }

    public final void d(NBTTagCompound tag, HolderLookup.a registries) {
        this.a(tag, registries);
    }

    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
    }

    public final NBTTagCompound b(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.d(registries);
        this.d(compoundTag);
        return compoundTag;
    }

    public final NBTTagCompound c(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.d(registries);
        this.c(compoundTag);
        return compoundTag;
    }

    public final NBTTagCompound d(HolderLookup.a registries) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.b(compoundTag, registries);
        compoundTag.a(a.a, registries.a(DynamicOpsNBT.a), this.h);
        if (!this.persistentDataContainer.isEmpty()) {
            compoundTag.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final NBTTagCompound e(HolderLookup.a registries) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        this.b(compoundTag, registries);
        if (!this.persistentDataContainer.isEmpty()) {
            compoundTag.a("PublicBukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return compoundTag;
    }

    public final NBTTagCompound f(HolderLookup.a registries) {
        NBTTagCompound compoundTag = this.e(registries);
        this.d(compoundTag);
        return compoundTag;
    }

    public void c(NBTTagCompound tag) {
        TileEntity.a(tag, this.p());
    }

    public static void a(NBTTagCompound tag, TileEntityTypes<?> entityType) {
        tag.a("id", d, entityType);
    }

    private void d(NBTTagCompound tag) {
        this.c(tag);
        tag.a("x", this.o.u());
        tag.a("y", this.o.v());
        tag.a("z", this.o.w());
    }

    @Nullable
    public static TileEntity a(BlockPosition pos, IBlockData state, NBTTagCompound tag, HolderLookup.a registries) {
        Object blockEntity;
        TileEntityTypes blockEntityType = tag.a("id", d).orElse(null);
        if (blockEntityType == null) {
            e.error("Skipping block entity with invalid type: {}", (Object)tag.a("id"));
            return null;
        }
        try {
            blockEntity = blockEntityType.a(pos, state);
        }
        catch (Throwable var8) {
            e.error("Failed to create block entity {} for block {} at position {} ", new Object[]{blockEntityType, pos, state, var8});
            return null;
        }
        try {
            ((TileEntity)blockEntity).c(tag, registries);
            return blockEntity;
        }
        catch (Throwable var7) {
            e.error("Failed to load data for block entity {} for block {} at position {}", new Object[]{blockEntityType, pos, state, var7});
            return null;
        }
    }

    public void e() {
        if (this.n != null) {
            if (ignoreBlockEntityUpdates) {
                return;
            }
            TileEntity.a(this.n, this.o, this.g);
        }
    }

    protected static void a(World level, BlockPosition pos, IBlockData state) {
        level.q(pos);
        if (!state.l()) {
            level.b(pos, state.b());
        }
    }

    public BlockPosition ax_() {
        return this.o;
    }

    public IBlockData m() {
        return this.g;
    }

    @Nullable
    public Packet<PacketListenerPlayOut> au_() {
        return null;
    }

    public NBTTagCompound a(HolderLookup.a registries) {
        return new NBTTagCompound();
    }

    public boolean n() {
        return this.p;
    }

    public void as_() {
        this.p = true;
    }

    public void o() {
        this.p = false;
    }

    public void a(BlockPosition pos, IBlockData state) {
        TileEntity tileEntity = this;
        if (tileEntity instanceof IInventory) {
            IInventory container = (IInventory)((Object)tileEntity);
            if (this.n != null) {
                InventoryUtils.a(this.n, pos, container);
            }
        }
    }

    public boolean a_(int id, int type) {
        return false;
    }

    public void a(CrashReportSystemDetails reportCategory) {
        reportCategory.a("Name", this::k);
        reportCategory.a("Cached block", this.m()::toString);
        if (this.n == null) {
            reportCategory.a("Block location", () -> String.valueOf(this.o) + " (world missing)");
        } else {
            reportCategory.a("Actual block", this.n.a_(this.o)::toString);
            CrashReportSystemDetails.a(reportCategory, this.n, this.o);
        }
    }

    private String k() {
        return String.valueOf(BuiltInRegistries.j.b(this.p())) + " // " + this.getClass().getCanonicalName();
    }

    public TileEntityTypes<?> p() {
        return this.f;
    }

    @Deprecated
    public void c(IBlockData blockState) {
        this.a(blockState);
        this.g = blockState;
    }

    protected void a(DataComponentGetter componentGetter) {
    }

    public final void a(ItemStack stack) {
        this.a(stack.c(), stack.d());
    }

    public final void a(DataComponentMap components, DataComponentPatch patch) {
        this.applyComponentsSet(components, patch);
    }

    public final Set<DataComponentType<?>> applyComponentsSet(DataComponentMap components, DataComponentPatch patch) {
        final HashSet set = new HashSet();
        set.add(DataComponents.aa);
        set.add(DataComponents.aq);
        final PatchedDataComponentMap dataComponentMap = PatchedDataComponentMap.a(components, patch);
        this.a(new DataComponentGetter(){

            @Override
            @Nullable
            public <T> T a(DataComponentType<? extends T> component) {
                set.add(component);
                return dataComponentMap.a(component);
            }

            @Override
            public <T> T a(DataComponentType<? extends T> component, T defaultValue) {
                set.add(component);
                return dataComponentMap.a(component, defaultValue);
            }
        });
        DataComponentPatch dataComponentPatch = patch.a(set::contains);
        this.h = dataComponentPatch.e().a();
        set.remove(DataComponents.aa);
        return set;
    }

    protected void a(DataComponentMap.a components) {
    }

    @Deprecated
    public void a(NBTTagCompound tag) {
    }

    public final DataComponentMap q() {
        DataComponentMap.a builder = DataComponentMap.a();
        builder.a(this.h);
        this.a(builder);
        return builder.a();
    }

    public DataComponentMap r() {
        return this.h;
    }

    public void a(DataComponentMap components) {
        this.h = components;
    }

    @Nullable
    public static IChatBaseComponent a(@Nullable NBTBase tag, HolderLookup.a registries) {
        return tag == null ? null : (IChatBaseComponent)ComponentSerialization.a.parse(registries.a(DynamicOpsNBT.a), (Object)tag).resultOrPartial(string -> e.warn("Failed to parse custom name, discarding: {}", string)).orElse(null);
    }

    public InventoryHolder getOwner() {
        return this.getOwner(true);
    }

    public InventoryHolder getOwner(boolean useSnapshot) {
        InventoryHolder inventoryHolder;
        if (this.n == null) {
            return null;
        }
        CraftBlock block = CraftBlock.at(this.n, this.o);
        BlockState state = block.getState(useSnapshot);
        return state instanceof InventoryHolder ? (inventoryHolder = (InventoryHolder)state) : null;
    }

    public NBTTagCompound sanitizeSentNbt(NBTTagCompound tag) {
        tag.r("PublicBukkitValues");
        return tag;
    }

    static {
        DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
        d = BuiltInRegistries.j.q();
        e = LogUtils.getLogger();
    }

    static class a {
        public static final MapCodec<DataComponentMap> a = DataComponentMap.b.optionalFieldOf("components", (Object)DataComponentMap.a);

        private a() {
        }
    }
}

