/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.BlockBanner;
import net.minecraft.world.level.block.BlockBannerAbstract;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;

public class TileEntityBanner
extends TileEntity
implements INamableTileEntity {
    public static final int a = 6;
    private static final String b = "patterns";
    @Nullable
    public IChatBaseComponent c;
    public EnumColor d;
    private BannerPatternLayers e = BannerPatternLayers.a;
    ThreadLocal<Boolean> serialisingForNetwork = ThreadLocal.withInitial(() -> Boolean.FALSE);

    public TileEntityBanner(BlockPosition pos, IBlockData blockState) {
        this(pos, blockState, ((BlockBannerAbstract)blockState.b()).b());
    }

    public TileEntityBanner(BlockPosition pos, IBlockData blockState, EnumColor baseColor) {
        super(TileEntityTypes.u, pos, blockState);
        this.d = baseColor;
    }

    @Override
    public IChatBaseComponent ah() {
        return this.c != null ? this.c : IChatBaseComponent.c("block.minecraft.banner");
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.c;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        if (!this.e.equals(BannerPatternLayers.a) || this.serialisingForNetwork.get().booleanValue()) {
            tag.a(b, BannerPatternLayers.b, registryOps, this.e);
        }
        tag.b("CustomName", ComponentSerialization.a, registryOps, this.c);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.c = TileEntityBanner.a(tag.a("CustomName"), registries);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        this.setPatterns(tag.a(b, BannerPatternLayers.b, (DynamicOps<NBTBase>)registryOps).orElse(BannerPatternLayers.a));
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        Boolean wasSerialisingForNetwork = this.serialisingForNetwork.get();
        try {
            this.serialisingForNetwork.set(Boolean.TRUE);
            NBTTagCompound nBTTagCompound = this.d(registries);
            return nBTTagCompound;
        }
        finally {
            this.serialisingForNetwork.set(wasSerialisingForNetwork);
        }
    }

    public BannerPatternLayers b() {
        return this.e;
    }

    public ItemStack c() {
        ItemStack itemStack = new ItemStack(BlockBanner.a(this.d));
        itemStack.b(this.q());
        return itemStack;
    }

    public EnumColor f() {
        return this.d;
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        super.a(componentGetter);
        this.setPatterns(componentGetter.a(DataComponents.am, BannerPatternLayers.a));
        this.c = componentGetter.a(DataComponents.g);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.am, this.e);
        components.a(DataComponents.g, this.c);
    }

    @Override
    public void a(NBTTagCompound tag) {
        tag.r(b);
        tag.r("CustomName");
    }

    public void setPatterns(BannerPatternLayers bannerPatternLayers) {
        if (bannerPatternLayers.b().size() > 20) {
            bannerPatternLayers = new BannerPatternLayers(List.copyOf(bannerPatternLayers.b().subList(0, 20)));
        }
        this.e = bannerPatternLayers;
    }
}

