/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeCampfire;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.Recipes;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockCookEvent;
import org.bukkit.event.block.CampfireStartEvent;
import org.bukkit.inventory.CampfireRecipe;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;

public class TileEntityCampfire
extends TileEntity
implements Clearable {
    private static final int a = 2;
    private static final int b = 4;
    private final NonNullList<net.minecraft.world.item.ItemStack> c = NonNullList.a(4, net.minecraft.world.item.ItemStack.l);
    public final int[] d = new int[4];
    public final int[] e = new int[4];
    public final boolean[] stopCooking = new boolean[4];

    public TileEntityCampfire(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.H, pos, blockState);
    }

    public static void a(WorldServer level, BlockPosition pos, IBlockData state, TileEntityCampfire campfire, CraftingManager.a<SingleRecipeInput, RecipeCampfire> check) {
        boolean flag = false;
        for (int i2 = 0; i2 < campfire.c.size(); ++i2) {
            SingleRecipeInput singleRecipeInput;
            Optional<RecipeHolder<RecipeCampfire>> optionalCookingRecipe;
            net.minecraft.world.item.ItemStack itemStack1;
            net.minecraft.world.item.ItemStack itemStack = campfire.c.get(i2);
            if (itemStack.f()) continue;
            flag = true;
            if (!campfire.stopCooking[i2]) {
                int n2 = i2;
                campfire.d[n2] = campfire.d[n2] + 1;
            }
            if (campfire.d[i2] < campfire.e[i2] || !(itemStack1 = (optionalCookingRecipe = check.a(singleRecipeInput = new SingleRecipeInput(itemStack), level)).map(recipe -> ((RecipeCampfire)recipe.b()).a(singleRecipeInput, (HolderLookup.a)level.J_())).orElse(itemStack)).a(level.K())) continue;
            CraftItemStack source = CraftItemStack.asCraftMirror(itemStack);
            ItemStack result = CraftItemStack.asBukkitCopy(itemStack1);
            BlockCookEvent blockCookEvent = new BlockCookEvent((Block)CraftBlock.at(level, pos), (ItemStack)source, result, (CookingRecipe)optionalCookingRecipe.map(RecipeHolder::toBukkitRecipe).orElse(null));
            if (!blockCookEvent.callEvent()) {
                return;
            }
            result = blockCookEvent.getResult();
            itemStack1 = CraftItemStack.asNMSCopy(result);
            double deviation = 0.11485000171139836;
            while (!itemStack1.f()) {
                EntityItem droppedItem = new EntityItem(level, (double)pos.u() + 0.5, (double)pos.v() + 0.5, (double)pos.w() + 0.5, itemStack1.a(level.A.a(21) + 10));
                droppedItem.n(level.A.a(0.0, deviation), level.A.a(0.2, deviation), level.A.a(0.0, deviation));
                level.b(droppedItem);
            }
            campfire.c.set(i2, net.minecraft.world.item.ItemStack.l);
            level.a(pos, state, state, 3);
            level.a(GameEvent.c, pos, GameEvent.a.a(state));
        }
        if (flag) {
            TileEntityCampfire.a(level, pos, state);
        }
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityCampfire blockEntity) {
        boolean flag = false;
        for (int i2 = 0; i2 < blockEntity.c.size(); ++i2) {
            if (blockEntity.d[i2] <= 0) continue;
            flag = true;
            blockEntity.d[i2] = MathHelper.a(blockEntity.d[i2] - 2, 0, blockEntity.e[i2]);
        }
        if (flag) {
            TileEntityCampfire.a(level, pos, state);
        }
    }

    public static void b(World level, BlockPosition pos, IBlockData state, TileEntityCampfire blockEntity) {
        int i2;
        RandomSource randomSource = level.A;
        if (randomSource.i() < 0.11f) {
            for (i2 = 0; i2 < randomSource.a(2) + 2; ++i2) {
                BlockCampfire.a(level, pos, state.c(BlockCampfire.c), false);
            }
        }
        i2 = state.c(BlockCampfire.e).e();
        for (int i1 = 0; i1 < blockEntity.c.size(); ++i1) {
            if (blockEntity.c.get(i1).f() || !(randomSource.i() < 0.2f)) continue;
            EnumDirection direction = EnumDirection.b(Math.floorMod(i1 + i2, 4));
            float f2 = 0.3125f;
            double d2 = (double)pos.u() + 0.5 - (double)((float)direction.j() * 0.3125f) + (double)((float)direction.h().j() * 0.3125f);
            double d1 = (double)pos.v() + 0.5;
            double d22 = (double)pos.w() + 0.5 - (double)((float)direction.l() * 0.3125f) + (double)((float)direction.h().l() * 0.3125f);
            for (int i22 = 0; i22 < 4; ++i22) {
                level.a(Particles.ah, d2, d1, d22, 0.0, 5.0E-4, 0.0);
            }
        }
    }

    public NonNullList<net.minecraft.world.item.ItemStack> c() {
        return this.c;
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.c.clear();
        ContainerUtil.b(tag, this.c, registries);
        tag.k("CookingTimes").ifPresentOrElse(ints -> System.arraycopy(ints, 0, this.d, 0, Math.min(this.e.length, ((int[])ints).length)), () -> Arrays.fill(this.d, 0));
        tag.k("CookingTotalTimes").ifPresentOrElse(ints -> System.arraycopy(ints, 0, this.e, 0, Math.min(this.e.length, ((int[])ints).length)), () -> Arrays.fill(this.e, 0));
        tag.j("Paper.StopCooking").ifPresent(bytes -> {
            boolean[] cookingState = new boolean[4];
            for (int index = 0; index < ((byte[])bytes).length; ++index) {
                cookingState[index] = bytes[index] == 1;
            }
            System.arraycopy(cookingState, 0, this.stopCooking, 0, Math.min(this.stopCooking.length, ((byte[])bytes).length));
        });
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        ContainerUtil.a(tag, this.c, true, registries);
        tag.a("CookingTimes", this.d);
        tag.a("CookingTotalTimes", this.e);
        byte[] cookingState = new byte[4];
        for (int index = 0; index < cookingState.length; ++index) {
            cookingState[index] = (byte)(this.stopCooking[index] ? 1 : 0);
        }
        tag.a("Paper.StopCooking", cookingState);
    }

    public PacketPlayOutTileEntityData d() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        ContainerUtil.a(compoundTag, this.c, true, registries);
        return compoundTag;
    }

    public boolean a(WorldServer level, @Nullable EntityLiving entity, net.minecraft.world.item.ItemStack stack) {
        for (int i2 = 0; i2 < this.c.size(); ++i2) {
            net.minecraft.world.item.ItemStack itemStack = this.c.get(i2);
            if (!itemStack.f()) continue;
            Optional<RecipeHolder<RecipeCampfire>> recipeFor = level.t().a(Recipes.e, new SingleRecipeInput(stack), level);
            if (recipeFor.isEmpty()) {
                return false;
            }
            CampfireStartEvent event = new CampfireStartEvent((Block)CraftBlock.at(this.n, this.o), (ItemStack)CraftItemStack.asCraftMirror(stack), (CampfireRecipe)recipeFor.get().toBukkitRecipe());
            this.n.getCraftServer().getPluginManager().callEvent((Event)event);
            this.e[i2] = event.getTotalCookTime();
            this.d[i2] = 0;
            this.c.set(i2, stack.b(1, entity));
            level.a(GameEvent.c, this.ax_(), GameEvent.a.a(entity, this.m()));
            this.f();
            return true;
        }
        return false;
    }

    private void f() {
        this.e();
        this.i().a(this.ax_(), this.m(), this.m(), 3);
    }

    @Override
    public void a() {
        this.c.clear();
    }

    @Override
    public void a(BlockPosition pos, IBlockData state) {
        if (this.n != null) {
            InventoryUtils.a(this.n, pos, this.c());
        }
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        super.a(componentGetter);
        componentGetter.a(DataComponents.ap, ItemContainerContents.a).a(this.c());
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.ap, ItemContainerContents.a(this.c()));
    }

    @Override
    public void a(NBTTagCompound tag) {
        tag.r("Items");
    }
}

