/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.event.block.BlockLockCheckEvent;
import javax.annotation.Nullable;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.ChestLock;
import net.minecraft.world.ContainerUtil;
import net.minecraft.world.IInventory;
import net.minecraft.world.INamableTileEntity;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftLocation;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public abstract class TileEntityContainer
extends TileEntity
implements IInventory,
ITileInventory,
INamableTileEntity {
    public ChestLock d = ChestLock.a;
    @Nullable
    public IChatBaseComponent e;

    protected TileEntityContainer(TileEntityTypes<?> type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.d = ChestLock.b(tag, registries);
        this.e = TileEntityContainer.a(tag.a("CustomName"), registries);
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        this.d.a(tag, registries);
        if (this.e != null) {
            tag.a("CustomName", (NBTBase)ComponentSerialization.a.encodeStart(registries.a(DynamicOpsNBT.a), (Object)this.e).getOrThrow());
        }
    }

    @Override
    public IChatBaseComponent ah() {
        return this.e != null ? this.e : this.j();
    }

    @Override
    public IChatBaseComponent P_() {
        return this.ah();
    }

    @Override
    @Nullable
    public IChatBaseComponent aj() {
        return this.e;
    }

    protected abstract IChatBaseComponent j();

    public boolean d(EntityHuman player) {
        return TileEntityContainer.canUnlock(player, this.d, this.P_(), this);
    }

    @Deprecated
    @DoNotUse
    public static boolean a(EntityHuman player, ChestLock code, IChatBaseComponent displayName) {
        return TileEntityContainer.canUnlock(player, code, displayName, null);
    }

    public static boolean canUnlock(EntityHuman player, ChestLock code, IChatBaseComponent displayName, @Nullable TileEntity blockEntity) {
        if (player instanceof EntityPlayer) {
            EntityPlayer serverPlayer = (EntityPlayer)player;
            if (blockEntity != null && blockEntity.i() != null && blockEntity.i().c_(blockEntity.ax_()) == blockEntity) {
                CraftBlock block = CraftBlock.at(blockEntity.i(), blockEntity.ax_());
                TranslatableComponent lockedMessage = Component.translatable((String)"container.isLocked", (ComponentLike[])new ComponentLike[]{PaperAdventure.asAdventure(displayName)});
                net.kyori.adventure.sound.Sound lockedSound = net.kyori.adventure.sound.Sound.sound((Sound.Type)Sound.BLOCK_CHEST_LOCKED, (Sound.Source)Sound.Source.BLOCK, (float)1.0f, (float)1.0f);
                BlockLockCheckEvent event = new BlockLockCheckEvent((Block)block, (Player)serverPlayer.getBukkitEntity(), (Component)lockedMessage, lockedSound);
                event.callEvent();
                if (event.getResult() == Event.Result.ALLOW) {
                    return true;
                }
                if (event.getResult() == Event.Result.DENY || !player.ak() && !code.a(event.isUsingCustomKeyItemStack() ? CraftItemStack.asNMSCopy(event.getKeyItem()) : player.fb())) {
                    if (event.getLockedMessage() != null) {
                        event.getPlayer().sendActionBar(event.getLockedMessage());
                    }
                    if (event.getLockedSound() != null) {
                        event.getPlayer().playSound(event.getLockedSound());
                    }
                    return false;
                }
                return true;
            }
        }
        if (!player.ak() && !code.a(player.fb())) {
            player.a(IChatBaseComponent.a("container.isLocked", displayName), true);
            player.a(SoundEffects.eT, SoundCategory.e, 1.0f, 1.0f);
            return false;
        }
        return true;
    }

    protected abstract NonNullList<ItemStack> f();

    protected abstract void a(NonNullList<ItemStack> var1);

    @Override
    public boolean c() {
        for (ItemStack itemStack : this.f()) {
            if (itemStack.f()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack a(int slot) {
        return this.f().get(slot);
    }

    @Override
    public ItemStack a(int slot, int amount) {
        ItemStack itemStack = ContainerUtil.a(this.f(), slot, amount);
        if (!itemStack.f()) {
            this.e();
        }
        return itemStack;
    }

    @Override
    public ItemStack b(int slot) {
        return ContainerUtil.a(this.f(), slot);
    }

    @Override
    public void a(int slot, ItemStack stack) {
        this.f().set(slot, stack);
        stack.f(this.f_(stack));
        this.e();
    }

    @Override
    public boolean a(EntityHuman player) {
        return IInventory.a(this, player);
    }

    @Override
    public void a() {
        this.f().clear();
    }

    @Override
    @Nullable
    public Container createMenu(int containerId, PlayerInventory playerInventory, EntityHuman player) {
        return this.d(player) ? this.a(containerId, playerInventory) : null;
    }

    protected abstract Container a(int var1, PlayerInventory var2);

    @Override
    protected void a(DataComponentGetter componentGetter) {
        super.a(componentGetter);
        this.e = componentGetter.a(DataComponents.g);
        this.d = componentGetter.a(DataComponents.as, ChestLock.a);
        componentGetter.a(DataComponents.ap, ItemContainerContents.a).a(this.f());
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.g, this.e);
        if (!this.d.equals(ChestLock.a)) {
            components.a(DataComponents.as, this.d);
        }
        components.a(DataComponents.ap, ItemContainerContents.a(this.f()));
    }

    @Override
    public void a(NBTTagCompound tag) {
        tag.r("CustomName");
        tag.r("lock");
        tag.r("Items");
    }

    @Override
    @Nullable
    public Location getLocation() {
        if (this.n == null) {
            return null;
        }
        return CraftLocation.toBukkit(this.o, this.n);
    }
}

