/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.adventure.PaperAdventure;
import io.papermc.paper.commands.DelegatingCommandSource;
import io.papermc.paper.event.player.PlayerSignCommandPreprocessEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kyori.adventure.text.Component;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockSign;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Sign;
import org.bukkit.block.sign.Side;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftSign;
import org.bukkit.craftbukkit.v1_21_R4.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.util.LazyPlayerSet;
import org.bukkit.entity.Player;
import org.bukkit.event.block.SignChangeEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class TileEntitySign
extends TileEntity {
    private static final Logger a = LogUtils.getLogger();
    private static final int b = 90;
    private static final int c = 10;
    private static final boolean d = false;
    @Nullable
    public UUID e;
    private SignText f;
    private SignText g;
    private boolean h = false;
    private final ICommandListener commandSource = new ICommandListener(){

        @Override
        public void a(IChatBaseComponent message) {
        }

        @Override
        public CommandSender getBukkitSender(CommandListenerWrapper commandSourceStack) {
            return commandSourceStack.f() != null ? commandSourceStack.f().getBukkitEntity() : new CraftBlockCommandSender(commandSourceStack, TileEntitySign.this);
        }

        @Override
        public boolean x_() {
            return false;
        }

        @Override
        public boolean y_() {
            return false;
        }

        @Override
        public boolean c() {
            return false;
        }
    };

    public TileEntitySign(BlockPosition pos, IBlockData blockState) {
        this((TileEntityTypes)TileEntityTypes.h, pos, blockState);
    }

    public TileEntitySign(TileEntityTypes type, BlockPosition pos, IBlockData blockState) {
        super(type, pos, blockState);
        this.f = this.f();
        this.g = this.f();
    }

    protected SignText f() {
        return new SignText();
    }

    public boolean a(EntityHuman player) {
        return this.isFacingFrontText(player.dA(), player.dG());
    }

    public boolean isFacingFrontText(double x2, double z2) {
        Block block = this.m().b();
        if (block instanceof BlockSign) {
            float f2;
            BlockSign signBlock = (BlockSign)block;
            Vec3D signHitboxCenterPosition = signBlock.o(this.m());
            double d2 = x2 - ((double)this.ax_().u() + signHitboxCenterPosition.d);
            double d1 = z2 - ((double)this.ax_().w() + signHitboxCenterPosition.f);
            float yRotationDegrees = signBlock.h(this.m());
            return MathHelper.d(yRotationDegrees, f2 = (float)(MathHelper.d(d1, d2) * 180.0 / 3.1415927410125732) - 90.0f) <= 90.0f;
        }
        return false;
    }

    public SignText a(boolean isFrontText) {
        return isFrontText ? this.f : this.g;
    }

    public SignText j() {
        return this.f;
    }

    public SignText k() {
        return this.g;
    }

    public int a() {
        return 10;
    }

    public int c() {
        return 90;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        RegistryOps<NBTBase> dynamicOps = registries.a(DynamicOpsNBT.a);
        tag.a("front_text", SignText.a, dynamicOps, this.f);
        tag.a("back_text", SignText.a, dynamicOps, this.g);
        tag.a("is_waxed", this.h);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        RegistryOps<NBTBase> dynamicOps = registries.a(DynamicOpsNBT.a);
        this.f = tag.a("front_text", SignText.a, (DynamicOps<NBTBase>)dynamicOps).map(this::a).orElseGet(SignText::new);
        this.g = tag.a("back_text", SignText.a, (DynamicOps<NBTBase>)dynamicOps).map(this::a).orElseGet(SignText::new);
        this.h = tag.b("is_waxed", false);
    }

    private SignText a(SignText text) {
        for (int i2 = 0; i2 < 4; ++i2) {
            IChatBaseComponent component = this.a(text.a(i2, false));
            IChatBaseComponent component1 = this.a(text.a(i2, true));
            text = text.a(i2, component, component1);
        }
        return text;
    }

    private IChatBaseComponent a(IChatBaseComponent lineText) {
        World world = this.n;
        if (world instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            try {
                return ChatComponentUtils.a(this.a(null, (World)serverLevel, this.o), lineText, null, 0);
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
        return lineText;
    }

    public void a(EntityHuman player, boolean isFrontText, List<FilteredText> filteredText) {
        if (!this.u() && player.cG().equals(this.t()) && this.n != null) {
            this.a(signText -> this.setMessages(player, filteredText, (SignText)signText, isFrontText), isFrontText);
            this.a((UUID)null);
            this.n.a(this.ax_(), this.m(), this.m(), 3);
        } else {
            a.warn("Player {} just tried to change non-editable sign", (Object)player.ah().getString());
            if (player.h(this.ax_().u(), this.ax_().v(), this.ax_().w()) < (double)MathHelper.h(32)) {
                ((EntityPlayer)player).f.b(this.s());
            }
        }
    }

    public boolean a(UnaryOperator<SignText> updater, boolean isFrontText) {
        SignText text = this.a(isFrontText);
        return this.a((SignText)updater.apply(text), isFrontText);
    }

    private SignText setMessages(EntityHuman player, List<FilteredText> filteredText, SignText text, boolean front) {
        SignText originalText = text;
        for (int i2 = 0; i2 < filteredText.size(); ++i2) {
            FilteredText filteredText1 = filteredText.get(i2);
            ChatModifier style = text.a(i2, player.W()).a();
            text = player.W() ? text.a(i2, IChatBaseComponent.b(UtilColor.g(filteredText1.b())).b(style)) : text.a(i2, IChatBaseComponent.b(filteredText1.d()).b(style), IChatBaseComponent.b(UtilColor.g(filteredText1.b())).b(style));
        }
        CraftPlayer apiPlayer = ((EntityPlayer)player).getBukkitEntity();
        ArrayList<Component> lines = new ArrayList<Component>();
        for (int i3 = 0; i3 < filteredText.size(); ++i3) {
            lines.add(PaperAdventure.asAdventure(text.a(i3, player.W())));
        }
        SignChangeEvent event = new SignChangeEvent((org.bukkit.block.Block)CraftBlock.at(this.n, this.o), (Player)apiPlayer, new ArrayList(lines), front ? Side.FRONT : Side.BACK);
        if (!event.callEvent()) {
            return originalText;
        }
        IChatBaseComponent[] components = CraftSign.sanitizeLines(event.lines());
        for (int i4 = 0; i4 < components.length; ++i4) {
            if (Objects.equals(lines.get(i4), event.line(i4))) continue;
            text = text.a(i4, components[i4]);
        }
        return text;
    }

    public boolean a(SignText text, boolean isFrontText) {
        return isFrontText ? this.c(text) : this.b(text);
    }

    private boolean b(SignText text) {
        if (text != this.g) {
            this.g = text;
            this.v();
            return true;
        }
        return false;
    }

    private boolean c(SignText text) {
        if (text != this.f) {
            this.f = text;
            this.v();
            return true;
        }
        return false;
    }

    public boolean a(boolean isFrontText, EntityHuman player) {
        return this.u() && this.a(isFrontText).b(player);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean a(EntityHuman player, World level, BlockPosition pos, boolean frontText) {
        boolean flag = false;
        IChatBaseComponent[] iChatBaseComponentArray = this.a(frontText).b(player.W());
        int n2 = iChatBaseComponentArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IChatBaseComponent component = iChatBaseComponentArray[n3];
            ChatModifier style = component.a();
            ChatClickable chatClickable = style.i();
            if (chatClickable instanceof ChatClickable.RunCommand) {
                PlayerSignCommandPreprocessEvent event;
                Object command;
                ChatClickable.RunCommand runCommand = (ChatClickable.RunCommand)chatClickable;
                try {
                    String string;
                    String var14;
                    String runCommand2 = var14 = (string = runCommand.b());
                    Object object = command = runCommand2.startsWith("/") ? runCommand2 : "/" + runCommand2;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (SpigotConfig.logCommands) {
                    a.info("{} issued server command: {}", (Object)player.cI(), command);
                }
                if (!(event = new PlayerSignCommandPreprocessEvent((Player)player.getBukkitEntity(), (String)command, (Set)new LazyPlayerSet(player.cV()), (Sign)CraftBlock.at(this.n, this.o).getState(), frontText ? Side.FRONT : Side.BACK)).callEvent()) {
                    return false;
                }
                player.cV().aG().a(this.a((EntityHuman)((CraftPlayer)event.getPlayer()).getHandle(), level, pos), event.getMessage());
                flag = true;
            }
            ++n3;
        }
        return flag;
    }

    private CommandListenerWrapper a(final @Nullable EntityHuman player, World level, BlockPosition pos) {
        String string = player == null ? "Sign" : player.ah().getString();
        IChatBaseComponent component = player == null ? IChatBaseComponent.b("Sign") : player.P_();
        ICommandListener commandSource = level.paperConfig().misc.showSignClickCommandFailureMsgsToPlayer ? new DelegatingCommandSource(this, this.commandSource){

            @Override
            public void a(IChatBaseComponent message) {
                if (player instanceof EntityPlayer) {
                    EntityPlayer serverPlayer = (EntityPlayer)player;
                    serverPlayer.a(message);
                }
            }

            @Override
            public boolean y_() {
                return true;
            }
        } : this.commandSource;
        return new CommandListenerWrapper(commandSource, Vec3D.b(pos), Vec2F.a, (WorldServer)level, 2, string, component, level.p(), player);
    }

    public PacketPlayOutTileEntityData s() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public void a(@Nullable UUID playWhoMayEdit) {
        this.e = playWhoMayEdit;
    }

    @Nullable
    public UUID t() {
        if (this.n != null && this.e != null) {
            this.a(this, this.n, this.e);
        }
        return this.e;
    }

    private void v() {
        this.e();
        if (this.n != null) {
            this.n.a(this.ax_(), this.m(), this.m(), 3);
        }
    }

    public boolean u() {
        return this.h;
    }

    public boolean b(boolean isWaxed) {
        if (this.h != isWaxed) {
            this.h = isWaxed;
            this.v();
            return true;
        }
        return false;
    }

    public boolean b(UUID uuid) {
        EntityHuman playerByUuid = this.n.a(uuid);
        return playerByUuid == null || !playerByUuid.a(this.ax_(), 4.0);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntitySign sign) {
        UUID playerWhoMayEdit = sign.t();
        if (playerWhoMayEdit != null) {
            sign.a(sign, level, playerWhoMayEdit);
        }
    }

    private void a(TileEntitySign sign, World level, UUID uuid) {
        if (sign.b(uuid)) {
            sign.a((UUID)null);
        }
    }

    public SoundEffect d() {
        return SoundEffects.Df;
    }
}

