/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import com.destroystokyo.paper.profile.PaperMinecraftSessionService;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.ProfileResult;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.Services;
import net.minecraft.util.UtilColor;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockSkullAbstract;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import org.jetbrains.annotations.Nullable;

public class TileEntitySkull
extends TileEntity {
    private static final String b = "profile";
    private static final String c = "note_block_sound";
    private static final String d = "custom_name";
    @javax.annotation.Nullable
    private static Executor e;
    @javax.annotation.Nullable
    private static LoadingCache<String, CompletableFuture<Optional<GameProfile>>> f;
    @javax.annotation.Nullable
    private static LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> g;
    public static final Executor a;
    @javax.annotation.Nullable
    public ResolvableProfile h;
    @javax.annotation.Nullable
    public MinecraftKey i;
    private int j;
    private boolean k;
    @javax.annotation.Nullable
    public IChatBaseComponent l;

    public TileEntitySkull(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.q, pos, blockState);
    }

    public static void a(final Services services, Executor mainThreadExecutor) {
        e = mainThreadExecutor;
        final BooleanSupplier booleanSupplier = () -> g == null;
        f = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<String, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> a(String username) {
                return TileEntitySkull.a(username, services);
            }
        });
        g = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).maximumSize(256L).build((CacheLoader)new CacheLoader<Pair<UUID, GameProfile>, CompletableFuture<Optional<GameProfile>>>(){

            public CompletableFuture<Optional<GameProfile>> load(Pair<UUID, @Nullable GameProfile> id) {
                return TileEntitySkull.fetchProfileById(id, services, booleanSupplier);
            }
        });
    }

    static CompletableFuture<Optional<GameProfile>> a(String name, Services services) {
        return services.f().b(name).thenCompose(optional -> {
            LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = g;
            return loadingCache != null && !optional.isEmpty() ? ((CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)((GameProfile)optional.get()).getId(), (Object)((GameProfile)optional.get())))).thenApply(optional1 -> optional1.or(() -> optional)) : CompletableFuture.completedFuture(Optional.empty());
        });
    }

    static CompletableFuture<Optional<GameProfile>> fetchProfileById(Pair<UUID, @Nullable GameProfile> id, Services services, BooleanSupplier cacheUninitialized) {
        return CompletableFuture.supplyAsync(() -> {
            if (cacheUninitialized.getAsBoolean()) {
                return Optional.empty();
            }
            MinecraftSessionService patt0$temp = services.c();
            if (patt0$temp instanceof PaperMinecraftSessionService) {
                PaperMinecraftSessionService paperService = (PaperMinecraftSessionService)patt0$temp;
                GameProfile profile = id.getSecond() != null ? (GameProfile)id.getSecond() : new GameProfile((UUID)id.getFirst(), "");
                return Optional.ofNullable(paperService.fetchProfile(profile, true)).map(ProfileResult::profile);
            }
            ProfileResult profileResult = services.c().fetchProfile((UUID)id.getFirst(), true);
            return Optional.ofNullable(profileResult).map(ProfileResult::profile);
        }, SystemUtils.PROFILE_EXECUTOR);
    }

    public static void a() {
        e = null;
        f = null;
        g = null;
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.b(b, ResolvableProfile.a, this.h);
        tag.b(c, MinecraftKey.a, this.i);
        tag.b(d, ComponentSerialization.a, registries.a(DynamicOpsNBT.a), this.l);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.a((ResolvableProfile)tag.a(b, ResolvableProfile.a).orElse(null));
        this.i = tag.a(c, MinecraftKey.a).orElse(null);
        this.l = TileEntitySkull.a(tag.a(d), registries);
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntitySkull blockEntity) {
        if (state.b(BlockSkullAbstract.a) && state.c(BlockSkullAbstract.a).booleanValue()) {
            blockEntity.k = true;
            ++blockEntity.j;
        } else {
            blockEntity.k = false;
        }
    }

    public float a(float partialTick) {
        return this.k ? (float)this.j + partialTick : (float)this.j;
    }

    @javax.annotation.Nullable
    public ResolvableProfile c() {
        return this.h;
    }

    @javax.annotation.Nullable
    public MinecraftKey d() {
        return this.i;
    }

    public PacketPlayOutTileEntityData f() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(@javax.annotation.Nullable ResolvableProfile owner) {
        TileEntitySkull tileEntitySkull = this;
        synchronized (tileEntitySkull) {
            this.h = owner;
        }
        this.j();
    }

    private void j() {
        if (this.h != null && !this.h.b()) {
            this.h.a().thenAcceptAsync(resolvableProfile -> {
                this.h = resolvableProfile;
                this.e();
            }, a);
        } else {
            this.e();
        }
    }

    public static CompletableFuture<Optional<GameProfile>> a(String profileName) {
        LoadingCache<String, CompletableFuture<Optional<GameProfile>>> loadingCache = f;
        return loadingCache != null && UtilColor.f(profileName) ? (CompletableFuture)loadingCache.getUnchecked((Object)profileName) : CompletableFuture.completedFuture(Optional.empty());
    }

    public static CompletableFuture<Optional<GameProfile>> fetchGameProfile(UUID profileUuid, @javax.annotation.Nullable String name) {
        LoadingCache<Pair<UUID, @Nullable GameProfile>, CompletableFuture<Optional<GameProfile>>> loadingCache = g;
        return loadingCache != null ? (CompletableFuture)loadingCache.getUnchecked((Object)new Pair((Object)profileUuid, (Object)(name != null ? new GameProfile(profileUuid, name) : null))) : CompletableFuture.completedFuture(Optional.empty());
    }

    @Override
    protected void a(DataComponentGetter componentGetter) {
        super.a(componentGetter);
        this.a(componentGetter.a(DataComponents.ak));
        this.i = componentGetter.a(DataComponents.al);
        this.l = componentGetter.a(DataComponents.g);
    }

    @Override
    protected void a(DataComponentMap.a components) {
        super.a(components);
        components.a(DataComponents.ak, this.h);
        components.a(DataComponents.al, this.i);
        components.a(DataComponents.g, this.l);
    }

    @Override
    public void a(NBTTagCompound tag) {
        super.a(tag);
        tag.r(b);
        tag.r(c);
        tag.r(d);
    }

    static {
        a = runnable -> {
            Executor executor = e;
            if (executor != null) {
                executor.execute(runnable);
            }
        };
    }
}

