/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity;

import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.UtilColor;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockStructure;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.BoundingBoxRenderable;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class TileEntityStructure
extends TileEntity
implements BoundingBoxRenderable {
    private static final int d = 5;
    public static final int a = 48;
    public static final int b = 48;
    public static final String c = "author";
    private static final String e = "";
    private static final String f = "";
    private static final BlockPosition g = new BlockPosition(0, 1, 0);
    private static final BaseBlockPosition h = BaseBlockPosition.i;
    private static final EnumBlockRotation i = EnumBlockRotation.a;
    private static final EnumBlockMirror j = EnumBlockMirror.a;
    private static final boolean k = true;
    private static final boolean l = false;
    private static final boolean m = false;
    private static final boolean q = false;
    private static final boolean r = true;
    private static final float s = 1.0f;
    private static final long t = 0L;
    @Nullable
    private MinecraftKey u;
    public String v = "";
    public String w = "";
    public BlockPosition x = g;
    public BaseBlockPosition y = h;
    public EnumBlockMirror z = EnumBlockMirror.a;
    public EnumBlockRotation A = EnumBlockRotation.a;
    public BlockPropertyStructureMode B;
    public boolean C = true;
    private boolean D = false;
    private boolean E = false;
    public boolean F = false;
    public boolean G = true;
    public float H = 1.0f;
    public long I = 0L;

    public TileEntityStructure(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.v, pos, blockState);
        this.B = blockState.c(BlockStructure.b);
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        tag.a("name", this.d());
        tag.a(c, this.v);
        tag.a("metadata", this.w);
        tag.a("posX", this.x.u());
        tag.a("posY", this.x.v());
        tag.a("posZ", this.x.w());
        tag.a("sizeX", this.y.u());
        tag.a("sizeY", this.y.v());
        tag.a("sizeZ", this.y.w());
        tag.a("rotation", EnumBlockRotation.h, this.A);
        tag.a("mirror", EnumBlockMirror.e, this.z);
        tag.a("mode", BlockPropertyStructureMode.e, this.B);
        tag.a("ignoreEntities", this.C);
        tag.a("strict", this.D);
        tag.a("powered", this.E);
        tag.a("showair", this.F);
        tag.a("showboundingbox", this.G);
        tag.a("integrity", this.H);
        tag.a("seed", this.I);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        this.a(tag.b("name", ""));
        this.v = tag.b(c, "");
        this.w = tag.b("metadata", "");
        int i2 = MathHelper.a(tag.b("posX", g.u()), -48, 48);
        int i1 = MathHelper.a(tag.b("posY", g.v()), -48, 48);
        int i22 = MathHelper.a(tag.b("posZ", g.w()), -48, 48);
        this.x = new BlockPosition(i2, i1, i22);
        int i3 = MathHelper.a(tag.b("sizeX", h.u()), 0, 48);
        int i4 = MathHelper.a(tag.b("sizeY", h.v()), 0, 48);
        int i5 = MathHelper.a(tag.b("sizeZ", h.w()), 0, 48);
        this.y = new BaseBlockPosition(i3, i4, i5);
        this.A = tag.a("rotation", EnumBlockRotation.h).orElse(i);
        this.z = tag.a("mirror", EnumBlockMirror.e).orElse(j);
        this.B = tag.a("mode", BlockPropertyStructureMode.e).orElse(BlockPropertyStructureMode.d);
        this.C = tag.b("ignoreEntities", true);
        this.D = tag.b("strict", false);
        this.E = tag.b("powered", false);
        this.F = tag.b("showair", false);
        this.G = tag.b("showboundingbox", true);
        this.H = tag.b("integrity", 1.0f);
        this.I = tag.b("seed", 0L);
        this.H();
    }

    private void H() {
        BlockPosition blockPos;
        IBlockData blockState;
        if (this.n != null && (blockState = this.n.a_(blockPos = this.ax_())).a(Blocks.pG)) {
            this.n.a(blockPos, (IBlockData)blockState.b(BlockStructure.b, this.B), 2);
        }
    }

    public PacketPlayOutTileEntityData a() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public boolean a(EntityHuman player) {
        if (!player.gH()) {
            return false;
        }
        if (player.cU().C) {
            player.a(this);
        }
        return true;
    }

    public String d() {
        return this.u == null ? "" : this.u.toString();
    }

    public boolean f() {
        return this.u != null;
    }

    public void a(@Nullable String structureName) {
        this.a(UtilColor.b(structureName) ? null : MinecraftKey.c(structureName));
    }

    public void a(@Nullable MinecraftKey structureName) {
        this.u = structureName;
    }

    public void a(EntityLiving author) {
        this.v = author.ah().getString();
    }

    public BlockPosition j() {
        return this.x;
    }

    public void a(BlockPosition structurePos) {
        this.x = structurePos;
    }

    public BaseBlockPosition k() {
        return this.y;
    }

    public void a(BaseBlockPosition structureSize) {
        this.y = structureSize;
    }

    public EnumBlockMirror s() {
        return this.z;
    }

    public void a(EnumBlockMirror mirror) {
        this.z = mirror;
    }

    public EnumBlockRotation t() {
        return this.A;
    }

    public void a(EnumBlockRotation rotation) {
        this.A = rotation;
    }

    public String u() {
        return this.w;
    }

    public void b(String metaData) {
        this.w = metaData;
    }

    public BlockPropertyStructureMode v() {
        return this.B;
    }

    public void a(BlockPropertyStructureMode mode) {
        this.B = mode;
        IBlockData blockState = this.n.a_(this.ax_());
        if (blockState.a(Blocks.pG)) {
            this.n.a(this.ax_(), (IBlockData)blockState.b(BlockStructure.b, mode), 2);
        }
    }

    public boolean w() {
        return this.C;
    }

    public boolean x() {
        return this.D;
    }

    public void a(boolean ignoreEntities) {
        this.C = ignoreEntities;
    }

    public void b(boolean strict) {
        this.D = strict;
    }

    public float y() {
        return this.H;
    }

    public void a(float integrity) {
        this.H = integrity;
    }

    public long z() {
        return this.I;
    }

    public void a(long seed) {
        this.I = seed;
    }

    public boolean A() {
        if (this.B != BlockPropertyStructureMode.a) {
            return false;
        }
        BlockPosition blockPos = this.ax_();
        int i2 = 80;
        BlockPosition blockPos1 = new BlockPosition(blockPos.u() - 80, this.n.K_(), blockPos.w() - 80);
        BlockPosition blockPos2 = new BlockPosition(blockPos.u() + 80, this.n.ao(), blockPos.w() + 80);
        Stream<BlockPosition> relatedCorners = this.a(blockPos1, blockPos2);
        return TileEntityStructure.a(blockPos, relatedCorners).filter(boundingBox -> {
            int i1 = boundingBox.k() - boundingBox.h();
            int i2 = boundingBox.l() - boundingBox.i();
            int i3 = boundingBox.m() - boundingBox.j();
            if (i1 > 1 && i2 > 1 && i3 > 1) {
                this.x = new BlockPosition(boundingBox.h() - blockPos.u() + 1, boundingBox.i() - blockPos.v() + 1, boundingBox.j() - blockPos.w() + 1);
                this.y = new BaseBlockPosition(i1 - 1, i2 - 1, i3 - 1);
                this.e();
                IBlockData blockState = this.n.a_(blockPos);
                this.n.a(blockPos, blockState, blockState, 3);
                return true;
            }
            return false;
        }).isPresent();
    }

    private Stream<BlockPosition> a(BlockPosition minPos, BlockPosition maxPos) {
        return BlockPosition.d(minPos, maxPos).filter(pos -> this.n.a_((BlockPosition)pos).a(Blocks.pG)).map(this.n::c_).filter(blockEntity -> blockEntity instanceof TileEntityStructure).map(blockEntity -> (TileEntityStructure)blockEntity).filter(blockEntity -> blockEntity.B == BlockPropertyStructureMode.c && Objects.equals(this.u, blockEntity.u)).map(TileEntity::ax_);
    }

    private static Optional<StructureBoundingBox> a(BlockPosition pos, Stream<BlockPosition> relatedCorners) {
        Iterator iterator = relatedCorners.iterator();
        if (!iterator.hasNext()) {
            return Optional.empty();
        }
        BlockPosition blockPos = (BlockPosition)iterator.next();
        StructureBoundingBox boundingBox = new StructureBoundingBox(blockPos);
        if (iterator.hasNext()) {
            iterator.forEachRemaining(boundingBox::a);
        } else {
            boundingBox.a(pos);
        }
        return Optional.of(boundingBox);
    }

    public boolean B() {
        return this.B == BlockPropertyStructureMode.a && this.c(true);
    }

    public boolean c(boolean writeToDisk) {
        World world;
        if (this.u != null && (world = this.n) instanceof WorldServer) {
            WorldServer serverLevel = (WorldServer)world;
            BlockPosition var4 = this.ax_().a(this.x);
            return TileEntityStructure.a(serverLevel, this.u, var4, this.y, this.C, this.v, writeToDisk);
        }
        return false;
    }

    public static boolean a(WorldServer level, MinecraftKey name, BlockPosition pos, BaseBlockPosition size, boolean ignoreEntities, String author, boolean writeToDisk) {
        DefinedStructure structureTemplate;
        StructureTemplateManager structureManager = level.r();
        try {
            structureTemplate = structureManager.a(name);
        }
        catch (ResourceKeyInvalidException var11) {
            return false;
        }
        structureTemplate.a(level, pos, size, !ignoreEntities, Blocks.lt);
        structureTemplate.a(author);
        if (writeToDisk) {
            try {
                return structureManager.c(name);
            }
            catch (ResourceKeyInvalidException var10) {
                return false;
            }
        }
        return true;
    }

    public static RandomSource b(long seed) {
        return seed == 0L ? RandomSource.a(SystemUtils.c()) : RandomSource.a(seed);
    }

    public boolean a(WorldServer level) {
        if (this.B == BlockPropertyStructureMode.b && this.u != null) {
            DefinedStructure structureTemplate = level.r().b(this.u).orElse(null);
            if (structureTemplate == null) {
                return false;
            }
            if (structureTemplate.a().equals(this.y)) {
                this.a(level, structureTemplate);
                return true;
            }
            this.a(structureTemplate);
            return false;
        }
        return false;
    }

    public boolean b(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate == null) {
            return false;
        }
        this.a(structureTemplate);
        return true;
    }

    private void a(DefinedStructure structureTemplate) {
        this.v = !UtilColor.b(structureTemplate.b()) ? structureTemplate.b() : "";
        this.y = structureTemplate.a();
        this.e();
    }

    public void c(WorldServer level) {
        DefinedStructure structureTemplate = this.d(level);
        if (structureTemplate != null) {
            this.a(level, structureTemplate);
        }
    }

    @Nullable
    private DefinedStructure d(WorldServer level) {
        return this.u == null ? null : (DefinedStructure)level.r().b(this.u).orElse(null);
    }

    private void a(WorldServer level, DefinedStructure structureTemplate) {
        this.a(structureTemplate);
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(this.z).a(this.A).a(this.C).b(this.D);
        if (this.H < 1.0f) {
            structurePlaceSettings.b().a(new DefinedStructureProcessorRotation(MathHelper.a(this.H, 0.0f, 1.0f))).a(TileEntityStructure.b(this.I));
        }
        BlockPosition blockPos = this.ax_().a(this.x);
        structureTemplate.a(level, blockPos, blockPos, structurePlaceSettings, TileEntityStructure.b(this.I), 2 | (this.D ? 816 : 0));
    }

    public void C() {
        if (this.u != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.r();
            structureManager.d(this.u);
        }
    }

    public boolean D() {
        if (this.B == BlockPropertyStructureMode.b && !this.n.C && this.u != null) {
            WorldServer serverLevel = (WorldServer)this.n;
            StructureTemplateManager structureManager = serverLevel.r();
            try {
                return structureManager.b(this.u).isPresent();
            }
            catch (ResourceKeyInvalidException var4) {
                return false;
            }
        }
        return false;
    }

    public boolean E() {
        return this.E;
    }

    public void d(boolean powered) {
        this.E = powered;
    }

    public boolean F() {
        return this.F;
    }

    public void e(boolean showAir) {
        this.F = showAir;
    }

    public boolean G() {
        return this.G;
    }

    public void f(boolean showBoundingBox) {
        this.G = showBoundingBox;
    }

    @Override
    public BoundingBoxRenderable.a b() {
        if (this.B != BlockPropertyStructureMode.a && this.B != BlockPropertyStructureMode.b) {
            return BoundingBoxRenderable.a.a;
        }
        if (this.B == BlockPropertyStructureMode.a && this.F) {
            return BoundingBoxRenderable.a.c;
        }
        return this.B != BlockPropertyStructureMode.a && !this.G ? BoundingBoxRenderable.a.a : BoundingBoxRenderable.a.b;
    }

    @Override
    public BoundingBoxRenderable.b c() {
        int i4;
        int i3;
        int i2;
        int x1;
        BlockPosition structurePos = this.j();
        BaseBlockPosition structureSize = this.k();
        int x2 = structurePos.u();
        int z2 = structurePos.w();
        int y2 = structurePos.v();
        int i5 = y2 + structureSize.v();
        return BoundingBoxRenderable.b.a(i2, y2, i3, i4, i5, switch (this.A) {
            case EnumBlockRotation.b -> {
                i2 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? x2 : x2 + 1;
                i3 = x1 < 0 ? z2 + 1 : z2;
                i4 = i2 - (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
                yield i3 + x1;
            }
            case EnumBlockRotation.c -> {
                i2 = x1 < 0 ? x2 : x2 + 1;
                i3 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? z2 : z2 + 1;
                i4 = i2 - x1;
                yield i3 - (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
            }
            case EnumBlockRotation.d -> {
                i2 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? x2 + 1 : x2;
                i3 = x1 < 0 ? z2 : z2 + 1;
                i4 = i2 + (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
                yield i3 - x1;
            }
            default -> {
                i2 = x1 < 0 ? x2 + 1 : x2;
                i3 = (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                }) < 0 ? z2 + 1 : z2;
                i4 = i2 + x1;
                yield i3 + (switch (this.z) {
                    case EnumBlockMirror.b -> {
                        x1 = structureSize.u();
                        yield -structureSize.w();
                    }
                    case EnumBlockMirror.c -> {
                        x1 = -structureSize.u();
                        yield structureSize.w();
                    }
                    default -> {
                        x1 = structureSize.u();
                        yield structureSize.w();
                    }
                });
            }
        });
    }

    public static final class UpdateType
    extends Enum<UpdateType> {
        public static final /* enum */ UpdateType a = new UpdateType();
        public static final /* enum */ UpdateType b = new UpdateType();
        public static final /* enum */ UpdateType c = new UpdateType();
        public static final /* enum */ UpdateType d = new UpdateType();
        private static final /* synthetic */ UpdateType[] e;

        public static UpdateType[] values() {
            return (UpdateType[])e.clone();
        }

        public static UpdateType valueOf(String name) {
            return Enum.valueOf(UpdateType.class, name);
        }

        private static /* synthetic */ UpdateType[] a() {
            return new UpdateType[]{a, b, c, d};
        }

        static {
            e = UpdateType.a();
        }
    }
}

