/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class TrialSpawner {
    public static final String a = "normal_config";
    public static final String b = "ominous_config";
    public static final int c = 40;
    private static final int d = 36000;
    private static final int e = 14;
    private static final int f = 47;
    private static final int g = MathHelper.h(47);
    private static final float h = 0.02f;
    public Holder<TrialSpawnerConfig> i;
    public Holder<TrialSpawnerConfig> j;
    private final TrialSpawnerData k;
    public int l;
    public int m;
    public final b n;
    private PlayerDetector o;
    private final PlayerDetector.a p;
    private boolean q;
    public boolean r;

    public MapCodec<TrialSpawner> a() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)TrialSpawnerConfig.c.optionalFieldOf(a, Holder.a(TrialSpawnerConfig.a)).forGetter(trialSpawner -> trialSpawner.i), (App)TrialSpawnerConfig.c.optionalFieldOf(b, Holder.a(TrialSpawnerConfig.a)).forGetter(trialSpawner -> trialSpawner.j), (App)TrialSpawnerData.b.forGetter(TrialSpawner::f), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(TrialSpawner::g), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(TrialSpawner::h)).apply((Applicative)instance, (holder, holder1, trialSpawnerData, integer, integer1) -> new TrialSpawner((Holder<TrialSpawnerConfig>)holder, (Holder<TrialSpawnerConfig>)holder1, (TrialSpawnerData)trialSpawnerData, (int)integer, (int)integer1, this.n, this.o, this.p)));
    }

    public TrialSpawner(b stateAccessor, PlayerDetector playerDetector, PlayerDetector.a entitySelector) {
        this(Holder.a(TrialSpawnerConfig.a), Holder.a(TrialSpawnerConfig.a), new TrialSpawnerData(), 36000, 14, stateAccessor, playerDetector, entitySelector);
    }

    public TrialSpawner(Holder<TrialSpawnerConfig> normalConfig, Holder<TrialSpawnerConfig> ominousConfig, TrialSpawnerData data, int targetCooldownLength, int requiredPlayerRange, b stateAccessor, PlayerDetector playerDetector, PlayerDetector.a entitySelector) {
        this.i = normalConfig;
        this.j = ominousConfig;
        this.k = data;
        this.m = targetCooldownLength;
        this.l = requiredPlayerRange;
        this.n = stateAccessor;
        this.o = playerDetector;
        this.p = entitySelector;
    }

    public TrialSpawnerConfig b() {
        return this.r ? this.d() : this.c();
    }

    @VisibleForTesting
    public TrialSpawnerConfig c() {
        return this.i.a();
    }

    @VisibleForTesting
    public TrialSpawnerConfig d() {
        return this.j.a();
    }

    public void a(WorldServer level, BlockPosition pos) {
        level.a(pos, (IBlockData)level.a_(pos).b(TrialSpawnerBlock.c, true), 3);
        level.c(3020, pos, 1);
        this.r = true;
        this.k.a(this, level);
    }

    public void b(WorldServer level, BlockPosition pos) {
        level.a(pos, (IBlockData)level.a_(pos).b(TrialSpawnerBlock.c, false), 3);
        this.r = false;
    }

    public boolean e() {
        return this.r;
    }

    public TrialSpawnerData f() {
        return this.k;
    }

    public int g() {
        return this.m;
    }

    public int h() {
        return this.l;
    }

    public TrialSpawnerState i() {
        return this.n.d();
    }

    public void a(World level, TrialSpawnerState state) {
        this.n.a(level, state);
    }

    public void j() {
        this.n.f();
    }

    public PlayerDetector k() {
        return this.o;
    }

    public PlayerDetector.a l() {
        return this.p;
    }

    public boolean a(WorldServer level) {
        return this.q || level.an() != EnumDifficulty.a && level.O().c(GameRules.f);
    }

    public Optional<UUID> c(WorldServer level, BlockPosition pos) {
        MobSpawnerData.a customSpawnRules;
        RandomSource random = level.G_();
        MobSpawnerData nextSpawnData = this.k.b(this, level.G_());
        NBTTagCompound compoundTag = nextSpawnData.d();
        Optional<EntityTypes<?>> optional = EntityTypes.a(compoundTag);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        Vec3D vec3 = compoundTag.a("Pos", Vec3D.a).orElseGet(() -> new Vec3D((double)pos.u() + (random.j() - random.j()) * (double)this.b().c() + 0.5, pos.v() + random.a(3) - 1, (double)pos.w() + (random.j() - random.j()) * (double)this.b().c() + 0.5));
        if (!level.b(optional.get().a(vec3.d, vec3.e, vec3.f))) {
            return Optional.empty();
        }
        if (!TrialSpawner.a((World)level, pos.b(), vec3)) {
            return Optional.empty();
        }
        BlockPosition blockPos = BlockPosition.a(vec3);
        if (!EntityPositionTypes.a(optional.get(), level, EntitySpawnReason.q, blockPos, level.G_())) {
            return Optional.empty();
        }
        if (nextSpawnData.b().isPresent() && !(customSpawnRules = nextSpawnData.b().get()).a(blockPos, level)) {
            return Optional.empty();
        }
        Entity entity = EntityTypes.a(compoundTag, (World)level, EntitySpawnReason.q, (Entity entity1) -> {
            entity1.b(vec3.d, vec3.e, vec3.f, random.i() * 360.0f, 0.0f);
            return entity1;
        });
        if (entity == null) {
            return Optional.empty();
        }
        if (entity instanceof EntityInsentient) {
            boolean flag;
            EntityInsentient mob = (EntityInsentient)entity;
            if (!mob.a((IWorldReader)level)) {
                return Optional.empty();
            }
            boolean bl = flag = nextSpawnData.a().i() == 1 && nextSpawnData.a().i("id").isPresent();
            if (flag) {
                mob.a((WorldAccess)level, level.d_(mob.dv()), EntitySpawnReason.q, null);
            }
            mob.gc();
            nextSpawnData.c().ifPresent(mob::a);
        }
        entity.spawnedViaMobSpawner = true;
        entity.spawnReason = CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER;
        if (CraftEventFactory.callTrialSpawnerSpawnEvent(entity, pos).isCancelled()) {
            return Optional.empty();
        }
        if (!level.tryAddFreshEntityWithPassengers(entity, CreatureSpawnEvent.SpawnReason.TRIAL_SPAWNER)) {
            return Optional.empty();
        }
        a flameParticle = this.r ? net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b : net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.a;
        level.c(3011, pos, flameParticle.a());
        level.c(3012, blockPos, flameParticle.a());
        level.a(entity, GameEvent.t, blockPos);
        return Optional.of(entity.cG());
    }

    public void a(WorldServer level, BlockPosition pos, ResourceKey<LootTable> lootTable) {
        LootParams lootParams;
        LootTable lootTable1 = level.p().bc().b(lootTable);
        ObjectArrayList randomItems = lootTable1.a(lootParams = new LootParams.a(level).a(LootContextParameterSets.b));
        if (!randomItems.isEmpty()) {
            BlockDispenseLootEvent spawnerDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(level, pos, null, randomItems);
            if (spawnerDispenseLootEvent.isCancelled()) {
                return;
            }
            randomItems = new ObjectArrayList(spawnerDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList());
            for (ItemStack itemStack : randomItems) {
                DispenseBehaviorItem.a(level, itemStack, 2, EnumDirection.b, Vec3D.c(pos).a(EnumDirection.b, 1.2));
            }
            level.c(3014, pos, 0);
        }
    }

    public void a(World level, BlockPosition pos, boolean isOminous) {
        RandomSource random;
        TrialSpawnerState state = this.i();
        state.a(level, pos, isOminous);
        if (state.d()) {
            double d2 = Math.max(0L, this.k.f - level.ae());
            this.k.l = this.k.k;
            this.k.k = (this.k.k + state.b() / (d2 + 200.0)) % 360.0;
        }
        if (state.e() && (random = level.G_()).i() <= 0.02f) {
            SoundEffect soundEvent = isOminous ? SoundEffects.mL : SoundEffects.mK;
            level.a(pos, soundEvent, SoundCategory.e, random.i() * 0.25f + 0.75f, random.i() + 0.5f, false);
        }
    }

    public void a(WorldServer level, BlockPosition pos, boolean isOminous) {
        TrialSpawnerState trialSpawnerState;
        this.r = isOminous;
        TrialSpawnerState state = this.i();
        if (this.k.d.removeIf(uuid -> TrialSpawner.a(level, pos, uuid))) {
            this.k.f = level.ae() + (long)this.b().h();
        }
        if ((trialSpawnerState = state.a(pos, this, level)) != state) {
            this.a((World)level, trialSpawnerState);
        }
    }

    private static boolean a(WorldServer level, BlockPosition pos, UUID uuid) {
        Entity entity = level.b(uuid);
        return entity == null || !entity.bJ() || !entity.dV().aj().equals(level.aj()) || entity.dv().j(pos) > (double)g;
    }

    private static boolean a(World level, Vec3D spawnerPos, Vec3D mobPos) {
        MovingObjectPositionBlock blockHitResult = level.a(new RayTrace(mobPos, spawnerPos, RayTrace.BlockCollisionOption.c, RayTrace.FluidCollisionOption.a, VoxelShapeCollision.a()));
        return blockHitResult.b().equals(BlockPosition.a(spawnerPos)) || blockHitResult.d() == MovingObjectPosition.EnumMovingObjectType.a;
    }

    public static void a(World level, BlockPosition pos, RandomSource random, ParticleType particleType) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d22 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            level.a(Particles.ah, d2, d1, d22, 0.0, 0.0, 0.0);
            level.a(particleType, d2, d1, d22, 0.0, 0.0, 0.0);
        }
    }

    public static void a(World level, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.5 + (random.j() - 0.5) * 2.0;
            double d1 = (double)pos.v() + 0.5 + (random.j() - 0.5) * 2.0;
            double d22 = (double)pos.w() + 0.5 + (random.j() - 0.5) * 2.0;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            level.a(Particles.bh, d2, d1, d22, d3, d4, d5);
            level.a(Particles.N, d2, d1, d22, d3, d4, d5);
        }
    }

    public static void a(World level, BlockPosition pos, RandomSource random, int type, ParticleParam particle) {
        for (int i2 = 0; i2 < 30 + Math.min(type, 10) * 5; ++i2) {
            double d2 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d1 = (double)(2.0f * random.i() - 1.0f) * 0.65;
            double d22 = (double)pos.u() + 0.5 + d2;
            double d3 = (double)pos.v() + 0.1 + (double)random.i() * 0.8;
            double d4 = (double)pos.w() + 0.5 + d1;
            level.a(particle, d22, d3, d4, 0.0, 0.0, 0.0);
        }
    }

    public static void b(World level, BlockPosition pos, RandomSource random) {
        for (int i2 = 0; i2 < 20; ++i2) {
            double d2 = (double)pos.u() + 0.4 + random.j() * 0.2;
            double d1 = (double)pos.v() + 0.4 + random.j() * 0.2;
            double d22 = (double)pos.w() + 0.4 + random.j() * 0.2;
            double d3 = random.k() * 0.02;
            double d4 = random.k() * 0.02;
            double d5 = random.k() * 0.02;
            level.a(Particles.aM, d2, d1, d22, d3, d4, d5 * 0.25);
            level.a(Particles.ah, d2, d1, d22, d3, d4, d5);
        }
    }

    public void a(EntityTypes<?> entityType, World level) {
        this.k.a();
        this.i = Holder.a(this.i.a().a(entityType));
        this.j = Holder.a(this.j.a().a(entityType));
        this.a(level, TrialSpawnerState.a);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void a(PlayerDetector playerDetector) {
        this.o = playerDetector;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void m() {
        this.q = true;
    }

    public static interface b {
        public void a(World var1, TrialSpawnerState var2);

        public TrialSpawnerState d();

        public void f();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a a = new a(Particles.F);
        public static final /* enum */ a b = new a(Particles.N);
        public final ParticleType c;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private a(ParticleType particleType) {
            this.c = particleType;
        }

        public static a a(int id) {
            a[] flameParticles = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.values();
            return id <= flameParticles.length && id >= 0 ? flameParticles[id] : a;
        }

        public int a() {
            return this.ordinal();
        }

        private static /* synthetic */ a[] b() {
            return new a[]{a, b};
        }

        static {
            d = net.minecraft.world.level.block.entity.trialspawner.TrialSpawner$a.b();
        }
    }
}

