/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.DynamicOps;
import io.papermc.paper.event.block.VaultChangeStateEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.network.protocol.game.PacketPlayOutTileEntityData;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.VaultBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.entity.vault.VaultClientData;
import net.minecraft.world.level.block.entity.vault.VaultConfig;
import net.minecraft.world.level.block.entity.vault.VaultServerData;
import net.minecraft.world.level.block.entity.vault.VaultSharedData;
import net.minecraft.world.level.block.entity.vault.VaultState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Vault;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.data.CraftBlockData;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftItemStack;
import org.bukkit.entity.Player;
import org.bukkit.event.block.BlockDispenseLootEvent;
import org.bukkit.event.block.VaultDisplayItemEvent;

public class VaultBlockEntity
extends TileEntity {
    public final VaultServerData a = new VaultServerData();
    private final VaultSharedData b = new VaultSharedData();
    private final VaultClientData c = new VaultClientData();
    private VaultConfig d = VaultConfig.b;

    public VaultBlockEntity(BlockPosition pos, IBlockData state) {
        super(TileEntityTypes.S, pos, state);
    }

    @Override
    @Nullable
    public Packet<PacketListenerPlayOut> au_() {
        return PacketPlayOutTileEntityData.a(this);
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return SystemUtils.a(new NBTTagCompound(), (? super T tag) -> tag.a("shared_data", VaultSharedData.b, registries.a(DynamicOpsNBT.a), this.b));
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        tag.a("config", VaultConfig.c, registryOps, this.d);
        tag.a("shared_data", VaultSharedData.b, registryOps, this.b);
        tag.a("server_data", VaultServerData.b, registryOps, this.a);
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        RegistryOps<NBTBase> dynamicOps = registries.a(DynamicOpsNBT.a);
        tag.a("server_data", VaultServerData.b, (DynamicOps<NBTBase>)dynamicOps).ifPresent(this.a::a);
        this.d = tag.a("config", VaultConfig.c, (DynamicOps<NBTBase>)dynamicOps).orElse(VaultConfig.b);
        tag.a("shared_data", VaultSharedData.b, (DynamicOps<NBTBase>)dynamicOps).ifPresent(this.b::a);
    }

    @Nullable
    public VaultServerData a() {
        return this.n != null && !this.n.C ? this.a : null;
    }

    public VaultSharedData c() {
        return this.b;
    }

    public VaultClientData d() {
        return this.c;
    }

    public VaultConfig f() {
        return this.d;
    }

    @VisibleForTesting
    public void a(VaultConfig config) {
        this.d = config;
    }

    public static final class b {
        private static final int a = 14;
        private static final int b = 20;
        private static final int c = 15;

        public static void a(WorldServer level, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData) {
            VaultState vaultState = state.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level.ae(), vaultState)) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, vaultState, config, sharedData, pos);
            }
            IBlockData blockState = state;
            if (level.ae() >= serverData.c() && state != (blockState = (IBlockData)state.b(VaultBlock.b, vaultState.a(level, pos, config, serverData, sharedData)))) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, pos, state, blockState, config, sharedData);
            }
            if (serverData.c || sharedData.c) {
                VaultBlockEntity.a(level, pos, state);
                if (sharedData.c) {
                    level.a(pos, state, blockState, 2);
                }
                serverData.c = false;
                sharedData.c = false;
            }
        }

        public static void a(WorldServer level, BlockPosition pos, IBlockData state, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, EntityHuman player, ItemStack stack) {
            VaultState vaultState = state.c(VaultBlock.b);
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, vaultState)) {
                if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, stack)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, serverData, pos, SoundEffects.BO);
                } else if (serverData.a(player)) {
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, serverData, pos, SoundEffects.BK);
                } else {
                    List<ItemStack> list = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, config, pos, player, stack);
                    if (!list.isEmpty()) {
                        player.b(StatisticList.c.b(stack.h()));
                        stack.a(config.e().M(), (EntityLiving)player);
                        BlockDispenseLootEvent vaultDispenseLootEvent = CraftEventFactory.callBlockDispenseLootEvent(level, pos, player, list);
                        if (vaultDispenseLootEvent.isCancelled()) {
                            return;
                        }
                        list = vaultDispenseLootEvent.getDispensedLoot().stream().map(CraftItemStack::asNMSCopy).toList();
                        net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.unlock(level, state, pos, config, serverData, sharedData, list, player);
                        serverData.b(player);
                        sharedData.a(level, pos, serverData, config, config.d());
                    }
                }
            }
        }

        static void a(WorldServer level, BlockPosition pos, IBlockData oldState, IBlockData newState, VaultConfig config, VaultSharedData sharedData) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.setVaultState(level, pos, oldState, newState, config, sharedData, null);
        }

        static void setVaultState(WorldServer level, BlockPosition pos, IBlockData oldState, IBlockData newState, VaultConfig config, VaultSharedData sharedData, @Nullable EntityHuman associatedPlayer) {
            Set<UUID> connectedPlayers;
            VaultState vaultState1;
            VaultState vaultState;
            VaultState oldVaultState = vaultState = oldState.c(VaultBlock.b);
            VaultState newVaultState = vaultState1 = newState.c(VaultBlock.b);
            Player apiAssociatedPlayer = null;
            if (associatedPlayer != null) {
                apiAssociatedPlayer = (Player)associatedPlayer.getBukkitEntity();
            } else if (newVaultState == VaultState.b && !(connectedPlayers = sharedData.d()).isEmpty()) {
                apiAssociatedPlayer = level.getCraftServer().getPlayer(connectedPlayers.iterator().next());
            }
            VaultChangeStateEvent event = new VaultChangeStateEvent((Block)CraftBlock.at(level, pos), apiAssociatedPlayer, CraftBlockData.toBukkit(oldVaultState, Vault.State.class), CraftBlockData.toBukkit(newVaultState, Vault.State.class));
            if (!event.callEvent()) {
                return;
            }
            level.a(pos, newState, 3);
            vaultState.a(level, pos, vaultState1, config, sharedData, newState.c(VaultBlock.d));
        }

        static void a(WorldServer level, VaultState state, VaultConfig config, VaultSharedData sharedData, BlockPosition pos) {
            if (!net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(config, state)) {
                sharedData.a(ItemStack.l);
            } else {
                ItemStack randomDisplayItemFromLootTable = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.a(level, pos, config.f().orElse(config.b()));
                VaultDisplayItemEvent event = CraftEventFactory.callVaultDisplayItemEvent(level, pos, randomDisplayItemFromLootTable);
                if (event.isCancelled()) {
                    return;
                }
                randomDisplayItemFromLootTable = CraftItemStack.asNMSCopy(event.getDisplayItem());
                sharedData.a(randomDisplayItemFromLootTable);
            }
        }

        private static ItemStack a(WorldServer level, BlockPosition pos, ResourceKey<LootTable> lootTable) {
            LootParams lootParams;
            LootTable lootTable1 = level.p().bc().b(lootTable);
            ObjectArrayList<ItemStack> randomItems = lootTable1.a(lootParams = new LootParams.a(level).a(LootContextParameters.f, Vec3D.b(pos)).a(LootContextParameterSets.l), level.G_());
            return randomItems.isEmpty() ? ItemStack.l : SystemUtils.a(randomItems, level.G_());
        }

        private static void a(WorldServer level, IBlockData state, BlockPosition pos, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, List<ItemStack> itemsToEject) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.unlock(level, state, pos, config, serverData, sharedData, itemsToEject, null);
        }

        private static void unlock(WorldServer level, IBlockData state, BlockPosition pos, VaultConfig config, VaultServerData serverData, VaultSharedData sharedData, List<ItemStack> itemsToEject, @Nullable EntityHuman associatedPlayer) {
            serverData.a(itemsToEject);
            sharedData.a(serverData.f());
            serverData.b(level.ae() + 14L);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$b.setVaultState(level, pos, state, (IBlockData)state.b(VaultBlock.b, VaultState.c), config, sharedData, associatedPlayer);
        }

        private static List<ItemStack> a(WorldServer level, VaultConfig config, BlockPosition pos, EntityHuman player, ItemStack key) {
            LootTable lootTable = level.p().bc().b(config.b());
            LootParams lootParams = new LootParams.a(level).a(LootContextParameters.f, Vec3D.b(pos)).a(player.eh()).a(LootContextParameters.a, player).a(LootContextParameters.i, key).a(LootContextParameterSets.l);
            return lootTable.a(lootParams);
        }

        private static boolean a(VaultConfig config, VaultState state) {
            return !config.e().f() && state != VaultState.a;
        }

        private static boolean a(VaultConfig config, ItemStack stack) {
            return ItemStack.c(stack, config.e()) && stack.M() >= config.e().M();
        }

        private static boolean a(long gameTime, VaultState state) {
            return gameTime % 20L == 0L && state == VaultState.b;
        }

        private static void a(WorldServer level, VaultServerData serverData, BlockPosition pos, SoundEffect sound) {
            if (level.ae() >= serverData.a() + 15L) {
                level.a(null, pos, sound, SoundCategory.e);
                serverData.a(level.ae());
            }
        }
    }

    public static final class a {
        private static final int a = 20;
        private static final float b = 0.5f;
        private static final float c = 0.02f;
        private static final int d = 20;
        private static final int e = 20;

        public static void a(World level, BlockPosition pos, IBlockData state, VaultClientData clientData, VaultSharedData sharedData) {
            clientData.c();
            if (level.ae() % 20L == 0L) {
                net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(level, pos, state, sharedData);
            }
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(level, pos, sharedData, state.c(VaultBlock.d) != false ? Particles.N : Particles.aM);
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(level, pos, sharedData);
        }

        public static void a(World level, BlockPosition pos, IBlockData state, VaultSharedData sharedData, ParticleParam particle) {
            net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(level, pos, state, sharedData);
            RandomSource randomSource = level.A;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, randomSource);
                level.a(Particles.ah, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                level.a(particle, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
            }
        }

        public static void a(World level, BlockPosition pos, ParticleParam particle) {
            RandomSource randomSource = level.A;
            for (int i2 = 0; i2 < 20; ++i2) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, randomSource);
                Vec3D vec31 = new Vec3D(randomSource.k() * 0.02, randomSource.k() * 0.02, randomSource.k() * 0.02);
                level.a(particle, vec3.a(), vec3.b(), vec3.c(), vec31.a(), vec31.b(), vec31.c());
            }
        }

        private static void a(World level, BlockPosition pos, VaultSharedData sharedData, ParticleParam particle) {
            RandomSource random = level.G_();
            if (random.i() <= 0.5f) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.b(pos, random);
                level.a(Particles.ah, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData)) {
                    level.a(particle, vec3.a(), vec3.b(), vec3.c(), 0.0, 0.0, 0.0);
                }
            }
        }

        private static void a(World level, Vec3D pos, EntityHuman player) {
            RandomSource randomSource = level.A;
            Vec3D vec3 = pos.a(player.dt().b(0.0, player.dr() / 2.0f, 0.0));
            int randomInt = MathHelper.a(randomSource, 2, 5);
            for (int i2 = 0; i2 < randomInt; ++i2) {
                Vec3D vec31 = vec3.a(randomSource, 1.0f);
                level.a(Particles.bd, pos.a(), pos.b(), pos.c(), vec31.a(), vec31.b(), vec31.c());
            }
        }

        private static void a(World level, BlockPosition pos, IBlockData state, VaultSharedData sharedData) {
            Set<UUID> connectedPlayers = sharedData.d();
            if (!connectedPlayers.isEmpty()) {
                Vec3D vec3 = net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, state.c(VaultBlock.c));
                for (UUID uuid : connectedPlayers) {
                    EntityHuman playerByUuid = level.a(uuid);
                    if (playerByUuid == null || !net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(pos, sharedData, playerByUuid)) continue;
                    net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(level, vec3, playerByUuid);
                }
            }
        }

        private static boolean a(BlockPosition pos, VaultSharedData sharedData, EntityHuman player) {
            return player.dv().j(pos) <= MathHelper.k(sharedData.e());
        }

        private static void a(World level, BlockPosition pos, VaultSharedData sharedData) {
            RandomSource random;
            if (net.minecraft.world.level.block.entity.vault.VaultBlockEntity$a.a(sharedData) && (random = level.G_()).i() <= 0.02f) {
                level.a(pos, SoundEffects.BF, SoundCategory.e, random.i() * 0.25f + 0.75f, random.i() + 0.5f, false);
            }
        }

        public static boolean a(VaultSharedData sharedData) {
            return sharedData.b();
        }

        private static Vec3D a(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6), MathHelper.a(random, 0.4, 0.6));
        }

        private static Vec3D b(BlockPosition pos, RandomSource random) {
            return Vec3D.a(pos).b(MathHelper.a(random, 0.1, 0.9), MathHelper.a(random, 0.25, 0.75), MathHelper.a(random, 0.1, 0.9));
        }

        private static Vec3D a(BlockPosition pos, EnumDirection facing) {
            return Vec3D.c(pos).b((double)facing.j() * 0.5, 1.75, (double)facing.l() * 0.5);
        }
    }
}

