/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.vault;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;

public class VaultServerData {
    static final String a = "server_data";
    static Codec<VaultServerData> b = RecordCodecBuilder.create(instance -> instance.group((App)UUIDUtil.c.lenientOptionalFieldOf("rewarded_players", Set.of()).forGetter(vaultServerData -> vaultServerData.e), (App)Codec.LONG.lenientOptionalFieldOf("state_updating_resumes_at", (Object)0L).forGetter(vaultServerData -> vaultServerData.f), (App)ItemStack.b.listOf().lenientOptionalFieldOf("items_to_eject", List.of()).forGetter(vaultServerData -> vaultServerData.g), (App)Codec.INT.lenientOptionalFieldOf("total_ejections_needed", (Object)0).forGetter(vaultServerData -> vaultServerData.i)).apply((Applicative)instance, VaultServerData::new));
    private static final int d = 128;
    private final Set<UUID> e = new ObjectLinkedOpenHashSet();
    private long f;
    private final List<ItemStack> g = new ObjectArrayList();
    private long h;
    private int i;
    boolean c;

    VaultServerData(Set<UUID> rewardedPlayers, long stateUpdatingResumesAt, List<ItemStack> itemsToEject, int totalEjectionsNeeded) {
        this.e.addAll(rewardedPlayers);
        this.f = stateUpdatingResumesAt;
        this.g.addAll(itemsToEject);
        this.i = totalEjectionsNeeded;
    }

    VaultServerData() {
    }

    void a(long lastInsertFailTimestamp) {
        this.h = lastInsertFailTimestamp;
    }

    long a() {
        return this.h;
    }

    public Set<UUID> b() {
        return this.e;
    }

    boolean a(EntityHuman player) {
        return this.e.contains(player.cG());
    }

    @VisibleForTesting
    public void b(EntityHuman player) {
        this.addToRewardedPlayers(player.cG());
    }

    public boolean addToRewardedPlayers(UUID player) {
        Iterator<UUID> iterator;
        boolean removed = this.e.add(player);
        if (this.e.size() > 128 && (iterator = this.e.iterator()).hasNext()) {
            iterator.next();
            iterator.remove();
        }
        this.i();
        return removed;
    }

    public long c() {
        return this.f;
    }

    public void b(long time) {
        this.f = time;
        this.i();
    }

    List<ItemStack> d() {
        return this.g;
    }

    void e() {
        this.i = 0;
        this.i();
    }

    void a(List<ItemStack> itemsToEject) {
        this.g.clear();
        this.g.addAll(itemsToEject);
        this.i = this.g.size();
        this.i();
    }

    ItemStack f() {
        return this.g.isEmpty() ? ItemStack.l : Objects.requireNonNullElse(this.g.get(this.g.size() - 1), ItemStack.l);
    }

    ItemStack g() {
        if (this.g.isEmpty()) {
            return ItemStack.l;
        }
        this.i();
        return Objects.requireNonNullElse(this.g.remove(this.g.size() - 1), ItemStack.l);
    }

    void a(VaultServerData other) {
        this.f = other.c();
        this.g.clear();
        this.g.addAll(other.g);
        this.e.clear();
        this.e.addAll(other.e);
    }

    private void i() {
        this.c = true;
    }

    public float h() {
        return this.i == 1 ? 1.0f : 1.0f - MathHelper.f(this.d().size(), 1.0f, this.i);
    }

    public boolean removeFromRewardedPlayers(UUID uuid) {
        if (this.e.remove(uuid)) {
            this.i();
            return true;
        }
        return false;
    }
}

