/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.SignalGetter;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.BlockPistonMoving;
import net.minecraft.world.level.block.piston.PistonExtendsChecker;
import net.minecraft.world.level.block.piston.TileEntityPiston;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.block.state.properties.BlockStateBoolean;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.pathfinder.PathMode;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.level.redstone.Orientation;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;

public class BlockPiston
extends BlockDirectional {
    public static final MapCodec<BlockPiston> b = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.fieldOf("sticky").forGetter(pistonBaseBlock -> pistonBaseBlock.i), BlockPiston.t()).apply((Applicative)instance, BlockPiston::new));
    public static final BlockStateBoolean c = BlockProperties.j;
    public static final int d = 0;
    public static final int e = 1;
    public static final int f = 2;
    public static final int g = 4;
    private static final Map<EnumDirection, VoxelShape> h = VoxelShapes.d(Block.c(16.0, 4.0, 16.0));
    private final boolean i;

    public MapCodec<BlockPiston> a() {
        return b;
    }

    public BlockPiston(boolean isSticky, BlockBase.Info properties) {
        super(properties);
        this.l((IBlockData)((IBlockData)this.C.b().b(BlockDirectional.a, EnumDirection.c)).b(c, false));
        this.i = isSticky;
    }

    @Override
    protected VoxelShape a(IBlockData state, IBlockAccess level, BlockPosition pos, VoxelShapeCollision context) {
        return state.c(c) != false ? h.get(state.c(BlockDirectional.a)) : VoxelShapes.b();
    }

    @Override
    public void a(World level, BlockPosition pos, IBlockData state, EntityLiving placer, ItemStack stack) {
        if (!level.C) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, Block neighborBlock, @Nullable Orientation orientation, boolean movedByPiston) {
        if (!level.C) {
            this.a(level, pos, state);
        }
    }

    @Override
    protected void a(IBlockData state, World level, BlockPosition pos, IBlockData oldState, boolean isMoving) {
        if (!oldState.a(state.b()) && !level.C && level.c_(pos) == null) {
            this.a(level, pos, state);
        }
    }

    @Override
    public IBlockData a(BlockActionContext context) {
        return (IBlockData)((IBlockData)this.m().b(BlockDirectional.a, context.d().g())).b(c, false);
    }

    private void a(World level, BlockPosition pos, IBlockData state) {
        EnumDirection direction = state.c(BlockDirectional.a);
        boolean neighborSignal = this.a((SignalGetter)level, pos, direction);
        if (neighborSignal && !state.c(c).booleanValue()) {
            if (new PistonExtendsChecker(level, pos, direction, true).a()) {
                level.a(pos, (Block)this, 0, direction.d());
            }
        } else if (!neighborSignal && state.c(c).booleanValue()) {
            TileEntityPiston pistonMovingBlockEntity;
            TileEntity tileEntity;
            BlockPosition blockPos = pos.a(direction, 2);
            IBlockData blockState = level.a_(blockPos);
            int i2 = 1;
            if (blockState.a(Blocks.ca) && blockState.c(BlockDirectional.a) == direction && (tileEntity = level.c_(blockPos)) instanceof TileEntityPiston && (pistonMovingBlockEntity = (TileEntityPiston)tileEntity).a() && (pistonMovingBlockEntity.a(0.0f) < 0.5f || level.ae() == pistonMovingBlockEntity.t() || ((WorldServer)level).d())) {
                i2 = 2;
            }
            level.a(pos, (Block)this, i2, direction.d());
        }
    }

    private boolean a(SignalGetter signalGetter, BlockPosition pos, EnumDirection direction) {
        for (EnumDirection direction1 : EnumDirection.values()) {
            if (direction1 == direction || !signalGetter.b(pos.a(direction1), direction1)) continue;
            return true;
        }
        if (signalGetter.b(pos, EnumDirection.a)) {
            return true;
        }
        BlockPosition blockPos = pos.d();
        for (EnumDirection direction2 : EnumDirection.values()) {
            if (direction2 == EnumDirection.a || !signalGetter.b(blockPos.a(direction2), direction2)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean a(IBlockData state, World level, BlockPosition pos, int id, int param) {
        EnumDirection direction = state.c(BlockDirectional.a);
        EnumDirection directionQueuedAs = EnumDirection.a(param & 7);
        if (!GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits && direction != directionQueuedAs) {
            return false;
        }
        IBlockData blockState = (IBlockData)state.b(c, true);
        if (!level.C) {
            boolean neighborSignal = this.a((SignalGetter)level, pos, direction);
            if (neighborSignal && (id == 1 || id == 2)) {
                level.a(pos, blockState, 2);
                return false;
            }
            if (!neighborSignal && id == 0) {
                return false;
            }
        }
        if (id == 0) {
            if (!this.a(level, pos, direction, true)) {
                return false;
            }
            level.a(pos, blockState, 67);
            level.a(null, pos, SoundEffects.uO, SoundCategory.e, 0.5f, level.A.i() * 0.25f + 0.6f);
            level.a(GameEvent.a, pos, GameEvent.a.a(blockState));
        } else if (id == 1 || id == 2) {
            TileEntity blockEntity = level.c_(pos.a(direction));
            if (blockEntity instanceof TileEntityPiston) {
                ((TileEntityPiston)blockEntity).k();
            }
            IBlockData blockState1 = (IBlockData)((IBlockData)Blocks.ca.m().b(BlockPistonMoving.b, direction)).b(BlockPistonMoving.c, this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            if (!this.i && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(direction)).callEvent()) {
                return false;
            }
            level.a(pos, blockState1, 276);
            level.a(BlockPistonMoving.a(pos, blockState1, (IBlockData)this.m().b(BlockDirectional.a, EnumDirection.a(param & 7)), direction, false, true));
            level.a(pos, blockState1.b());
            blockState1.a((GeneratorAccess)level, pos, 2);
            if (this.i) {
                TileEntityPiston pistonMovingBlockEntity;
                TileEntity tileEntity;
                BlockPosition blockPos = pos.b(direction.j() * 2, direction.k() * 2, direction.l() * 2);
                IBlockData blockState2 = level.a_(blockPos);
                boolean flag = false;
                if (blockState2.a(Blocks.ca) && (tileEntity = level.c_(blockPos)) instanceof TileEntityPiston && (pistonMovingBlockEntity = (TileEntityPiston)tileEntity).c() == direction && pistonMovingBlockEntity.a()) {
                    pistonMovingBlockEntity.k();
                    flag = true;
                }
                if (!flag) {
                    if (id != 1 || blockState2.l() || !BlockPiston.a(blockState2, level, blockPos, direction.g(), false, direction) || blockState2.r() != EnumPistonReaction.a && !blockState2.a(Blocks.bI) && !blockState2.a(Blocks.by)) {
                        if (id == 1 && blockState1.l() && !new BlockPistonRetractEvent((org.bukkit.block.Block)CraftBlock.at(level, pos), Collections.emptyList(), CraftBlock.notchToBlockFace(direction)).callEvent()) {
                            return false;
                        }
                        level.a(pos.a(direction), false);
                    } else {
                        this.a(level, pos, direction, false);
                    }
                }
            } else {
                BlockPosition headPos = pos.a(direction);
                if (GlobalConfiguration.get().unsupportedSettings.allowPermanentBlockBreakExploits || level.a_(headPos) == Blocks.bJ.m().b(BlockDirectional.a, direction)) {
                    level.a(headPos, false);
                } else {
                    ((WorldServer)level).m().a(headPos);
                }
            }
            level.a(null, pos, SoundEffects.uN, SoundCategory.e, 0.5f, level.A.i() * 0.15f + 0.6f);
            level.a(GameEvent.e, pos, GameEvent.a.a(blockState1));
        }
        return true;
    }

    public static boolean a(IBlockData state, World level, BlockPosition pos, EnumDirection movementDirection, boolean allowDestroy, EnumDirection pistonFacing) {
        if (pos.v() < level.K_() || pos.v() > level.ao() || !level.E_().a(pos) || !level.E_().a(pos.a(movementDirection))) {
            return false;
        }
        if (state.l()) {
            return true;
        }
        if (state.a(Blocks.cy) || state.a(Blocks.pS) || state.a(Blocks.pT) || state.a(Blocks.tY)) {
            return false;
        }
        if (movementDirection == EnumDirection.a && pos.v() == level.K_()) {
            return false;
        }
        if (movementDirection == EnumDirection.b && pos.v() == level.ao()) {
            return false;
        }
        if (!state.a(Blocks.bI) && !state.a(Blocks.by)) {
            if (state.e(level, pos) == -1.0f) {
                return false;
            }
            switch (state.r()) {
                case c: {
                    return false;
                }
                case b: {
                    return allowDestroy;
                }
                case e: {
                    return movementDirection == pistonFacing;
                }
            }
        } else if (state.c(c).booleanValue()) {
            return false;
        }
        return !state.x();
    }

    /*
     * WARNING - void declaration
     */
    private boolean a(final World level, BlockPosition pos, EnumDirection facing, boolean extending) {
        void var21_41;
        void var21_39;
        int i1;
        PistonExtendsChecker pistonStructureResolver;
        BlockPosition blockPos = pos.a(facing);
        if (!extending && level.a_(blockPos).a(Blocks.bJ)) {
            level.a(blockPos, Blocks.a.m(), 276);
        }
        if (!(pistonStructureResolver = new PistonExtendsChecker(level, pos, facing, extending)).a()) {
            return false;
        }
        HashMap map = Maps.newHashMap();
        List<BlockPosition> toPush = pistonStructureResolver.c();
        ArrayList list = Lists.newArrayList();
        for (BlockPosition blockPos1 : toPush) {
            IBlockData blockState = level.a_(blockPos1);
            list.add(blockState);
            map.put(blockPos1, blockState);
        }
        List<BlockPosition> toDestroy = pistonStructureResolver.d();
        IBlockData[] blockStates = new IBlockData[toPush.size() + toDestroy.size()];
        EnumDirection direction = extending ? facing : facing.g();
        int i3 = 0;
        CraftBlock bukkitBlock = CraftBlock.at(level, pos);
        final List<BlockPosition> moved = pistonStructureResolver.c();
        final List<BlockPosition> broken = pistonStructureResolver.d();
        AbstractList<org.bukkit.block.Block> blocks = new AbstractList<org.bukkit.block.Block>(this){

            @Override
            public int size() {
                return moved.size() + broken.size();
            }

            @Override
            public org.bukkit.block.Block get(int index) {
                if (index >= this.size() || index < 0) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                BlockPosition pos = index < moved.size() ? (BlockPosition)moved.get(index) : (BlockPosition)broken.get(index - moved.size());
                return CraftBlock.at(level, pos);
            }
        };
        Object event = extending ? new BlockPistonExtendEvent((org.bukkit.block.Block)bukkitBlock, (List)blocks, CraftBlock.notchToBlockFace(direction)) : new BlockPistonRetractEvent((org.bukkit.block.Block)bukkitBlock, (List)blocks, CraftBlock.notchToBlockFace(direction));
        if (!event.callEvent()) {
            for (BlockPosition brokenPos : broken) {
                level.a(brokenPos, Blocks.a.m(), level.a_(brokenPos), 3);
            }
            for (BlockPosition movedPos : moved) {
                level.a(movedPos, Blocks.a.m(), level.a_(movedPos), 3);
                movedPos = movedPos.a(direction);
                level.a(movedPos, Blocks.a.m(), level.a_(movedPos), 3);
            }
            return false;
        }
        for (i1 = toDestroy.size() - 1; i1 >= 0; --i1) {
            BlockPosition blockPos2 = toDestroy.get(i1);
            IBlockData iBlockData = level.a_(blockPos2);
            TileEntity blockEntity = iBlockData.x() ? level.c_(blockPos2) : null;
            BlockPiston.dropResources(iBlockData, level, blockPos2, blockEntity, pos);
            if (!iBlockData.a(TagsBlock.aN) && level.A_()) {
                level.c(2001, blockPos2, BlockPiston.j(iBlockData));
            }
            level.a(blockPos2, Blocks.a.m(), 18);
            level.a(GameEvent.f, blockPos2, GameEvent.a.a(iBlockData));
            blockStates[i3++] = iBlockData;
        }
        for (i1 = toPush.size() - 1; i1 >= 0; --i1) {
            BlockPosition blockPosition;
            boolean allowDesync = GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication;
            BlockPosition oldPos = blockPosition = toPush.get(i1);
            IBlockData blockState12 = allowDesync ? level.a_(oldPos) : null;
            BlockPosition blockPosition2 = blockPosition.a(direction);
            map.remove(blockPosition2);
            IBlockData blockState2 = (IBlockData)Blocks.ca.m().b(BlockDirectional.a, facing);
            level.a(blockPosition2, blockState2, 324);
            if (!allowDesync) {
                blockState12 = level.a_(oldPos);
                map.replace(oldPos, blockState12);
            }
            level.a(BlockPistonMoving.a(blockPosition2, blockState2, allowDesync ? (IBlockData)list.get(i1) : blockState12, facing, extending, false));
            if (!allowDesync) {
                level.a(oldPos, Blocks.a.m(), 594);
            }
            blockStates[i3++] = blockState12;
        }
        if (extending) {
            BlockPropertyPistonType pistonType = this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a;
            IBlockData blockState3 = (IBlockData)((IBlockData)Blocks.bJ.m().b(BlockDirectional.a, facing)).b(BlockPistonExtension.c, pistonType);
            IBlockData iBlockData = (IBlockData)((IBlockData)Blocks.ca.m().b(BlockPistonMoving.b, facing)).b(BlockPistonMoving.c, this.i ? BlockPropertyPistonType.b : BlockPropertyPistonType.a);
            map.remove(blockPos);
            level.a(blockPos, iBlockData, 324);
            level.a(BlockPistonMoving.a(blockPos, iBlockData, blockState3, facing, true, true));
        }
        IBlockData blockState4 = Blocks.a.m();
        for (BlockPosition blockPosition : map.keySet()) {
            level.a(blockPosition, blockState4, 82);
        }
        for (Map.Entry entry : map.entrySet()) {
            BlockPosition blockPos4 = (BlockPosition)entry.getKey();
            IBlockData blockState5 = (IBlockData)entry.getValue();
            blockState5.b(level, blockPos4, 2);
            blockState4.a((GeneratorAccess)level, blockPos4, 2);
            blockState4.b(level, blockPos4, 2);
        }
        Orientation orientation = ExperimentalRedstoneUtils.a(level, pistonStructureResolver.b(), null);
        i3 = 0;
        int n2 = toDestroy.size() - 1;
        while (var21_39 >= 0) {
            IBlockData blockState2 = blockStates[i3++];
            BlockPosition blockPos5 = toDestroy.get((int)var21_39);
            if (level instanceof WorldServer) {
                WorldServer serverLevel = (WorldServer)level;
                blockState2.a(serverLevel, blockPos5, false);
            }
            blockState2.b(level, blockPos5, 2);
            level.a(blockPos5, blockState2.b(), orientation);
            --var21_39;
        }
        int n3 = toPush.size() - 1;
        while (var21_41 >= 0) {
            level.a(toPush.get((int)var21_41), blockStates[i3++].b(), orientation);
            --var21_41;
        }
        if (extending) {
            level.a(blockPos, Blocks.bJ, orientation);
        }
        return true;
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockRotation rot) {
        return (IBlockData)state.b(BlockDirectional.a, rot.a(state.c(BlockDirectional.a)));
    }

    @Override
    protected IBlockData a(IBlockData state, EnumBlockMirror mirror) {
        return state.a(mirror.a(state.c(BlockDirectional.a)));
    }

    @Override
    protected void a(BlockStateList.a<Block, IBlockData> builder) {
        builder.a(BlockDirectional.a, c);
    }

    @Override
    protected boolean g_(IBlockData state) {
        return state.c(c);
    }

    @Override
    protected boolean a(IBlockData state, PathMode pathComputationType) {
        return false;
    }
}

