/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.piston;

import com.mojang.serialization.DynamicOps;
import io.papermc.paper.configuration.GlobalConfiguration;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockDirectional;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.piston.BlockPiston;
import net.minecraft.world.level.block.piston.BlockPistonExtension;
import net.minecraft.world.level.block.piston.PistonUtil;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.BlockPropertyPistonType;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.redstone.ExperimentalRedstoneUtils;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class TileEntityPiston
extends TileEntity {
    private static final int b = 2;
    private static final double c = 0.01;
    public static final double a = 0.51;
    private static final IBlockData d = Blocks.a.m();
    private static final float e = 0.0f;
    private static final boolean f = false;
    private static final boolean g = false;
    private IBlockData h = d;
    private EnumDirection i = EnumDirection.a;
    private boolean j = false;
    private boolean k = false;
    private static final ThreadLocal<EnumDirection> l = ThreadLocal.withInitial(() -> null);
    private float m = 0.0f;
    private float q = 0.0f;
    private long r;
    private int s;

    public TileEntityPiston(BlockPosition pos, IBlockData blockState) {
        super(TileEntityTypes.l, pos, blockState);
    }

    public TileEntityPiston(BlockPosition pos, IBlockData blockState, IBlockData movedState, EnumDirection direction, boolean extending, boolean isSourcePiston) {
        this(pos, blockState);
        this.h = movedState;
        this.i = direction;
        this.j = extending;
        this.k = isSourcePiston;
    }

    @Override
    public NBTTagCompound a(HolderLookup.a registries) {
        return this.e(registries);
    }

    public boolean a() {
        return this.j;
    }

    public EnumDirection c() {
        return this.i;
    }

    public boolean d() {
        return this.k;
    }

    public float a(float partialTicks) {
        if (partialTicks > 1.0f) {
            partialTicks = 1.0f;
        }
        return MathHelper.h(partialTicks, this.q, this.m);
    }

    public float b(float partialTicks) {
        return (float)this.i.j() * this.e(this.a(partialTicks));
    }

    public float c(float partialTicks) {
        return (float)this.i.k() * this.e(this.a(partialTicks));
    }

    public float d(float partialTicks) {
        return (float)this.i.l() * this.e(this.a(partialTicks));
    }

    private float e(float progress) {
        return this.j ? progress - 1.0f : 1.0f - progress;
    }

    private IBlockData u() {
        return !this.a() && this.d() && this.h.b() instanceof BlockPiston ? (IBlockData)((IBlockData)((IBlockData)Blocks.bJ.m().b(BlockPistonExtension.d, this.m > 0.25f)).b(BlockPistonExtension.c, this.h.a(Blocks.by) ? BlockPropertyPistonType.b : BlockPropertyPistonType.a)).b(BlockDirectional.a, this.h.c(BlockDirectional.a)) : this.h;
    }

    private static void a(World level, BlockPosition pos, float partialTick, TileEntityPiston piston) {
        AxisAlignedBB aabb;
        List<Entity> entities;
        EnumDirection movementDirection = piston.f();
        double d2 = partialTick - piston.m;
        VoxelShape collisionShape = piston.u().g(level, pos);
        if (!collisionShape.c() && !(entities = level.a_(null, PistonUtil.a(aabb = TileEntityPiston.a(pos, collisionShape.a(), piston), movementDirection, d2).b(aabb))).isEmpty()) {
            List<AxisAlignedBB> list = collisionShape.e();
            boolean isSlimeBlock = piston.h.a(Blocks.ix);
            Iterator<Entity> var12 = entities.iterator();
            while (true) {
                AxisAlignedBB boundingBox;
                AxisAlignedBB aabb1;
                AxisAlignedBB movementArea;
                if (!var12.hasNext()) {
                    return;
                }
                Entity entity = var12.next();
                if (entity.i_() == EnumPistonReaction.d) continue;
                if (isSlimeBlock) {
                    if (entity instanceof EntityPlayer) continue;
                    Vec3D deltaMovement = entity.dy();
                    double d1 = deltaMovement.d;
                    double d22 = deltaMovement.e;
                    double d3 = deltaMovement.f;
                    switch (movementDirection.o()) {
                        case a: {
                            d1 = movementDirection.j();
                            break;
                        }
                        case b: {
                            d22 = movementDirection.k();
                            break;
                        }
                        case c: {
                            d3 = movementDirection.l();
                        }
                    }
                    entity.n(d1, d22, d3);
                    entity.activatedTick = Math.max(entity.activatedTick, (long)(MinecraftServer.currentTick + 10));
                    entity.activatedImmunityTick = Math.max(entity.activatedImmunityTick, (long)(MinecraftServer.currentTick + 10));
                }
                double d4 = 0.0;
                Iterator<AxisAlignedBB> iterator = list.iterator();
                while (!(!iterator.hasNext() || (movementArea = PistonUtil.a(TileEntityPiston.a(pos, aabb1 = iterator.next(), piston), movementDirection, d2)).c(boundingBox = entity.cR()) && (d4 = Math.max(d4, TileEntityPiston.a(movementArea, movementDirection, boundingBox))) >= d2)) {
                }
                if (d4 <= 0.0) continue;
                d4 = Math.min(d4, d2) + 0.01;
                TileEntityPiston.a(movementDirection, entity, d4, movementDirection);
                if (piston.j || !piston.k) continue;
                TileEntityPiston.a(pos, entity, movementDirection, d2);
            }
        }
    }

    private static void a(EnumDirection noClipDirection, Entity entity, double progress, EnumDirection direction) {
        l.set(noClipDirection);
        Vec3D vec3 = entity.dt();
        entity.a(EnumMoveType.c, new Vec3D(progress * (double)direction.j(), progress * (double)direction.k(), progress * (double)direction.l()));
        entity.a(vec3, entity.dt());
        entity.aJ();
        l.set(null);
    }

    private static void b(World level, BlockPosition pos, float partialTick, TileEntityPiston piston) {
        EnumDirection movementDirection;
        if (piston.v() && (movementDirection = piston.f()).o().d()) {
            double d2 = piston.h.g(level, pos).c(EnumDirection.EnumAxis.b);
            AxisAlignedBB aabb = TileEntityPiston.a(pos, new AxisAlignedBB(0.0, d2, 0.0, 1.0, 1.5000010000000001, 1.0), piston);
            double d1 = partialTick - piston.m;
            for (Entity entity : level.a((Entity)null, aabb, collidedEntity -> TileEntityPiston.a(aabb, collidedEntity, pos))) {
                TileEntityPiston.a(movementDirection, entity, d1, movementDirection);
            }
        }
    }

    private static boolean a(AxisAlignedBB box, Entity entity, BlockPosition pos) {
        return entity.i_() == EnumPistonReaction.a && entity.aH() && (entity.d(pos) || entity.dA() >= box.a && entity.dA() <= box.d && entity.dG() >= box.c && entity.dG() <= box.f);
    }

    private boolean v() {
        return this.h.a(Blocks.pO);
    }

    public EnumDirection f() {
        return this.j ? this.i : this.i.g();
    }

    private static double a(AxisAlignedBB headShape, EnumDirection direction, AxisAlignedBB facing) {
        switch (direction) {
            case f: {
                return headShape.d - facing.a;
            }
            case e: {
                return facing.d - headShape.a;
            }
            default: {
                return headShape.e - facing.b;
            }
            case a: {
                return facing.e - headShape.b;
            }
            case d: {
                return headShape.f - facing.c;
            }
            case c: 
        }
        return facing.f - headShape.c;
    }

    private static AxisAlignedBB a(BlockPosition pos, AxisAlignedBB aabb, TileEntityPiston pistonMovingBlockEntity) {
        double d2 = pistonMovingBlockEntity.e(pistonMovingBlockEntity.m);
        return aabb.d((double)pos.u() + d2 * (double)pistonMovingBlockEntity.i.j(), (double)pos.v() + d2 * (double)pistonMovingBlockEntity.i.k(), (double)pos.w() + d2 * (double)pistonMovingBlockEntity.i.l());
    }

    private static void a(BlockPosition pos, Entity entity, EnumDirection dir, double progress) {
        double d1;
        EnumDirection opposite;
        double d2;
        AxisAlignedBB aabb;
        AxisAlignedBB boundingBox = entity.cR();
        if (boundingBox.c(aabb = VoxelShapes.b().a().a(pos)) && Math.abs((d2 = TileEntityPiston.a(aabb, opposite = dir.g(), boundingBox) + 0.01) - (d1 = TileEntityPiston.a(aabb, opposite, boundingBox.a(aabb)) + 0.01)) < 0.01) {
            d2 = Math.min(d2, progress) + 0.01;
            TileEntityPiston.a(dir, entity, d2, opposite);
        }
    }

    public IBlockData j() {
        return this.h;
    }

    public void k() {
        if (this.n != null && (this.q < 1.0f || this.n.C)) {
            this.q = this.m = 1.0f;
            this.n.o(this.o);
            this.as_();
            if (this.n.a_(this.o).a(Blocks.ca)) {
                IBlockData blockState = this.k ? Blocks.a.m() : Block.b(this.h, this.n, this.o);
                this.n.a(this.o, blockState, 3);
                this.n.b(this.o, blockState.b(), ExperimentalRedstoneUtils.a(this.n, this.s(), null));
            }
        }
    }

    @Override
    public void a(BlockPosition pos, IBlockData state) {
        this.k();
    }

    public EnumDirection s() {
        return this.j ? this.i : this.i.g();
    }

    public static void a(World level, BlockPosition pos, IBlockData state, TileEntityPiston blockEntity) {
        blockEntity.r = level.ae();
        blockEntity.q = blockEntity.m;
        if (blockEntity.q >= 1.0f) {
            if (level.C && blockEntity.s < 5) {
                ++blockEntity.s;
            } else {
                level.o(pos);
                blockEntity.as_();
                if (level.a_(pos).a(Blocks.ca)) {
                    IBlockData blockState = Block.b(blockEntity.h, level, pos);
                    if (blockState.l()) {
                        level.a(pos, blockEntity.h, GlobalConfiguration.get().unsupportedSettings.allowPistonDuplication ? 340 : 342);
                        Block.a(blockEntity.h, blockState, level, pos, 3);
                    } else {
                        if (blockState.b(BlockProperties.I) && blockState.c(BlockProperties.I).booleanValue()) {
                            blockState = (IBlockData)blockState.b(BlockProperties.I, false);
                        }
                        level.a(pos, blockState, 67);
                        level.b(pos, blockState.b(), ExperimentalRedstoneUtils.a(level, blockEntity.s(), null));
                    }
                }
            }
        } else {
            float f2 = blockEntity.m + 0.5f;
            TileEntityPiston.a(level, pos, f2, blockEntity);
            TileEntityPiston.b(level, pos, f2, blockEntity);
            blockEntity.m = f2;
            if (blockEntity.m >= 1.0f) {
                blockEntity.m = 1.0f;
            }
        }
    }

    @Override
    protected void a(NBTTagCompound tag, HolderLookup.a registries) {
        super.a(tag, registries);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        this.h = tag.a("blockState", IBlockData.a, (DynamicOps<NBTBase>)registryOps).orElse(d);
        this.i = tag.a("facing", EnumDirection.k).orElse(EnumDirection.a);
        this.q = this.m = tag.b("progress", 0.0f);
        this.j = tag.b("extending", false);
        this.k = tag.b("source", false);
    }

    @Override
    protected void b(NBTTagCompound tag, HolderLookup.a registries) {
        super.b(tag, registries);
        RegistryOps<NBTBase> registryOps = registries.a(DynamicOpsNBT.a);
        tag.a("blockState", IBlockData.a, registryOps, this.h);
        tag.a("facing", EnumDirection.k, this.i);
        tag.a("progress", this.q);
        tag.a("extending", this.j);
        tag.a("source", this.k);
    }

    public VoxelShape a(IBlockAccess level, BlockPosition pos) {
        VoxelShape collisionShape = !this.j && this.k && this.h.b() instanceof BlockPiston ? ((IBlockData)this.h.b(BlockPiston.c, true)).g(level, pos) : VoxelShapes.a();
        EnumDirection direction = l.get();
        if ((double)this.m < 1.0 && direction == this.f()) {
            return collisionShape;
        }
        IBlockData blockState = this.d() ? (IBlockData)((IBlockData)Blocks.bJ.m().b(BlockDirectional.a, this.i)).b(BlockPistonExtension.d, this.j != 1.0f - this.m < 0.25f) : this.h;
        float extendedProgress = this.e(this.m);
        double d2 = (float)this.i.j() * extendedProgress;
        double d1 = (float)this.i.k() * extendedProgress;
        double d22 = (float)this.i.l() * extendedProgress;
        return VoxelShapes.a(collisionShape, blockState.g(level, pos).a(d2, d1, d22));
    }

    public long t() {
        return this.r;
    }

    @Override
    public void a(World level) {
        super.a(level);
        if (level.a(Registries.i).a(this.h.b().p().h()).isEmpty()) {
            this.h = Blocks.a.m();
        }
    }
}

