/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import ca.spottedleaf.moonrise.patches.blockstate_propertyaccess.PropertyAccess;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.util.INamable;
import net.minecraft.world.level.block.state.properties.IBlockState;

public final class BlockStateEnum<T extends Enum<T>>
extends IBlockState<T>
implements PropertyAccess<T> {
    private final List<T> a;
    private final Map<String, T> b;
    private final int[] c;
    private int[] idLookupTable;

    @Override
    public final int moonrise$getIdFor(T value) {
        Class target = this.g();
        return value.getClass() != target && ((Enum)value).getDeclaringClass() != target ? -1 : this.idLookupTable[((Enum)value).ordinal()];
    }

    private void init() {
        List<T> values = this.a();
        Class clazz = this.g();
        int id = 0;
        this.idLookupTable = new int[((Enum[])clazz.getEnumConstants()).length];
        Arrays.fill(this.idLookupTable, -1);
        Enum[] byId = (Enum[])Array.newInstance(clazz, values.size());
        for (Enum value : values) {
            int valueId;
            this.idLookupTable[value.ordinal()] = valueId = id++;
            byId[valueId] = value;
        }
        this.moonrise$setById((Comparable[])byId);
    }

    private BlockStateEnum(String name, Class<T> clazz, List<T> values) {
        super(name, clazz);
        if (values.isEmpty()) {
            throw new IllegalArgumentException("Trying to make empty EnumProperty '" + name + "'");
        }
        this.a = List.copyOf(values);
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        this.c = new int[enums.length];
        for (Enum _enum : enums) {
            this.c[_enum.ordinal()] = values.indexOf(_enum);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Enum _enum1 : values) {
            String serializedName = ((INamable)((Object)_enum1)).c();
            builder.put((Object)serializedName, (Object)_enum1);
        }
        this.b = builder.buildOrThrow();
        this.init();
    }

    @Override
    public List<T> a() {
        return this.a;
    }

    @Override
    public Optional<T> b(String value) {
        return Optional.ofNullable((Enum)this.b.get(value));
    }

    public String a(T value) {
        return ((INamable)value).c();
    }

    public int b(T value) {
        return this.c[((Enum)value).ordinal()];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals_unused(Object other) {
        if (this == other) return true;
        if (!(other instanceof BlockStateEnum)) return false;
        BlockStateEnum enumProperty = (BlockStateEnum)other;
        if (!super.equals(other)) return false;
        if (!this.a.equals(enumProperty.a)) return false;
        return true;
    }

    @Override
    public int b() {
        int i2 = super.b();
        return 31 * i2 + this.a.hashCode();
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> clazz) {
        return BlockStateEnum.a(name, clazz, (T type) -> true);
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> clazz, Predicate<T> filter) {
        return BlockStateEnum.a(name, clazz, Arrays.stream((Enum[])clazz.getEnumConstants()).filter(filter).collect(Collectors.toList()));
    }

    @SafeVarargs
    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> clazz, T ... values) {
        return BlockStateEnum.a(name, clazz, List.of(values));
    }

    public static <T extends Enum<T>> BlockStateEnum<T> a(String name, Class<T> clazz, List<T> values) {
        return new BlockStateEnum<T>(name, clazz, values);
    }
}

