/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.chunk_system.level.chunk.ChunkSystemLevelChunk;
import ca.spottedleaf.moonrise.patches.chunk_system.scheduling.NewChunkHolder;
import ca.spottedleaf.moonrise.patches.getblock.GetBlockChunk;
import ca.spottedleaf.moonrise.patches.starlight.chunk.StarlightChunk;
import com.destroystokyo.paper.event.server.ServerExceptionEvent;
import com.destroystokyo.paper.exception.ServerException;
import com.destroystokyo.paper.exception.ServerInternalException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFluids;
import net.minecraft.world.level.block.BlockMinecartTrackAbstract;
import net.minecraft.world.level.block.BlockTileEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkEmpty;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.gameevent.EuclideanGameEventListenerRegistry;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistry;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.TickContainerAccess;
import org.bukkit.craftbukkit.v1_21_R4.CraftChunk;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.event.Event;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.generator.BlockPopulator;
import org.slf4j.Logger;

public class Chunk
extends IChunkAccess
implements ChunkSystemLevelChunk,
StarlightChunk,
GetBlockChunk {
    static final Logger n = LogUtils.getLogger();
    private static final TickingBlockEntity o = new TickingBlockEntity(){

        @Override
        public void a() {
        }

        @Override
        public boolean b() {
            return true;
        }

        @Override
        public BlockPosition c() {
            return BlockPosition.c;
        }

        @Override
        public String d() {
            return "<null>";
        }
    };
    private final Map<BlockPosition, d> p = Maps.newHashMap();
    public boolean q;
    public final WorldServer r;
    @Nullable
    private Supplier<FullChunkStatus> s;
    @Nullable
    private c t;
    private final Int2ObjectMap<GameEventListenerRegistry> u;
    private final LevelChunkTicks<Block> v;
    private final LevelChunkTicks<FluidType> w;
    private e x = chunkPos -> {};
    public boolean mustNotSave;
    public boolean needsDecoration;
    boolean loadedTicketLevel;
    private boolean postProcessingDone;
    private NewChunkHolder chunkAndHolder;
    private static final IBlockData AIR_BLOCKSTATE = Blocks.a.m();
    private static final Fluid AIR_FLUIDSTATE = FluidTypes.a.g();
    private static final IBlockData VOID_AIR_BLOCKSTATE = Blocks.nH.m();
    private final int minSection;
    private final int maxSection;
    private final boolean debug;
    private final IBlockData defaultBlockState;

    @Override
    public final boolean moonrise$isPostProcessingDone() {
        return this.postProcessingDone;
    }

    @Override
    public final NewChunkHolder moonrise$getChunkHolder() {
        return this.chunkAndHolder;
    }

    @Override
    public final void moonrise$setChunkHolder(NewChunkHolder holder) {
        this.chunkAndHolder = holder;
    }

    @Override
    public final IBlockData moonrise$getBlock(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public Chunk(World level, ChunkCoordIntPair pos) {
        this(level, pos, ChunkConverter.a, new LevelChunkTicks<Block>(), new LevelChunkTicks<FluidType>(), 0L, null, null, null);
    }

    public Chunk(World level, ChunkCoordIntPair pos, ChunkConverter data, LevelChunkTicks<Block> blockTicks, LevelChunkTicks<FluidType> fluidTicks, long inhabitedTime, @Nullable ChunkSection[] sections, @Nullable c postLoad, @Nullable BlendingData blendingData) {
        super(pos, data, level, MinecraftServer.getServer().ba().f(Registries.aG), inhabitedTime, sections, blendingData);
        this.r = (WorldServer)level;
        this.u = new Int2ObjectOpenHashMap();
        for (HeightMap.Type types : HeightMap.Type.values()) {
            if (!ChunkStatus.n.e().contains(types)) continue;
            this.h.put(types, new HeightMap(this, types));
        }
        this.t = postLoad;
        this.v = blockTicks;
        this.w = fluidTicks;
        this.minSection = WorldUtil.getMinSection(level);
        this.maxSection = WorldUtil.getMaxSection(level);
        boolean empty = this instanceof ChunkEmpty;
        this.debug = !empty && this.r.ak();
        this.defaultBlockState = empty ? VOID_AIR_BLOCKSTATE : AIR_BLOCKSTATE;
    }

    public Chunk(WorldServer level, ProtoChunk chunk, @Nullable c postLoad) {
        this(level, chunk.f(), chunk.t(), chunk.K(), chunk.L(), chunk.w(), chunk.d(), postLoad, chunk.v());
        if (!Collections.disjoint(chunk.j.keySet(), chunk.k.keySet())) {
            n.error("Chunk at {} contains duplicated block entities", (Object)chunk.f());
        }
        for (TileEntity blockEntity : chunk.H().values()) {
            this.a(blockEntity);
        }
        this.j.putAll(chunk.J());
        for (int i2 = 0; i2 < chunk.p().length; ++i2) {
            this.b[i2] = chunk.p()[i2];
        }
        this.a(chunk.g());
        this.b(chunk.h());
        for (Map.Entry<HeightMap.Type, HeightMap> entry : chunk.e()) {
            if (!ChunkStatus.n.e().contains(entry.getKey())) continue;
            this.a(entry.getKey(), entry.getValue().a());
        }
        this.a(chunk.x());
        this.i();
        this.needsDecoration = true;
        this.persistentDataContainer = chunk.persistentDataContainer;
        this.starlight$setBlockNibbles(chunk.starlight$getBlockNibbles());
        this.starlight$setSkyNibbles(chunk.starlight$getSkyNibbles());
        this.starlight$setSkyEmptinessMap(chunk.starlight$getSkyEmptinessMap());
        this.starlight$setBlockEmptinessMap(chunk.starlight$getBlockEmptinessMap());
    }

    public void a(e unsavedListener) {
        this.x = unsavedListener;
        if (this.k()) {
            unsavedListener.setUnsaved(this.c);
        }
    }

    @Override
    public long w() {
        return this.r.paperConfig().chunks.fixedChunkInhabitedTime < 0 ? super.w() : (long)this.r.paperConfig().chunks.fixedChunkInhabitedTime;
    }

    @Override
    public void i() {
        boolean isUnsaved = this.k();
        super.i();
        if (!isUnsaved) {
            this.x.setUnsaved(this.c);
        }
    }

    @Override
    public TickContainerAccess<Block> q() {
        return this.v;
    }

    @Override
    public TickContainerAccess<FluidType> r() {
        return this.w;
    }

    @Override
    public IChunkAccess.a a(long gametime) {
        return new IChunkAccess.a(this.v.a(gametime), this.w.a(gametime));
    }

    @Override
    public GameEventListenerRegistry a(int sectionY) {
        GameEventListenerRegistry gameEventListenerRegistry;
        WorldServer worldServer = this.r;
        if (worldServer instanceof WorldServer) {
            WorldServer serverLevel = worldServer;
            gameEventListenerRegistry = (GameEventListenerRegistry)this.u.computeIfAbsent(sectionY, i2 -> new EuclideanGameEventListenerRegistry(serverLevel, sectionY, this::i));
        } else {
            gameEventListenerRegistry = super.a(sectionY);
        }
        return gameEventListenerRegistry;
    }

    @Override
    public IBlockData getBlockState(int x2, int y2, int z2) {
        return this.getBlockStateFinal(x2, y2, z2);
    }

    public IBlockData getBlockStateFinal(int x2, int y2, int z2) {
        int sectionIndex = this.f(y2);
        if (sectionIndex < 0 || sectionIndex >= this.m.length || this.m[sectionIndex].e == 0) {
            return Blocks.a.m();
        }
        return this.m[sectionIndex].h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF);
    }

    @Override
    public IBlockData a_(BlockPosition pos) {
        return this.getBlockStateFinal(pos.u(), pos.v(), pos.w());
    }

    @Override
    public final Fluid getFluidIfLoaded(BlockPosition pos) {
        return this.b_(pos);
    }

    @Override
    public final IBlockData getBlockStateIfLoaded(BlockPosition pos) {
        return this.a_(pos);
    }

    @Override
    public Fluid b_(BlockPosition pos) {
        return this.a(pos.u(), pos.v(), pos.w());
    }

    public Fluid a(int x2, int y2, int z2) {
        ChunkSection levelChunkSection;
        int sectionIndex = this.f(y2);
        if (sectionIndex >= 0 && sectionIndex < this.m.length && !(levelChunkSection = this.m[sectionIndex]).c()) {
            return levelChunkSection.h.a((y2 & 0xF) << 8 | (z2 & 0xF) << 4 | x2 & 0xF).y();
        }
        return FluidTypes.a.g();
    }

    @Override
    @Nullable
    public IBlockData a(BlockPosition pos, IBlockData state, int flags) {
        WorldServer worldServer;
        TileEntity blockEntity;
        boolean flag2;
        int i2;
        int i1;
        int y2 = pos.v();
        ChunkSection section = this.b(this.f(y2));
        boolean hasOnlyAir = section.c();
        if (hasOnlyAir && state.l()) {
            return null;
        }
        int i3 = pos.u() & 0xF;
        IBlockData blockState = section.a(i3, i1 = y2 & 0xF, i2 = pos.w() & 0xF, state);
        if (blockState == state) {
            return null;
        }
        Block block = state.b();
        this.h.get(HeightMap.Type.e).a(i3, y2, i2, state);
        this.h.get(HeightMap.Type.f).a(i3, y2, i2, state);
        this.h.get(HeightMap.Type.d).a(i3, y2, i2, state);
        this.h.get(HeightMap.Type.b).a(i3, y2, i2, state);
        boolean hasOnlyAir1 = section.c();
        if (hasOnlyAir != hasOnlyAir1) {
            this.r.m().a().a(pos, hasOnlyAir1);
            this.r.m().a(this.c.h, SectionPosition.a(y2), this.c.i, hasOnlyAir1);
        }
        if (LightEngine.a(blockState, state)) {
            GameProfilerFiller profilerFiller = Profiler.a();
            profilerFiller.a("updateSkyLightSources");
            profilerFiller.b("queueCheckLight");
            this.r.m().a().a(pos);
            profilerFiller.c();
        }
        boolean flag = !blockState.a(block);
        boolean flag1 = (flags & 0x40) != 0;
        boolean bl = flag2 = (flags & 0x100) == 0;
        if (flag && blockState.x()) {
            if (!this.r.C && flag2 && (blockEntity = this.r.c_(pos)) != null) {
                blockEntity.a(pos, blockState);
            }
            this.d(pos);
        }
        if ((flag || block instanceof BlockMinecartTrackAbstract) && (worldServer = this.r) instanceof WorldServer) {
            WorldServer serverLevel = worldServer;
            if ((flags & 1) != 0 || flag1) {
                blockState.a(serverLevel, pos, flag1);
            }
        }
        if (!section.a(i3, i1, i2).a(block)) {
            return null;
        }
        if (!(this.r.C || (flags & 0x200) != 0 || this.r.captureBlockStates && !(block instanceof BlockTileEntity))) {
            state.a((World)this.r, pos, blockState, flag1);
        }
        if (state.x()) {
            blockEntity = this.a(pos, EnumTileEntityState.c);
            if (blockEntity != null && !blockEntity.b(state)) {
                n.warn("Found mismatched block entity @ {}: type = {}, state = {}", new Object[]{pos, blockEntity.p().a().h().a(), state});
                this.d(pos);
                blockEntity = null;
            }
            if (blockEntity == null) {
                blockEntity = ((ITileEntity)((Object)block)).a(pos, state);
                if (blockEntity != null) {
                    this.b(blockEntity);
                }
            } else {
                blockEntity.c(state);
                this.c(blockEntity);
            }
        }
        this.i();
        return blockState;
    }

    @Override
    @Deprecated
    public void a(Entity entity) {
    }

    @Nullable
    private TileEntity g(BlockPosition pos) {
        IBlockData blockState = this.a_(pos);
        return !blockState.x() ? null : ((ITileEntity)((Object)blockState.b())).a(pos, blockState);
    }

    @Override
    @Nullable
    public TileEntity c_(BlockPosition pos) {
        return this.a(pos, EnumTileEntityState.c);
    }

    @Nullable
    public TileEntity a(BlockPosition pos, EnumTileEntityState creationType) {
        TileEntity blockEntity1;
        NBTTagCompound compoundTag;
        TileEntity blockEntity = this.r.capturedTileEntities.get(pos);
        if (blockEntity == null) {
            blockEntity = this.k.get(pos);
        }
        if (blockEntity == null && (compoundTag = this.j.remove(pos)) != null && (blockEntity1 = this.a(pos, compoundTag)) != null) {
            return blockEntity1;
        }
        if (blockEntity == null) {
            if (creationType == EnumTileEntityState.a && (blockEntity = this.g(pos)) != null) {
                this.b(blockEntity);
            }
        } else if (blockEntity.n()) {
            this.k.remove(pos);
            return null;
        }
        return blockEntity;
    }

    public void b(TileEntity blockEntity) {
        this.a(blockEntity);
        if (this.L()) {
            WorldServer worldServer = this.r;
            if (worldServer instanceof WorldServer) {
                WorldServer serverLevel = worldServer;
                this.b(blockEntity, serverLevel);
            }
            this.c(blockEntity);
        }
    }

    private boolean L() {
        return this.q || this.r.A_();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean h(BlockPosition pos) {
        if (!this.r.E_().a(pos)) return false;
        WorldServer worldServer = this.r;
        if (!(worldServer instanceof WorldServer)) return true;
        WorldServer serverLevel = worldServer;
        if (!this.F().a(FullChunkStatus.c)) return false;
        if (!serverLevel.c(ChunkCoordIntPair.a(pos))) return false;
        return true;
    }

    @Override
    public void a(TileEntity blockEntity) {
        BlockPosition blockPos = blockEntity.ax_();
        IBlockData blockState = this.a_(blockPos);
        if (!blockState.x()) {
            ServerInternalException e2 = new ServerInternalException("Trying to set block entity %s at position %s, but state %s does not allow it".formatted(blockEntity, blockPos, blockState));
            e2.printStackTrace();
            ServerInternalException.reportInternalException((Throwable)e2);
        } else {
            IBlockData blockState1 = blockEntity.m();
            if (blockState != blockState1) {
                if (!blockEntity.p().a(blockState)) {
                    n.warn("Trying to set block entity {} at position {}, but state {} does not allow it", new Object[]{blockEntity, blockPos, blockState});
                    return;
                }
                if (blockState.b() != blockState1.b()) {
                    n.warn("Block state mismatch on block entity {} in position {}, {} != {}, updating", new Object[]{blockEntity, blockPos, blockState, blockState1});
                }
                blockEntity.c(blockState);
            }
            blockEntity.a(this.r);
            blockEntity.o();
            TileEntity blockEntity1 = this.k.put(blockPos.j(), blockEntity);
            if (blockEntity1 != null && blockEntity1 != blockEntity) {
                blockEntity1.as_();
            }
        }
    }

    @Override
    @Nullable
    public NBTTagCompound a(BlockPosition pos, HolderLookup.a registries) {
        TileEntity blockEntity = this.c_(pos);
        if (blockEntity != null && !blockEntity.n()) {
            NBTTagCompound compoundTag = blockEntity.b(this.r.J_());
            compoundTag.a("keepPacked", false);
            return compoundTag;
        }
        NBTTagCompound compoundTag = this.j.get(pos);
        if (compoundTag != null) {
            compoundTag = compoundTag.l();
            compoundTag.a("keepPacked", true);
        }
        return compoundTag;
    }

    @Override
    public void d(BlockPosition pos) {
        if (this.L()) {
            TileEntity blockEntity = this.k.remove(pos);
            if (!this.j.isEmpty()) {
                this.j.remove(pos);
            }
            if (blockEntity != null) {
                WorldServer worldServer = this.r;
                if (worldServer instanceof WorldServer) {
                    WorldServer serverLevel = worldServer;
                    this.a(blockEntity, serverLevel);
                }
                blockEntity.as_();
            }
        }
        this.k(pos);
    }

    private <T extends TileEntity> void a(T blockEntity, WorldServer level) {
        GameEventListener listener;
        Block block = blockEntity.m().b();
        if (block instanceof ITileEntity && (listener = ((ITileEntity)((Object)block)).a(level, blockEntity)) != null) {
            int sectionPosY = SectionPosition.a(blockEntity.ax_().v());
            GameEventListenerRegistry listenerRegistry = this.a(sectionPosY);
            listenerRegistry.b(listener);
        }
    }

    private void i(int sectionY) {
        this.u.remove(sectionY);
    }

    private void k(BlockPosition pos) {
        d rebindableTickingBlockEntityWrapper = this.p.remove(pos);
        if (rebindableTickingBlockEntityWrapper != null) {
            rebindableTickingBlockEntityWrapper.a(o);
        }
    }

    public void G() {
        if (this.t != null) {
            this.t.run(this);
            this.t = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCallback() {
        if (this.loadedTicketLevel) {
            n.error("Double calling chunk load!", new Throwable());
        }
        this.loadedTicketLevel = true;
        CraftServer server = this.r.getCraftServer();
        if (server != null) {
            CraftChunk bukkitChunk = new CraftChunk(this);
            server.getPluginManager().callEvent((Event)new ChunkLoadEvent((org.bukkit.Chunk)bukkitChunk, this.needsDecoration));
            CraftEventFactory.callEntitiesLoadEvent(this.r, this.c, this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
            if (this.needsDecoration) {
                this.needsDecoration = false;
                Random random = new Random();
                random.setSeed(this.r.E());
                long xRand = random.nextLong() / 2L * 2L + 1L;
                long zRand = random.nextLong() / 2L * 2L + 1L;
                random.setSeed((long)this.c.h * xRand + (long)this.c.i * zRand ^ this.r.E());
                CraftWorld world = this.r.getWorld();
                if (world != null) {
                    this.r.populating = true;
                    try {
                        for (BlockPopulator populator : world.getPopulators()) {
                            populator.populate((org.bukkit.World)world, random, (org.bukkit.Chunk)bukkitChunk);
                        }
                    }
                    finally {
                        this.r.populating = false;
                    }
                }
                server.getPluginManager().callEvent((Event)new ChunkPopulateEvent((org.bukkit.Chunk)bukkitChunk));
            }
        }
    }

    public void unloadCallback() {
        if (!this.loadedTicketLevel) {
            n.error("Double calling chunk unload!", new Throwable());
        }
        CraftServer server = this.r.getCraftServer();
        CraftEventFactory.callEntitiesUnloadEvent(this.r, this.c, this.r.moonrise$getChunkTaskScheduler().chunkHolderManager.getChunkHolder(this.locX, this.locZ).getEntityChunk().getAllEntities());
        CraftChunk bukkitChunk = new CraftChunk(this);
        ChunkUnloadEvent unloadEvent = new ChunkUnloadEvent((org.bukkit.Chunk)bukkitChunk, true);
        server.getPluginManager().callEvent((Event)unloadEvent);
        this.mustNotSave = !unloadEvent.isSaveChunk();
        this.loadedTicketLevel = false;
    }

    @Override
    public boolean k() {
        long gameTime = this.r.ae();
        if (this.v.moonrise$isDirty(gameTime) || this.w.moonrise$isDirty(gameTime)) {
            return true;
        }
        return super.k();
    }

    @Override
    public boolean j() {
        if (!this.k()) {
            return false;
        }
        this.v.moonrise$clearDirty();
        this.w.moonrise$clearDirty();
        super.j();
        return true;
    }

    public boolean E() {
        return false;
    }

    public void a(PacketDataSerializer buffer, Map<HeightMap.Type, long[]> heightmaps, Consumer<ClientboundLevelChunkPacketData.b> outputTagConsumer) {
        this.J();
        for (ChunkSection levelChunkSection : this.m) {
            levelChunkSection.a(buffer);
        }
        heightmaps.forEach(this::a);
        this.C();
        outputTagConsumer.accept((pos, blockEntityType, blockEntityTag) -> {
            TileEntity blockEntity = this.a(pos, EnumTileEntityState.a);
            if (blockEntity != null && blockEntityTag != null && blockEntity.p() == blockEntityType) {
                blockEntity.c(blockEntityTag, this.r.J_());
            }
        });
    }

    public void a(PacketDataSerializer buffer) {
        for (ChunkSection levelChunkSection : this.m) {
            levelChunkSection.b(buffer);
        }
    }

    public void b(boolean loaded) {
        this.q = loaded;
    }

    public World H() {
        return this.r;
    }

    public Map<BlockPosition, TileEntity> I() {
        return this.k;
    }

    public void a(WorldServer level) {
        ChunkCoordIntPair pos = this.f();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == null) continue;
            for (Short _short : this.b[i2]) {
                IBlockData blockState1;
                BlockPosition blockPos = ProtoChunk.a(_short, this.h(i2), pos);
                IBlockData blockState = this.a_(blockPos);
                Fluid fluidState = blockState.y();
                if (!fluidState.c()) {
                    fluidState.a(level, blockPos, blockState);
                }
                if (blockState.b() instanceof BlockFluids || (blockState1 = Block.b(blockState, level, blockPos)) == blockState) continue;
                level.a(blockPos, blockState1, 276);
            }
            this.b[i2].clear();
        }
        for (BlockPosition blockPos1 : ImmutableList.copyOf(this.j.keySet())) {
            this.c_(blockPos1);
        }
        this.j.clear();
        this.e.a(this);
        this.postProcessingDone = true;
    }

    @Nullable
    private TileEntity a(BlockPosition pos, NBTTagCompound tag) {
        TileEntity blockEntity;
        IBlockData blockState = this.a_(pos);
        if ("DUMMY".equals(tag.b("id", ""))) {
            if (blockState.x()) {
                blockEntity = ((ITileEntity)((Object)blockState.b())).a(pos, blockState);
            } else {
                blockEntity = null;
                n.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)pos, (Object)blockState);
            }
        } else {
            blockEntity = TileEntity.a(pos, blockState, tag, this.r.J_());
        }
        if (blockEntity != null) {
            blockEntity.a(this.r);
            this.b(blockEntity);
        } else {
            n.warn("Tried to load a block entity for block {} but failed at location {}", (Object)blockState, (Object)pos);
        }
        return blockEntity;
    }

    public void d(long pos) {
        this.v.b(pos);
        this.w.b(pos);
    }

    public void b(WorldServer level) {
        level.n().a(this.c, this.v);
        level.o().a(this.c, this.w);
    }

    public void c(WorldServer level) {
        level.n().a(this.c);
        level.o().a(this.c);
    }

    @Override
    public ChunkStatus n() {
        return ChunkStatus.n;
    }

    public FullChunkStatus F() {
        return this.s == null ? FullChunkStatus.b : this.s.get();
    }

    public void b(Supplier<FullChunkStatus> fullStatus) {
        this.s = fullStatus;
    }

    public void J() {
        this.k.values().forEach(TileEntity::as_);
        this.k.clear();
        this.p.values().forEach(ticker -> ticker.a(o));
        this.p.clear();
    }

    public void K() {
        this.k.values().forEach(blockEntity -> {
            WorldServer patt0$temp = this.r;
            if (patt0$temp instanceof WorldServer) {
                WorldServer serverLevel = patt0$temp;
                this.b(blockEntity, serverLevel);
            }
            this.c(blockEntity);
        });
    }

    private <T extends TileEntity> void b(T blockEntity, WorldServer level) {
        GameEventListener listener;
        Block block = blockEntity.m().b();
        if (block instanceof ITileEntity && (listener = ((ITileEntity)((Object)block)).a(level, blockEntity)) != null) {
            this.a(SectionPosition.a(blockEntity.ax_().v())).a(listener);
        }
    }

    private <T extends TileEntity> void c(T blockEntity) {
        IBlockData blockState = blockEntity.m();
        BlockEntityTicker<?> ticker = blockState.a((World)this.r, blockEntity.p());
        if (ticker == null) {
            this.k(blockEntity.ax_());
        } else {
            this.p.compute(blockEntity.ax_(), (pos, ticker1) -> {
                TickingBlockEntity tickingBlockEntity = this.a(blockEntity, ticker);
                if (ticker1 != null) {
                    ticker1.a(tickingBlockEntity);
                    return ticker1;
                }
                if (this.L()) {
                    d rebindableTickingBlockEntityWrapper = new d(tickingBlockEntity);
                    this.r.a(rebindableTickingBlockEntityWrapper);
                    return rebindableTickingBlockEntityWrapper;
                }
                return null;
            });
        }
    }

    private <T extends TileEntity> TickingBlockEntity a(T blockEntity, BlockEntityTicker<T> ticker) {
        return new a(this, blockEntity, ticker);
    }

    private /* synthetic */ String c(int x2, int y2, int z2) throws Exception {
        return CrashReportSystemDetails.a((LevelHeightAccessor)this, x2, y2, z2);
    }

    @FunctionalInterface
    public static interface c {
        public void run(Chunk var1);
    }

    @FunctionalInterface
    public static interface e {
        public void setUnsaved(ChunkCoordIntPair var1);
    }

    public static final class EnumTileEntityState
    extends Enum<EnumTileEntityState> {
        public static final /* enum */ EnumTileEntityState a = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState b = new EnumTileEntityState();
        public static final /* enum */ EnumTileEntityState c = new EnumTileEntityState();
        private static final /* synthetic */ EnumTileEntityState[] d;

        public static EnumTileEntityState[] values() {
            return (EnumTileEntityState[])d.clone();
        }

        public static EnumTileEntityState valueOf(String name) {
            return Enum.valueOf(EnumTileEntityState.class, name);
        }

        private static /* synthetic */ EnumTileEntityState[] a() {
            return new EnumTileEntityState[]{a, b, c};
        }

        static {
            d = EnumTileEntityState.a();
        }
    }

    static class d
    implements TickingBlockEntity {
        private TickingBlockEntity a;

        d(TickingBlockEntity ticker) {
            this.a = ticker;
        }

        void a(TickingBlockEntity ticker) {
            this.a = ticker;
        }

        @Override
        public void a() {
            this.a.a();
        }

        @Override
        public boolean b() {
            return this.a.b();
        }

        @Override
        public BlockPosition c() {
            return this.a.c();
        }

        @Override
        public String d() {
            return this.a.d();
        }

        public String toString() {
            return String.valueOf(this.a) + " <wrapped>";
        }
    }

    static class a<T extends TileEntity>
    implements TickingBlockEntity {
        private final T b;
        private final BlockEntityTicker<T> c;
        private boolean d;
        final /* synthetic */ Chunk a;

        a(T blockEntity, BlockEntityTicker<T> ticker) {
            this.a = this$0;
            this.b = blockEntity;
            this.c = ticker;
        }

        @Override
        public void a() {
            BlockPosition blockPos;
            if (!((TileEntity)this.b).n() && ((TileEntity)this.b).l() && this.a.h(blockPos = ((TileEntity)this.b).ax_())) {
                try {
                    GameProfilerFiller profilerFiller = Profiler.a();
                    profilerFiller.a(this::d);
                    IBlockData blockState = this.a.a_(blockPos);
                    if (((TileEntity)this.b).p().a(blockState)) {
                        this.c.tick(this.a.r, ((TileEntity)this.b).ax_(), blockState, this.b);
                        this.d = false;
                    } else {
                        this.a.d(this.c());
                        if (!this.d) {
                            this.d = true;
                            n.warn("Block entity {} @ {} state {} invalid for ticking:", new Object[]{LogUtils.defer(this::d), LogUtils.defer(this::c), blockState});
                        }
                    }
                    profilerFiller.c();
                }
                catch (Throwable var5) {
                    String msg = String.format("BlockEntity threw exception at %s:%s,%s,%s", this.a.H().getWorld().getName(), this.c().u(), this.c().v(), this.c().w());
                    MinecraftServer.l.error(msg, var5);
                    this.a.r.getCraftServer().getPluginManager().callEvent((Event)new ServerExceptionEvent((ServerException)new ServerInternalException(msg, var5)));
                    this.a.d(this.c());
                }
            }
        }

        @Override
        public boolean b() {
            return ((TileEntity)this.b).n();
        }

        @Override
        public BlockPosition c() {
            return ((TileEntity)this.b).ax_();
        }

        @Override
        public String d() {
            return TileEntityTypes.a(((TileEntity)this.b).p()).toString();
        }

        public String toString() {
            return "Level ticker for " + this.d() + "@" + String.valueOf(this.c());
        }
    }
}

