/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk;

import ca.spottedleaf.moonrise.patches.fast_palette.FastPaletteData;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.annotation.DoNotUse;
import io.papermc.paper.antixray.ChunkPacketInfo;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.stream.LongStream;
import net.minecraft.core.Registry;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.util.DataBits;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.DataPalette;
import net.minecraft.world.level.chunk.DataPaletteExpandable;
import net.minecraft.world.level.chunk.DataPaletteGlobal;
import net.minecraft.world.level.chunk.DataPaletteHash;
import net.minecraft.world.level.chunk.DataPaletteLinear;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.SingleValuePalette;
import org.jetbrains.annotations.Nullable;

public class DataPaletteBlock<T>
implements DataPaletteExpandable<T>,
PalettedContainerRO<T> {
    private static final int a = 0;
    private final DataPaletteExpandable<T> b = (bits, objectAdded) -> 0;
    public final Registry<T> c;
    private final T @Nullable [] presetValues;
    public volatile c<T> d;
    private final d e;

    public void a() {
    }

    public void b() {
    }

    @Deprecated
    @DoNotUse
    public static <T> Codec<DataPaletteBlock<T>> a(Registry<T> registry, Codec<T> codec, d strategy, T value) {
        return DataPaletteBlock.codecRW(registry, codec, strategy, value, null);
    }

    public static <T> Codec<DataPaletteBlock<T>> codecRW(Registry<T> registry, Codec<T> codec, d strategy, T value, T @Nullable [] presetValues) {
        PalettedContainerRO.b unpacker = (idListx, paletteProviderx, serialized) -> DataPaletteBlock.unpack(idListx, paletteProviderx, serialized, value, presetValues);
        return DataPaletteBlock.a(registry, codec, strategy, value, unpacker);
    }

    public static <T> Codec<PalettedContainerRO<T>> b(Registry<T> registry, Codec<T> codec, d strategy, T value) {
        PalettedContainerRO.b unpacker = (registry1, strategy1, packedData) -> DataPaletteBlock.unpack(registry1, strategy1, packedData, value, null).map(container -> container);
        return DataPaletteBlock.a(registry, codec, strategy, value, unpacker);
    }

    private static <T, C extends PalettedContainerRO<T>> Codec<C> a(Registry<T> registry, Codec<T> codec, d strategy, T value, PalettedContainerRO.b<T, C> unpacker) {
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.mapResult(ExtraCodecs.a(value)).listOf().fieldOf("palette").forGetter(PalettedContainerRO.a::a), (App)Codec.LONG_STREAM.lenientOptionalFieldOf("data").forGetter(PalettedContainerRO.a::b)).apply((Applicative)instance, PalettedContainerRO.a::new)).comapFlatMap(packedData -> unpacker.read(registry, strategy, (PalettedContainerRO.a)packedData), container -> container.a(registry, strategy));
    }

    private void updateData(c<T> data) {
        if (data != null) {
            ((FastPaletteData)data).moonrise$setPalette(data.c.moonrise$getRawPalette(data));
        }
    }

    private T readPaletteSlow(c<T> data, int paletteIdx) {
        return data.c.a(paletteIdx);
    }

    private T readPalette(c<T> data, int paletteIdx) {
        T[] palette = ((FastPaletteData)data).moonrise$getPalette();
        if (palette == null) {
            return this.readPaletteSlow(data, paletteIdx);
        }
        Object ret = palette[paletteIdx];
        if (ret == null) {
            throw new IllegalArgumentException("Palette index out of bounds");
        }
        return ret;
    }

    @Deprecated
    @DoNotUse
    public DataPaletteBlock(Registry<T> registry, d strategy, a<T> configuration, DataBits storage, List<T> values) {
        this(registry, strategy, configuration, storage, values, null, null);
    }

    public DataPaletteBlock(Registry<T> registry, d strategy, a<T> configuration, DataBits storage, List<T> values, T defaultValue, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.c = registry;
        this.e = strategy;
        this.d = new c<T>(configuration, storage, configuration.a().create(configuration.b(), registry, this, values));
        if (presetValues != null && (configuration.a() == net.minecraft.world.level.chunk.DataPaletteBlock$d.a ? this.d.c.a(0) != defaultValue : configuration.a() != net.minecraft.world.level.chunk.DataPaletteBlock$d.f)) {
            int maxSize = 1 << configuration.b();
            for (T presetValue : presetValues) {
                if (this.d.c.b() >= maxSize) {
                    HashSet<T> allValues = new HashSet<T>(values);
                    allValues.addAll(Arrays.asList(presetValues));
                    int newBits = MathHelper.e(allValues.size());
                    if (newBits <= configuration.b()) break;
                    this.onResize(newBits, null);
                    break;
                }
                this.d.c.a(presetValue);
            }
        }
        this.updateData(this.d);
    }

    private DataPaletteBlock(Registry<T> registry, d strategy, c<T> data, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.c = registry;
        this.e = strategy;
        this.d = data;
        this.updateData(this.d);
    }

    private DataPaletteBlock(DataPaletteBlock<T> other, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.c = other.c;
        this.e = other.e;
        this.d = other.d.a(this);
    }

    @Deprecated
    @DoNotUse
    public DataPaletteBlock(Registry<T> registry, T palette, d strategy) {
        this(registry, palette, strategy, null);
    }

    public DataPaletteBlock(Registry<T> registry, T palette, d strategy, T @Nullable [] presetValues) {
        this.presetValues = presetValues;
        this.e = strategy;
        this.c = registry;
        this.d = this.a(null, 0);
        this.d.c.a(palette);
        this.updateData(this.d);
    }

    private c<T> a(@javax.annotation.Nullable c<T> data, int id) {
        a<T> configuration = this.e.a(this.c, id);
        return data != null && configuration.equals(data.b()) ? data : configuration.a(this.c, this, this.e.a());
    }

    @Override
    public synchronized int onResize(int bits, T objectAdded) {
        c<T> data = this.d;
        if (this.presetValues != null && objectAdded != null && data.b().a() == net.minecraft.world.level.chunk.DataPaletteBlock$d.a) {
            int duplicates = 0;
            List<T> presetValues = Arrays.asList(this.presetValues);
            duplicates += presetValues.contains(objectAdded) ? 1 : 0;
            bits = MathHelper.e((1 << this.e.b(this.c, 1 << bits)) + presetValues.size() - (duplicates += presetValues.contains(data.c.a(0)) ? 1 : 0));
        }
        c data1 = this.a(data, bits);
        data1.a(data.c, data.b);
        this.d = data1;
        this.addPresetValues();
        this.updateData(this.d);
        return objectAdded == null ? -1 : data1.c.a(objectAdded);
    }

    private void addPresetValues() {
        if (this.presetValues != null && this.d.b().a() != net.minecraft.world.level.chunk.DataPaletteBlock$d.f) {
            for (T presetValue : this.presetValues) {
                this.d.c.a(presetValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized T a(int x2, int y2, int z2, T state) {
        T var5;
        this.a();
        try {
            var5 = this.a(this.e.a(x2, y2, z2), state);
        }
        finally {
            this.b();
        }
        return var5;
    }

    public T b(int x2, int y2, int z2, T state) {
        return this.a(this.e.a(x2, y2, z2), state);
    }

    private T a(int index, T state) {
        int paletteIdx = this.d.c.a(state);
        c<T> data = this.d;
        int prev = data.b.a(index, paletteIdx);
        return this.readPalette(data, prev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void c(int x2, int y2, int z2, T state) {
        this.a();
        try {
            this.b(this.e.a(x2, y2, z2), state);
        }
        finally {
            this.b();
        }
    }

    private void b(int index, T state) {
        int i2 = this.d.c.a(state);
        this.d.b.b(index, i2);
    }

    @Override
    public T a(int x2, int y2, int z2) {
        return this.a(this.e.a(x2, y2, z2));
    }

    public T a(int index) {
        c<T> data = this.d;
        return this.readPalette(data, data.b.a(index));
    }

    @Override
    public void a(Consumer<T> consumer) {
        DataPalette palette = this.d.d();
        IntArraySet set = new IntArraySet();
        this.d.b.a(arg_0 -> ((IntSet)set).add(arg_0));
        set.forEach(id -> consumer.accept(palette.a(id)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void a(PacketDataSerializer buffer) {
        this.a();
        try {
            byte _byte = buffer.readByte();
            c<T> data = this.a(this.d, _byte);
            data.c.a(buffer);
            buffer.c(data.b.a());
            this.d = data;
            this.addPresetValues();
            this.updateData(this.d);
        }
        finally {
            this.b();
        }
    }

    @Override
    @Deprecated
    @DoNotUse
    public void b(PacketDataSerializer buffer) {
        this.write(buffer, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(PacketDataSerializer buffer, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
        this.a();
        try {
            this.d.write(buffer, chunkPacketInfo, chunkSectionIndex);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setPresetValues(chunkSectionIndex, this.presetValues);
            }
        }
        finally {
            this.b();
        }
    }

    private static <T> DataResult<DataPaletteBlock<T>> unpack(Registry<T> registry, d strategy, PalettedContainerRO.a<T> packedData, T defaultValue, T @Nullable [] presetValues) {
        DataBits bitStorage;
        List<T> list = packedData.a();
        int size = strategy.a();
        int i2 = strategy.b(registry, list.size());
        a<T> configuration = strategy.a(registry, i2);
        if (i2 == 0) {
            bitStorage = new ZeroBitStorage(size);
        } else {
            Optional<LongStream> optional = packedData.b();
            if (optional.isEmpty()) {
                return DataResult.error(() -> "Missing values for non-zero storage");
            }
            long[] longs = optional.get().toArray();
            try {
                if (configuration.a() == net.minecraft.world.level.chunk.DataPaletteBlock$d.f) {
                    DataPaletteHash<Object> palette = new DataPaletteHash<Object>(registry, i2, (bits, objectAdded) -> 0, list);
                    SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i2, size, longs);
                    int[] ints = new int[size];
                    simpleBitStorage.a(ints);
                    DataPaletteBlock.a(ints, id -> registry.a(palette.a(id)));
                    bitStorage = new SimpleBitStorage(configuration.b(), size, ints);
                } else {
                    bitStorage = new SimpleBitStorage(configuration.b(), size, longs);
                }
            }
            catch (SimpleBitStorage.a var13) {
                return DataResult.error(() -> "Failed to read PalettedContainer: " + var13.getMessage());
            }
        }
        return DataResult.success(new DataPaletteBlock<T>(registry, strategy, configuration, bitStorage, list, defaultValue, presetValues));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized PalettedContainerRO.a<T> a(Registry<T> registry, d strategy) {
        PalettedContainerRO.a<T> var12;
        this.a();
        try {
            Optional<LongStream> optional;
            DataPaletteHash<T> hashMapPalette = new DataPaletteHash<T>(registry, this.d.b.c(), this.b);
            int size = strategy.a();
            int[] ints = new int[size];
            this.d.b.a(ints);
            DataPaletteBlock.a(ints, id -> hashMapPalette.a(this.d.c.a(id)));
            int i2 = strategy.b(registry, hashMapPalette.b());
            if (i2 != 0) {
                SimpleBitStorage simpleBitStorage = new SimpleBitStorage(i2, size, ints);
                optional = Optional.of(Arrays.stream(simpleBitStorage.a()));
            } else {
                optional = Optional.empty();
            }
            var12 = new PalettedContainerRO.a<T>(hashMapPalette.c(), optional);
        }
        finally {
            this.b();
        }
        return var12;
    }

    private static <T> void a(int[] bits, IntUnaryOperator operator) {
        int i2 = -1;
        int i1 = -1;
        for (int i22 = 0; i22 < bits.length; ++i22) {
            int i3 = bits[i22];
            if (i3 != i2) {
                i2 = i3;
                i1 = operator.applyAsInt(i3);
            }
            bits[i22] = i1;
        }
    }

    @Override
    public int c() {
        return this.d.a();
    }

    @Override
    public boolean a(Predicate<T> predicate) {
        return this.d.c.a(predicate);
    }

    @Override
    public DataPaletteBlock<T> d() {
        return new DataPaletteBlock<T>(this, this.presetValues);
    }

    @Override
    public DataPaletteBlock<T> e() {
        return new DataPaletteBlock<T>(this.c, this.d.c.a(0), this.e, this.presetValues);
    }

    @Override
    public void a(b<T> countConsumer) {
        if (this.d.c.b() == 1) {
            countConsumer.accept(this.d.c.a(0), this.d.b.b());
        } else {
            Int2IntOpenHashMap map = new Int2IntOpenHashMap();
            this.d.b.a((int id) -> map.addTo(id, 1));
            map.int2IntEntrySet().forEach(idEntry -> countConsumer.accept(this.d.c.a(idEntry.getIntKey()), idEntry.getIntValue()));
        }
    }

    public static abstract class d {
        public static final DataPalette.a a = SingleValuePalette::a;
        public static final DataPalette.a b = DataPaletteLinear::a;
        public static final DataPalette.a c = DataPaletteHash::a;
        static final DataPalette.a f = DataPaletteGlobal::a;
        public static final d d = new d(4){

            @Override
            public <A> a<A> a(Registry<A> registry, int size) {
                return switch (size) {
                    case 0 -> new a(a, size);
                    case 1, 2, 3, 4 -> new a(b, 4);
                    case 5, 6, 7, 8 -> new a(c, size);
                    default -> new a(f, MathHelper.e(registry.d()));
                };
            }
        };
        public static final d e = new d(2){

            @Override
            public <A> a<A> a(Registry<A> registry, int size) {
                return switch (size) {
                    case 0 -> new a(a, size);
                    case 1, 2, 3 -> new a(b, size);
                    default -> new a(f, MathHelper.e(registry.d()));
                };
            }
        };
        private final int g;

        d(int sizeBits) {
            this.g = sizeBits;
        }

        public int a() {
            return 1 << this.g * 3;
        }

        public int a(int x2, int y2, int z2) {
            return (y2 << this.g | z2) << this.g | x2;
        }

        public abstract <A> a<A> a(Registry<A> var1, int var2);

        <A> int b(Registry<A> registry, int size) {
            int i2 = MathHelper.e(size);
            a<A> configuration = this.a(registry, i2);
            return configuration.a() == f ? i2 : configuration.b();
        }
    }

    public static final class c<T>
    implements FastPaletteData<T> {
        private final a<T> a;
        private final DataBits b;
        private final DataPalette<T> c;
        private T[] moonrise$palette;

        public c(a<T> configuration, DataBits storage, DataPalette<T> palette) {
            this.a = configuration;
            this.b = storage;
            this.c = palette;
        }

        public a<T> b() {
            return this.a;
        }

        public DataBits c() {
            return this.b;
        }

        public DataPalette<T> d() {
            return this.c;
        }

        @Override
        public final T[] moonrise$getPalette() {
            return this.moonrise$palette;
        }

        @Override
        public final void moonrise$setPalette(T[] palette) {
            this.moonrise$palette = palette;
        }

        public void a(DataPalette<T> palette, DataBits bitStorage) {
            for (int i2 = 0; i2 < bitStorage.b(); ++i2) {
                T object = palette.a(bitStorage.a(i2));
                this.b.b(i2, this.c.a(object));
            }
        }

        public int a() {
            return 1 + this.c.a() + VarInt.a(this.b.a().length) + this.b.a().length * 8;
        }

        public void write(PacketDataSerializer buffer, @javax.annotation.Nullable ChunkPacketInfo<T> chunkPacketInfo, int chunkSectionIndex) {
            buffer.l(this.b.c());
            this.c.b(buffer);
            if (chunkPacketInfo != null) {
                chunkPacketInfo.setBits(chunkSectionIndex, this.a.b());
                chunkPacketInfo.setPalette(chunkSectionIndex, this.c);
                chunkPacketInfo.setIndex(chunkSectionIndex, buffer.writerIndex());
            }
            buffer.b(this.b.a());
        }

        public c<T> a(DataPaletteExpandable<T> resizeHandler) {
            return new c<T>(this.a, this.b.d(), this.c.a(resizeHandler));
        }
    }

    record a<T>(DataPalette.a a, int b) {
        public c<T> a(Registry<T> registry, DataPaletteExpandable<T> paletteResize, int size) {
            DataBits bitStorage = this.b == 0 ? new ZeroBitStorage(size) : new SimpleBitStorage(this.b, size);
            DataPalette<T> palette = this.a.create(this.b, registry, paletteResize, List.of());
            return new c<T>(this, bitStorage, palette);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "factory;bits", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "factory;bits", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "factory;bits", "a", "b"}, this, o2);
        }
    }

    @FunctionalInterface
    public static interface b<T> {
        public void accept(T var1, int var2);
    }
}

