/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.patches.chunk_system.io.ChunkSystemRegionFileStorage;
import ca.spottedleaf.moonrise.patches.chunk_system.io.MoonriseRegionFileIO;
import ca.spottedleaf.moonrise.patches.chunk_system.util.stream.ExternalChunkStreamMarker;
import com.mojang.logging.LogUtils;
import io.papermc.paper.configuration.GlobalConfiguration;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;
import net.minecraft.FileUtils;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ExceptionSuppressor;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.chunk.storage.SerializableChunkData;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;

public class RegionFileCache
implements AutoCloseable,
ChunkSystemRegionFileStorage {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String a = ".mca";
    private static final int b = 256;
    public final Long2ObjectLinkedOpenHashMap<RegionFile> c = new Long2ObjectLinkedOpenHashMap();
    private final RegionStorageInfo d;
    private final Path e;
    private final boolean f;
    private final boolean isChunkData;
    private static final int REGION_SHIFT = 5;
    private static final int MAX_NON_EXISTING_CACHE = 4096;
    private final LongLinkedOpenHashSet nonExistingRegionFiles = new LongLinkedOpenHashSet();

    public static boolean isChunkDataFolder(Path path) {
        return path.toFile().getName().equalsIgnoreCase("region");
    }

    @Nullable
    public static ChunkCoordIntPair getRegionFileCoordinates(Path file) {
        String fileName = file.getFileName().toString();
        if (!fileName.startsWith("r.") || !fileName.endsWith(a)) {
            return null;
        }
        String[] split = fileName.split("\\.");
        if (split.length != 4) {
            return null;
        }
        try {
            int x2 = Integer.parseInt(split[1]);
            int z2 = Integer.parseInt(split[2]);
            return new ChunkCoordIntPair(x2 << 5, z2 << 5);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    private static String getRegionFileName(int chunkX, int chunkZ) {
        return "r." + (chunkX >> 5) + "." + (chunkZ >> 5) + a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doesRegionFilePossiblyExist(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.contains(position)) {
                this.nonExistingRegionFiles.addAndMoveToFirst(position);
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRegionFile(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            this.nonExistingRegionFiles.remove(position);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markNonExisting(long position) {
        LongLinkedOpenHashSet longLinkedOpenHashSet = this.nonExistingRegionFiles;
        synchronized (longLinkedOpenHashSet) {
            if (this.nonExistingRegionFiles.addAndMoveToFirst(position)) {
                while (this.nonExistingRegionFiles.size() >= 4096) {
                    this.nonExistingRegionFiles.removeLastLong();
                }
            }
        }
    }

    @Override
    public final boolean moonrise$doesRegionFileNotExistNoIO(int chunkX, int chunkZ) {
        return !this.doesRegionFilePossiblyExist(ChunkCoordIntPair.c(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfLoaded(int chunkX, int chunkZ) {
        return (RegionFile)this.c.getAndMoveToFirst(ChunkCoordIntPair.c(chunkX >> 5, chunkZ >> 5));
    }

    @Override
    public final synchronized RegionFile moonrise$getRegionFileIfExists(int chunkX, int chunkZ) throws IOException {
        Path regionPath;
        long key = ChunkCoordIntPair.c(chunkX >> 5, chunkZ >> 5);
        RegionFile ret = (RegionFile)this.c.getAndMoveToFirst(key);
        if (ret != null) {
            return ret;
        }
        if (!this.doesRegionFilePossiblyExist(key)) {
            return null;
        }
        if (this.c.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
            ((RegionFile)this.c.removeLast()).close();
        }
        if (!Files.exists(regionPath = this.e.resolve(RegionFileCache.getRegionFileName(chunkX, chunkZ)), new LinkOption[0])) {
            this.markNonExisting(key);
            return null;
        }
        this.createRegionFile(key);
        FileUtils.c(this.e);
        ret = new RegionFile(this.d, regionPath, this.e, this.f);
        this.c.putAndMoveToFirst(key, (Object)ret);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final MoonriseRegionFileIO.RegionDataController.WriteData moonrise$startWrite(int chunkX, int chunkZ, NBTTagCompound compound) throws IOException {
        if (compound == null) {
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
        RegionFile regionFile = this.b(pos);
        MoonriseRegionFileIO.RegionDataController.WriteData writeData = regionFile.moonrise$startWrite(compound, pos);
        try {
            try {
                NBTCompressedStreamTools.a(compound, (DataOutput)writeData.output());
            }
            finally {
                writeData.output().close();
            }
        }
        catch (RegionFileSizeException ex) {
            int maxSize = 500;
            LOGGER.error("Chunk at (" + chunkX + "," + chunkZ + ") in regionfile '" + regionFile.a().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
            return new MoonriseRegionFileIO.RegionDataController.WriteData(compound, MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE, null, null);
        }
        return writeData;
    }

    @Override
    public final void moonrise$finishWrite(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.WriteData writeData) throws IOException {
        ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
        if (writeData.result() == MoonriseRegionFileIO.RegionDataController.WriteData.WriteResult.DELETE) {
            RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
            if (regionFile != null) {
                regionFile.d(pos);
            }
            return;
        }
        writeData.write().run(this.b(pos));
    }

    @Override
    public final MoonriseRegionFileIO.RegionDataController.ReadData moonrise$readData(int chunkX, int chunkZ) throws IOException {
        DataInputStream input;
        RegionFile regionFile = this.moonrise$getRegionFileIfExists(chunkX, chunkZ);
        DataInputStream dataInputStream = input = regionFile == null ? null : regionFile.a(new ChunkCoordIntPair(chunkX, chunkZ));
        if (input == null) {
            return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.NO_DATA, null, null, regionFile == null ? 0 : regionFile.getRecalculateCount());
        }
        MoonriseRegionFileIO.RegionDataController.ReadData ret = new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.HAS_DATA, input, null, regionFile.getRecalculateCount());
        if (!(input instanceof ExternalChunkStreamMarker)) {
            return ret;
        }
        NBTTagCompound syncRead = this.moonrise$finishRead(chunkX, chunkZ, ret);
        if (syncRead == null) {
            return this.moonrise$readData(chunkX, chunkZ);
        }
        return new MoonriseRegionFileIO.RegionDataController.ReadData(MoonriseRegionFileIO.RegionDataController.ReadData.ReadResult.SYNC_READ, null, syncRead, regionFile.getRecalculateCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final NBTTagCompound moonrise$finishRead(int chunkX, int chunkZ, MoonriseRegionFileIO.RegionDataController.ReadData readData) throws IOException {
        try {
            NBTTagCompound ret = NBTCompressedStreamTools.a(readData.input());
            if (!this.isChunkData) {
                NBTTagCompound nBTTagCompound = ret;
                return nBTTagCompound;
            }
            ChunkCoordIntPair pos = new ChunkCoordIntPair(chunkX, chunkZ);
            ChunkCoordIntPair headerChunkPos = SerializableChunkData.getChunkCoordinate(ret);
            RegionFile regionFile = this.b(pos);
            if (regionFile.getRecalculateCount() != readData.recalculateCount()) {
                NBTTagCompound nBTTagCompound = null;
                return nBTTagCompound;
            }
            if (!headerChunkPos.equals(pos)) {
                LOGGER.error("Attempting to read chunk data at " + String.valueOf(pos) + " but got chunk data for " + String.valueOf(headerChunkPos) + " instead! Attempting regionfile recalculation " + String.valueOf(regionFile.a().toAbsolutePath()));
                if (regionFile.recalculateHeader()) {
                    NBTTagCompound nBTTagCompound = null;
                    return nBTTagCompound;
                }
                LOGGER.error(LogUtils.FATAL_MARKER, "Can't recalculate regionfile header?");
                NBTTagCompound nBTTagCompound = ret;
                return nBTTagCompound;
            }
            NBTTagCompound nBTTagCompound = ret;
            return nBTTagCompound;
        }
        finally {
            readData.input().close();
        }
    }

    public RegionFile b(ChunkCoordIntPair chunkcoordintpair) throws IOException {
        return this.getRegionFile(chunkcoordintpair, false);
    }

    protected RegionFileCache(RegionStorageInfo info, Path folder, boolean sync) {
        this.e = folder;
        this.f = sync;
        this.d = info;
        this.isChunkData = RegionFileCache.isChunkDataFolder(this.e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Contract(value="_, false -> !null")
    private RegionFile getRegionFile(ChunkCoordIntPair chunkPos, boolean existingOnly) throws IOException {
        if (existingOnly) {
            return this.moonrise$getRegionFileIfExists(chunkPos.h, chunkPos.i);
        }
        RegionFileCache regionFileCache = this;
        synchronized (regionFileCache) {
            long key = ChunkCoordIntPair.c(chunkPos.h >> 5, chunkPos.i >> 5);
            RegionFile ret = (RegionFile)this.c.getAndMoveToFirst(key);
            if (ret != null) {
                return ret;
            }
            if (this.c.size() >= GlobalConfiguration.get().misc.regionFileCacheSize) {
                ((RegionFile)this.c.removeLast()).close();
            }
            Path regionPath = this.e.resolve(RegionFileCache.getRegionFileName(chunkPos.h, chunkPos.i));
            this.createRegionFile(key);
            FileUtils.c(this.e);
            ret = new RegionFile(this.d, regionPath, this.e, this.f);
            this.c.putAndMoveToFirst(key, (Object)ret);
            return ret;
        }
    }

    private static void printOversizedLog(String msg, Path file, int x2, int z2) {
        LogManager.getLogger().fatal(msg + " (" + file.toString().replaceAll(".+[\\\\/]", "") + " - " + x2 + "," + z2 + ") Go clean it up to remove this message. /minecraft:tp " + (x2 << 4) + " 128 " + (z2 << 4) + " - DO NOT REPORT THIS TO PAPER - You may ask for help on Discord, but do not file an issue. These error messages can not be removed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NBTTagCompound readOversizedChunk(RegionFile regionfile, ChunkCoordIntPair chunkCoordinate) throws IOException {
        RegionFile regionFile = regionfile;
        synchronized (regionFile) {
            try (DataInputStream datainputstream = regionfile.a(chunkCoordinate);){
                NBTTagCompound oversizedData = regionfile.getOversizedData(chunkCoordinate.h, chunkCoordinate.i);
                NBTTagCompound chunk = NBTCompressedStreamTools.a(datainputstream);
                if (oversizedData == null) {
                    NBTTagCompound nBTTagCompound2 = chunk;
                    return nBTTagCompound2;
                }
                NBTTagCompound oversizedLevel = oversizedData.n("Level");
                RegionFileCache.mergeChunkList(chunk.n("Level"), oversizedLevel, "Entities", "Entities");
                RegionFileCache.mergeChunkList(chunk.n("Level"), oversizedLevel, "TileEntities", "TileEntities");
                NBTTagCompound nBTTagCompound = chunk;
                return nBTTagCompound;
            }
            catch (Throwable throwable3) {
                throwable3.printStackTrace();
                throw throwable3;
            }
        }
    }

    private static void mergeChunkList(NBTTagCompound level, NBTTagCompound oversizedLevel, String key, String oversizedKey) {
        NBTTagList levelList = level.p(key);
        NBTTagList oversizedList = oversizedLevel.p(oversizedKey);
        if (!oversizedList.isEmpty()) {
            levelList.addAll(oversizedList);
            level.a(key, levelList);
        }
    }

    @Nullable
    public NBTTagCompound a(ChunkCoordIntPair chunkPos) throws IOException {
        NBTTagCompound var4;
        RegionFile regionFile = this.getRegionFile(chunkPos, true);
        if (regionFile == null) {
            return null;
        }
        if (regionFile.isOversized(chunkPos.h, chunkPos.i)) {
            RegionFileCache.printOversizedLog("Loading Oversized Chunk!", regionFile.a(), chunkPos.h, chunkPos.i);
            return RegionFileCache.readOversizedChunk(regionFile, chunkPos);
        }
        try (DataInputStream chunkDataInputStream = regionFile.a(chunkPos);){
            ChunkCoordIntPair headerChunkPos;
            if (chunkDataInputStream == null) {
                NBTTagCompound nBTTagCompound = null;
                return nBTTagCompound;
            }
            var4 = NBTCompressedStreamTools.a(chunkDataInputStream);
            if (this.isChunkData && !(headerChunkPos = SerializableChunkData.getChunkCoordinate(var4)).equals(chunkPos)) {
                MinecraftServer.l.error("Attempting to read chunk data at " + String.valueOf(chunkPos) + " but got chunk data for " + String.valueOf(headerChunkPos) + " instead! Attempting regionfile recalculation for regionfile " + String.valueOf(regionFile.a().toAbsolutePath()));
                if (regionFile.recalculateHeader()) {
                    NBTTagCompound nBTTagCompound = this.a(chunkPos);
                    return nBTTagCompound;
                }
                MinecraftServer.l.error("Can't recalculate regionfile header, regenerating chunk " + String.valueOf(chunkPos) + " for " + String.valueOf(regionFile.a().toAbsolutePath()));
                NBTTagCompound nBTTagCompound = null;
                return nBTTagCompound;
            }
        }
        return var4;
    }

    public void a(ChunkCoordIntPair chunkPos, StreamTagVisitor visitor) throws IOException {
        RegionFile regionFile = this.getRegionFile(chunkPos, true);
        if (regionFile == null) {
            return;
        }
        try (DataInputStream chunkDataInputStream = regionFile.a(chunkPos);){
            if (chunkDataInputStream != null) {
                NBTCompressedStreamTools.a((DataInput)chunkDataInputStream, visitor, NBTReadLimiter.a());
            }
        }
    }

    public void a(ChunkCoordIntPair chunkPos, @Nullable NBTTagCompound chunkData) throws IOException {
        RegionFile regionFile = this.getRegionFile(chunkPos, chunkData == null);
        if (regionFile == null) {
            return;
        }
        if (chunkData == null) {
            regionFile.d(chunkPos);
        } else {
            DataOutputStream chunkDataOutputStream = regionFile.c(chunkPos);
            try {
                NBTCompressedStreamTools.a(chunkData, (DataOutput)chunkDataOutputStream);
                regionFile.setOversized(chunkPos.h, chunkPos.i, false);
                chunkDataOutputStream.close();
            }
            catch (RegionFileSizeException ex) {
                regionFile.d(chunkPos);
                int maxSize = 500;
                LOGGER.error("Chunk at (" + chunkPos.h + "," + chunkPos.i + ") in regionfile '" + regionFile.a().toString() + "' exceeds max size of 500MiB, it has been deleted from disk.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        RegionFileCache regionFileCache = this;
        synchronized (regionFileCache) {
            ExceptionSuppressor<IOException> exceptionCollector = new ExceptionSuppressor<IOException>();
            for (RegionFile regionFile : this.c.values()) {
                try {
                    regionFile.close();
                }
                catch (IOException ex) {
                    exceptionCollector.a(ex);
                }
            }
            exceptionCollector.a();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a() throws IOException {
        RegionFileCache regionFileCache = this;
        synchronized (regionFileCache) {
            ExceptionSuppressor<IOException> exceptionCollector = new ExceptionSuppressor<IOException>();
            for (RegionFile regionFile : this.c.values()) {
                try {
                    regionFile.b();
                }
                catch (IOException ex) {
                    exceptionCollector.a(ex);
                }
            }
            exceptionCollector.a();
        }
    }

    public RegionStorageInfo b() {
        return this.d;
    }

    public static final class RegionFileSizeException
    extends RuntimeException {
        public RegionFileSizeException(String message) {
            super(message);
        }
    }
}

