/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import ca.spottedleaf.moonrise.common.util.MixinWorkarounds;
import ca.spottedleaf.moonrise.common.util.WorldUtil;
import ca.spottedleaf.moonrise.patches.starlight.light.SWMRNibbleArray;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightEngine;
import ca.spottedleaf.moonrise.patches.starlight.storage.StarlightSectionData;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortArrayList;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Optionull;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NbtException;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.LightEngineThreaded;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlace;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkConverter;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.DataPaletteBlock;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.NibbleArray;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.ProtoChunkExtension;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.chunk.storage.IChunkLoader;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ProtoChunkTickList;
import net.minecraft.world.ticks.TickListChunk;
import org.slf4j.Logger;

public final class SerializableChunkData
extends Record {
    private final IRegistry<BiomeBase> h;
    private final ChunkCoordIntPair i;
    private final int j;
    private final long k;
    private final long l;
    private final ChunkStatus m;
    @Nullable
    private final BlendingData.d n;
    @Nullable
    private final BelowZeroRetrogen o;
    private final ChunkConverter p;
    @Nullable
    private final long[] q;
    private final Map<HeightMap.Type, long[]> r;
    private final IChunkAccess.a s;
    private final ShortList[] t;
    private final boolean u;
    private final List<b> v;
    private final List<NBTTagCompound> w;
    private final List<NBTTagCompound> x;
    private final NBTTagCompound y;
    @Nullable
    private final NBTBase persistentDataContainer;
    public static final Codec<DataPaletteBlock<IBlockData>> z = DataPaletteBlock.codecRW(Block.k, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), null);
    private static final Codec<List<TickListChunk<Block>>> A = TickListChunk.a(BuiltInRegistries.e.q()).listOf();
    private static final Codec<List<TickListChunk<FluidType>>> B = TickListChunk.a(BuiltInRegistries.c.q()).listOf();
    private static final Logger C = LogUtils.getLogger();
    private static final String D = "UpgradeData";
    private static final String E = "block_ticks";
    private static final String F = "fluid_ticks";
    public static final String a = "xPos";
    public static final String b = "zPos";
    public static final String c = "Heightmaps";
    public static final String d = "isLightOn";
    public static final String e = "sections";
    public static final String f = "BlockLight";
    public static final String g = "SkyLight";
    private static final int CURRENT_DATA_VERSION = SharedConstants.b().d().c();
    private static final boolean JUST_CORRUPT_IT = Boolean.getBoolean("Paper.ignoreWorldDataVersion");

    public SerializableChunkData(IRegistry<BiomeBase> biomeRegistry, ChunkCoordIntPair chunkPos, int minSectionY, long lastUpdateTime, long inhabitedTime, ChunkStatus chunkStatus, @Nullable BlendingData.d blendingData, @Nullable BelowZeroRetrogen belowZeroRetrogen, ChunkConverter upgradeData, @Nullable long[] carvingMask, Map<HeightMap.Type, long[]> heightmaps, IChunkAccess.a packedTicks, ShortList[] postProcessingSections, boolean lightCorrect, List<b> sectionData, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities, NBTTagCompound structureData, @Nullable NBTBase persistentDataContainer) {
        this.h = biomeRegistry;
        this.i = chunkPos;
        this.j = minSectionY;
        this.k = lastUpdateTime;
        this.l = inhabitedTime;
        this.m = chunkStatus;
        this.n = blendingData;
        this.o = belowZeroRetrogen;
        this.p = upgradeData;
        this.q = carvingMask;
        this.r = heightmaps;
        this.s = packedTicks;
        this.t = postProcessingSections;
        this.u = lightCorrect;
        this.v = sectionData;
        this.w = entities;
        this.x = blockEntities;
        this.y = structureData;
        this.persistentDataContainer = persistentDataContainer;
    }

    public static ChunkCoordIntPair getChunkCoordinate(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.n("Level");
            return new ChunkCoordIntPair(levelData.b(a, 0), levelData.b(b, 0));
        }
        return new ChunkCoordIntPair(chunkData.b(a, 0), chunkData.b(b, 0));
    }

    public static long getLastWorldSaveTime(NBTTagCompound chunkData) {
        int dataVersion = IChunkLoader.a(chunkData);
        if (dataVersion < 2842) {
            NBTTagCompound levelData = chunkData.n("Level");
            return levelData.b("LastUpdate", 0L);
        }
        return chunkData.b("LastUpdate", 0L);
    }

    @Nullable
    public static SerializableChunkData a(LevelHeightAccessor levelHeightAccessor, IRegistryCustom registries, NBTTagCompound tag) {
        WorldServer serverLevel = (WorldServer)levelHeightAccessor;
        if (tag.i("Status").isEmpty()) {
            return null;
        }
        tag.e("DataVersion").ifPresent(dataVersion -> {
            if (!JUST_CORRUPT_IT && dataVersion > CURRENT_DATA_VERSION) {
                new RuntimeException("Server attempted to load chunk saved with newer version of minecraft! " + dataVersion + " > " + CURRENT_DATA_VERSION).printStackTrace();
                System.exit(1);
            }
        });
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(tag.b(a, 0), tag.b(b, 0));
        long longOr = tag.b("LastUpdate", 0L);
        long longOr1 = tag.b("InhabitedTime", 0L);
        ChunkStatus chunkStatus = tag.a("Status", ChunkStatus.o).orElse(ChunkStatus.c);
        ChunkConverter upgradeData = tag.m(D).map(compoundTag1 -> new ChunkConverter((NBTTagCompound)compoundTag1, levelHeightAccessor)).orElse(ChunkConverter.a);
        boolean booleanOr = chunkStatus.a(ChunkStatus.l) && tag.a(d) != null && tag.b("starlight.light_version", -1) == 9;
        BlendingData.d packed = tag.a("blending_data", BlendingData.d.a).orElse(null);
        BelowZeroRetrogen belowZeroRetrogen = tag.a("below_zero_retrogen", BelowZeroRetrogen.a).orElse(null);
        long[] longs = tag.l("carving_mask").orElse(null);
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        tag.m(c).ifPresent(compoundTag1 -> {
            for (HeightMap.Type types : chunkStatus.e()) {
                compoundTag1.l(types.a()).ifPresent(longs1 -> map.put(types, (long[])longs1));
            }
        });
        List<TickListChunk<Block>> list = TickListChunk.a(tag.a(E, A).orElse(List.of()), chunkPos);
        List<TickListChunk<FluidType>> list1 = TickListChunk.a(tag.a(F, B).orElse(List.of()), chunkPos);
        IChunkAccess.a packedTicks = new IChunkAccess.a(list, list1);
        NBTTagList listOrEmpty = tag.p("PostProcessing");
        ShortList[] lists = new ShortList[listOrEmpty.size()];
        for (int i2 = 0; i2 < listOrEmpty.size(); ++i2) {
            NBTTagList listOrEmpty1 = listOrEmpty.f(i2);
            ShortArrayList list2 = new ShortArrayList(listOrEmpty1.size());
            for (int i1 = 0; i1 < listOrEmpty1.size(); ++i1) {
                list2.add(listOrEmpty1.a(i1, (short)0));
            }
            lists[i2] = list2;
        }
        List<NBTTagCompound> list3 = tag.o("entities").stream().flatMap(NBTTagList::j).toList();
        List<NBTTagCompound> list4 = tag.o("block_entities").stream().flatMap(NBTTagList::j).toList();
        NBTTagCompound compoundOrEmpty = tag.n("structures");
        NBTTagList listOrEmpty2 = tag.p(e);
        ArrayList<b> list5 = new ArrayList<b>(listOrEmpty2.size());
        IRegistry<BiomeBase> registry = registries.f(Registries.aG);
        Codec<DataPaletteBlock<Holder<BiomeBase>>> codec = SerializableChunkData.makeBiomeCodecRW(registry);
        for (int i2 = 0; i2 < listOrEmpty2.size(); ++i2) {
            ChunkSection levelChunkSection;
            NBTTagCompound compoundTag;
            Optional<NBTTagCompound> compound = listOrEmpty2.a(i2);
            if (compound.isEmpty()) continue;
            NBTTagCompound sectionData = compoundTag = compound.get();
            byte byteOr = compoundTag.b("Y", (byte)0);
            if (byteOr >= levelHeightAccessor.aq() && byteOr <= levelHeightAccessor.ar()) {
                IBlockData[] presetBlockStates = serverLevel.chunkPacketBlockController.getPresetBlockStates(serverLevel, chunkPos, byteOr);
                Codec<DataPaletteBlock<IBlockData>> blockStateCodec = presetBlockStates == null ? z : DataPaletteBlock.codecRW(Block.k, IBlockData.a, DataPaletteBlock.d.d, Blocks.a.m(), presetBlockStates);
                DataPaletteBlock palettedContainer = compoundTag.m("block_states").map(compoundTag1 -> (DataPaletteBlock)blockStateCodec.parse((DynamicOps)DynamicOpsNBT.a, compoundTag1).promotePartial(string -> SerializableChunkData.a(chunkPos, byteOr, string)).getOrThrow(a::new)).orElseGet(() -> new DataPaletteBlock<IBlockData>(Block.k, Blocks.a.m(), DataPaletteBlock.d.d, presetBlockStates));
                DataPaletteBlock palettedContainerRo = compoundTag.m("biomes").map(compoundTag1 -> (DataPaletteBlock)codec.parse((DynamicOps)DynamicOpsNBT.a, compoundTag1).promotePartial(string -> SerializableChunkData.a(chunkPos, byteOr, string)).getOrThrow(a::new)).orElseGet(() -> new DataPaletteBlock<Holder.c>(registry.t(), registry.b(Biomes.b), DataPaletteBlock.d.e, null));
                levelChunkSection = new ChunkSection(palettedContainer, palettedContainerRo);
            } else {
                levelChunkSection = null;
            }
            NibbleArray dataLayer = compoundTag.j(f).map(NibbleArray::new).orElse(null);
            NibbleArray dataLayer1 = compoundTag.j(g).map(NibbleArray::new).orElse(null);
            b serializableChunkData = new b(byteOr, levelChunkSection, dataLayer, dataLayer1);
            if (sectionData.b("starlight.blocklight_state")) {
                ((StarlightSectionData)serializableChunkData).starlight$setBlockLightState(sectionData.b("starlight.blocklight_state", 0));
            }
            if (sectionData.b("starlight.skylight_state")) {
                ((StarlightSectionData)serializableChunkData).starlight$setSkyLightState(sectionData.b("starlight.skylight_state", 0));
            }
            list5.add(serializableChunkData);
        }
        return new SerializableChunkData(registry, chunkPos, levelHeightAccessor.aq(), longOr, longOr1, chunkStatus, packed, belowZeroRetrogen, upgradeData, longs, map, packedTicks, lists, booleanOr, list5, list3, list4, compoundOrEmpty, tag.a("ChunkBukkitValues"));
    }

    private ProtoChunk loadStarlightLightData(WorldServer world, ProtoChunk ret) {
        boolean hasSkyLight = world.F_().g();
        int minSection = WorldUtil.getMinLightSection(world);
        SWMRNibbleArray[] blockNibbles = StarLightEngine.getFilledEmptyLight(world);
        SWMRNibbleArray[] skyNibbles = StarLightEngine.getFilledEmptyLight(world);
        if (!this.u) {
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
            return ret;
        }
        try {
            for (b sectionData : this.v) {
                int y2 = sectionData.a();
                NibbleArray blockLight = sectionData.c();
                NibbleArray skyLight = sectionData.d();
                int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
                int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
                if (blockState >= 0) {
                    blockNibbles[y2 - minSection] = blockLight != null ? new SWMRNibbleArray(MixinWorkarounds.clone(blockLight.a()), blockState) : new SWMRNibbleArray(null, blockState);
                }
                if (skyState < 0 || !hasSkyLight) continue;
                if (skyLight != null) {
                    skyNibbles[y2 - minSection] = new SWMRNibbleArray(MixinWorkarounds.clone(skyLight.a()), skyState);
                    continue;
                }
                skyNibbles[y2 - minSection] = new SWMRNibbleArray(null, skyState);
            }
            ret.starlight$setBlockNibbles(blockNibbles);
            ret.starlight$setSkyNibbles(skyNibbles);
        }
        catch (Throwable thr) {
            ret.a(false);
            C.error("Failed to parse light data for chunk " + String.valueOf(ret.f()) + " in world '" + WorldUtil.getWorldName(world) + "'", thr);
        }
        return ret;
    }

    public ProtoChunk a(WorldServer level, VillagePlace poiManager, RegionStorageInfo regionStorageInfo, ChunkCoordIntPair pos) {
        Iterator protoChunkTicks1;
        IChunkAccess chunkAccess;
        if (!Objects.equals(pos, this.i)) {
            C.error("Chunk file at {} is in the wrong location; relocating. (Expected {}, got {})", new Object[]{pos, pos, this.i});
            level.p().a(this.i, pos, regionStorageInfo);
        }
        int sectionsCount = level.ap();
        ChunkSection[] levelChunkSections = new ChunkSection[sectionsCount];
        boolean hasSkyLight = level.F_().g();
        ChunkProviderServer chunkSource = level.m();
        LevelLightEngine lightEngine = ((IChunkProvider)chunkSource).q();
        IRegistry<BiomeBase> registry = level.J_().f(Registries.aG);
        boolean flag = false;
        for (b sectionData : this.v) {
            boolean flag2;
            SectionPosition sectionPos = SectionPosition.a(pos, sectionData.a);
            if (sectionData.b != null) {
                levelChunkSections[level.g((int)sectionData.a)] = sectionData.b;
            }
            boolean flag1 = sectionData.c != null;
            boolean bl = flag2 = hasSkyLight && sectionData.d != null;
            if (!flag1 && !flag2) continue;
            if (!flag) {
                lightEngine.b(pos, true);
                flag = true;
            }
            if (flag1) {
                lightEngine.a(EnumSkyBlock.b, sectionPos, sectionData.c);
            }
            if (!flag2) continue;
            lightEngine.a(EnumSkyBlock.a, sectionPos, sectionData.d);
        }
        ChunkType chunkType = this.m.d();
        if (chunkType == ChunkType.b) {
            LevelChunkTicks<Block> levelChunkTicks = new LevelChunkTicks<Block>(this.s.a());
            LevelChunkTicks<FluidType> levelChunkTicks1 = new LevelChunkTicks<FluidType>(this.s.b());
            chunkAccess = new Chunk(level.a(), pos, this.p, levelChunkTicks, levelChunkTicks1, this.l, levelChunkSections, SerializableChunkData.a(level, this.w, this.x), BlendingData.a(this.n));
        } else {
            ProtoChunkTickList<Block> protoChunkTicks = ProtoChunkTickList.a(this.s.a());
            protoChunkTicks1 = ProtoChunkTickList.a(this.s.b());
            ProtoChunk protoChunk = new ProtoChunk(pos, this.p, levelChunkSections, protoChunkTicks, (ProtoChunkTickList<FluidType>)((Object)protoChunkTicks1), level, registry, BlendingData.a(this.n));
            chunkAccess = protoChunk;
            protoChunk.c(this.l);
            if (this.o != null) {
                protoChunk.a(this.o);
            }
            protoChunk.a(this.m);
            if (this.m.a(ChunkStatus.k)) {
                protoChunk.a(lightEngine);
            }
        }
        protoChunkTicks1 = this.persistentDataContainer;
        if (protoChunkTicks1 instanceof NBTTagCompound) {
            NBTTagCompound compoundTag = (NBTTagCompound)((Object)protoChunkTicks1);
            chunkAccess.persistentDataContainer.putAll(compoundTag);
        }
        chunkAccess.a(this.u);
        EnumSet<HeightMap.Type> set = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type types : chunkAccess.n().e()) {
            long[] longs = this.r.get(types);
            if (longs != null) {
                chunkAccess.a(types, longs);
                continue;
            }
            set.add(types);
        }
        HeightMap.a(chunkAccess, set);
        chunkAccess.a(SerializableChunkData.a(StructurePieceSerializationContext.a(level), this.y, level.E()));
        chunkAccess.b(SerializableChunkData.a(level.J_(), pos, this.y));
        for (int i2 = 0; i2 < this.t.length; ++i2) {
            chunkAccess.a(this.t[i2], i2);
        }
        if (chunkType == ChunkType.b) {
            return this.loadStarlightLightData(level, new ProtoChunkExtension((Chunk)chunkAccess, false));
        }
        ProtoChunk protoChunk1 = (ProtoChunk)chunkAccess;
        for (NBTTagCompound compoundTag : this.w) {
            protoChunk1.b(compoundTag);
        }
        for (NBTTagCompound compoundTag : this.x) {
            protoChunk1.a(compoundTag);
        }
        if (this.q != null) {
            protoChunk1.a(new CarvingMask(this.q, chunkAccess.K_()));
        }
        return this.loadStarlightLightData(level, protoChunk1);
    }

    private static void a(ChunkCoordIntPair chunkPos, int sectionY, String error) {
        C.error("Recoverable errors when loading section [{}, {}, {}]: {}", new Object[]{chunkPos.h, sectionY, chunkPos.i, error});
    }

    private static Codec<PalettedContainerRO<Holder<BiomeBase>>> a(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.b(biomeRegistry.t(), biomeRegistry.r(), DataPaletteBlock.d.e, biomeRegistry.b(Biomes.b));
    }

    private static Codec<DataPaletteBlock<Holder<BiomeBase>>> makeBiomeCodecRW(IRegistry<BiomeBase> biomeRegistry) {
        return DataPaletteBlock.codecRW(biomeRegistry.t(), biomeRegistry.r(), DataPaletteBlock.d.e, biomeRegistry.b(Biomes.b), null);
    }

    public static SerializableChunkData a(WorldServer level, IChunkAccess chunk) {
        ArrayList<b> list;
        if (!chunk.s()) {
            throw new IllegalArgumentException("Chunk can't be serialized: " + String.valueOf(chunk));
        }
        ChunkCoordIntPair pos = chunk.f();
        ArrayList<b> sectionsList = list = new ArrayList<b>();
        ChunkSection[] sections = chunk.d();
        LightEngineThreaded lightEngine = level.m().a();
        int minLightSection = WorldUtil.getMinLightSection(level);
        int maxLightSection = WorldUtil.getMaxLightSection(level);
        int minBlockSection = WorldUtil.getMinSection(level);
        ChunkSection[] chunkSections = chunk.d();
        SWMRNibbleArray[] blockNibbles = chunk.starlight$getBlockNibbles();
        SWMRNibbleArray[] skyNibbles = chunk.starlight$getSkyNibbles();
        for (int lightSection = minLightSection; lightSection <= maxLightSection; ++lightSection) {
            int lightSectionIdx = lightSection - minLightSection;
            int blockSectionIdx = lightSection - minBlockSection;
            ChunkSection chunkSection = blockSectionIdx >= 0 && blockSectionIdx < chunkSections.length ? chunkSections[blockSectionIdx].k() : null;
            SWMRNibbleArray.SaveState blockNibble = blockNibbles[lightSectionIdx].getSaveState();
            SWMRNibbleArray.SaveState saveState = skyNibbles[lightSectionIdx].getSaveState();
            if (chunkSection == null && blockNibble == null && saveState == null) continue;
            b sectionData = new b(lightSection, chunkSection, blockNibble == null ? null : (blockNibble.data == null ? null : new NibbleArray(blockNibble.data)), saveState == null ? null : (saveState.data == null ? null : new NibbleArray(saveState.data)));
            if (blockNibble != null) {
                ((StarlightSectionData)sectionData).starlight$setBlockLightState(blockNibble.state);
            }
            if (saveState != null) {
                ((StarlightSectionData)sectionData).starlight$setSkyLightState(saveState.state);
            }
            sectionsList.add(sectionData);
        }
        ArrayList<NBTTagCompound> list1 = new ArrayList<NBTTagCompound>(chunk.c().size());
        for (BlockPosition blockPos : chunk.c()) {
            NBTTagCompound blockEntityNbtForSaving = chunk.a(blockPos, level.J_());
            if (blockEntityNbtForSaving == null) continue;
            list1.add(blockEntityNbtForSaving);
        }
        ArrayList<NBTTagCompound> list2 = new ArrayList<NBTTagCompound>();
        long[] longs = null;
        if (chunk.n().d() == ChunkType.a) {
            ProtoChunk protoChunk = (ProtoChunk)chunk;
            list2.addAll(protoChunk.I());
            CarvingMask carvingMask = protoChunk.E();
            if (carvingMask != null) {
                longs = carvingMask.a();
            }
        }
        EnumMap<HeightMap.Type, long[]> map = new EnumMap<HeightMap.Type, long[]>(HeightMap.Type.class);
        for (Map.Entry entry : chunk.e()) {
            if (!chunk.n().e().contains(entry.getKey())) continue;
            long[] rawData = ((HeightMap)entry.getValue()).a();
            map.put((HeightMap.Type)entry.getKey(), (long[])rawData.clone());
        }
        IChunkAccess.a ticksForSerialization = chunk.a(level.ae());
        ShortList[] shortListArray = (ShortList[])Arrays.stream(chunk.p()).map(list3 -> list3 != null ? new ShortArrayList(list3) : null).toArray(ShortList[]::new);
        NBTTagCompound compoundTag = SerializableChunkData.a(StructurePieceSerializationContext.a(level), pos, chunk.g(), chunk.h());
        NBTTagCompound persistentDataContainer = null;
        if (!chunk.persistentDataContainer.isEmpty()) {
            persistentDataContainer = chunk.persistentDataContainer.toTagCompound();
        }
        return new SerializableChunkData(level.J_().f(Registries.aG), pos, chunk.aq(), level.ae(), chunk.w(), chunk.n(), Optionull.a(chunk.v(), BlendingData::a), chunk.z(), chunk.t().c(), longs, map, ticksForSerialization, shortListArray, chunk.x(), list, list2, list1, compoundTag, persistentDataContainer);
    }

    public NBTTagCompound a() {
        NBTTagCompound compoundTag = GameProfileSerializer.e(new NBTTagCompound());
        compoundTag.a(a, this.i.h);
        compoundTag.a("yPos", this.j);
        compoundTag.a(b, this.i.i);
        compoundTag.a("LastUpdate", this.k);
        compoundTag.a("InhabitedTime", this.l);
        compoundTag.a("Status", BuiltInRegistries.l.b(this.m).toString());
        compoundTag.b("blending_data", BlendingData.d.a, this.n);
        compoundTag.b("below_zero_retrogen", BelowZeroRetrogen.a, this.o);
        if (!this.p.a()) {
            compoundTag.a(D, this.p.b());
        }
        NBTTagList listTag = new NBTTagList();
        Codec<PalettedContainerRO<Holder<BiomeBase>>> codec = SerializableChunkData.a(this.h);
        for (b sectionData : this.v) {
            NBTTagCompound compoundTag1;
            NBTTagCompound sectionNBT = compoundTag1 = new NBTTagCompound();
            ChunkSection levelChunkSection = sectionData.b;
            if (levelChunkSection != null) {
                compoundTag1.a("block_states", z, levelChunkSection.h());
                compoundTag1.a("biomes", codec, levelChunkSection.i());
            }
            if (sectionData.c != null) {
                compoundTag1.a(f, sectionData.c.a());
            }
            if (sectionData.d != null) {
                compoundTag1.a(g, sectionData.d.a());
            }
            int blockState = ((StarlightSectionData)sectionData).starlight$getBlockLightState();
            int skyState = ((StarlightSectionData)sectionData).starlight$getSkyLightState();
            if (blockState > 0) {
                sectionNBT.a("starlight.blocklight_state", blockState);
            }
            if (skyState > 0) {
                sectionNBT.a("starlight.skylight_state", skyState);
            }
            if (compoundTag1.j()) continue;
            compoundTag1.a("Y", (byte)sectionData.a);
            listTag.add(compoundTag1);
        }
        compoundTag.a(e, listTag);
        if (this.u) {
            compoundTag.a(d, true);
        }
        NBTTagList listTag1 = new NBTTagList();
        listTag1.addAll(this.x);
        compoundTag.a("block_entities", listTag1);
        if (this.m.d() == ChunkType.a) {
            NBTTagList listTag2 = new NBTTagList();
            listTag2.addAll(this.w);
            compoundTag.a("entities", listTag2);
            if (this.q != null) {
                compoundTag.a("carving_mask", this.q);
            }
        }
        SerializableChunkData.a(compoundTag, this.s);
        compoundTag.a("PostProcessing", SerializableChunkData.a(this.t));
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        this.r.forEach((types, longs) -> compoundTag2.a(types.a(), new NBTTagLongArray((long[])longs)));
        compoundTag.a(c, compoundTag2);
        compoundTag.a("structures", this.y);
        if (this.persistentDataContainer != null) {
            compoundTag.a("ChunkBukkitValues", this.persistentDataContainer);
        }
        if (this.u && !this.m.d(ChunkStatus.l)) {
            compoundTag.a(d, false);
            compoundTag.a("starlight.light_version", 9);
        }
        return compoundTag;
    }

    private static void a(NBTTagCompound tag, IChunkAccess.a ticks) {
        tag.a(E, A, ticks.a());
        tag.a(F, B, ticks.b());
    }

    public static ChunkStatus a(@Nullable NBTTagCompound tag) {
        return tag != null ? tag.a("Status", ChunkStatus.o).orElse(ChunkStatus.c) : ChunkStatus.c;
    }

    @Nullable
    private static Chunk.c a(WorldServer level, List<NBTTagCompound> entities, List<NBTTagCompound> blockEntities) {
        return entities.isEmpty() && blockEntities.isEmpty() ? null : chunk -> {
            if (!entities.isEmpty()) {
                level.a(EntityTypes.a(entities, (World)level, EntitySpawnReason.r));
            }
            for (NBTTagCompound compoundTag : blockEntities) {
                boolean booleanOr = compoundTag.b("keepPacked", false);
                if (booleanOr) {
                    chunk.a(compoundTag);
                    continue;
                }
                BlockPosition posFromTag = TileEntity.a(chunk.f(), compoundTag);
                TileEntity blockEntity = TileEntity.a(posFromTag, chunk.a_(posFromTag), compoundTag, level.J_());
                if (blockEntity == null) continue;
                chunk.a(blockEntity);
            }
        };
    }

    private static NBTTagCompound a(StructurePieceSerializationContext context, ChunkCoordIntPair pos, Map<Structure, StructureStart> structureStarts, Map<Structure, LongSet> references) {
        NBTTagCompound compoundTag = new NBTTagCompound();
        NBTTagCompound compoundTag1 = new NBTTagCompound();
        IRegistry<Structure> registry = context.b().f(Registries.be);
        for (Map.Entry<Structure, StructureStart> entry : structureStarts.entrySet()) {
            MinecraftKey key = registry.b(entry.getKey());
            compoundTag1.a(key.toString(), entry.getValue().a(context, pos));
        }
        compoundTag.a("starts", compoundTag1);
        NBTTagCompound compoundTag2 = new NBTTagCompound();
        for (Map.Entry<Structure, LongSet> entry1 : references.entrySet()) {
            if (entry1.getValue().isEmpty()) continue;
            MinecraftKey key1 = registry.b(entry1.getKey());
            compoundTag2.a(key1.toString(), entry1.getValue().toLongArray());
        }
        compoundTag.a("References", compoundTag2);
        return compoundTag;
    }

    private static Map<Structure, StructureStart> a(StructurePieceSerializationContext context, NBTTagCompound tag, long seed) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> registry = context.b().f(Registries.be);
        NBTTagCompound compoundOrEmpty = tag.n("starts");
        for (String string : compoundOrEmpty.e()) {
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            Structure structure = registry.a(resourceLocation);
            if (structure == null) {
                C.error("Unknown structure start: {}", (Object)resourceLocation);
                continue;
            }
            StructureStart structureStart = StructureStart.a(context, compoundOrEmpty.n(string), seed);
            if (structureStart == null) continue;
            NBTBase persistentBase = compoundOrEmpty.n(string).a("StructureBukkitValues");
            if (persistentBase instanceof NBTTagCompound) {
                NBTTagCompound compoundTag = (NBTTagCompound)persistentBase;
                structureStart.persistentDataContainer.putAll(compoundTag);
            }
            map.put(structure, structureStart);
        }
        return map;
    }

    private static Map<Structure, LongSet> a(IRegistryCustom registries, ChunkCoordIntPair pos, NBTTagCompound tag) {
        HashMap map = Maps.newHashMap();
        IRegistry<Structure> registry = registries.f(Registries.be);
        NBTTagCompound compoundOrEmpty = tag.n("References");
        compoundOrEmpty.a((string, tag1) -> {
            MinecraftKey resourceLocation = MinecraftKey.c(string);
            Structure structure = (Structure)registry.a(resourceLocation);
            if (structure == null) {
                C.warn("Found reference to unknown structure '{}' in chunk {}, discarding", (Object)resourceLocation, (Object)pos);
            } else {
                Optional<long[]> longArray = tag1.r_();
                if (!longArray.isEmpty()) {
                    map.put(structure, new LongOpenHashSet(Arrays.stream(longArray.get()).filter(l2 -> {
                        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(l2);
                        if (chunkPos.a(pos) > 8) {
                            C.warn("Found invalid structure reference [ {} @ {} ] for chunk {}.", new Object[]{resourceLocation, chunkPos, pos});
                            return false;
                        }
                        return true;
                    }).toArray()));
                }
            }
        });
        return map;
    }

    private static NBTTagList a(ShortList[] offsets) {
        NBTTagList listTag = new NBTTagList();
        for (ShortList list : offsets) {
            NBTTagList listTag1 = new NBTTagList();
            if (list != null) {
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    listTag1.add(NBTTagShort.a(list.getShort(i2)));
                }
            }
            listTag.add(listTag1);
        }
        return listTag;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SerializableChunkData.class, "biomeRegistry;chunkPos;minSectionY;lastUpdateTime;inhabitedTime;chunkStatus;blendingData;belowZeroRetrogen;upgradeData;carvingMask;heightmaps;packedTicks;postProcessingSections;lightCorrect;sectionData;entities;blockEntities;structureData;persistentDataContainer", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "persistentDataContainer"}, this, o2);
    }

    public IRegistry<BiomeBase> b() {
        return this.h;
    }

    public ChunkCoordIntPair c() {
        return this.i;
    }

    public int d() {
        return this.j;
    }

    public long e() {
        return this.k;
    }

    public long f() {
        return this.l;
    }

    public ChunkStatus g() {
        return this.m;
    }

    @Nullable
    public BlendingData.d h() {
        return this.n;
    }

    @Nullable
    public BelowZeroRetrogen i() {
        return this.o;
    }

    public ChunkConverter j() {
        return this.p;
    }

    @Nullable
    public long[] k() {
        return this.q;
    }

    public Map<HeightMap.Type, long[]> l() {
        return this.r;
    }

    public IChunkAccess.a m() {
        return this.s;
    }

    public ShortList[] n() {
        return this.t;
    }

    public boolean o() {
        return this.u;
    }

    public List<b> p() {
        return this.v;
    }

    public List<NBTTagCompound> q() {
        return this.w;
    }

    public List<NBTTagCompound> r() {
        return this.x;
    }

    public NBTTagCompound s() {
        return this.y;
    }

    @Nullable
    public NBTBase persistentDataContainer() {
        return this.persistentDataContainer;
    }

    public static final class b
    implements StarlightSectionData {
        private final int a;
        @Nullable
        private final ChunkSection b;
        @Nullable
        private final NibbleArray c;
        @Nullable
        private final NibbleArray d;
        private int blockLightState = -1;
        private int skyLightState = -1;

        @Override
        public final int starlight$getBlockLightState() {
            return this.blockLightState;
        }

        @Override
        public final void starlight$setBlockLightState(int state) {
            this.blockLightState = state;
        }

        @Override
        public final int starlight$getSkyLightState() {
            return this.skyLightState;
        }

        @Override
        public final void starlight$setSkyLightState(int state) {
            this.skyLightState = state;
        }

        public b(int y2, @Nullable ChunkSection chunkSection, @Nullable NibbleArray blockLight, @Nullable NibbleArray skyLight) {
            this.a = y2;
            this.b = chunkSection;
            this.c = blockLight;
            this.d = skyLight;
        }

        public int a() {
            return this.a;
        }

        @Nullable
        public ChunkSection b() {
            return this.b;
        }

        @Nullable
        public NibbleArray c() {
            return this.c;
        }

        @Nullable
        public NibbleArray d() {
            return this.d;
        }
    }

    public static class a
    extends NbtException {
        public a(String message) {
            super(message);
        }
    }
}

