/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.dimension.end;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.papermc.paper.event.block.DragonEggFormEvent;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.EndFeatures;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossBattle;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderCrystal;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityEnderPortal;
import net.minecraft.world.level.block.state.pattern.ShapeDetector;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBuilder;
import net.minecraft.world.level.block.state.predicate.BlockPredicate;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.dimension.end.EnumDragonRespawn;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.WorldGenEndTrophy;
import net.minecraft.world.level.levelgen.feature.WorldGenEnder;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureConfiguration;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.boss.DragonBattle;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.boss.CraftDragonBattle;
import org.slf4j.Logger;

public class EnderDragonBattle {
    private static final Logger d = LogUtils.getLogger();
    private static final int e = 1200;
    private static final int f = 100;
    public static final int a = 20;
    private static final int g = 8;
    public static final int b = 9;
    public static final int h = 20;
    private static final int i = 96;
    public static final int c = 128;
    private final Predicate<Entity> j;
    private static final IChatBaseComponent DEFAULT_BOSS_EVENT_NAME = IChatBaseComponent.c("entity.minecraft.ender_dragon");
    public final BossBattleServer k = (BossBattleServer)new BossBattleServer(DEFAULT_BOSS_EVENT_NAME, BossBattle.BarColor.a, BossBattle.BarStyle.a).b(true).c(true);
    public final WorldServer l;
    private final BlockPosition m;
    public final ObjectArrayList<Integer> n = new ObjectArrayList();
    private final ShapeDetector o;
    private int p;
    private int q;
    private int r;
    private int s = 21;
    private boolean t;
    public boolean u;
    private boolean v = false;
    @Nullable
    public UUID w;
    private boolean x = true;
    @Nullable
    public BlockPosition y;
    @Nullable
    public EnumDragonRespawn z;
    private int A;
    @Nullable
    public List<EntityEnderCrystal> B;

    public EnderDragonBattle(WorldServer level, long seed, a data) {
        this(level, seed, data, BlockPosition.c);
    }

    public EnderDragonBattle(WorldServer level, long seed, a data, BlockPosition origin) {
        this.l = level;
        this.m = origin;
        this.j = IEntitySelector.a.and(IEntitySelector.a(origin.u(), 128 + origin.v(), origin.w(), 192.0));
        this.x = data.c;
        this.w = data.g.orElse(null);
        this.t = data.d;
        this.u = data.e;
        if (data.f) {
            this.z = EnumDragonRespawn.a;
        }
        if (data == net.minecraft.world.level.dimension.end.EnderDragonBattle$a.b && !level.paperConfig().entities.spawning.scanForLegacyEnderDragon) {
            this.x = false;
            this.t = true;
        }
        this.y = data.h.orElse(null);
        this.n.addAll((Collection)data.i.orElseGet(() -> {
            ObjectArrayList list = new ObjectArrayList((Collection)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            SystemUtils.c(list, RandomSource.a(seed));
            return list;
        }));
        this.o = ShapeDetectorBuilder.a().a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").a("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").a("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").a('#', ShapeDetectorBlock.a(BlockPredicate.a(Blocks.I))).b();
    }

    @Deprecated
    @VisibleForTesting
    public void a() {
        this.v = true;
    }

    public a b() {
        return new a(this.x, this.t, this.u, false, Optional.ofNullable(this.w), Optional.ofNullable(this.y), Optional.of(this.n));
    }

    public void c() {
        this.k.d(!this.t);
        if (++this.s >= 20) {
            this.o();
            this.s = 0;
        }
        if (!this.k.h().isEmpty()) {
            this.l.m().a(TicketType.c, new ChunkCoordIntPair(0, 0), 9);
            boolean isArenaLoaded = this.n();
            if (this.x && isArenaLoaded) {
                this.j();
                this.x = false;
            }
            if (this.z != null) {
                if (this.B == null && isArenaLoaded) {
                    this.z = null;
                    this.tryRespawn();
                }
                this.z.a(this.l, this, this.B, this.A++, this.y);
            }
            if (!this.t) {
                if ((this.w == null || ++this.p >= 1200) && isArenaLoaded) {
                    this.k();
                    this.p = 0;
                }
                if (++this.r >= 100 && isArenaLoaded) {
                    this.p();
                    this.r = 0;
                }
            }
        } else {
            this.l.m().b(TicketType.c, new ChunkCoordIntPair(0, 0), 9);
        }
    }

    private void j() {
        d.info("Scanning for legacy world dragon fight...");
        boolean hasActiveExitPortal = this.l();
        if (hasActiveExitPortal) {
            d.info("Found that the dragon has been killed in this world already.");
            this.u = true;
        } else {
            d.info("Found that the dragon has not yet been killed in this world.");
            this.u = false;
            if (this.m() == null) {
                this.a(false);
            }
        }
        List<? extends EntityEnderDragon> dragons = this.l.j();
        if (dragons.isEmpty()) {
            this.t = true;
        } else {
            EntityEnderDragon enderDragon = dragons.get(0);
            this.w = enderDragon.cG();
            d.info("Found that there's a dragon still alive ({})", (Object)enderDragon);
            this.t = false;
            if (!hasActiveExitPortal && this.l.paperConfig().entities.behavior.shouldRemoveDragon) {
                d.info("But we didn't have a portal, let's remove it.");
                enderDragon.discard(null);
                this.w = null;
            }
        }
        if (!this.u && this.t) {
            this.t = false;
        }
    }

    private void k() {
        List<? extends EntityEnderDragon> dragons = this.l.j();
        if (dragons.isEmpty()) {
            d.debug("Haven't seen the dragon, respawning it");
            this.r();
        } else {
            d.debug("Haven't seen our dragon, but found another one to use.");
            this.w = dragons.get(0).cG();
        }
    }

    public void a(EnumDragonRespawn state) {
        if (this.z == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.A = 0;
        if (state == EnumDragonRespawn.e) {
            this.z = null;
            this.t = false;
            EntityEnderDragon enderDragon = this.r();
            if (enderDragon != null) {
                for (EntityPlayer serverPlayer : this.k.h()) {
                    CriterionTriggers.o.a(serverPlayer, enderDragon);
                }
            }
        } else {
            this.z = state;
        }
    }

    private boolean l() {
        for (int i2 = -8; i2 <= 8; ++i2) {
            for (int i1 = -8; i1 <= 8; ++i1) {
                Chunk chunk = this.l.d(i2, i1);
                for (TileEntity blockEntity : chunk.I().values()) {
                    if (!(blockEntity instanceof TileEntityEnderPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public ShapeDetector.ShapeDetectorCollection m() {
        int i1;
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(this.m);
        for (int i2 = -8 + chunkPos.h; i2 <= 8 + chunkPos.h; ++i2) {
            for (i1 = -8 + chunkPos.i; i1 <= 8 + chunkPos.i; ++i1) {
                Chunk chunk = this.l.d(i2, i1);
                for (TileEntity blockEntity : chunk.I().values()) {
                    ShapeDetector.ShapeDetectorCollection blockPatternMatch;
                    if (!(blockEntity instanceof TileEntityEnderPortal) || (blockPatternMatch = this.o.a(this.l, blockEntity.ax_())) == null) continue;
                    BlockPosition pos = blockPatternMatch.a(3, 3, 3).d();
                    if (this.y == null) {
                        this.y = pos;
                    }
                    return blockPatternMatch;
                }
            }
        }
        BlockPosition location = WorldGenEndTrophy.a(this.m);
        for (int i2 = i1 = this.l.a(HeightMap.Type.e, location).v(); i2 >= this.l.K_(); --i2) {
            ShapeDetector.ShapeDetectorCollection blockPatternMatch1 = this.o.a(this.l, new BlockPosition(location.u(), i2, location.w()));
            if (blockPatternMatch1 == null) continue;
            if (this.y == null) {
                this.y = blockPatternMatch1.a(3, 3, 3).d();
            }
            return blockPatternMatch1;
        }
        return null;
    }

    private boolean n() {
        if (this.v) {
            return true;
        }
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(this.m);
        for (int i2 = -8 + chunkPos.h; i2 <= 8 + chunkPos.h; ++i2) {
            for (int i1 = 8 + chunkPos.i; i1 <= 8 + chunkPos.i; ++i1) {
                IChunkAccess chunk = this.l.a(i2, i1, ChunkStatus.n, false);
                if (!(chunk instanceof Chunk)) {
                    return false;
                }
                FullChunkStatus fullStatus = ((Chunk)chunk).F();
                if (fullStatus.a(FullChunkStatus.c)) continue;
                return false;
            }
        }
        return true;
    }

    private void o() {
        HashSet set = Sets.newHashSet();
        for (EntityPlayer serverPlayer : this.l.a(this.j)) {
            this.k.a(serverPlayer);
            set.add(serverPlayer);
        }
        HashSet set1 = Sets.newHashSet(this.k.h());
        set1.removeAll(set);
        for (EntityPlayer serverPlayer1 : set1) {
            this.k.b(serverPlayer1);
        }
    }

    private void p() {
        this.r = 0;
        this.q = 0;
        for (WorldGenEnder.Spike endSpike : WorldGenEnder.a(this.l)) {
            this.q += this.l.a(EntityEnderCrystal.class, endSpike.f()).size();
        }
        d.debug("Found {} end crystals still alive", (Object)this.q);
    }

    public void a(EntityEnderDragon dragon) {
        if (dragon.cG().equals(this.w)) {
            this.k.a(0.0f);
            this.k.d(false);
            this.a(true);
            this.q();
            BlockPosition eggPosition = this.l.a(HeightMap.Type.e, WorldGenEndTrophy.a(this.m));
            CraftBlockState eggState = CraftBlockStates.getBlockState(this.l, eggPosition);
            eggState.setData(Blocks.fZ.m());
            DragonEggFormEvent eggEvent = new DragonEggFormEvent((Block)CraftBlock.at(this.l, eggPosition), (BlockState)eggState, (DragonBattle)new CraftDragonBattle(this));
            if (!this.l.paperConfig().entities.behavior.enderDragonsDeathAlwaysPlacesDragonEgg && this.u) {
                eggEvent.setCancelled(true);
            }
            if (eggEvent.callEvent()) {
                ((CraftBlockState)eggEvent.getNewState()).place(3);
            }
            this.u = true;
            this.t = true;
        }
    }

    @Deprecated
    @VisibleForTesting
    public void d() {
        this.n.clear();
    }

    public boolean spawnNewGatewayIfPossible() {
        if (!this.n.isEmpty()) {
            this.q();
            return true;
        }
        return false;
    }

    public List<EntityEnderCrystal> getSpikeCrystals() {
        ArrayList<EntityEnderCrystal> endCrystals = new ArrayList<EntityEnderCrystal>();
        for (WorldGenEnder.Spike spike : WorldGenEnder.a(this.l)) {
            endCrystals.addAll(this.l.a(EntityEnderCrystal.class, spike.f()));
        }
        return endCrystals;
    }

    private void q() {
        if (!this.n.isEmpty()) {
            int i2 = (Integer)this.n.remove(this.n.size() - 1);
            int floor = MathHelper.a(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            int floor1 = MathHelper.a(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)i2)));
            this.a(new BlockPosition(floor, 75, floor1));
        }
    }

    public void a(BlockPosition pos) {
        this.l.c(3000, pos, 0);
        this.l.J_().a(Registries.aL).flatMap(registry -> registry.a(EndFeatures.d)).ifPresent(endGatewayFeature -> ((WorldGenFeatureConfigured)endGatewayFeature.a()).a(this.l, this.l.m().g(), RandomSource.a(), pos));
    }

    public void a(boolean active) {
        WorldGenEndTrophy endPodiumFeature = new WorldGenEndTrophy(active);
        if (this.y == null) {
            this.y = this.l.a(HeightMap.Type.f, WorldGenEndTrophy.a(this.m)).e();
            while (this.l.a_(this.y).a(Blocks.I) && this.y.v() > 63) {
                this.y = this.y.e();
            }
            this.y = this.y.h(Math.max(this.l.K_() + 1, this.y.v()));
        }
        if (this.y.v() <= this.l.K_()) {
            this.y = this.y.h(this.l.K_() + 1);
        }
        if (endPodiumFeature.a(WorldGenFeatureConfiguration.m, this.l, this.l.m().g(), RandomSource.a(), this.y)) {
            int i2 = MathHelper.e(4, 16);
            this.l.m().a.a(new ChunkCoordIntPair(this.y), i2);
        }
    }

    @Nullable
    private EntityEnderDragon r() {
        this.l.m(new BlockPosition(this.m.u(), 128 + this.m.v(), this.m.w()));
        EntityEnderDragon enderDragon = EntityTypes.Q.a(this.l, EntitySpawnReason.h);
        if (enderDragon != null) {
            enderDragon.a(this);
            enderDragon.c(this.m);
            enderDragon.gr().a(DragonControllerPhase.a);
            enderDragon.b(this.m.u(), 128 + this.m.v(), this.m.w(), this.l.A.i() * 360.0f, 0.0f);
            this.l.b(enderDragon);
            this.w = enderDragon.cG();
            this.h();
        }
        return enderDragon;
    }

    public void b(EntityEnderDragon dragon) {
        if (dragon.cG().equals(this.w)) {
            this.k.a(dragon.eG() / dragon.eU());
            this.p = 0;
            if (dragon.g_()) {
                this.k.a(dragon.P_());
            } else {
                this.k.a(DEFAULT_BOSS_EVENT_NAME);
            }
        }
    }

    public int e() {
        return this.q;
    }

    public void a(EntityEnderCrystal crystal, DamageSource dmgSrc) {
        if (this.z != null && this.B.contains(crystal)) {
            d.debug("Aborting respawn sequence");
            this.z = null;
            this.A = 0;
            this.h();
            this.a(true);
        } else {
            this.p();
            Entity entity = this.l.b(this.w);
            if (entity instanceof EntityEnderDragon) {
                EntityEnderDragon enderDragon = (EntityEnderDragon)entity;
                enderDragon.a(this.l, crystal, crystal.dv(), dmgSrc);
            }
        }
    }

    public boolean f() {
        return this.u;
    }

    public boolean tryRespawn() {
        return this.tryRespawn(null);
    }

    public boolean tryRespawn(@Nullable BlockPosition placedEndCrystalPos) {
        if (this.t && this.z == null) {
            BlockPosition blockPos = this.y;
            if (blockPos == null) {
                d.debug("Tried to respawn, but need to find the portal first.");
                ShapeDetector.ShapeDetectorCollection blockPatternMatch = this.m();
                if (blockPatternMatch == null) {
                    d.debug("Couldn't find a portal, so we made one.");
                    this.a(true);
                } else {
                    d.debug("Found the exit portal & saved its location for next time.");
                }
                blockPos = this.y;
            }
            if (placedEndCrystalPos != null) {
                int dy = placedEndCrystalPos.v() - blockPos.v();
                if (dy != 0 && dy != 1) {
                    return false;
                }
                int dx = placedEndCrystalPos.u() - blockPos.u();
                int dz = placedEndCrystalPos.w() - blockPos.w();
                if (!(dx >= -1 && dx <= 1 && dz >= -3 && dz <= 3 || dx >= -3 && dx <= 3 && dz >= -1 && dz <= 1)) {
                    return false;
                }
            }
            ArrayList list = Lists.newArrayList();
            BlockPosition blockPos1 = blockPos.b(1);
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                List<EntityEnderCrystal> entitiesOfClass = this.l.a(EntityEnderCrystal.class, new AxisAlignedBB(blockPos1.a(direction, 2)));
                if (entitiesOfClass.isEmpty()) {
                    return false;
                }
                list.addAll(entitiesOfClass);
            }
            d.debug("Found all crystals, respawning dragon.");
            return this.respawnDragon(list);
        }
        return false;
    }

    public boolean respawnDragon(List<EntityEnderCrystal> crystals) {
        if (this.t && this.z == null) {
            ShapeDetector.ShapeDetectorCollection blockPatternMatch = this.m();
            while (blockPatternMatch != null) {
                for (int i2 = 0; i2 < this.o.c(); ++i2) {
                    for (int i1 = 0; i1 < this.o.b(); ++i1) {
                        for (int i22 = 0; i22 < this.o.a(); ++i22) {
                            ShapeDetectorBlock block = blockPatternMatch.a(i2, i1, i22);
                            if (!block.a().a(Blocks.I) && !block.a().a(Blocks.fW)) continue;
                            this.l.b(block.d(), Blocks.fY.m());
                        }
                    }
                }
                blockPatternMatch = this.m();
            }
            this.z = EnumDragonRespawn.a;
            this.A = 0;
            this.a(false);
            this.B = crystals;
            return true;
        }
        return false;
    }

    public void h() {
        for (WorldGenEnder.Spike endSpike : WorldGenEnder.a(this.l)) {
            for (EntityEnderCrystal endCrystal : this.l.a(EntityEnderCrystal.class, endSpike.f())) {
                endCrystal.m(false);
                endCrystal.a((BlockPosition)null);
            }
        }
    }

    @Nullable
    public UUID i() {
        return this.w;
    }

    public static final class a
    extends Record {
        private final boolean c;
        private final boolean d;
        private final boolean e;
        private final boolean f;
        private final Optional<UUID> g;
        private final Optional<BlockPosition> h;
        private final Optional<List<Integer>> i;
        public static final Codec<a> a = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("NeedsStateScanning").orElse((Object)true).forGetter(a::a), (App)Codec.BOOL.fieldOf("DragonKilled").orElse((Object)false).forGetter(a::b), (App)Codec.BOOL.fieldOf("PreviouslyKilled").orElse((Object)false).forGetter(a::c), (App)Codec.BOOL.lenientOptionalFieldOf("IsRespawning", (Object)false).forGetter(a::d), (App)UUIDUtil.a.lenientOptionalFieldOf("Dragon").forGetter(a::e), (App)BlockPosition.a.lenientOptionalFieldOf("ExitPortalLocation").forGetter(a::f), (App)Codec.list((Codec)Codec.INT).lenientOptionalFieldOf("Gateways").forGetter(a::g)).apply((Applicative)instance, a::new));
        public static final a b = new a(true, false, false, false, Optional.empty(), Optional.empty(), Optional.empty());

        public a(boolean needsStateScanning, boolean dragonKilled, boolean previouslyKilled, boolean isRespawning, Optional<UUID> dragonUUID, Optional<BlockPosition> exitPortalLocation, Optional<List<Integer>> gateways) {
            this.c = needsStateScanning;
            this.d = dragonKilled;
            this.e = previouslyKilled;
            this.f = isRespawning;
            this.g = dragonUUID;
            this.h = exitPortalLocation;
            this.i = gateways;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "needsStateScanning;dragonKilled;previouslyKilled;isRespawning;dragonUUID;exitPortalLocation;gateways", "c", "d", "e", "f", "g", "h", "i"}, this, o2);
        }

        public boolean a() {
            return this.c;
        }

        public boolean b() {
            return this.d;
        }

        public boolean c() {
            return this.e;
        }

        public boolean d() {
            return this.f;
        }

        public Optional<UUID> e() {
            return this.g;
        }

        public Optional<BlockPosition> f() {
            return this.h;
        }

        public Optional<List<Integer>> g() {
            return this.i;
        }
    }
}

