/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.OverworldBiomeBuilder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import org.apache.commons.lang3.mutable.MutableDouble;

public interface Aquifer {
    public static Aquifer a(NoiseChunk chunk, ChunkCoordIntPair chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory positionalRandomFactory, int minY, int height, a globalFluidPicker) {
        return new c(chunk, chunkPos, noiseRouter, positionalRandomFactory, minY, height, globalFluidPicker);
    }

    public static Aquifer a(final a defaultFluid) {
        return new Aquifer(){

            @Override
            @Nullable
            public IBlockData a(DensityFunction.b context, double substance) {
                return substance > 0.0 ? null : defaultFluid.computeFluid(context.a(), context.b(), context.c()).a(context.b());
            }

            @Override
            public boolean a() {
                return false;
            }
        };
    }

    @Nullable
    public IBlockData a(DensityFunction.b var1, double var2);

    public boolean a();

    public static class c
    implements Aquifer {
        private static final int a = 10;
        private static final int b = 9;
        private static final int c = 10;
        private static final int d = 6;
        private static final int e = 3;
        private static final int f = 6;
        private static final int g = 16;
        private static final int h = 12;
        private static final int i = 16;
        private static final int j = 11;
        private static final double k = net.minecraft.world.level.levelgen.Aquifer$c.a(MathHelper.h(10), MathHelper.h(12));
        private final NoiseChunk l;
        private final DensityFunction m;
        private final DensityFunction n;
        private final DensityFunction o;
        private final DensityFunction p;
        private final PositionalRandomFactory q;
        private final b[] r;
        private final long[] s;
        private final a t;
        private final DensityFunction u;
        private final DensityFunction v;
        private boolean w;
        private final int x;
        private final int y;
        private final int z;
        private final int A;
        private final int B;
        private static final int[][] C = new int[][]{{0, 0}, {-2, -1}, {-1, -1}, {0, -1}, {1, -1}, {-3, 0}, {-2, 0}, {-1, 0}, {1, 0}, {-2, 1}, {-1, 1}, {0, 1}, {1, 1}};

        c(NoiseChunk noiseChunk, ChunkCoordIntPair chunkPos, NoiseRouter noiseRouter, PositionalRandomFactory positionalRandomFactory, int minY, int height, a globalFluidPicker) {
            this.l = noiseChunk;
            this.m = noiseRouter.a();
            this.n = noiseRouter.b();
            this.o = noiseRouter.c();
            this.p = noiseRouter.d();
            this.u = noiseRouter.h();
            this.v = noiseRouter.i();
            this.q = positionalRandomFactory;
            this.x = this.a(chunkPos.d()) - 1;
            this.t = globalFluidPicker;
            int i2 = this.a(chunkPos.f()) + 1;
            this.A = i2 - this.x + 1;
            this.y = this.b(minY) - 1;
            int i1 = this.b(minY + height) + 1;
            int i22 = i1 - this.y + 1;
            this.z = this.c(chunkPos.e()) - 1;
            int i3 = this.c(chunkPos.g()) + 1;
            this.B = i3 - this.z + 1;
            int i4 = this.A * i22 * this.B;
            this.r = new b[i4];
            this.s = new long[i4];
            Arrays.fill(this.s, Long.MAX_VALUE);
        }

        private int a(int gridX, int gridY, int gridZ) {
            int i2 = gridX - this.x;
            int i1 = gridY - this.y;
            int i22 = gridZ - this.z;
            return (i1 * this.B + i22) * this.A + i2;
        }

        @Override
        @Nullable
        public IBlockData a(DensityFunction.b context, double substance) {
            boolean flag2;
            double d4;
            double d3;
            int i2 = context.a();
            int i1 = context.b();
            int i22 = context.c();
            if (substance > 0.0) {
                this.w = false;
                return null;
            }
            b fluidStatus = this.t.computeFluid(i2, i1, i22);
            if (fluidStatus.a(i1).a(Blocks.K)) {
                this.w = false;
                return Blocks.K.m();
            }
            int i3 = Math.floorDiv(i2 - 5, 16);
            int i4 = Math.floorDiv(i1 + 1, 12);
            int i5 = Math.floorDiv(i22 - 5, 16);
            int i6 = Integer.MAX_VALUE;
            int i7 = Integer.MAX_VALUE;
            int i8 = Integer.MAX_VALUE;
            int i9 = Integer.MAX_VALUE;
            long l2 = 0L;
            long l1 = 0L;
            long l22 = 0L;
            long l3 = 0L;
            for (int i10 = 0; i10 <= 1; ++i10) {
                for (int i11 = -1; i11 <= 1; ++i11) {
                    for (int i12 = 0; i12 <= 1; ++i12) {
                        long l5;
                        int i13 = i3 + i10;
                        int i14 = i4 + i11;
                        int i15 = i5 + i12;
                        int index = this.a(i13, i14, i15);
                        long l4 = this.s[index];
                        if (l4 != Long.MAX_VALUE) {
                            l5 = l4;
                        } else {
                            RandomSource randomSource = this.q.a(i13, i14, i15);
                            this.s[index] = l5 = BlockPosition.a(i13 * 16 + randomSource.a(10), i14 * 12 + randomSource.a(9), i15 * 16 + randomSource.a(10));
                        }
                        int i16 = BlockPosition.a(l5) - i2;
                        int i17 = BlockPosition.b(l5) - i1;
                        int i18 = BlockPosition.c(l5) - i22;
                        int i19 = i16 * i16 + i17 * i17 + i18 * i18;
                        if (i6 >= i19) {
                            l3 = l22;
                            l22 = l1;
                            l1 = l2;
                            l2 = l5;
                            i9 = i8;
                            i8 = i7;
                            i7 = i6;
                            i6 = i19;
                            continue;
                        }
                        if (i7 >= i19) {
                            l3 = l22;
                            l22 = l1;
                            l1 = l5;
                            i9 = i8;
                            i8 = i7;
                            i7 = i19;
                            continue;
                        }
                        if (i8 >= i19) {
                            l3 = l22;
                            l22 = l5;
                            i9 = i8;
                            i8 = i19;
                            continue;
                        }
                        if (i9 < i19) continue;
                        l3 = l5;
                        i9 = i19;
                    }
                }
            }
            b aquiferStatus = this.a(l2);
            double d2 = net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i7);
            IBlockData blockState = aquiferStatus.a(i1);
            if (d2 <= 0.0) {
                b aquiferStatus1;
                this.w = d2 >= k ? !aquiferStatus.equals(aquiferStatus1 = this.a(l1)) : false;
                return blockState;
            }
            if (blockState.a(Blocks.J) && this.t.computeFluid(i2, i1 - 1, i22).a(i1 - 1).a(Blocks.K)) {
                this.w = true;
                return blockState;
            }
            MutableDouble mutableDouble = new MutableDouble(Double.NaN);
            b aquiferStatus2 = this.a(l1);
            double d1 = d2 * this.a(context, mutableDouble, aquiferStatus, aquiferStatus2);
            if (substance + d1 > 0.0) {
                this.w = false;
                return null;
            }
            b aquiferStatus3 = this.a(l22);
            double d22 = net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i8);
            if (d22 > 0.0 && substance + (d3 = d2 * d22 * this.a(context, mutableDouble, aquiferStatus, aquiferStatus3)) > 0.0) {
                this.w = false;
                return null;
            }
            double d32 = net.minecraft.world.level.levelgen.Aquifer$c.a(i7, i8);
            if (d32 > 0.0 && substance + (d4 = d2 * d32 * this.a(context, mutableDouble, aquiferStatus2, aquiferStatus3)) > 0.0) {
                this.w = false;
                return null;
            }
            boolean flag = !aquiferStatus.equals(aquiferStatus2);
            boolean flag1 = d32 >= k && !aquiferStatus2.equals(aquiferStatus3);
            boolean bl = flag2 = d22 >= k && !aquiferStatus.equals(aquiferStatus3);
            this.w = !flag && !flag1 && !flag2 ? d22 >= k && net.minecraft.world.level.levelgen.Aquifer$c.a(i6, i9) >= k && !aquiferStatus.equals(this.a(l3)) : true;
            return blockState;
        }

        @Override
        public boolean a() {
            return this.w;
        }

        private static double a(int firstDistance, int secondDistance) {
            double d2 = 25.0;
            return 1.0 - (double)Math.abs(secondDistance - firstDistance) / 25.0;
        }

        private double a(DensityFunction.b context, MutableDouble substance, b firstFluid, b secondFluid) {
            int i2 = context.b();
            IBlockData blockState = firstFluid.a(i2);
            IBlockData blockState1 = secondFluid.a(i2);
            if (!(blockState.a(Blocks.K) && blockState1.a(Blocks.J) || blockState.a(Blocks.J) && blockState1.a(Blocks.K))) {
                double d12;
                double d10;
                int abs = Math.abs(firstFluid.a - secondFluid.a);
                if (abs == 0) {
                    return 0.0;
                }
                double d2 = 0.5 * (double)(firstFluid.a + secondFluid.a);
                double d1 = (double)i2 + 0.5 - d2;
                double d22 = (double)abs / 2.0;
                double d3 = 0.0;
                double d4 = 2.5;
                double d5 = 1.5;
                double d6 = 3.0;
                double d7 = 10.0;
                double d8 = 3.0;
                double d9 = d22 - Math.abs(d1);
                double d11 = d1 > 0.0 ? ((d10 = 0.0 + d9) > 0.0 ? d10 / 1.5 : d10 / 2.5) : ((d10 = 3.0 + d9) > 0.0 ? d10 / 3.0 : d10 / 10.0);
                double d10x = 2.0;
                if (!(d11 < -2.0) && !(d11 > 2.0)) {
                    double value = substance.getValue();
                    if (Double.isNaN(value)) {
                        double d13 = this.m.a(context);
                        substance.setValue(d13);
                        d12 = d13;
                    } else {
                        d12 = value;
                    }
                } else {
                    d12 = 0.0;
                }
                return 2.0 * (d12 + d11);
            }
            return 2.0;
        }

        private int a(int x2) {
            return Math.floorDiv(x2, 16);
        }

        private int b(int y2) {
            return Math.floorDiv(y2, 12);
        }

        private int c(int z2) {
            return Math.floorDiv(z2, 16);
        }

        private b a(long packedPos) {
            b fluidStatus1;
            int i2;
            int i1;
            int x2 = BlockPosition.a(packedPos);
            int y2 = BlockPosition.b(packedPos);
            int z2 = BlockPosition.c(packedPos);
            int i3 = this.a(x2);
            int index = this.a(i3, i1 = this.b(y2), i2 = this.c(z2));
            b fluidStatus = this.r[index];
            if (fluidStatus != null) {
                return fluidStatus;
            }
            this.r[index] = fluidStatus1 = this.b(x2, y2, z2);
            return fluidStatus1;
        }

        private b b(int x2, int y2, int z2) {
            b fluidStatus = this.t.computeFluid(x2, y2, z2);
            int i2 = Integer.MAX_VALUE;
            int i1 = y2 + 12;
            int i22 = y2 - 12;
            boolean flag = false;
            for (int[] ints : C) {
                b fluidStatus1;
                boolean flag2;
                boolean flag1;
                int i3 = x2 + SectionPosition.c(ints[0]);
                int i4 = z2 + SectionPosition.c(ints[1]);
                int i5 = this.l.a(i3, i4);
                int i6 = i5 + 8;
                boolean bl = flag1 = ints[0] == 0 && ints[1] == 0;
                if (flag1 && i22 > i6) {
                    return fluidStatus;
                }
                boolean bl2 = flag2 = i1 > i6;
                if ((flag2 || flag1) && !(fluidStatus1 = this.t.computeFluid(i3, i6, i4)).a(i6).l()) {
                    if (flag1) {
                        flag = true;
                    }
                    if (flag2) {
                        return fluidStatus1;
                    }
                }
                i2 = Math.min(i2, i5);
            }
            int i7 = this.a(x2, y2, z2, fluidStatus, i2, flag);
            return new b(i7, this.a(x2, y2, z2, fluidStatus, i7));
        }

        private int a(int x2, int y2, int z2, b fluidStatus, int maxSurfaceLevel, boolean fluidPresent) {
            int i2;
            double d1;
            double d2;
            DensityFunction.e singlePointContext = new DensityFunction.e(x2, y2, z2);
            if (OverworldBiomeBuilder.a(this.u, this.v, singlePointContext)) {
                d2 = -1.0;
                d1 = -1.0;
            } else {
                i2 = maxSurfaceLevel + 8 - y2;
                int i1 = 64;
                double d22 = fluidPresent ? MathHelper.a((double)i2, 0.0, 64.0, 1.0, 0.0) : 0.0;
                double d3 = MathHelper.a(this.n.a(singlePointContext), -1.0, 1.0);
                double d4 = MathHelper.b(d22, 1.0, 0.0, -0.3, 0.8);
                double d5 = MathHelper.b(d22, 1.0, 0.0, -0.8, 0.4);
                d2 = d3 - d5;
                d1 = d3 - d4;
            }
            i2 = d1 > 0.0 ? fluidStatus.a : (d2 > 0.0 ? this.a(x2, y2, z2, maxSurfaceLevel) : -32512);
            return i2;
        }

        private int a(int x2, int y2, int z2, int maxSurfaceLevel) {
            int i2 = 16;
            int i1 = 40;
            int i22 = Math.floorDiv(x2, 16);
            int i3 = Math.floorDiv(y2, 40);
            int i4 = Math.floorDiv(z2, 16);
            int i5 = i3 * 40 + 20;
            int i6 = 10;
            double d2 = this.o.a(new DensityFunction.e(i22, i3, i4)) * 10.0;
            int i7 = MathHelper.a(d2, 3);
            int i8 = i5 + i7;
            return Math.min(maxSurfaceLevel, i8);
        }

        private IBlockData a(int x2, int y2, int z2, b fluidStatus, int surfaceLevel) {
            IBlockData blockState = fluidStatus.b;
            if (surfaceLevel <= -10 && surfaceLevel != -32512 && fluidStatus.b != Blocks.K.m()) {
                int i4;
                int i3;
                int i2 = 64;
                int i1 = 40;
                int i22 = Math.floorDiv(x2, 64);
                double d2 = this.p.a(new DensityFunction.e(i22, i3 = Math.floorDiv(y2, 40), i4 = Math.floorDiv(z2, 64)));
                if (Math.abs(d2) > 0.3) {
                    blockState = Blocks.K.m();
                }
            }
            return blockState;
        }
    }

    public static interface a {
        public b computeFluid(int var1, int var2, int var3);
    }

    public record b(int a, IBlockData b) {
        public IBlockData a(int y2) {
            return y2 < this.a ? this.b : Blocks.a.m();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "fluidLevel;fluidType", "a", "b"}, this, o2);
        }
    }
}

