/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import net.minecraft.SystemUtils;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.WorldGenFeaturePillagerOutpostPoolPiece;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;

public class Beardifier
implements DensityFunctions.c {
    public static final int a = 12;
    private static final int f = 24;
    private static final float[] g = SystemUtils.a(new float[13824], (? super T array) -> {
        for (int i2 = 0; i2 < 24; ++i2) {
            for (int i1 = 0; i1 < 24; ++i1) {
                for (int i22 = 0; i22 < 24; ++i22) {
                    array[i2 * 24 * 24 + i1 * 24 + i22] = (float)Beardifier.a(i1 - 12, i22 - 12, i2 - 12);
                }
            }
        }
    });
    private final ObjectListIterator<a> h;
    private final ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction> i;

    public static Beardifier a(StructureManager structureManager, ChunkCoordIntPair chunkPos) {
        int minBlockX = chunkPos.d();
        int minBlockZ = chunkPos.e();
        ObjectArrayList list = new ObjectArrayList(10);
        ObjectArrayList list1 = new ObjectArrayList(32);
        for (StructureStart structureStart : structureManager.a(chunkPos, (Structure structure) -> structure.d() != TerrainAdjustment.a)) {
            TerrainAdjustment terrainAdjustment = structureStart.h().d();
            for (StructurePiece structurePiece : structureStart.i()) {
                if (!structurePiece.a(chunkPos, 12)) continue;
                if (structurePiece instanceof WorldGenFeaturePillagerOutpostPoolPiece) {
                    WorldGenFeaturePillagerOutpostPoolPiece poolElementStructurePiece = (WorldGenFeaturePillagerOutpostPoolPiece)structurePiece;
                    WorldGenFeatureDefinedStructurePoolTemplate.Matching projection = poolElementStructurePiece.b().g();
                    if (projection == WorldGenFeatureDefinedStructurePoolTemplate.Matching.b) {
                        list.add((Object)new a(poolElementStructurePiece.f(), terrainAdjustment, poolElementStructurePiece.d()));
                    }
                    for (WorldGenFeatureDefinedStructureJigsawJunction jigsawJunction : poolElementStructurePiece.e()) {
                        int sourceX = jigsawJunction.a();
                        int sourceZ = jigsawJunction.c();
                        if (sourceX <= minBlockX - 12 || sourceZ <= minBlockZ - 12 || sourceX >= minBlockX + 15 + 12 || sourceZ >= minBlockZ + 15 + 12) continue;
                        list1.add((Object)jigsawJunction);
                    }
                    continue;
                }
                list.add((Object)new a(structurePiece.f(), terrainAdjustment, 0));
            }
        }
        return new Beardifier((ObjectListIterator<a>)list.iterator(), (ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction>)list1.iterator());
    }

    @VisibleForTesting
    public Beardifier(ObjectListIterator<a> pieceIterator, ObjectListIterator<WorldGenFeatureDefinedStructureJigsawJunction> junctionIterator) {
        this.h = pieceIterator;
        this.i = junctionIterator;
    }

    @Override
    public double a(DensityFunction.b context) {
        int max;
        int groundLevelDelta;
        int i2 = context.a();
        int i1 = context.b();
        int i22 = context.c();
        double d2 = 0.0;
        while (this.h.hasNext()) {
            a rigid = (a)this.h.next();
            StructureBoundingBox boundingBox = rigid.a();
            groundLevelDelta = rigid.c();
            max = Math.max(0, Math.max(boundingBox.h() - i2, i2 - boundingBox.k()));
            int max1 = Math.max(0, Math.max(boundingBox.j() - i22, i22 - boundingBox.m()));
            int i3 = boundingBox.i() + groundLevelDelta;
            int i4 = i1 - i3;
            int i5 = switch (rigid.b()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.a -> 0;
                case TerrainAdjustment.b, TerrainAdjustment.c -> i4;
                case TerrainAdjustment.d -> Math.max(0, Math.max(i3 - i1, i1 - boundingBox.l()));
                case TerrainAdjustment.e -> Math.max(0, Math.max(boundingBox.i() - i1, i1 - boundingBox.l()));
            };
            d2 += (switch (rigid.b()) {
                default -> throw new MatchException(null, null);
                case TerrainAdjustment.a -> 0.0;
                case TerrainAdjustment.b -> Beardifier.a((double)max, (double)i5 / 2.0, (double)max1);
                case TerrainAdjustment.c, TerrainAdjustment.d -> Beardifier.a(max, i5, max1, i4) * 0.8;
                case TerrainAdjustment.e -> Beardifier.a((double)max / 2.0, (double)i5 / 2.0, (double)max1 / 2.0) * 0.8;
            });
        }
        this.h.back(Integer.MAX_VALUE);
        while (this.i.hasNext()) {
            WorldGenFeatureDefinedStructureJigsawJunction jigsawJunction = (WorldGenFeatureDefinedStructureJigsawJunction)this.i.next();
            int i6 = i2 - jigsawJunction.a();
            groundLevelDelta = i1 - jigsawJunction.b();
            max = i22 - jigsawJunction.c();
            d2 += Beardifier.a(i6, groundLevelDelta, max, groundLevelDelta) * 0.4;
        }
        this.i.back(Integer.MAX_VALUE);
        return d2;
    }

    @Override
    public double a() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double b() {
        return Double.POSITIVE_INFINITY;
    }

    private static double a(double x2, double y2, double z2) {
        double len = MathHelper.g(x2, y2, z2);
        return MathHelper.a(len, 0.0, 6.0, 1.0, 0.0);
    }

    private static double a(int x2, int y2, int z2, int height) {
        int i2 = x2 + 12;
        int i1 = y2 + 12;
        int i22 = z2 + 12;
        if (Beardifier.a(i2) && Beardifier.a(i1) && Beardifier.a(i22)) {
            double d2 = (double)height + 0.5;
            double d1 = MathHelper.f((double)x2, d2, (double)z2);
            double d22 = -d2 * MathHelper.g(d1 / 2.0) / 2.0;
            return d22 * (double)g[i22 * 24 * 24 + i2 * 24 + i1];
        }
        return 0.0;
    }

    private static boolean a(int value) {
        return value >= 0 && value < 24;
    }

    private static double a(int x2, int y2, int z2) {
        return Beardifier.a(x2, (double)y2 + 0.5, z2);
    }

    private static double a(int x2, double y2, int z2) {
        double d2 = MathHelper.f((double)x2, y2, (double)z2);
        return Math.pow(Math.E, -d2 / 16.0);
    }

    @VisibleForTesting
    public record a(StructureBoundingBox a, TerrainAdjustment b, int c) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "box;terrainAdjustment;groundLevelDelta", "a", "b", "c"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "box;terrainAdjustment;groundLevelDelta", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "box;terrainAdjustment;groundLevelDelta", "a", "b", "c"}, this, o2);
        }
    }
}

