/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.QuartPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.SpawnerCreature;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSettingsGeneration;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseRouterData;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import org.apache.commons.lang3.mutable.MutableObject;

public final class ChunkGeneratorAbstract
extends ChunkGenerator {
    public static final MapCodec<ChunkGeneratorAbstract> c = RecordCodecBuilder.mapCodec(instance -> instance.group((App)WorldChunkManager.a.fieldOf("biome_source").forGetter(generator -> generator.b), (App)GeneratorSettingBase.b.fieldOf("settings").forGetter(generator -> generator.e)).apply((Applicative)instance, instance.stable(ChunkGeneratorAbstract::new)));
    private static final IBlockData d = Blocks.a.m();
    public final Holder<GeneratorSettingBase> e;
    private final Supplier<Aquifer.a> f;

    public ChunkGeneratorAbstract(WorldChunkManager biomeSource, Holder<GeneratorSettingBase> settings) {
        super(biomeSource);
        this.e = settings;
        this.f = Suppliers.memoize(() -> ChunkGeneratorAbstract.a((GeneratorSettingBase)settings.a()));
    }

    private static Aquifer.a a(GeneratorSettingBase settings) {
        Aquifer.b fluidStatus = new Aquifer.b(-54, Blocks.K.m());
        int seaLevel = settings.l();
        Aquifer.b fluidStatus1 = new Aquifer.b(seaLevel, settings.h());
        Aquifer.b fluidStatus2 = new Aquifer.b(-4064, Blocks.a.m());
        return (x2, y2, z2) -> y2 < Math.min(-54, seaLevel) ? fluidStatus : fluidStatus1;
    }

    @Override
    public CompletableFuture<IChunkAccess> a(RandomState randomState, Blender blender, StructureManager structureManager, IChunkAccess chunk) {
        return CompletableFuture.supplyAsync(() -> {
            this.b(blender, randomState, structureManager, chunk);
            return chunk;
        }, Runnable::run);
    }

    private void b(Blender blender, RandomState random, StructureManager structureManager, IChunkAccess chunk) {
        NoiseChunk noiseChunk = chunk.a((IChunkAccess chunkAccess) -> this.a((IChunkAccess)chunkAccess, structureManager, blender, random));
        BiomeResolver biomeResolver = BelowZeroRetrogen.a(blender.a(this.b), chunk);
        chunk.a(biomeResolver, noiseChunk.a(random.a(), this.e.a().k()));
    }

    private NoiseChunk a(IChunkAccess chunk, StructureManager structureManager, Blender blender, RandomState random) {
        return NoiseChunk.a(chunk, random, Beardifier.a(structureManager, chunk.f()), this.e.a(), this.f.get(), blender);
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    public Holder<GeneratorSettingBase> h() {
        return this.e;
    }

    public boolean a(ResourceKey<GeneratorSettingBase> settings) {
        return this.e.a(settings);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type type, LevelHeightAccessor level, RandomState random) {
        return this.a(level, random, x2, z2, null, type.e()).orElse(level.K_());
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor height, RandomState random) {
        MutableObject mutableObject = new MutableObject();
        this.a(height, random, x2, z2, (MutableObject<BlockColumn>)mutableObject, null);
        return (BlockColumn)mutableObject.getValue();
    }

    @Override
    public void a(List<String> info, RandomState random, BlockPosition pos) {
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        NoiseRouter noiseRouter = random.a();
        DensityFunction.e singlePointContext = new DensityFunction.e(pos.u(), pos.v(), pos.w());
        double d2 = noiseRouter.j().a(singlePointContext);
        info.add("NoiseRouter T: " + decimalFormat.format(noiseRouter.e().a(singlePointContext)) + " V: " + decimalFormat.format(noiseRouter.f().a(singlePointContext)) + " C: " + decimalFormat.format(noiseRouter.g().a(singlePointContext)) + " E: " + decimalFormat.format(noiseRouter.h().a(singlePointContext)) + " D: " + decimalFormat.format(noiseRouter.i().a(singlePointContext)) + " W: " + decimalFormat.format(d2) + " PV: " + decimalFormat.format(NoiseRouterData.a((float)d2)) + " AS: " + decimalFormat.format(noiseRouter.k().a(singlePointContext)) + " N: " + decimalFormat.format(noiseRouter.l().a(singlePointContext)));
    }

    private OptionalInt a(LevelHeightAccessor level, RandomState random, int x2, int z2, @Nullable MutableObject<BlockColumn> column, @Nullable Predicate<IBlockData> stoppingState) {
        IBlockData[] blockStates;
        NoiseSettings noiseSettings = this.e.a().f().a(level);
        int cellHeight = noiseSettings.a();
        int minY = noiseSettings.c();
        int i2 = MathHelper.a(minY, cellHeight);
        int i1 = MathHelper.a(noiseSettings.d(), cellHeight);
        if (i1 <= 0) {
            return OptionalInt.empty();
        }
        if (column == null) {
            blockStates = null;
        } else {
            blockStates = new IBlockData[noiseSettings.d()];
            column.setValue((Object)new BlockColumn(minY, blockStates));
        }
        int cellWidth = noiseSettings.b();
        int i22 = Math.floorDiv(x2, cellWidth);
        int i3 = Math.floorDiv(z2, cellWidth);
        int i4 = Math.floorMod(x2, cellWidth);
        int i5 = Math.floorMod(z2, cellWidth);
        int i6 = i22 * cellWidth;
        int i7 = i3 * cellWidth;
        double d2 = (double)i4 / (double)cellWidth;
        double d1 = (double)i5 / (double)cellWidth;
        NoiseChunk noiseChunk = new NoiseChunk(1, random, i6, i7, noiseSettings, DensityFunctions.b.a, this.e.a(), this.f.get(), Blender.a());
        noiseChunk.f();
        noiseChunk.b(0);
        for (int i8 = i1 - 1; i8 >= 0; --i8) {
            noiseChunk.b(i8, 0);
            for (int i9 = cellHeight - 1; i9 >= 0; --i9) {
                IBlockData blockState;
                int i10 = (i2 + i8) * cellHeight + i9;
                double d22 = (double)i9 / (double)cellHeight;
                noiseChunk.a(i10, d22);
                noiseChunk.b(x2, d2);
                noiseChunk.c(z2, d1);
                IBlockData interpolatedState = noiseChunk.e();
                IBlockData iBlockData = blockState = interpolatedState == null ? this.e.a().g() : interpolatedState;
                if (blockStates != null) {
                    int i11 = i8 * cellHeight + i9;
                    blockStates[i11] = blockState;
                }
                if (stoppingState == null || !stoppingState.test(blockState)) continue;
                noiseChunk.g();
                return OptionalInt.of(i10 + 1);
            }
        }
        noiseChunk.g();
        return OptionalInt.empty();
    }

    @Override
    public void a(RegionLimitedWorldAccess level, StructureManager structureManager, RandomState random, IChunkAccess chunk) {
        if (!SharedConstants.a(chunk.f())) {
            WorldGenerationContext worldGenerationContext = new WorldGenerationContext(this, level, level.getMinecraftWorld());
            this.a(chunk, worldGenerationContext, random, structureManager, level.H_(), level.J_().f(Registries.aG), Blender.a(level));
        }
    }

    @VisibleForTesting
    public void a(IChunkAccess chunk, WorldGenerationContext context, RandomState random, StructureManager structureManager, BiomeManager biomeManager, IRegistry<BiomeBase> biomes, Blender blender) {
        NoiseChunk noiseChunk = chunk.a((IChunkAccess chunkAccess) -> this.a((IChunkAccess)chunkAccess, structureManager, blender, random));
        GeneratorSettingBase noiseGeneratorSettings = this.e.a();
        random.c().a(random, biomeManager, biomes, noiseGeneratorSettings.n(), context, chunk, noiseChunk, noiseGeneratorSettings.j());
    }

    @Override
    public void a(RegionLimitedWorldAccess level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, IChunkAccess chunk) {
        BiomeManager biomeManager1 = biomeManager.a((int x2, int y2, int z2) -> this.b.getNoiseBiome(x2, y2, z2, random.b()));
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
        int i2 = 8;
        ChunkCoordIntPair pos = chunk.f();
        NoiseChunk noiseChunk = chunk.a((IChunkAccess chunkAccess) -> this.a((IChunkAccess)chunkAccess, structureManager, Blender.a(level), random));
        Aquifer aquifer = noiseChunk.i();
        CarvingContext carvingContext = new CarvingContext(this, level.J_(), chunk.B(), noiseChunk, random, this.e.a().j(), level.getMinecraftWorld());
        CarvingMask carvingMask = ((ProtoChunk)chunk).F();
        for (int i1 = -8; i1 <= 8; ++i1) {
            for (int i22 = -8; i22 <= 8; ++i22) {
                ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(pos.h + i1, pos.i + i22);
                IChunkAccess chunk1 = level.a(chunkPos.h, chunkPos.i);
                BiomeSettingsGeneration biomeGenerationSettings = chunk1.a(() -> this.a(this.b.getNoiseBiome(QuartPos.a(chunkPos.d()), 0, QuartPos.a(chunkPos.e()), random.b())));
                Iterable<Holder<WorldGenCarverWrapper<?>>> carvers = biomeGenerationSettings.a();
                int i3 = 0;
                for (Holder<WorldGenCarverWrapper<?>> holder : carvers) {
                    WorldGenCarverWrapper<?> configuredWorldCarver = holder.a();
                    worldgenRandom.c(seed + (long)i3, chunkPos.h, chunkPos.i);
                    if (configuredWorldCarver.a(worldgenRandom)) {
                        configuredWorldCarver.a(carvingContext, chunk, biomeManager1::a, worldgenRandom, aquifer, chunkPos, carvingMask);
                    }
                    ++i3;
                }
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomState, StructureManager structureManager, IChunkAccess chunk) {
        NoiseSettings noiseSettings = this.e.a().f().a(chunk.B());
        int minY = noiseSettings.c();
        int i2 = MathHelper.a(minY, noiseSettings.a());
        int i1 = MathHelper.a(noiseSettings.d(), noiseSettings.a());
        return i1 <= 0 ? CompletableFuture.completedFuture(chunk) : CompletableFuture.supplyAsync(() -> {
            IChunkAccess var20;
            int sectionIndex = chunk.f(i1 * noiseSettings.a() - 1 + minY);
            int sectionIndex1 = chunk.f(minY);
            HashSet set = Sets.newHashSet();
            for (int i22 = sectionIndex; i22 >= sectionIndex1; --i22) {
                ChunkSection section = chunk.b(i22);
                section.a();
                set.add(section);
            }
            try {
                var20 = this.a(blender, structureManager, randomState, chunk, i2, i1);
            }
            finally {
                for (ChunkSection levelChunkSection1 : set) {
                    levelChunkSection1.b();
                }
            }
            return var20;
        }, Runnable::run);
    }

    private IChunkAccess a(Blender blender, StructureManager structureManager, RandomState random, IChunkAccess chunk, int minCellY, int cellCountY) {
        NoiseChunk noiseChunk = chunk.a((IChunkAccess chunkAccess) -> this.a((IChunkAccess)chunkAccess, structureManager, blender, random));
        HeightMap heightmapUnprimed = chunk.a(HeightMap.Type.c);
        HeightMap heightmapUnprimed1 = chunk.a(HeightMap.Type.a);
        ChunkCoordIntPair pos = chunk.f();
        int minBlockX = pos.d();
        int minBlockZ = pos.e();
        Aquifer aquifer = noiseChunk.i();
        noiseChunk.f();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        int cellWidth = noiseChunk.j();
        int cellHeight = noiseChunk.k();
        int i2 = 16 / cellWidth;
        int i1 = 16 / cellWidth;
        for (int i22 = 0; i22 < i2; ++i22) {
            noiseChunk.b(i22);
            for (int i3 = 0; i3 < i1; ++i3) {
                int i4 = chunk.ap() - 1;
                ChunkSection section = chunk.b(i4);
                for (int i5 = cellCountY - 1; i5 >= 0; --i5) {
                    noiseChunk.b(i5, i3);
                    for (int i6 = cellHeight - 1; i6 >= 0; --i6) {
                        int i7 = (minCellY + i5) * cellHeight + i6;
                        int i8 = i7 & 0xF;
                        int sectionIndex = chunk.f(i7);
                        if (i4 != sectionIndex) {
                            i4 = sectionIndex;
                            section = chunk.b(sectionIndex);
                        }
                        double d2 = (double)i6 / (double)cellHeight;
                        noiseChunk.a(i7, d2);
                        for (int i9 = 0; i9 < cellWidth; ++i9) {
                            int i10 = minBlockX + i22 * cellWidth + i9;
                            int i11 = i10 & 0xF;
                            double d1 = (double)i9 / (double)cellWidth;
                            noiseChunk.b(i10, d1);
                            for (int i12 = 0; i12 < cellWidth; ++i12) {
                                int i13 = minBlockZ + i3 * cellWidth + i12;
                                int i14 = i13 & 0xF;
                                double d22 = (double)i12 / (double)cellWidth;
                                noiseChunk.c(i13, d22);
                                IBlockData interpolatedState = noiseChunk.e();
                                if (interpolatedState == null) {
                                    interpolatedState = this.e.a().g();
                                }
                                if ((interpolatedState = this.a(noiseChunk, i10, i7, i13, interpolatedState)) == d || SharedConstants.a(chunk.f())) continue;
                                section.a(i11, i8, i14, interpolatedState, false);
                                heightmapUnprimed.a(i11, i7, i14, interpolatedState);
                                heightmapUnprimed1.a(i11, i7, i14, interpolatedState);
                                if (!aquifer.a() || interpolatedState.y().c()) continue;
                                mutableBlockPos.d(i10, i7, i13);
                                chunk.e(mutableBlockPos);
                            }
                        }
                    }
                }
            }
            noiseChunk.h();
        }
        noiseChunk.g();
        return chunk;
    }

    private IBlockData a(NoiseChunk chunk, int x2, int y2, int z2, IBlockData state) {
        return state;
    }

    @Override
    public int e() {
        return this.e.a().f().d();
    }

    @Override
    public int f() {
        return this.e.a().l();
    }

    @Override
    public int g() {
        return this.e.a().f().c();
    }

    @Override
    public void a(RegionLimitedWorldAccess level) {
        if (!this.e.a().a()) {
            ChunkCoordIntPair center = level.b();
            Holder<BiomeBase> biome = level.u(center.l().h(level.ao()));
            SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(RandomSupport.a()));
            worldgenRandom.a(level.E(), center.d(), center.e());
            SpawnerCreature.a(level, biome, center, worldgenRandom);
        }
    }
}

