/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.BlockColumn;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.WorldChunkManagerHell;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class ChunkProviderDebug
extends ChunkGenerator {
    public static final MapCodec<ChunkProviderDebug> c = RecordCodecBuilder.mapCodec(instance -> instance.group(RegistryOps.d(Biomes.b)).apply((Applicative)instance, instance.stable(ChunkProviderDebug::new)));
    private static final int h = 2;
    private static final List<IBlockData> i = StreamSupport.stream(BuiltInRegistries.e.spliterator(), false).flatMap(block -> block.l().a().stream()).collect(Collectors.toList());
    private static final int j = MathHelper.f(MathHelper.c((float)i.size()));
    private static final int k = MathHelper.f((float)i.size() / (float)j);
    protected static final IBlockData d = Blocks.a.m();
    protected static final IBlockData e = Blocks.iy.m();
    public static final int f = 70;
    public static final int g = 60;

    public ChunkProviderDebug(Holder.c<BiomeBase> biomeSource) {
        super(new WorldChunkManagerHell(biomeSource));
    }

    @Override
    protected MapCodec<? extends ChunkGenerator> b() {
        return c;
    }

    @Override
    public void a(RegionLimitedWorldAccess level, StructureManager structureManager, RandomState random, IChunkAccess chunk) {
    }

    @Override
    public void a(GeneratorAccessSeed level, IChunkAccess chunk, StructureManager structureManager) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        ChunkCoordIntPair pos = chunk.f();
        int i2 = pos.h;
        int i1 = pos.i;
        for (int i22 = 0; i22 < 16; ++i22) {
            for (int i3 = 0; i3 < 16; ++i3) {
                int blockPosCoord = SectionPosition.a(i2, i22);
                int blockPosCoord1 = SectionPosition.a(i1, i3);
                level.a((BlockPosition)mutableBlockPos.d(blockPosCoord, 60, blockPosCoord1), e, 2);
                IBlockData blockStateFor = ChunkProviderDebug.a(blockPosCoord, blockPosCoord1);
                level.a((BlockPosition)mutableBlockPos.d(blockPosCoord, 70, blockPosCoord1), blockStateFor, 2);
            }
        }
    }

    @Override
    public CompletableFuture<IChunkAccess> a(Blender blender, RandomState randomState, StructureManager structureManager, IChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    @Override
    public int a(int x2, int z2, HeightMap.Type type, LevelHeightAccessor level, RandomState random) {
        return 0;
    }

    @Override
    public BlockColumn a(int x2, int z2, LevelHeightAccessor height, RandomState random) {
        return new BlockColumn(0, new IBlockData[0]);
    }

    @Override
    public void a(List<String> info, RandomState random, BlockPosition pos) {
    }

    public static IBlockData a(int chunkX, int chunkZ) {
        int abs;
        IBlockData blockState = d;
        if (chunkX > 0 && chunkZ > 0 && chunkX % 2 != 0 && chunkZ % 2 != 0 && (chunkX /= 2) <= j && (chunkZ /= 2) <= k && (abs = MathHelper.a(chunkX * j + chunkZ)) < i.size()) {
            blockState = i.get(abs);
        }
        return blockState;
    }

    @Override
    public void a(RegionLimitedWorldAccess level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, IChunkAccess chunk) {
    }

    @Override
    public void a(RegionLimitedWorldAccess level) {
    }

    @Override
    public int g() {
        return 0;
    }

    @Override
    public int e() {
        return 384;
    }

    @Override
    public int f() {
        return 63;
    }
}

