/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.DataBits;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.block.BlockLeaves;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.IChunkAccess;
import org.slf4j.Logger;

public class HeightMap {
    private static final Logger a = LogUtils.getLogger();
    static final Predicate<IBlockData> b = state -> !state.l();
    static final Predicate<IBlockData> c = BlockBase.BlockData::d;
    private final DataBits d;
    private final Predicate<IBlockData> e;
    private final IChunkAccess f;

    public HeightMap(IChunkAccess chunk, Type type) {
        this.e = type.e();
        this.f = chunk;
        int i2 = MathHelper.e(chunk.L_() + 1);
        this.d = new SimpleBitStorage(i2, 256);
    }

    public static void a(IChunkAccess chunk, Set<Type> types) {
        if (!types.isEmpty()) {
            int size = types.size();
            ObjectArrayList list = new ObjectArrayList(size);
            ObjectListIterator objectListIterator = list.iterator();
            int i2 = chunk.b() + 16;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i1 = 0; i1 < 16; ++i1) {
                block1: for (int i22 = 0; i22 < 16; ++i22) {
                    for (Type types1 : types) {
                        list.add((Object)chunk.a(types1));
                    }
                    for (int i3 = i2 - 1; i3 >= chunk.K_(); --i3) {
                        mutableBlockPos.d(i1, i3, i22);
                        IBlockData blockState = chunk.a_(mutableBlockPos);
                        if (blockState.a(Blocks.a)) continue;
                        while (objectListIterator.hasNext()) {
                            HeightMap heightmap = (HeightMap)objectListIterator.next();
                            if (!heightmap.e.test(blockState)) continue;
                            heightmap.a(i1, i22, i3 + 1);
                            objectListIterator.remove();
                        }
                        if (list.isEmpty()) continue block1;
                        objectListIterator.back(size);
                    }
                }
            }
        }
    }

    public boolean a(int x2, int y2, int z2, IBlockData state) {
        int firstAvailable = this.a(x2, z2);
        if (y2 <= firstAvailable - 2) {
            return false;
        }
        if (this.e.test(state)) {
            if (y2 >= firstAvailable) {
                this.a(x2, z2, y2 + 1);
                return true;
            }
        } else if (firstAvailable - 1 == y2) {
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i2 = y2 - 1; i2 >= this.f.K_(); --i2) {
                mutableBlockPos.d(x2, i2, z2);
                if (!this.e.test(this.f.a_(mutableBlockPos))) continue;
                this.a(x2, z2, i2 + 1);
                return true;
            }
            this.a(x2, z2, this.f.K_());
            return true;
        }
        return false;
    }

    public int a(int x2, int z2) {
        return this.a(HeightMap.c(x2, z2));
    }

    public int b(int x2, int z2) {
        return this.a(HeightMap.c(x2, z2)) - 1;
    }

    private int a(int index) {
        return this.d.a(index) + this.f.K_();
    }

    private void a(int x2, int z2, int value) {
        this.d.b(HeightMap.c(x2, z2), value - this.f.K_());
    }

    public void a(IChunkAccess chunk, Type type, long[] data) {
        long[] raw = this.d.a();
        if (raw.length == data.length) {
            System.arraycopy(data, 0, raw, 0, data.length);
        } else {
            a.warn("Ignoring heightmap data for chunk " + String.valueOf(chunk.f()) + ", size does not match; expected: " + raw.length + ", got: " + data.length);
            HeightMap.a(chunk, EnumSet.of(type));
        }
    }

    public long[] a() {
        return this.d.a();
    }

    private static int c(int x2, int z2) {
        return x2 + z2 * 16;
    }

    public static final class Type
    extends Enum<Type>
    implements INamable {
        public static final /* enum */ Type a = new Type(0, "WORLD_SURFACE_WG", Use.a, b);
        public static final /* enum */ Type b = new Type(1, "WORLD_SURFACE", Use.c, b);
        public static final /* enum */ Type c = new Type(2, "OCEAN_FLOOR_WG", Use.a, c);
        public static final /* enum */ Type d = new Type(3, "OCEAN_FLOOR", Use.b, c);
        public static final /* enum */ Type e = new Type(4, "MOTION_BLOCKING", Use.c, state -> state.d() || !state.y().c());
        public static final /* enum */ Type f = new Type(5, "MOTION_BLOCKING_NO_LEAVES", Use.c, state -> (state.d() || !state.y().c()) && !(state.b() instanceof BlockLeaves));
        public static final Codec<Type> g;
        private static final IntFunction<Type> i;
        public static final StreamCodec<ByteBuf, Type> h;
        private final int j;
        private final String k;
        private final Use l;
        private final Predicate<IBlockData> m;
        private static final /* synthetic */ Type[] n;

        public static Type[] values() {
            return (Type[])n.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(int id, String serializationKey, Use usage, Predicate<IBlockData> isOpaque) {
            this.j = id;
            this.k = serializationKey;
            this.l = usage;
            this.m = isOpaque;
        }

        public String a() {
            return this.k;
        }

        public boolean b() {
            return this.l == Use.c;
        }

        public boolean d() {
            return this.l != Use.a;
        }

        public Predicate<IBlockData> e() {
            return this.m;
        }

        @Override
        public String c() {
            return this.k;
        }

        private static /* synthetic */ Type[] f() {
            return new Type[]{a, b, c, d, e, f};
        }

        static {
            n = Type.f();
            g = INamable.a(Type::values);
            i = ByIdMap.a(types -> types.j, Type.values(), ByIdMap.a.a);
            h = ByteBufCodecs.a(i, (T types) -> types.j);
        }
    }

    public static final class Use
    extends Enum<Use> {
        public static final /* enum */ Use a = new Use();
        public static final /* enum */ Use b = new Use();
        public static final /* enum */ Use c = new Use();
        private static final /* synthetic */ Use[] d;

        public static Use[] values() {
            return (Use[])d.clone();
        }

        public static Use valueOf(String name) {
            return Enum.valueOf(Use.class, name);
        }

        private static /* synthetic */ Use[] a() {
            return new Use[]{a, b, c};
        }

        static {
            d = Use.a();
        }
    }
}

