/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.Noises;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;

public final class RandomState {
    final PositionalRandomFactory a;
    private final HolderGetter<NoiseGeneratorNormal.a> b;
    private final NoiseRouter c;
    private final Climate.Sampler d;
    private final SurfaceSystem e;
    private final PositionalRandomFactory f;
    private final PositionalRandomFactory g;
    private final Map<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal> h;
    private final Map<MinecraftKey, PositionalRandomFactory> i;

    public static RandomState a(HolderGetter.a registries, ResourceKey<GeneratorSettingBase> settingsKey, long levelSeed) {
        return RandomState.a(registries.b(Registries.aX).b(settingsKey).a(), registries.b(Registries.aY), levelSeed);
    }

    public static RandomState a(GeneratorSettingBase settings, HolderGetter<NoiseGeneratorNormal.a> noiseParametersGetter, long levelSeed) {
        return new RandomState(settings, noiseParametersGetter, levelSeed);
    }

    private RandomState(GeneratorSettingBase settings, HolderGetter<NoiseGeneratorNormal.a> noiseParametersGetter, final long levelSeed) {
        this.a = settings.d().a(levelSeed).e();
        this.b = noiseParametersGetter;
        this.f = this.a.a(MinecraftKey.b("aquifer")).e();
        this.g = this.a.a(MinecraftKey.b("ore")).e();
        this.h = new ConcurrentHashMap<ResourceKey<NoiseGeneratorNormal.a>, NoiseGeneratorNormal>();
        this.i = new ConcurrentHashMap<MinecraftKey, PositionalRandomFactory>();
        this.e = new SurfaceSystem(this, settings.g(), settings.l(), this.a);
        final boolean useLegacyRandomSource = settings.n();
        class A
        implements DensityFunction.f {
            private final Map<DensityFunction, DensityFunction> d = new HashMap<DensityFunction, DensityFunction>();

            A() {
            }

            private RandomSource a(long seed) {
                return new LegacyRandomSource(levelSeed + seed);
            }

            @Override
            public DensityFunction.c a(DensityFunction.c noiseHolder) {
                Holder<NoiseGeneratorNormal.a> holder = noiseHolder.b();
                if (useLegacyRandomSource) {
                    if (holder.a(Noises.a)) {
                        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.a(this.a(0L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(holder, normalNoise);
                    }
                    if (holder.a(Noises.b)) {
                        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.a(this.a(1L), new NoiseGeneratorNormal.a(-7, 1.0, 1.0));
                        return new DensityFunction.c(holder, normalNoise);
                    }
                    if (holder.a(Noises.j)) {
                        NoiseGeneratorNormal normalNoise = NoiseGeneratorNormal.b(RandomState.this.a.a(Noises.j.a()), new NoiseGeneratorNormal.a(0, 0.0, new double[0]));
                        return new DensityFunction.c(holder, normalNoise);
                    }
                }
                NoiseGeneratorNormal normalNoise = RandomState.this.a(holder.e().orElseThrow());
                return new DensityFunction.c(holder, normalNoise);
            }

            private DensityFunction a(DensityFunction densityFunction) {
                if (densityFunction instanceof BlendedNoise) {
                    BlendedNoise blendedNoise = (BlendedNoise)densityFunction;
                    RandomSource randomSource = useLegacyRandomSource ? this.a(0L) : RandomState.this.a.a(MinecraftKey.b("terrain"));
                    return blendedNoise.a(randomSource);
                }
                return densityFunction instanceof DensityFunctions.i ? new DensityFunctions.i(levelSeed) : densityFunction;
            }

            @Override
            public DensityFunction apply(DensityFunction densityFunction) {
                return this.d.computeIfAbsent(densityFunction, this::a);
            }
        }
        this.c = settings.i().a(new A());
        DensityFunction.f visitor = new DensityFunction.f(this){
            private final Map<DensityFunction, DensityFunction> a = new HashMap<DensityFunction, DensityFunction>();

            private DensityFunction a(DensityFunction densityFunction) {
                DensityFunction densityFunction2;
                if (densityFunction instanceof DensityFunctions.j) {
                    DensityFunctions.j holderHolder = (DensityFunctions.j)densityFunction;
                    return holderHolder.j().a();
                }
                if (densityFunction instanceof DensityFunctions.l) {
                    DensityFunctions.l marker = (DensityFunctions.l)densityFunction;
                    densityFunction2 = marker.k();
                } else {
                    densityFunction2 = densityFunction;
                }
                return densityFunction2;
            }

            @Override
            public DensityFunction apply(DensityFunction densityFunction) {
                return this.a.computeIfAbsent(densityFunction, this::a);
            }
        };
        this.d = new Climate.Sampler(this.c.e().a(visitor), this.c.f().a(visitor), this.c.g().a(visitor), this.c.h().a(visitor), this.c.i().a(visitor), this.c.j().a(visitor), settings.k());
    }

    public NoiseGeneratorNormal a(ResourceKey<NoiseGeneratorNormal.a> resourceKey) {
        return this.h.computeIfAbsent(resourceKey, resourceKey1 -> Noises.a(this.b, this.a, resourceKey));
    }

    public PositionalRandomFactory a(MinecraftKey location) {
        return this.i.computeIfAbsent(location, resourceLocation -> this.a.a(location).e());
    }

    public NoiseRouter a() {
        return this.c;
    }

    public Climate.Sampler b() {
        return this.d;
    }

    public SurfaceSystem c() {
        return this.e;
    }

    public PositionalRandomFactory d() {
        return this.f;
    }

    public PositionalRandomFactory e() {
        return this.g;
    }
}

