/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.RegistryMaterials;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.WorldChunkManager;
import net.minecraft.world.level.biome.WorldChunkManagerMultiNoise;
import net.minecraft.world.level.biome.WorldChunkManagerTheEnd;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.ChunkGeneratorAbstract;
import net.minecraft.world.level.levelgen.ChunkProviderDebug;
import net.minecraft.world.level.levelgen.ChunkProviderFlat;
import net.minecraft.world.level.levelgen.GeneratorSettingBase;
import net.minecraft.world.level.storage.WorldDataServer;

public record WorldDimensions(Map<ResourceKey<WorldDimension>, WorldDimension> b) {
    private final Map<ResourceKey<WorldDimension>, WorldDimension> b;
    public static final MapCodec<WorldDimensions> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.unboundedMap(ResourceKey.a(Registries.bq), WorldDimension.a).fieldOf("dimensions").forGetter(WorldDimensions::d)).apply((Applicative)instance, instance.stable(WorldDimensions::new)));
    private static final Set<ResourceKey<WorldDimension>> c = ImmutableSet.of(WorldDimension.b, WorldDimension.c, WorldDimension.d);
    private static final int d = c.size();

    public WorldDimensions {
        WorldDimension levelStem = dimensions.get(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldDimensions(IRegistry<WorldDimension> stemRegistry) {
        this(stemRegistry.c().collect(Collectors.toMap(Holder.c::h, Holder.c::a)));
    }

    public static Stream<ResourceKey<WorldDimension>> a(Stream<ResourceKey<WorldDimension>> stemKeys) {
        return Stream.concat(c.stream(), stemKeys.filter(resourceKey -> !c.contains(resourceKey)));
    }

    public WorldDimensions a(HolderLookup.a registries, ChunkGenerator chunkGenerator) {
        HolderLookup.b<DimensionManager> holderLookup = registries.e(Registries.aP);
        Map<ResourceKey<WorldDimension>, WorldDimension> map = WorldDimensions.a(holderLookup, this.b, chunkGenerator);
        return new WorldDimensions(map);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> a(HolderLookup<DimensionManager> dimensionTypeRegistry, Map<ResourceKey<WorldDimension>, WorldDimension> dimensions, ChunkGenerator chunkGenerator) {
        WorldDimension levelStem = dimensions.get(WorldDimension.b);
        Holder<DimensionManager> holder = levelStem == null ? dimensionTypeRegistry.b(BuiltinDimensionTypes.a) : levelStem.a();
        return WorldDimensions.a(dimensions, holder, chunkGenerator);
    }

    public static Map<ResourceKey<WorldDimension>, WorldDimension> a(Map<ResourceKey<WorldDimension>, WorldDimension> stemMap, Holder<DimensionManager> dimensionType, ChunkGenerator chunkGenerator) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.putAll(stemMap);
        builder.put(WorldDimension.b, (Object)new WorldDimension(dimensionType, chunkGenerator));
        return builder.buildKeepingLast();
    }

    public ChunkGenerator a() {
        WorldDimension levelStem = this.b.get(WorldDimension.b);
        if (levelStem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelStem.b();
    }

    public Optional<WorldDimension> a(ResourceKey<WorldDimension> stemKey) {
        return Optional.ofNullable(this.b.get(stemKey));
    }

    public ImmutableSet<ResourceKey<World>> b() {
        return (ImmutableSet)this.d().keySet().stream().map(Registries::a).collect(ImmutableSet.toImmutableSet());
    }

    public boolean c() {
        return this.a() instanceof ChunkProviderDebug;
    }

    private static WorldDataServer.a b(IRegistry<WorldDimension> stemRegistry) {
        return stemRegistry.f(WorldDimension.b).map(levelStem -> {
            ChunkGenerator chunkGenerator = levelStem.b();
            if (chunkGenerator instanceof ChunkProviderDebug) {
                return WorldDataServer.a.c;
            }
            return chunkGenerator instanceof ChunkProviderFlat ? WorldDataServer.a.b : WorldDataServer.a.a;
        }).orElse(WorldDataServer.a.a);
    }

    static Lifecycle a(ResourceKey<WorldDimension> key, WorldDimension stem) {
        return WorldDimensions.b(key, stem) ? Lifecycle.stable() : Lifecycle.experimental();
    }

    private static boolean b(ResourceKey<WorldDimension> key, WorldDimension stem) {
        if (key == WorldDimension.b) {
            return WorldDimensions.a(stem);
        }
        return key == WorldDimension.c ? WorldDimensions.b(stem) : key == WorldDimension.d && WorldDimensions.c(stem);
    }

    private static boolean a(WorldDimension levelStem) {
        WorldChunkManagerMultiNoise multiNoiseBiomeSource;
        WorldChunkManager worldChunkManager;
        Holder<DimensionManager> holder = levelStem.a();
        return !(!holder.a(BuiltinDimensionTypes.a) && !holder.a(BuiltinDimensionTypes.d) || (worldChunkManager = levelStem.b().d()) instanceof WorldChunkManagerMultiNoise && !(multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)worldChunkManager).a(MultiNoiseBiomeSourceParameterLists.b));
    }

    private static boolean b(WorldDimension levelStem) {
        WorldChunkManagerMultiNoise multiNoiseBiomeSource;
        ChunkGeneratorAbstract noiseBasedChunkGenerator;
        Object object;
        return levelStem.a().a(BuiltinDimensionTypes.b) && (object = levelStem.b()) instanceof ChunkGeneratorAbstract && (noiseBasedChunkGenerator = (ChunkGeneratorAbstract)object).a(GeneratorSettingBase.f) && (object = noiseBasedChunkGenerator.d()) instanceof WorldChunkManagerMultiNoise && (multiNoiseBiomeSource = (WorldChunkManagerMultiNoise)object).a(MultiNoiseBiomeSourceParameterLists.a);
    }

    private static boolean c(WorldDimension levelStem) {
        ChunkGeneratorAbstract noiseBasedChunkGenerator;
        ChunkGenerator chunkGenerator;
        return levelStem.a().a(BuiltinDimensionTypes.c) && (chunkGenerator = levelStem.b()) instanceof ChunkGeneratorAbstract && (noiseBasedChunkGenerator = (ChunkGeneratorAbstract)chunkGenerator).a(GeneratorSettingBase.g) && noiseBasedChunkGenerator.d() instanceof WorldChunkManagerTheEnd;
    }

    public b a(IRegistry<WorldDimension> stemRegistry) {
        record A(ResourceKey<WorldDimension> a, WorldDimension b) {
            RegistrationInfo c() {
                return new RegistrationInfo(Optional.empty(), WorldDimensions.a(this.a, this.b));
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{A.class, "key;value", "a", "b"}, this);
            }

            @Override
            public final boolean equals(Object o2) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{A.class, "key;value", "a", "b"}, this, o2);
            }
        }
        Stream<ResourceKey<WorldDimension>> stream = Stream.concat(stemRegistry.j().stream(), this.b.keySet().stream()).distinct();
        ArrayList list = new ArrayList();
        WorldDimensions.a(stream).forEach(resourceKey -> stemRegistry.f((ResourceKey<WorldDimension>)resourceKey).or(() -> Optional.ofNullable(this.b.get(resourceKey))).ifPresent(levelStem -> list.add(new A((ResourceKey<WorldDimension>)resourceKey, (WorldDimension)levelStem))));
        Lifecycle lifecycle = list.size() == d ? Lifecycle.stable() : Lifecycle.experimental();
        RegistryMaterials<WorldDimension> writableRegistry = new RegistryMaterials<WorldDimension>(Registries.bq, lifecycle);
        list.forEach(entry -> writableRegistry.a(entry.a, entry.b, entry.c()));
        IRegistry<WorldDimension> frozen = writableRegistry.n();
        WorldDataServer.a specialWorldProperty = WorldDimensions.b(frozen);
        return new b(frozen.n(), specialWorldProperty);
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this);
    }

    @Override
    public final boolean equals(Object o2) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{WorldDimensions.class, "dimensions", "b"}, this, o2);
    }

    public Map<ResourceKey<WorldDimension>, WorldDimension> d() {
        return this.b;
    }

    public record b(IRegistry<WorldDimension> a, WorldDataServer.a b) {
        private final IRegistry<WorldDimension> a;
        private final WorldDataServer.a b;

        public Lifecycle a() {
            return this.a.h();
        }

        public IRegistryCustom.Dimension b() {
            return new IRegistryCustom.c(List.of(this.a)).e();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "dimensions;specialWorldProperty", "a", "b"}, this, o2);
        }

        public IRegistry<WorldDimension> c() {
            return this.a;
        }

        public WorldDataServer.a d() {
            return this.b;
        }
    }
}

