/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.serialization.Codec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.MarsagliaPolarGaussian;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.Xoroshiro128PlusPlus;

public class XoroshiroRandomSource
implements RandomSource {
    private static final float c = 5.9604645E-8f;
    private static final double d = (double)1.110223E-16f;
    public static final Codec<XoroshiroRandomSource> b = Xoroshiro128PlusPlus.a.xmap(xoroshiro128PlusPlus -> new XoroshiroRandomSource((Xoroshiro128PlusPlus)xoroshiro128PlusPlus), xoroshiroRandomSource -> xoroshiroRandomSource.e);
    private Xoroshiro128PlusPlus e;
    private final MarsagliaPolarGaussian f = new MarsagliaPolarGaussian(this);

    public XoroshiroRandomSource(long seed) {
        this.e = new Xoroshiro128PlusPlus(RandomSupport.c(seed));
    }

    public XoroshiroRandomSource(RandomSupport.a seed) {
        this.e = new Xoroshiro128PlusPlus(seed);
    }

    public XoroshiroRandomSource(long seedLo, long seedHi) {
        this.e = new Xoroshiro128PlusPlus(seedLo, seedHi);
    }

    private XoroshiroRandomSource(Xoroshiro128PlusPlus randomNumberGenerator) {
        this.e = randomNumberGenerator;
    }

    @Override
    public RandomSource d() {
        return new XoroshiroRandomSource(this.e.a(), this.e.a());
    }

    @Override
    public PositionalRandomFactory e() {
        return new a(this.e.a(), this.e.a());
    }

    @Override
    public void b(long seed) {
        this.e = new Xoroshiro128PlusPlus(RandomSupport.c(seed));
        this.f.a();
    }

    @Override
    public int f() {
        return (int)this.e.a();
    }

    @Override
    public int a(int bound) {
        if (bound <= 0) {
            throw new IllegalArgumentException("Bound must be positive");
        }
        long l2 = Integer.toUnsignedLong(this.f());
        long l1 = l2 * (long)bound;
        long l22 = l1 & 0xFFFFFFFFL;
        if (l22 < (long)bound) {
            int i2 = Integer.remainderUnsigned(~bound + 1, bound);
            while (l22 < (long)i2) {
                l2 = Integer.toUnsignedLong(this.f());
                l1 = l2 * (long)bound;
                l22 = l1 & 0xFFFFFFFFL;
            }
        }
        long l3 = l1 >> 32;
        return (int)l3;
    }

    @Override
    public long g() {
        return this.e.a();
    }

    @Override
    public boolean h() {
        return (this.e.a() & 1L) != 0L;
    }

    @Override
    public float i() {
        return (float)this.c(24) * 5.9604645E-8f;
    }

    @Override
    public double j() {
        return (float)this.c(53) * 1.110223E-16f;
    }

    @Override
    public double k() {
        return this.f.b();
    }

    @Override
    public void b(int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            this.e.a();
        }
    }

    private long c(int bits) {
        return this.e.a() >>> 64 - bits;
    }

    public static class a
    implements PositionalRandomFactory {
        private final long a;
        private final long b;

        public a(long seedLo, long seedHi) {
            this.a = seedLo;
            this.b = seedHi;
        }

        @Override
        public RandomSource a(int x2, int y2, int z2) {
            long seed = MathHelper.b(x2, y2, z2);
            long l2 = seed ^ this.a;
            return new XoroshiroRandomSource(l2, this.b);
        }

        @Override
        public RandomSource a(String name) {
            RandomSupport.a seed128bit = RandomSupport.a(name);
            return new XoroshiroRandomSource(seed128bit.a(this.a, this.b));
        }

        @Override
        public RandomSource a(long seed) {
            return new XoroshiroRandomSource(seed ^ this.a, seed ^ this.b);
        }

        @Override
        @VisibleForTesting
        public void a(StringBuilder builder) {
            builder.append("seedLo: ").append(this.a).append(", seedHi: ").append(this.b);
        }
    }
}

