/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.blending;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.EnumDirection8;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.data.worldgen.NoiseData;
import net.minecraft.server.level.RegionLimitedWorldAccess;
import net.minecraft.tags.TagsBlock;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorNormal;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableObject;

public class Blender {
    private static final Blender a = new Blender(new Long2ObjectOpenHashMap(), new Long2ObjectOpenHashMap()){

        @Override
        public a a(int x2, int z2) {
            return new a(1.0, 0.0);
        }

        @Override
        public double a(DensityFunction.b context, double density) {
            return density;
        }

        @Override
        public BiomeResolver a(BiomeResolver resolver) {
            return resolver;
        }
    };
    private static final NoiseGeneratorNormal b = NoiseGeneratorNormal.b(new XoroshiroRandomSource(42L), NoiseData.a);
    private static final int c = QuartPos.d(7) - 1;
    private static final int d = QuartPos.e(c + 3);
    private static final int e = 2;
    private static final int f = QuartPos.e(5);
    private static final double g = 8.0;
    private final Long2ObjectOpenHashMap<BlendingData> h;
    private final Long2ObjectOpenHashMap<BlendingData> i;

    public static Blender a() {
        return a;
    }

    public static Blender a(@Nullable RegionLimitedWorldAccess region) {
        if (region == null) {
            return a;
        }
        ChunkCoordIntPair center = region.b();
        if (!region.a(center, d)) {
            return a;
        }
        Long2ObjectOpenHashMap map = new Long2ObjectOpenHashMap();
        Long2ObjectOpenHashMap map1 = new Long2ObjectOpenHashMap();
        int squared = MathHelper.h(d + 1);
        for (int i2 = -d; i2 <= d; ++i2) {
            for (int i1 = -d; i1 <= d; ++i1) {
                int i3;
                int i22;
                BlendingData orUpdateBlendingData;
                if (i2 * i2 + i1 * i1 > squared || (orUpdateBlendingData = BlendingData.a(region, i22 = center.h + i2, i3 = center.i + i1)) == null) continue;
                map.put(ChunkCoordIntPair.c(i22, i3), (Object)orUpdateBlendingData);
                if (i2 < -f || i2 > f || i1 < -f || i1 > f) continue;
                map1.put(ChunkCoordIntPair.c(i22, i3), (Object)orUpdateBlendingData);
            }
        }
        return map.isEmpty() && map1.isEmpty() ? a : new Blender((Long2ObjectOpenHashMap<BlendingData>)map, (Long2ObjectOpenHashMap<BlendingData>)map1);
    }

    Blender(Long2ObjectOpenHashMap<BlendingData> heightAndBiomeBlendingData, Long2ObjectOpenHashMap<BlendingData> densityBlendingData) {
        this.h = heightAndBiomeBlendingData;
        this.i = densityBlendingData;
    }

    public a a(int x2, int z2) {
        int quartPosZ;
        int quartPosX = QuartPos.a(x2);
        double blendingDataValue = this.a(quartPosX, 0, quartPosZ = QuartPos.a(z2), BlendingData::a);
        if (blendingDataValue != Double.MAX_VALUE) {
            return new a(0.0, Blender.a(blendingDataValue));
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble1 = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.h.forEach((_long, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(_long)), QuartPos.d(ChunkCoordIntPair.b(_long)), (x1, z1, height) -> {
            double d2 = MathHelper.f(quartPosX - x1, quartPosZ - z1);
            if (!(d2 > (double)c)) {
                if (d2 < mutableDouble2.doubleValue()) {
                    mutableDouble2.setValue(d2);
                }
                double d3 = 1.0 / (d2 * d2 * d2 * d2);
                mutableDouble1.add(height * d3);
                mutableDouble.add(d3);
            }
        }));
        if (mutableDouble2.doubleValue() == Double.POSITIVE_INFINITY) {
            return new a(1.0, 0.0);
        }
        double d2 = mutableDouble1.doubleValue() / mutableDouble.doubleValue();
        double d1 = MathHelper.a(mutableDouble2.doubleValue() / (double)(c + 1), 0.0, 1.0);
        d1 = 3.0 * d1 * d1 - 2.0 * d1 * d1 * d1;
        return new a(d1, Blender.a(d2));
    }

    private static double a(double height) {
        double d2 = 1.0;
        double d1 = height + 0.5;
        double d22 = MathHelper.c(d1, 8.0);
        return 1.0 * (32.0 * (d1 - 128.0) - 3.0 * (d1 - 120.0) * d22 + 3.0 * d22 * d22) / (128.0 * (32.0 - 3.0 * d22));
    }

    public double a(DensityFunction.b context, double density) {
        int quartPosZ;
        int i2;
        int quartPosX = QuartPos.a(context.a());
        double blendingDataValue = this.a(quartPosX, i2 = context.b() / 8, quartPosZ = QuartPos.a(context.c()), BlendingData::b);
        if (blendingDataValue != Double.MAX_VALUE) {
            return blendingDataValue;
        }
        MutableDouble mutableDouble = new MutableDouble(0.0);
        MutableDouble mutableDouble1 = new MutableDouble(0.0);
        MutableDouble mutableDouble2 = new MutableDouble(Double.POSITIVE_INFINITY);
        this.i.forEach((_long, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(_long)), QuartPos.d(ChunkCoordIntPair.b(_long)), i2 - 1, i2 + 1, (int x2, int y2, int z2, double density1) -> {
            double len = MathHelper.g((double)(quartPosX - x2), (double)((i2 - y2) * 2), (double)(quartPosZ - z2));
            if (!(len > 2.0)) {
                if (len < mutableDouble2.doubleValue()) {
                    mutableDouble2.setValue(len);
                }
                double d2 = 1.0 / (len * len * len * len);
                mutableDouble1.add(density1 * d2);
                mutableDouble.add(d2);
            }
        }));
        if (mutableDouble2.doubleValue() == Double.POSITIVE_INFINITY) {
            return density;
        }
        double d2 = mutableDouble1.doubleValue() / mutableDouble.doubleValue();
        double d1 = MathHelper.a(mutableDouble2.doubleValue() / 3.0, 0.0, 1.0);
        return MathHelper.d(d1, d2, density);
    }

    private double a(int x2, int y2, int z2, b getter) {
        int sectionPosX = QuartPos.e(x2);
        int sectionPosZ = QuartPos.e(z2);
        boolean flag = (x2 & 3) == 0;
        boolean flag1 = (z2 & 3) == 0;
        double blendingDataValue = this.a(getter, sectionPosX, sectionPosZ, x2, y2, z2);
        if (blendingDataValue == Double.MAX_VALUE) {
            if (flag && flag1) {
                blendingDataValue = this.a(getter, sectionPosX - 1, sectionPosZ - 1, x2, y2, z2);
            }
            if (blendingDataValue == Double.MAX_VALUE) {
                if (flag) {
                    blendingDataValue = this.a(getter, sectionPosX - 1, sectionPosZ, x2, y2, z2);
                }
                if (blendingDataValue == Double.MAX_VALUE && flag1) {
                    blendingDataValue = this.a(getter, sectionPosX, sectionPosZ - 1, x2, y2, z2);
                }
            }
        }
        return blendingDataValue;
    }

    private double a(b getter, int sectionX, int sectionZ, int x2, int y2, int z2) {
        BlendingData blendingData = (BlendingData)this.h.get(ChunkCoordIntPair.c(sectionX, sectionZ));
        return blendingData != null ? getter.get(blendingData, x2 - QuartPos.d(sectionX), y2, z2 - QuartPos.d(sectionZ)) : Double.MAX_VALUE;
    }

    public BiomeResolver a(BiomeResolver resolver) {
        return (x2, y2, z2, sampler) -> {
            Holder<BiomeBase> holder = this.a(x2, y2, z2);
            return holder == null ? resolver.getNoiseBiome(x2, y2, z2, sampler) : holder;
        };
    }

    @Nullable
    private Holder<BiomeBase> a(int x2, int y2, int z2) {
        MutableDouble mutableDouble = new MutableDouble(Double.POSITIVE_INFINITY);
        MutableObject mutableObject = new MutableObject();
        this.h.forEach((_long, blendingData) -> blendingData.a(QuartPos.d(ChunkCoordIntPair.a(_long)), y2, QuartPos.d(ChunkCoordIntPair.b(_long)), (int x1, int z1, Holder<BiomeBase> biome) -> {
            double d2 = MathHelper.f(x2 - x1, z2 - z1);
            if (!(d2 > (double)c) && d2 < mutableDouble.doubleValue()) {
                mutableObject.setValue((Object)biome);
                mutableDouble.setValue(d2);
            }
        }));
        if (mutableDouble.doubleValue() == Double.POSITIVE_INFINITY) {
            return null;
        }
        double d2 = b.a(x2, 0.0, z2) * 12.0;
        double d1 = MathHelper.a((mutableDouble.doubleValue() + d2) / (double)(c + 1), 0.0, 1.0);
        return d1 > 0.5 ? null : (Holder)mutableObject.getValue();
    }

    public static void a(RegionLimitedWorldAccess region, IChunkAccess chunk) {
        ChunkCoordIntPair pos = chunk.f();
        boolean isOldNoiseGeneration = chunk.u();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition blockPos = new BlockPosition(pos.d(), 0, pos.e());
        BlendingData blendingData = chunk.v();
        if (blendingData != null) {
            int minY = blendingData.b().K_();
            int maxY = blendingData.b().ao();
            if (isOldNoiseGeneration) {
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (int i1 = 0; i1 < 16; ++i1) {
                        Blender.a(chunk, mutableBlockPos.a(blockPos, i2, minY - 1, i1));
                        Blender.a(chunk, mutableBlockPos.a(blockPos, i2, minY, i1));
                        Blender.a(chunk, mutableBlockPos.a(blockPos, i2, maxY, i1));
                        Blender.a(chunk, mutableBlockPos.a(blockPos, i2, maxY + 1, i1));
                    }
                }
            }
            for (EnumDirection direction : EnumDirection.EnumDirectionLimit.a) {
                if (region.a(pos.h + direction.j(), pos.i + direction.l()).u() == isOldNoiseGeneration) continue;
                int i2 = direction == EnumDirection.f ? 15 : 0;
                int i3 = direction == EnumDirection.e ? 0 : 15;
                int i4 = direction == EnumDirection.d ? 15 : 0;
                int i5 = direction == EnumDirection.c ? 0 : 15;
                for (int i6 = i2; i6 <= i3; ++i6) {
                    for (int i7 = i4; i7 <= i5; ++i7) {
                        int i8 = Math.min(maxY, chunk.a(HeightMap.Type.e, i6, i7)) + 1;
                        for (int i9 = minY; i9 < i8; ++i9) {
                            Blender.a(chunk, mutableBlockPos.a(blockPos, i6, i9, i7));
                        }
                    }
                }
            }
        }
    }

    private static void a(IChunkAccess chunk, BlockPosition pos) {
        Fluid fluidState;
        IBlockData blockState = chunk.a_(pos);
        if (blockState.a(TagsBlock.Q)) {
            chunk.e(pos);
        }
        if (!(fluidState = chunk.b_(pos)).c()) {
            chunk.e(pos);
        }
    }

    public static void a(GeneratorAccessSeed level, ProtoChunk chunk) {
        ChunkCoordIntPair pos = chunk.f();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumDirection8 direction8 : EnumDirection8.values()) {
            int i1;
            int i2 = pos.h + direction8.b();
            BlendingData blendingData = level.a(i2, i1 = pos.i + direction8.c()).v();
            if (blendingData == null) continue;
            builder.put((Object)direction8, (Object)blendingData);
        }
        ImmutableMap map = builder.build();
        if (chunk.u() || !map.isEmpty()) {
            c distanceGetter = Blender.a(chunk.v(), (Map<EnumDirection8, BlendingData>)map);
            CarvingMask.a mask = (x2, y2, z2) -> {
                double d2;
                double d1;
                double d3 = (double)x2 + 0.5 + b.a(x2, y2, z2) * 4.0;
                return distanceGetter.getDistance(d3, d1 = (double)y2 + 0.5 + b.a(y2, z2, x2) * 4.0, d2 = (double)z2 + 0.5 + b.a(z2, x2, y2) * 4.0) < 4.0;
            };
            chunk.F().a(mask);
        }
    }

    public static c a(@Nullable BlendingData blendingData, Map<EnumDirection8, BlendingData> surroundingBlendingData) {
        ArrayList list = Lists.newArrayList();
        if (blendingData != null) {
            list.add(Blender.a(null, blendingData));
        }
        surroundingBlendingData.forEach((direction8, blendingData1) -> list.add(Blender.a(direction8, blendingData1)));
        return (x2, y2, z2) -> {
            double d2 = Double.POSITIVE_INFINITY;
            for (c distanceGetter : list) {
                double distance = distanceGetter.getDistance(x2, y2, z2);
                if (!(distance < d2)) continue;
                d2 = distance;
            }
            return d2;
        };
    }

    private static c a(@Nullable EnumDirection8 direction, BlendingData blendingData) {
        double d2 = 0.0;
        double d1 = 0.0;
        if (direction != null) {
            for (EnumDirection direction1 : direction.a()) {
                d2 += (double)(direction1.j() * 16);
                d1 += (double)(direction1.l() * 16);
            }
        }
        double d22 = d2;
        double d3 = d1;
        double d4 = (double)blendingData.b().L_() / 2.0;
        double d5 = (double)blendingData.b().K_() + d4;
        return (z2, d6, d7) -> Blender.a(z2 - 8.0 - d22, d6 - d5, d7 - 8.0 - d3, 8.0, d4, 8.0);
    }

    private static double a(double x1, double y1, double z1, double x2, double y2, double z2) {
        double d2 = Math.abs(x1) - x2;
        double d1 = Math.abs(y1) - y2;
        double d22 = Math.abs(z1) - z2;
        return MathHelper.g(Math.max(0.0, d2), Math.max(0.0, d1), Math.max(0.0, d22));
    }

    static interface b {
        public double get(BlendingData var1, int var2, int var3, int var4);
    }

    public record a(double a, double b) {
        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "alpha;blendingOffset", "a", "b"}, this, o2);
        }
    }

    public static interface c {
        public double getDistance(double var1, double var3, double var5);
    }
}

