/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.carver;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.carver.CanyonCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCanyon;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.WorldGenCarverWrapper;
import net.minecraft.world.level.levelgen.carver.WorldGenCaves;
import net.minecraft.world.level.levelgen.carver.WorldGenCavesHell;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import org.apache.commons.lang3.mutable.MutableBoolean;

public abstract class WorldGenCarverAbstract<C extends WorldGenCarverConfiguration> {
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> a = WorldGenCarverAbstract.a("cave", new WorldGenCaves(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CaveCarverConfiguration> b = WorldGenCarverAbstract.a("nether_cave", new WorldGenCavesHell(CaveCarverConfiguration.a));
    public static final WorldGenCarverAbstract<CanyonCarverConfiguration> c = WorldGenCarverAbstract.a("canyon", new WorldGenCanyon(CanyonCarverConfiguration.a));
    protected static final IBlockData d = Blocks.a.m();
    protected static final IBlockData e = Blocks.nI.m();
    protected static final Fluid f = FluidTypes.c.g();
    protected static final Fluid g = FluidTypes.e.g();
    protected Set<FluidType> h = ImmutableSet.of((Object)FluidTypes.c);
    private final MapCodec<WorldGenCarverWrapper<C>> i;

    private static <C extends WorldGenCarverConfiguration, F extends WorldGenCarverAbstract<C>> F a(String key, F carver) {
        return (F)IRegistry.a(BuiltInRegistries.N, key, carver);
    }

    public WorldGenCarverAbstract(Codec<C> codec) {
        this.i = codec.fieldOf("config").xmap(this::a, WorldGenCarverWrapper::b);
    }

    public WorldGenCarverWrapper<C> a(C config) {
        return new WorldGenCarverWrapper<C>(this, config);
    }

    public MapCodec<WorldGenCarverWrapper<C>> c() {
        return this.i;
    }

    public int d() {
        return 4;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeAccessor, Aquifer aquifer, double x2, double y2, double z2, double horizontalRadius, double verticalRadius, CarvingMask carvingMask, a skipChecker) {
        ChunkCoordIntPair pos = chunk.f();
        double d2 = pos.b();
        double d1 = pos.c();
        double d22 = 16.0 + horizontalRadius * 2.0;
        if (!(Math.abs(x2 - d2) > d22) && !(Math.abs(z2 - d1) > d22)) {
            int minBlockX = pos.d();
            int minBlockZ = pos.e();
            int max = Math.max(MathHelper.a(x2 - horizontalRadius) - minBlockX - 1, 0);
            int min = Math.min(MathHelper.a(x2 + horizontalRadius) - minBlockX, 15);
            int max1 = Math.max(MathHelper.a(y2 - verticalRadius) - 1, context.a() + 1);
            int i2 = chunk.A() ? 0 : 7;
            int min1 = Math.min(MathHelper.a(y2 + verticalRadius) + 1, context.a() + context.b() - 1 - i2);
            int max2 = Math.max(MathHelper.a(z2 - horizontalRadius) - minBlockZ - 1, 0);
            int min2 = Math.min(MathHelper.a(z2 + horizontalRadius) - minBlockZ, 15);
            boolean flag = false;
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
            for (int i1 = max; i1 <= min; ++i1) {
                int blockX = pos.a(i1);
                double d3 = ((double)blockX + 0.5 - x2) / horizontalRadius;
                for (int i22 = max2; i22 <= min2; ++i22) {
                    int blockZ = pos.b(i22);
                    double d4 = ((double)blockZ + 0.5 - z2) / horizontalRadius;
                    if (d3 * d3 + d4 * d4 >= 1.0) continue;
                    MutableBoolean mutableBoolean = new MutableBoolean(false);
                    for (int i3 = min1; i3 > max1; --i3) {
                        double d5 = ((double)i3 - 0.5 - y2) / verticalRadius;
                        if (skipChecker.shouldSkip(context, d3, d5, d4, i3) || carvingMask.b(i1, i3, i22) && !WorldGenCarverAbstract.b(config)) continue;
                        carvingMask.a(i1, i3, i22);
                        mutableBlockPos.d(blockX, i3, blockZ);
                        flag |= this.a(context, config, chunk, biomeAccessor, carvingMask, mutableBlockPos, mutableBlockPos1, aquifer, mutableBoolean);
                    }
                }
            }
            return flag;
        }
        return false;
    }

    protected boolean a(CarvingContext context, C config, IChunkAccess chunk, Function<BlockPosition, Holder<BiomeBase>> biomeGetter, CarvingMask carvingMask, BlockPosition.MutableBlockPosition pos, BlockPosition.MutableBlockPosition checkPos, Aquifer aquifer, MutableBoolean reachedSurface) {
        IBlockData blockState = chunk.a_(pos);
        if (blockState.a(Blocks.i) || blockState.a(Blocks.fE)) {
            reachedSurface.setTrue();
        }
        if (!this.a(config, blockState) && !WorldGenCarverAbstract.b(config)) {
            return false;
        }
        IBlockData carveState = this.a(context, config, pos, aquifer);
        if (carveState == null) {
            return false;
        }
        chunk.a((BlockPosition)pos, carveState);
        if (aquifer.a() && !carveState.y().c()) {
            chunk.e(pos);
        }
        if (reachedSurface.isTrue()) {
            checkPos.a((BaseBlockPosition)pos, EnumDirection.a);
            if (chunk.a_(checkPos).a(Blocks.j)) {
                context.a(biomeGetter, chunk, checkPos, !carveState.y().c()).ifPresent(blockState1 -> {
                    chunk.a((BlockPosition)checkPos, (IBlockData)blockState1);
                    if (!blockState1.y().c()) {
                        chunk.e(checkPos);
                    }
                });
            }
        }
        return true;
    }

    @Nullable
    private IBlockData a(CarvingContext context, C config, BlockPosition pos, Aquifer aquifer) {
        if (pos.v() <= ((WorldGenCarverConfiguration)config).g.a(context)) {
            return g.g();
        }
        IBlockData blockState = aquifer.a(new DensityFunction.e(pos.u(), pos.v(), pos.w()), 0.0);
        if (blockState == null) {
            return WorldGenCarverAbstract.b(config) ? ((WorldGenCarverConfiguration)config).h.e() : null;
        }
        return WorldGenCarverAbstract.b(config) ? WorldGenCarverAbstract.b(config, blockState) : blockState;
    }

    private static IBlockData b(WorldGenCarverConfiguration config, IBlockData state) {
        if (state.a(Blocks.a)) {
            return config.h.b();
        }
        if (state.a(Blocks.J)) {
            IBlockData waterState = config.h.c();
            return waterState.b(BlockProperties.I) ? (IBlockData)waterState.b(BlockProperties.I, true) : waterState;
        }
        return state.a(Blocks.K) ? config.h.d() : state;
    }

    public abstract boolean a(CarvingContext var1, C var2, IChunkAccess var3, Function<BlockPosition, Holder<BiomeBase>> var4, RandomSource var5, Aquifer var6, ChunkCoordIntPair var7, CarvingMask var8);

    public abstract boolean a(C var1, RandomSource var2);

    protected boolean a(C config, IBlockData state) {
        return state.a(((WorldGenCarverConfiguration)config).i);
    }

    protected static boolean a(ChunkCoordIntPair chunkPos, double x2, double z2, int branchIndex, int branchCount, float width) {
        double d5;
        double d4;
        double d1;
        double d3;
        double d2 = chunkPos.b();
        double d22 = x2 - d2;
        return d22 * d22 + (d3 = z2 - (d1 = (double)chunkPos.c())) * d3 - (d4 = (double)(branchCount - branchIndex)) * d4 <= (d5 = (double)(width + 2.0f + 16.0f)) * d5;
    }

    private static boolean b(WorldGenCarverConfiguration config) {
        return config.h.a();
    }

    public static interface a {
        public boolean shouldSkip(CarvingContext var1, double var2, double var4, double var6, int var8);
    }
}

