/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureEmptyConfiguration;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.CraftWorld;
import org.bukkit.craftbukkit.v1_21_R4.util.BlockStateListPopulator;
import org.bukkit.entity.Entity;
import org.bukkit.event.Event;
import org.bukkit.event.world.PortalCreateEvent;

public class EndPlatformFeature
extends WorldGenerator<WorldGenFeatureEmptyConfiguration> {
    public EndPlatformFeature(Codec<WorldGenFeatureEmptyConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<WorldGenFeatureEmptyConfiguration> context) {
        EndPlatformFeature.a(context.b(), context.e(), false);
        return true;
    }

    public static void a(WorldAccess level, BlockPosition pos, boolean dropBlocks) {
        EndPlatformFeature.createEndPlatform(level, pos, dropBlocks, null);
    }

    public static void createEndPlatform(WorldAccess level, BlockPosition pos, boolean dropBlocks, @Nullable net.minecraft.world.entity.Entity entity) {
        BlockStateListPopulator blockList = new BlockStateListPopulator(level);
        BlockPosition.MutableBlockPosition mutableBlockPos = pos.k();
        for (int i2 = -2; i2 <= 2; ++i2) {
            for (int i1 = -2; i1 <= 2; ++i1) {
                for (int i22 = -1; i22 < 3; ++i22) {
                    Block block;
                    BlockPosition.MutableBlockPosition blockPos = mutableBlockPos.g(pos).e(i1, i22, i2);
                    Block block2 = block = i22 == -1 ? Blocks.cy : Blocks.a;
                    if (blockList.a_(blockPos).a(block)) continue;
                    if (dropBlocks) {
                        blockList.a((BlockPosition)blockPos, true, null);
                    }
                    blockList.a((BlockPosition)blockPos, block.m(), 3);
                }
            }
        }
        if (entity != null) {
            CraftWorld bworld = level.a().getWorld();
            PortalCreateEvent portalEvent = new PortalCreateEvent(blockList.getSnapshotBlocks(), (World)bworld, (Entity)entity.getBukkitEntity(), PortalCreateEvent.CreateReason.END_PLATFORM);
            level.a().getCraftServer().getPluginManager().callEvent((Event)portalEvent);
            if (portalEvent.isCancelled()) {
                return;
            }
        }
        if (dropBlocks) {
            blockList.placeBlocks(state -> level.a(state.getPosition(), true, null));
        } else {
            blockList.placeBlocks();
        }
    }
}

