/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature;

import com.mojang.serialization.Codec;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.FossilFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.WorldGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.apache.commons.lang3.mutable.MutableInt;

public class WorldGenFossils
extends WorldGenerator<FossilFeatureConfiguration> {
    public WorldGenFossils(Codec<FossilFeatureConfiguration> codec) {
        super(codec);
    }

    @Override
    public boolean a(FeaturePlaceContext<FossilFeatureConfiguration> context) {
        int i2;
        RandomSource randomSource = context.d();
        GeneratorAccessSeed worldGenLevel = context.b();
        BlockPosition blockPos = context.e();
        EnumBlockRotation random = EnumBlockRotation.a(randomSource);
        FossilFeatureConfiguration fossilFeatureConfiguration = context.f();
        int randomInt = randomSource.a(fossilFeatureConfiguration.b.size());
        StructureTemplateManager structureManager = worldGenLevel.a().p().aY();
        DefinedStructure structureTemplate = structureManager.a(fossilFeatureConfiguration.b.get(randomInt));
        DefinedStructure structureTemplate1 = structureManager.a(fossilFeatureConfiguration.c.get(randomInt));
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(blockPos);
        StructureBoundingBox boundingBox = new StructureBoundingBox(chunkPos.d() - 16, worldGenLevel.K_(), chunkPos.e() - 16, chunkPos.f() + 16, worldGenLevel.ao(), chunkPos.g() + 16);
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(random).a(boundingBox).a(randomSource);
        BaseBlockPosition size = structureTemplate.a(random);
        BlockPosition blockPos1 = blockPos.b(-size.u() / 2, 0, -size.w() / 2);
        int y2 = blockPos.v();
        for (i2 = 0; i2 < size.u(); ++i2) {
            for (int i1 = 0; i1 < size.w(); ++i1) {
                y2 = Math.min(y2, worldGenLevel.a(HeightMap.Type.c, blockPos1.u() + i2, blockPos1.w() + i1));
            }
        }
        i2 = Math.max(y2 - 15 - randomSource.a(10), worldGenLevel.K_() + 10);
        BlockPosition zeroPositionWithTransform = structureTemplate.a(blockPos1.h(i2), EnumBlockMirror.a, random);
        if (WorldGenFossils.a(worldGenLevel, structureTemplate.b(structurePlaceSettings, zeroPositionWithTransform)) > fossilFeatureConfiguration.f) {
            return false;
        }
        structurePlaceSettings.b();
        fossilFeatureConfiguration.d.a().a().forEach(structurePlaceSettings::a);
        structureTemplate.a(worldGenLevel, zeroPositionWithTransform, zeroPositionWithTransform, structurePlaceSettings, randomSource, 260);
        structurePlaceSettings.b();
        fossilFeatureConfiguration.e.a().a().forEach(structurePlaceSettings::a);
        structureTemplate1.a(worldGenLevel, zeroPositionWithTransform, zeroPositionWithTransform, structurePlaceSettings, randomSource, 260);
        return true;
    }

    private static int a(GeneratorAccessSeed level, StructureBoundingBox boundingBox) {
        MutableInt mutableInt = new MutableInt(0);
        boundingBox.a((BlockPosition blockPos) -> {
            IBlockData blockState = level.a_((BlockPosition)blockPos);
            if (blockState.l() || blockState.a(Blocks.K) || blockState.a(Blocks.J)) {
                mutableInt.add(1);
            }
        });
        return mutableInt.getValue();
    }
}

