/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.treedecorators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.WorldGenTrees;
import net.minecraft.world.level.levelgen.feature.stateproviders.WorldGenFeatureStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTree;
import net.minecraft.world.level.levelgen.feature.treedecorators.WorldGenFeatureTrees;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;

public class PlaceOnGroundDecorator
extends WorldGenFeatureTree {
    public static final MapCodec<PlaceOnGroundDecorator> a = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.m.fieldOf("tries").orElse((Object)128).forGetter(decorator -> decorator.b), (App)ExtraCodecs.l.fieldOf("radius").orElse((Object)2).forGetter(decorator -> decorator.c), (App)ExtraCodecs.l.fieldOf("height").orElse((Object)1).forGetter(decorator -> decorator.d), (App)WorldGenFeatureStateProvider.a.fieldOf("block_state_provider").forGetter(decorator -> decorator.e)).apply((Applicative)instance, PlaceOnGroundDecorator::new));
    private final int b;
    private final int c;
    private final int d;
    private final WorldGenFeatureStateProvider e;

    public PlaceOnGroundDecorator(int tries, int radius, int height, WorldGenFeatureStateProvider blockStateProvider) {
        this.b = tries;
        this.c = radius;
        this.d = height;
        this.e = blockStateProvider;
    }

    @Override
    protected WorldGenFeatureTrees<?> a() {
        return WorldGenFeatureTrees.i;
    }

    @Override
    public void a(WorldGenFeatureTree.a context) {
        List<BlockPosition> lowestTrunkOrRootOfTree = WorldGenTrees.a(context);
        if (!lowestTrunkOrRootOfTree.isEmpty()) {
            BlockPosition blockPos = lowestTrunkOrRootOfTree.getFirst();
            int y2 = blockPos.v();
            int x2 = blockPos.u();
            int x1 = blockPos.u();
            int z2 = blockPos.w();
            int z1 = blockPos.w();
            for (BlockPosition blockPos1 : lowestTrunkOrRootOfTree) {
                if (blockPos1.v() != y2) continue;
                x2 = Math.min(x2, blockPos1.u());
                x1 = Math.max(x1, blockPos1.u());
                z2 = Math.min(z2, blockPos1.w());
                z1 = Math.max(z1, blockPos1.w());
            }
            RandomSource randomSource = context.b();
            StructureBoundingBox boundingBox = new StructureBoundingBox(x2, y2, z2, x1, y2, z1).c(this.c, this.d, this.c);
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
            for (int i2 = 0; i2 < this.b; ++i2) {
                mutableBlockPos.d(randomSource.a(boundingBox.h(), boundingBox.k()), randomSource.a(boundingBox.i(), boundingBox.l()), randomSource.a(boundingBox.j(), boundingBox.m()));
                this.a(context, mutableBlockPos);
            }
        }
    }

    private void a(WorldGenFeatureTree.a context, BlockPosition pos) {
        BlockPosition blockPos = pos.d();
        if (context.a().a(blockPos, (IBlockData blockState) -> blockState.l() || blockState.a(Blocks.fx)) && context.a(pos, BlockBase.BlockData::s)) {
            context.a(blockPos, this.e.a(context.b(), blockPos));
        }
    }
}

