/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.feature.trunkplacers;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.VirtualLevelReadable;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.feature.configurations.WorldGenFeatureTreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.WorldGenFoilagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacers;

public class UpwardsBranchingTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<UpwardsBranchingTrunkPlacer> a = RecordCodecBuilder.mapCodec(instance -> UpwardsBranchingTrunkPlacer.a(instance).and(instance.group((App)IntProvider.e.fieldOf("extra_branch_steps").forGetter(trunkPlacer -> trunkPlacer.b), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("place_branch_per_log_probability").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.h)), (App)IntProvider.d.fieldOf("extra_branch_length").forGetter(trunkPlacer -> trunkPlacer.i), (App)RegistryCodecs.a(Registries.i).fieldOf("can_grow_through").forGetter(trunkPlacer -> trunkPlacer.j))).apply((Applicative)instance, UpwardsBranchingTrunkPlacer::new));
    private final IntProvider b;
    private final float h;
    private final IntProvider i;
    private final HolderSet<Block> j;

    public UpwardsBranchingTrunkPlacer(int baseHeight, int heightRandA, int heightRandB, IntProvider extraBranchSteps, float placeBranchPerLogProbability, IntProvider extraBranchLength, HolderSet<Block> canGrowThrough) {
        super(baseHeight, heightRandA, heightRandB);
        this.b = extraBranchSteps;
        this.h = placeBranchPerLogProbability;
        this.i = extraBranchLength;
        this.j = canGrowThrough;
    }

    @Override
    protected TrunkPlacers<?> a() {
        return TrunkPlacers.h;
    }

    @Override
    public List<WorldGenFoilagePlacer.a> a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int freeTreeHeight, BlockPosition pos, WorldGenFeatureTreeConfiguration config) {
        ArrayList list = Lists.newArrayList();
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int i2 = 0; i2 < freeTreeHeight; ++i2) {
            int i1 = pos.v() + i2;
            if (this.b(level, blockSetter, random, mutableBlockPos.d(pos.u(), i1, pos.w()), config) && i2 < freeTreeHeight - 1 && random.i() < this.h) {
                EnumDirection randomDirection = EnumDirection.EnumDirectionLimit.a.a(random);
                int i22 = this.i.a(random);
                int max = Math.max(0, i22 - this.i.a(random) - 1);
                int i3 = this.b.a(random);
                this.a(level, blockSetter, random, freeTreeHeight, config, list, mutableBlockPos, i1, randomDirection, max, i3);
            }
            if (i2 != freeTreeHeight - 1) continue;
            list.add(new WorldGenFoilagePlacer.a(mutableBlockPos.d(pos.u(), i1 + 1, pos.w()), 0, false));
        }
        return list;
    }

    private void a(VirtualLevelReadable level, BiConsumer<BlockPosition, IBlockData> blockSetter, RandomSource random, int freeTreeHeight, WorldGenFeatureTreeConfiguration treeConfig, List<WorldGenFoilagePlacer.a> foliageAttachments, BlockPosition.MutableBlockPosition pos, int y2, EnumDirection direction, int extraBranchLength, int extraBranchSteps) {
        int i2 = y2 + extraBranchLength;
        int x2 = pos.u();
        int z2 = pos.w();
        for (int i1 = extraBranchLength; i1 < freeTreeHeight && extraBranchSteps > 0; ++i1, --extraBranchSteps) {
            if (i1 < 1) continue;
            int i22 = y2 + i1;
            i2 = i22;
            if (this.b(level, blockSetter, random, pos.d(x2 += direction.j(), i22, z2 += direction.l()), treeConfig)) {
                i2 = i22 + 1;
            }
            foliageAttachments.add(new WorldGenFoilagePlacer.a(pos.j(), 0, false));
        }
        if (i2 - y2 > 1) {
            BlockPosition blockPos = new BlockPosition(x2, i2, z2);
            foliageAttachments.add(new WorldGenFoilagePlacer.a(blockPos, 0, false));
            foliageAttachments.add(new WorldGenFoilagePlacer.a(blockPos.c(2), 0, false));
        }
    }

    @Override
    protected boolean a(VirtualLevelReadable level, BlockPosition pos) {
        return super.a(level, pos) || level.a(pos, (IBlockData blockState) -> blockState.a(this.j));
    }
}

