/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.structure.PersistentIndexed;
import net.minecraft.world.level.storage.WorldPersistentData;

public class PersistentStructureLegacy {
    private static final Map<String, String> a = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Village", "Village");
        map.put("Mineshaft", "Mineshaft");
        map.put("Mansion", "Mansion");
        map.put("Igloo", "Temple");
        map.put("Desert_Pyramid", "Temple");
        map.put("Jungle_Pyramid", "Temple");
        map.put("Swamp_Hut", "Temple");
        map.put("Stronghold", "Stronghold");
        map.put("Monument", "Monument");
        map.put("Fortress", "Fortress");
        map.put("EndCity", "EndCity");
    });
    private static final Map<String, String> b = SystemUtils.a(Maps.newHashMap(), (? super T map) -> {
        map.put("Iglu", "Igloo");
        map.put("TeDP", "Desert_Pyramid");
        map.put("TeJP", "Jungle_Pyramid");
        map.put("TeSH", "Swamp_Hut");
    });
    private static final Set<String> c = Set.of("pillager_outpost", "mineshaft", "mansion", "jungle_pyramid", "desert_pyramid", "igloo", "ruined_portal", "shipwreck", "swamp_hut", "stronghold", "monument", "ocean_ruin", "fortress", "endcity", "buried_treasure", "village", "nether_fossil", "bastion_remnant");
    private final boolean d;
    private final Map<String, Long2ObjectMap<NBTTagCompound>> e = Maps.newHashMap();
    private final Map<String, PersistentIndexed> f = Maps.newHashMap();
    private final List<String> g;
    private final List<String> h;

    public PersistentStructureLegacy(@Nullable WorldPersistentData storage, List<String> legacyKeys, List<String> currentKeys) {
        this.g = legacyKeys;
        this.h = currentKeys;
        this.a(storage);
        boolean flag = false;
        for (String string : this.h) {
            flag |= this.e.get(string) != null;
        }
        this.d = flag;
    }

    public void a(long packedChunkPos) {
        for (String string : this.g) {
            PersistentIndexed structureFeatureIndexSavedData = this.f.get(string);
            if (structureFeatureIndexSavedData == null || !structureFeatureIndexSavedData.c(packedChunkPos)) continue;
            structureFeatureIndexSavedData.d(packedChunkPos);
        }
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        NBTTagCompound compoundOrEmpty = tag.n("Level");
        ChunkCoordIntPair chunkPos = new ChunkCoordIntPair(compoundOrEmpty.b("xPos", 0), compoundOrEmpty.b("zPos", 0));
        if (this.a(chunkPos.h, chunkPos.i)) {
            tag = this.a(tag, chunkPos);
        }
        NBTTagCompound compoundOrEmpty1 = compoundOrEmpty.n("Structures");
        NBTTagCompound compoundOrEmpty2 = compoundOrEmpty1.n("References");
        for (String string : this.h) {
            boolean flag = c.contains(string.toLowerCase(Locale.ROOT));
            if (compoundOrEmpty2.l(string).isPresent() || !flag) continue;
            int i2 = 8;
            LongArrayList list = new LongArrayList();
            for (int i1 = chunkPos.h - 8; i1 <= chunkPos.h + 8; ++i1) {
                for (int i22 = chunkPos.i - 8; i22 <= chunkPos.i + 8; ++i22) {
                    if (!this.a(i1, i22, string)) continue;
                    list.add(ChunkCoordIntPair.c(i1, i22));
                }
            }
            compoundOrEmpty2.a(string, list.toLongArray());
        }
        compoundOrEmpty1.a("References", compoundOrEmpty2);
        compoundOrEmpty.a("Structures", compoundOrEmpty1);
        tag.a("Level", compoundOrEmpty);
        return tag;
    }

    private boolean a(int chunkX, int chunkZ, String key) {
        return this.d && this.e.get(key) != null && this.f.get(a.get(key)).b(ChunkCoordIntPair.c(chunkX, chunkZ));
    }

    private boolean a(int chunkX, int chunkZ) {
        if (!this.d) {
            return false;
        }
        for (String string : this.h) {
            if (this.e.get(string) == null || !this.f.get(a.get(string)).c(ChunkCoordIntPair.c(chunkX, chunkZ))) continue;
            return true;
        }
        return false;
    }

    private NBTTagCompound a(NBTTagCompound tag, ChunkCoordIntPair chunkPos) {
        NBTTagCompound compoundOrEmpty = tag.n("Level");
        NBTTagCompound compoundOrEmpty1 = compoundOrEmpty.n("Structures");
        NBTTagCompound compoundOrEmpty2 = compoundOrEmpty1.n("Starts");
        for (String string : this.h) {
            NBTTagCompound compoundTag;
            Long2ObjectMap<NBTTagCompound> map = this.e.get(string);
            if (map == null) continue;
            long packedChunkPos = chunkPos.a();
            if (!this.f.get(a.get(string)).c(packedChunkPos) || (compoundTag = (NBTTagCompound)map.get(packedChunkPos)) == null) continue;
            compoundOrEmpty2.a(string, compoundTag);
        }
        compoundOrEmpty1.a("Starts", compoundOrEmpty2);
        compoundOrEmpty.a("Structures", compoundOrEmpty1);
        tag.a("Level", compoundOrEmpty);
        return tag;
    }

    private void a(@Nullable WorldPersistentData storage) {
        if (storage != null) {
            for (String string : this.g) {
                NBTTagCompound compoundTag = new NBTTagCompound();
                try {
                    compoundTag = storage.a(string, DataFixTypes.o, 1493).n("data").n("Features");
                    if (compoundTag.j()) {
                        continue;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                compoundTag.a((String string2, NBTBase tag) -> {
                    if (tag instanceof NBTTagCompound) {
                        NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
                        long packedChunkPos = ChunkCoordIntPair.c(compoundTag1.b("ChunkX", 0), compoundTag1.b("ChunkZ", 0));
                        NBTTagList listOrEmpty = compoundTag1.p("Children");
                        if (!listOrEmpty.isEmpty()) {
                            Optional<String> optional = listOrEmpty.a(0).flatMap(compoundTag2 -> compoundTag2.i("id"));
                            optional.map(b::get).ifPresent(string3 -> compoundTag1.a("id", (String)string3));
                        }
                        compoundTag1.i("id").ifPresent(string3 -> this.e.computeIfAbsent((String)string3, string4 -> new Long2ObjectOpenHashMap()).put(packedChunkPos, (Object)compoundTag1));
                    }
                });
                String string1 = string + "_index";
                PersistentIndexed structureFeatureIndexSavedData = storage.a(PersistentIndexed.a(string1));
                if (structureFeatureIndexSavedData.a().isEmpty()) {
                    PersistentIndexed structureFeatureIndexSavedData1 = new PersistentIndexed();
                    this.f.put(string, structureFeatureIndexSavedData1);
                    compoundTag.a((String string2, NBTBase tag) -> {
                        if (tag instanceof NBTTagCompound) {
                            NBTTagCompound compoundTag1 = (NBTTagCompound)tag;
                            structureFeatureIndexSavedData1.a(ChunkCoordIntPair.c(compoundTag1.b("ChunkX", 0), compoundTag1.b("ChunkZ", 0)));
                        }
                    });
                    continue;
                }
                this.f.put(string, structureFeatureIndexSavedData);
            }
        }
    }

    public static PersistentStructureLegacy a(ResourceKey<WorldDimension> level, @Nullable WorldPersistentData storage) {
        if (level == WorldDimension.b) {
            return new PersistentStructureLegacy(storage, (List<String>)ImmutableList.of((Object)"Monument", (Object)"Stronghold", (Object)"Village", (Object)"Mineshaft", (Object)"Temple", (Object)"Mansion"), (List<String>)ImmutableList.of((Object)"Village", (Object)"Mineshaft", (Object)"Mansion", (Object)"Igloo", (Object)"Desert_Pyramid", (Object)"Jungle_Pyramid", (Object)"Swamp_Hut", (Object)"Stronghold", (Object)"Monument"));
        }
        if (level == WorldDimension.c) {
            ImmutableList list = ImmutableList.of((Object)"Fortress");
            return new PersistentStructureLegacy(storage, (List<String>)list, (List<String>)list);
        }
        if (level == WorldDimension.d) {
            ImmutableList list = ImmutableList.of((Object)"EndCity");
            return new PersistentStructureLegacy(storage, (List<String>)list, (List<String>)list);
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Unknown dimension type : %s", level));
    }
}

