/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawJunction;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeaturePillagerOutpostPoolPiece
extends StructurePiece {
    protected final WorldGenFeatureDefinedStructurePoolStructure a;
    protected BlockPosition b;
    private final int d;
    protected final EnumBlockRotation c;
    private final List<WorldGenFeatureDefinedStructureJigsawJunction> h = Lists.newArrayList();
    private final StructureTemplateManager i;
    private final LiquidSettings j;

    public WorldGenFeaturePillagerOutpostPoolPiece(StructureTemplateManager structureTemplateManager, WorldGenFeatureDefinedStructurePoolStructure element, BlockPosition position, int groundLevelDelta, EnumBlockRotation rotation, StructureBoundingBox boundingBox, LiquidSettings liquidSettings) {
        super(WorldGenFeatureStructurePieceType.ad, 0, boundingBox);
        this.i = structureTemplateManager;
        this.a = element;
        this.b = position;
        this.d = groundLevelDelta;
        this.c = rotation;
        this.j = liquidSettings;
    }

    public WorldGenFeaturePillagerOutpostPoolPiece(StructurePieceSerializationContext context, NBTTagCompound tag) {
        super(WorldGenFeatureStructurePieceType.ad, tag);
        this.i = context.c();
        this.b = new BlockPosition(tag.b("PosX", 0), tag.b("PosY", 0), tag.b("PosZ", 0));
        this.d = tag.b("ground_level_delta", 0);
        RegistryOps<NBTBase> dynamicOps = context.b().a(DynamicOpsNBT.a);
        this.a = tag.a("pool_element", WorldGenFeatureDefinedStructurePoolStructure.f, (DynamicOps<NBTBase>)dynamicOps).orElseThrow(() -> new IllegalStateException("Invalid pool element found"));
        this.c = tag.a("rotation", EnumBlockRotation.h).orElseThrow();
        this.f = this.a.a(this.i, this.b, this.c);
        NBTTagList listOrEmpty = tag.p("junctions");
        this.h.clear();
        listOrEmpty.forEach(junctionTag -> this.h.add(WorldGenFeatureDefinedStructureJigsawJunction.a(new Dynamic<NBTBase>((DynamicOps<NBTBase>)dynamicOps, (NBTBase)junctionTag))));
        this.j = tag.a("liquid_settings", LiquidSettings.c).orElse(JigsawStructure.e);
    }

    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
        tag.a("PosX", this.b.u());
        tag.a("PosY", this.b.v());
        tag.a("PosZ", this.b.w());
        tag.a("ground_level_delta", this.d);
        RegistryOps<NBTBase> dynamicOps = context.b().a(DynamicOpsNBT.a);
        tag.a("pool_element", WorldGenFeatureDefinedStructurePoolStructure.f, dynamicOps, this.a);
        tag.a("rotation", EnumBlockRotation.h, this.c);
        NBTTagList listTag = new NBTTagList();
        for (WorldGenFeatureDefinedStructureJigsawJunction jigsawJunction : this.h) {
            listTag.add(jigsawJunction.a(dynamicOps).getValue());
        }
        tag.a("junctions", listTag);
        if (this.j != JigsawStructure.e) {
            tag.a("liquid_settings", LiquidSettings.c, dynamicOps, this.j);
        }
    }

    @Override
    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
        this.a(level, structureManager, generator, random, box, pos, false);
    }

    public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, BlockPosition pos, boolean keepJigsaws) {
        this.a.a(this.i, level, structureManager, generator, this.b, pos, this.c, box, random, this.j, keepJigsaws);
    }

    @Override
    public void a(int x2, int y2, int z2) {
        super.a(x2, y2, z2);
        this.b = this.b.b(x2, y2, z2);
    }

    @Override
    public EnumBlockRotation a() {
        return this.c;
    }

    public String toString() {
        return String.format(Locale.ROOT, "<%s | %s | %s | %s>", this.getClass().getSimpleName(), this.b, this.c, this.a);
    }

    public WorldGenFeatureDefinedStructurePoolStructure b() {
        return this.a;
    }

    public BlockPosition c() {
        return this.b;
    }

    public int d() {
        return this.d;
    }

    public void a(WorldGenFeatureDefinedStructureJigsawJunction junction) {
        this.h.add(junction);
    }

    public List<WorldGenFeatureDefinedStructureJigsawJunction> e() {
        return this.h;
    }
}

