/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;

public abstract class WorldGenScatteredPiece
extends StructurePiece {
    protected final int a;
    protected final int b;
    protected final int c;
    protected int d = -1;

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, int x2, int y2, int z2, int width, int height, int depth, EnumDirection orientation) {
        super(type, 0, StructurePiece.a(x2, y2, z2, orientation, width, height, depth));
        this.a = width;
        this.b = height;
        this.c = depth;
        this.a(orientation);
    }

    protected WorldGenScatteredPiece(WorldGenFeatureStructurePieceType type, NBTTagCompound tag) {
        super(type, tag);
        this.a = tag.b("Width", 0);
        this.b = tag.b("Height", 0);
        this.c = tag.b("Depth", 0);
        this.d = tag.b("HPos", 0);
    }

    @Override
    protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
        tag.a("Width", this.a);
        tag.a("Height", this.b);
        tag.a("Depth", this.c);
        tag.a("HPos", this.d);
    }

    protected boolean a(GeneratorAccess level, StructureBoundingBox bounds, int height) {
        if (this.d >= 0) {
            return true;
        }
        int i2 = 0;
        int i1 = 0;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int z2 = this.f.j(); z2 <= this.f.m(); ++z2) {
            for (int x2 = this.f.h(); x2 <= this.f.k(); ++x2) {
                mutableBlockPos.d(x2, 64, z2);
                if (!bounds.b(mutableBlockPos)) continue;
                i2 += level.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v();
                ++i1;
            }
        }
        if (i1 == 0) {
            return false;
        }
        this.d = i2 / i1;
        this.f.a(0, this.d - this.f.i() + height, 0);
        return true;
    }

    protected boolean a(GeneratorAccess level, int height) {
        if (this.d >= 0) {
            return true;
        }
        int i2 = level.ao() + 1;
        boolean flag = false;
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        for (int z2 = this.f.j(); z2 <= this.f.m(); ++z2) {
            for (int x2 = this.f.h(); x2 <= this.f.k(); ++x2) {
                mutableBlockPos.d(x2, 0, z2);
                i2 = Math.min(i2, level.a(HeightMap.Type.f, (BlockPosition)mutableBlockPos).v());
                flag = true;
            }
        }
        if (!flag) {
            return false;
        }
        this.d = i2;
        this.f.a(0, this.d - this.f.i() + height, 0);
        return true;
    }
}

