/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacementType;

public class RandomSpreadStructurePlacement
extends StructurePlacement {
    public static final MapCodec<RandomSpreadStructurePlacement> a = RecordCodecBuilder.mapCodec(instance -> RandomSpreadStructurePlacement.a(instance).and(instance.group((App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(RandomSpreadStructurePlacement::a), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(RandomSpreadStructurePlacement::b), (App)RandomSpreadType.c.optionalFieldOf("spread_type", (Object)RandomSpreadType.a).forGetter(RandomSpreadStructurePlacement::c))).apply((Applicative)instance, RandomSpreadStructurePlacement::new)).validate(RandomSpreadStructurePlacement::a);
    private final int c;
    private final int d;
    private final RandomSpreadType e;

    private static DataResult<RandomSpreadStructurePlacement> a(RandomSpreadStructurePlacement placement) {
        return placement.c <= placement.d ? DataResult.error(() -> "Spacing has to be larger than separation") : DataResult.success((Object)placement);
    }

    public RandomSpreadStructurePlacement(BaseBlockPosition locateOffset, StructurePlacement.c frequencyReductionMethod, float frequency, int salt, Optional<StructurePlacement.a> exclusionZone, int spacing, int separation, RandomSpreadType spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, exclusionZone);
        this.c = spacing;
        this.d = separation;
        this.e = spreadType;
    }

    public RandomSpreadStructurePlacement(int spacing, int separation, RandomSpreadType spreadType, int salt) {
        this(BaseBlockPosition.i, StructurePlacement.c.a, 1.0f, salt, Optional.empty(), spacing, separation, spreadType);
    }

    public int a() {
        return this.c;
    }

    public int b() {
        return this.d;
    }

    public RandomSpreadType c() {
        return this.e;
    }

    public ChunkCoordIntPair a(long seed, int regionX, int regionZ) {
        int i2 = Math.floorDiv(regionX, this.c);
        int i1 = Math.floorDiv(regionZ, this.c);
        SeededRandom worldgenRandom = new SeededRandom(new LegacyRandomSource(0L));
        worldgenRandom.a(seed, i2, i1, this.i());
        int i22 = this.c - this.d;
        int i3 = this.e.a(worldgenRandom, i22);
        int i4 = this.e.a(worldgenRandom, i22);
        return new ChunkCoordIntPair(i2 * this.c + i3, i1 * this.c + i4);
    }

    @Override
    protected boolean a(ChunkGeneratorStructureState structureState, int x2, int z2) {
        ChunkCoordIntPair potentialStructureChunk = this.a(structureState.d(), x2, z2);
        return potentialStructureChunk.h == x2 && potentialStructureChunk.i == z2;
    }

    @Override
    public StructurePlacementType<?> e() {
        return StructurePlacementType.a;
    }
}

