/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.state.properties.BlockPropertyStructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolStructure;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePools;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorBlockIgnore;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorJigsawReplacement;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureStructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class WorldGenFeatureDefinedStructurePoolSingle
extends WorldGenFeatureDefinedStructurePoolStructure {
    private static final Comparator<DefinedStructure.a> a = Comparator.comparingInt(DefinedStructure.a::g).reversed();
    private static final Codec<Either<MinecraftKey, DefinedStructure>> g = Codec.of(WorldGenFeatureDefinedStructurePoolSingle::a, (Decoder)MinecraftKey.a.map(Either::left));
    public static final MapCodec<WorldGenFeatureDefinedStructurePoolSingle> b = RecordCodecBuilder.mapCodec(instance -> instance.group(WorldGenFeatureDefinedStructurePoolSingle.d(), WorldGenFeatureDefinedStructurePoolSingle.b(), WorldGenFeatureDefinedStructurePoolSingle.f(), WorldGenFeatureDefinedStructurePoolSingle.c()).apply((Applicative)instance, WorldGenFeatureDefinedStructurePoolSingle::new));
    protected final Either<MinecraftKey, DefinedStructure> c;
    protected final Holder<ProcessorList> d;
    protected final Optional<LiquidSettings> e;

    private static <T> DataResult<T> a(Either<MinecraftKey, DefinedStructure> template, DynamicOps<T> ops, T values) {
        Optional<MinecraftKey> optional = template.left();
        return optional.isEmpty() ? DataResult.error(() -> "Can not serialize a runtime pool element") : MinecraftKey.a.encode((Object)optional.get(), ops, values);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Holder<ProcessorList>> b() {
        return DefinedStructureStructureProcessorType.d.fieldOf("processors").forGetter(singlePoolElement -> singlePoolElement.d);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Optional<LiquidSettings>> c() {
        return LiquidSettings.c.optionalFieldOf("override_liquid_settings").forGetter(singlePoolElement -> singlePoolElement.e);
    }

    protected static <E extends WorldGenFeatureDefinedStructurePoolSingle> RecordCodecBuilder<E, Either<MinecraftKey, DefinedStructure>> d() {
        return g.fieldOf("location").forGetter(singlePoolElement -> singlePoolElement.c);
    }

    protected WorldGenFeatureDefinedStructurePoolSingle(Either<MinecraftKey, DefinedStructure> template, Holder<ProcessorList> processors, WorldGenFeatureDefinedStructurePoolTemplate.Matching projection, Optional<LiquidSettings> overrideLiquidSettings) {
        super(projection);
        this.c = template;
        this.d = processors;
        this.e = overrideLiquidSettings;
    }

    @Override
    public BaseBlockPosition a(StructureTemplateManager structureTemplateManager, EnumBlockRotation rotation) {
        DefinedStructure template = this.a(structureTemplateManager);
        return template.a(rotation);
    }

    private DefinedStructure a(StructureTemplateManager structureTemplateManager) {
        return this.c.map(structureTemplateManager::a, Function.identity());
    }

    public List<DefinedStructure.BlockInfo> a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, boolean relativePosition) {
        DefinedStructure template = this.a(structureTemplateManager);
        ObjectArrayList<DefinedStructure.BlockInfo> list = template.a(pos, new DefinedStructureInfo().a(rotation), Blocks.pG, relativePosition);
        ArrayList list1 = Lists.newArrayList();
        for (DefinedStructure.BlockInfo structureBlockInfo : list) {
            BlockPropertyStructureMode structureMode;
            NBTTagCompound compoundTag = structureBlockInfo.c();
            if (compoundTag == null || (structureMode = compoundTag.a("mode", BlockPropertyStructureMode.e).orElseThrow()) != BlockPropertyStructureMode.d) continue;
            list1.add(structureBlockInfo);
        }
        return list1;
    }

    @Override
    public List<DefinedStructure.a> a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation, RandomSource random) {
        List<DefinedStructure.a> jigsaws = this.a(structureTemplateManager).a(pos, rotation);
        SystemUtils.c(jigsaws, random);
        WorldGenFeatureDefinedStructurePoolSingle.a(jigsaws);
        return jigsaws;
    }

    @VisibleForTesting
    static void a(List<DefinedStructure.a> structureBlockInfos) {
        structureBlockInfos.sort(a);
    }

    @Override
    public StructureBoundingBox a(StructureTemplateManager structureTemplateManager, BlockPosition pos, EnumBlockRotation rotation) {
        DefinedStructure template = this.a(structureTemplateManager);
        return template.b(new DefinedStructureInfo().a(rotation), pos);
    }

    @Override
    public boolean a(StructureTemplateManager structureTemplateManager, GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, BlockPosition offset, BlockPosition pos, EnumBlockRotation rotation, StructureBoundingBox box, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws) {
        DefinedStructureInfo settings;
        DefinedStructure template = this.a(structureTemplateManager);
        if (!template.a(level, offset, pos, settings = this.a(rotation, box, liquidSettings, keepJigsaws), random, 18)) {
            return false;
        }
        for (DefinedStructure.BlockInfo structureBlockInfo : DefinedStructure.a(level, offset, pos, settings, this.a(structureTemplateManager, offset, rotation, false))) {
            this.a(level, structureBlockInfo, offset, rotation, random, box);
        }
        return true;
    }

    protected DefinedStructureInfo a(EnumBlockRotation rotation, StructureBoundingBox boundingBox, LiquidSettings liquidSettings, boolean offset) {
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo();
        structurePlaceSettings.a(boundingBox);
        structurePlaceSettings.a(rotation);
        structurePlaceSettings.b(true);
        structurePlaceSettings.a(false);
        structurePlaceSettings.a(DefinedStructureProcessorBlockIgnore.b);
        structurePlaceSettings.c(true);
        structurePlaceSettings.a(this.e.orElse(liquidSettings));
        if (!offset) {
            structurePlaceSettings.a(DefinedStructureProcessorJigsawReplacement.b);
        }
        this.d.a().a().forEach(structurePlaceSettings::a);
        this.g().b().forEach(structurePlaceSettings::a);
        return structurePlaceSettings;
    }

    @Override
    public WorldGenFeatureDefinedStructurePools<?> a() {
        return WorldGenFeatureDefinedStructurePools.a;
    }

    public String toString() {
        return "Single[" + String.valueOf(this.c) + "]";
    }

    @VisibleForTesting
    public MinecraftKey e() {
        return this.c.orThrow();
    }
}

