/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.structures;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.EntityMinecartChest;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFalling;
import net.minecraft.world.level.block.BlockMinecartTrack;
import net.minecraft.world.level.block.BlockTall;
import net.minecraft.world.level.block.BlockTorchWall;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockPropertyTrackPosition;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.WorldGenFeatureStructurePieceType;
import net.minecraft.world.level.levelgen.structure.structures.MineshaftStructure;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import org.bukkit.entity.EntityType;

public class MineshaftPieces {
    private static final int b = 3;
    private static final int c = 3;
    private static final int d = 5;
    private static final int e = 20;
    private static final int f = 50;
    private static final int g = 8;
    public static final int a = 50;

    private static c a(StructurePieceAccessor pieces, RandomSource random, int x2, int y2, int z2, @Nullable EnumDirection orientation, int genDepth, MineshaftStructure.a type) {
        int randomInt = random.a(100);
        if (randomInt >= 80) {
            StructureBoundingBox boundingBox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$b.a(pieces, random, x2, y2, z2, orientation);
            if (boundingBox != null) {
                return new b(genDepth, boundingBox, orientation, type);
            }
        } else if (randomInt >= 70) {
            StructureBoundingBox boundingBox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$e.a(pieces, random, x2, y2, z2, orientation);
            if (boundingBox != null) {
                return new e(genDepth, boundingBox, orientation, type);
            }
        } else {
            StructureBoundingBox boundingBox = net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(pieces, random, x2, y2, z2, orientation);
            if (boundingBox != null) {
                return new a(genDepth, random, boundingBox, orientation, type);
            }
        }
        return null;
    }

    static c a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random, int x2, int y2, int z2, EnumDirection direction, int genDepth) {
        if (genDepth > 8) {
            return null;
        }
        if (Math.abs(x2 - piece.f().h()) <= 80 && Math.abs(z2 - piece.f().j()) <= 80) {
            MineshaftStructure.a type = ((c)piece).a;
            c mineShaftPiece = MineshaftPieces.a(pieces, random, x2, y2, z2, direction, genDepth + 1, type);
            if (mineShaftPiece != null) {
                pieces.a(mineShaftPiece);
                mineShaftPiece.a(piece, pieces, random);
            }
            return mineShaftPiece;
        }
        return null;
    }

    public static class b
    extends c {
        private final EnumDirection b;
        private final boolean c;

        public b(NBTTagCompound tag) {
            super(WorldGenFeatureStructurePieceType.b, tag);
            this.c = tag.b("tf", false);
            this.b = tag.a("D", EnumDirection.l).orElse(EnumDirection.d);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
            super.a(context, tag);
            tag.a("tf", this.c);
            tag.a("D", EnumDirection.l, this.b);
        }

        public b(int genDepth, StructureBoundingBox boundingBox, @Nullable EnumDirection direction, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.b, genDepth, type, boundingBox);
            this.b = direction;
            this.c = boundingBox.e() > 3;
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor pieces, RandomSource random, int x2, int y2, int z2, EnumDirection direction) {
            int i2 = random.a(4) == 0 ? 6 : 2;
            StructureBoundingBox boundingBox = switch (direction) {
                default -> new StructureBoundingBox(-1, 0, -4, 3, i2, 0);
                case EnumDirection.d -> new StructureBoundingBox(-1, 0, 0, 3, i2, 4);
                case EnumDirection.e -> new StructureBoundingBox(-4, 0, -1, 0, i2, 3);
                case EnumDirection.f -> new StructureBoundingBox(0, 0, -1, 4, i2, 3);
            };
            boundingBox.a(x2, y2, z2);
            return pieces.a(boundingBox) != null ? null : boundingBox;
        }

        @Override
        public void a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            int genDepth = this.g();
            switch (this.b) {
                default: {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.j() - 1, EnumDirection.c, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i(), this.f.j() + 1, EnumDirection.e, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i(), this.f.j() + 1, EnumDirection.f, genDepth);
                    break;
                }
                case d: {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.m() + 1, EnumDirection.d, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i(), this.f.j() + 1, EnumDirection.e, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i(), this.f.j() + 1, EnumDirection.f, genDepth);
                    break;
                }
                case e: {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.j() - 1, EnumDirection.c, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.m() + 1, EnumDirection.d, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i(), this.f.j() + 1, EnumDirection.e, genDepth);
                    break;
                }
                case f: {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.j() - 1, EnumDirection.c, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i(), this.f.m() + 1, EnumDirection.d, genDepth);
                    MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i(), this.f.j() + 1, EnumDirection.f, genDepth);
                }
            }
            if (this.c) {
                if (random.h()) {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i() + 3 + 1, this.f.j() - 1, EnumDirection.c, genDepth);
                }
                if (random.h()) {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i() + 3 + 1, this.f.j() + 1, EnumDirection.e, genDepth);
                }
                if (random.h()) {
                    MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i() + 3 + 1, this.f.j() + 1, EnumDirection.f, genDepth);
                }
                if (random.h()) {
                    MineshaftPieces.a(piece, pieces, random, this.f.h() + 1, this.f.i() + 3 + 1, this.f.m() + 1, EnumDirection.d, genDepth);
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            if (!this.a(level, box)) {
                IBlockData planksState = this.a.d();
                if (this.c) {
                    this.a(level, box, this.f.h() + 1, this.f.i(), this.f.j(), this.f.k() - 1, this.f.i() + 3 - 1, this.f.m(), StructurePiece.e, StructurePiece.e, false);
                    this.a(level, box, this.f.h(), this.f.i(), this.f.j() + 1, this.f.k(), this.f.i() + 3 - 1, this.f.m() - 1, StructurePiece.e, StructurePiece.e, false);
                    this.a(level, box, this.f.h() + 1, this.f.l() - 2, this.f.j(), this.f.k() - 1, this.f.l(), this.f.m(), StructurePiece.e, StructurePiece.e, false);
                    this.a(level, box, this.f.h(), this.f.l() - 2, this.f.j() + 1, this.f.k(), this.f.l(), this.f.m() - 1, StructurePiece.e, StructurePiece.e, false);
                    this.a(level, box, this.f.h() + 1, this.f.i() + 3, this.f.j() + 1, this.f.k() - 1, this.f.i() + 3, this.f.m() - 1, StructurePiece.e, StructurePiece.e, false);
                } else {
                    this.a(level, box, this.f.h() + 1, this.f.i(), this.f.j(), this.f.k() - 1, this.f.l(), this.f.m(), StructurePiece.e, StructurePiece.e, false);
                    this.a(level, box, this.f.h(), this.f.i(), this.f.j() + 1, this.f.k(), this.f.l(), this.f.m() - 1, StructurePiece.e, StructurePiece.e, false);
                }
                this.a(level, box, this.f.h() + 1, this.f.i(), this.f.j() + 1, this.f.l());
                this.a(level, box, this.f.h() + 1, this.f.i(), this.f.m() - 1, this.f.l());
                this.a(level, box, this.f.k() - 1, this.f.i(), this.f.j() + 1, this.f.l());
                this.a(level, box, this.f.k() - 1, this.f.i(), this.f.m() - 1, this.f.l());
                int i2 = this.f.i() - 1;
                for (int x2 = this.f.h(); x2 <= this.f.k(); ++x2) {
                    for (int z2 = this.f.j(); z2 <= this.f.m(); ++z2) {
                        this.a(level, box, planksState, x2, i2, z2);
                    }
                }
            }
        }

        private void a(GeneratorAccessSeed level, StructureBoundingBox box, int x2, int y2, int z2, int maxY) {
            if (!this.a((IBlockAccess)level, x2, maxY + 1, z2, box).l()) {
                this.a(level, box, x2, y2, z2, x2, maxY, z2, this.a.d(), StructurePiece.e, false);
            }
        }
    }

    public static class e
    extends c {
        public e(int genDepth, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.d, genDepth, type, boundingBox);
            this.a(orientation);
        }

        public e(NBTTagCompound tag) {
            super(WorldGenFeatureStructurePieceType.d, tag);
        }

        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor pieces, RandomSource random, int x2, int y2, int z2, EnumDirection direction) {
            StructureBoundingBox boundingBox = switch (direction) {
                default -> new StructureBoundingBox(0, -5, -8, 2, 2, 0);
                case EnumDirection.d -> new StructureBoundingBox(0, -5, 0, 2, 2, 8);
                case EnumDirection.e -> new StructureBoundingBox(-8, -5, 0, 0, 2, 2);
                case EnumDirection.f -> new StructureBoundingBox(0, -5, 0, 8, 2, 2);
            };
            boundingBox.a(x2, y2, z2);
            return pieces.a(boundingBox) != null ? null : boundingBox;
        }

        @Override
        public void a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            int genDepth = this.g();
            EnumDirection orientation = this.i();
            if (orientation != null) {
                switch (orientation) {
                    default: {
                        MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i(), this.f.j() - 1, EnumDirection.c, genDepth);
                        break;
                    }
                    case d: {
                        MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i(), this.f.m() + 1, EnumDirection.d, genDepth);
                        break;
                    }
                    case e: {
                        MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i(), this.f.j(), EnumDirection.e, genDepth);
                        break;
                    }
                    case f: {
                        MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i(), this.f.j(), EnumDirection.f, genDepth);
                    }
                }
            }
        }

        @Override
        public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            if (!this.a(level, box)) {
                this.a(level, box, 0, 5, 0, 2, 7, 1, StructurePiece.e, StructurePiece.e, false);
                this.a(level, box, 0, 0, 7, 2, 2, 8, StructurePiece.e, StructurePiece.e, false);
                for (int i2 = 0; i2 < 5; ++i2) {
                    this.a(level, box, 0, 5 - i2 - (i2 < 4 ? 1 : 0), 2 + i2, 2, 7 - i2, 2 + i2, StructurePiece.e, StructurePiece.e, false);
                }
            }
        }
    }

    public static class a
    extends c {
        private final boolean b;
        private final boolean c;
        private boolean d;
        private final int h;

        public a(NBTTagCompound tag) {
            super(WorldGenFeatureStructurePieceType.a, tag);
            this.b = tag.b("hr", false);
            this.c = tag.b("sc", false);
            this.d = tag.b("hps", false);
            this.h = tag.b("Num", 0);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
            super.a(context, tag);
            tag.a("hr", this.b);
            tag.a("sc", this.c);
            tag.a("hps", this.d);
            tag.a("Num", this.h);
        }

        public a(int genDepth, RandomSource random, StructureBoundingBox boundingBox, EnumDirection orientation, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.a, genDepth, type, boundingBox);
            this.a(orientation);
            this.b = random.a(3) == 0;
            this.c = !this.b && random.a(23) == 0;
            this.h = this.i().o() == EnumDirection.EnumAxis.c ? boundingBox.f() / 5 : boundingBox.d() / 5;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public static StructureBoundingBox a(StructurePieceAccessor pieces, RandomSource random, int x2, int y2, int z2, EnumDirection direction) {
            int i2 = random.a(3) + 2;
            while (i2 > 0) {
                int i1 = i2 * 5;
                StructureBoundingBox boundingBox = switch (direction) {
                    default -> new StructureBoundingBox(0, 0, -(i1 - 1), 2, 2, 0);
                    case EnumDirection.d -> new StructureBoundingBox(0, 0, 0, 2, 2, i1 - 1);
                    case EnumDirection.e -> new StructureBoundingBox(-(i1 - 1), 0, 0, 0, 2, 2);
                    case EnumDirection.f -> new StructureBoundingBox(0, 0, 0, i1 - 1, 2, 2);
                };
                boundingBox.a(x2, y2, z2);
                if (pieces.a(boundingBox) == null) {
                    return boundingBox;
                }
                --i2;
            }
            return null;
        }

        @Override
        public void a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            block24: {
                int genDepth = this.g();
                int randomInt = random.a(4);
                EnumDirection orientation = this.i();
                if (orientation != null) {
                    switch (orientation) {
                        default: {
                            if (randomInt <= 1) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i() - 1 + random.a(3), this.f.j() - 1, orientation, genDepth);
                                break;
                            }
                            if (randomInt == 2) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i() - 1 + random.a(3), this.f.j(), EnumDirection.e, genDepth);
                                break;
                            }
                            MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i() - 1 + random.a(3), this.f.j(), EnumDirection.f, genDepth);
                            break;
                        }
                        case d: {
                            if (randomInt <= 1) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i() - 1 + random.a(3), this.f.m() + 1, orientation, genDepth);
                                break;
                            }
                            if (randomInt == 2) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i() - 1 + random.a(3), this.f.m() - 3, EnumDirection.e, genDepth);
                                break;
                            }
                            MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i() - 1 + random.a(3), this.f.m() - 3, EnumDirection.f, genDepth);
                            break;
                        }
                        case e: {
                            if (randomInt <= 1) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i() - 1 + random.a(3), this.f.j(), orientation, genDepth);
                                break;
                            }
                            if (randomInt == 2) {
                                MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i() - 1 + random.a(3), this.f.j() - 1, EnumDirection.c, genDepth);
                                break;
                            }
                            MineshaftPieces.a(piece, pieces, random, this.f.h(), this.f.i() - 1 + random.a(3), this.f.m() + 1, EnumDirection.d, genDepth);
                            break;
                        }
                        case f: {
                            if (randomInt <= 1) {
                                MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i() - 1 + random.a(3), this.f.j(), orientation, genDepth);
                                break;
                            }
                            if (randomInt == 2) {
                                MineshaftPieces.a(piece, pieces, random, this.f.k() - 3, this.f.i() - 1 + random.a(3), this.f.j() - 1, EnumDirection.c, genDepth);
                                break;
                            }
                            MineshaftPieces.a(piece, pieces, random, this.f.k() - 3, this.f.i() - 1 + random.a(3), this.f.m() + 1, EnumDirection.d, genDepth);
                        }
                    }
                }
                if (genDepth >= 8) break block24;
                if (orientation != EnumDirection.c && orientation != EnumDirection.d) {
                    int i2 = this.f.h() + 3;
                    while (i2 + 3 <= this.f.k()) {
                        int randomInt1 = random.a(5);
                        if (randomInt1 == 0) {
                            MineshaftPieces.a(piece, pieces, random, i2, this.f.i(), this.f.j() - 1, EnumDirection.c, genDepth + 1);
                        } else if (randomInt1 == 1) {
                            MineshaftPieces.a(piece, pieces, random, i2, this.f.i(), this.f.m() + 1, EnumDirection.d, genDepth + 1);
                        }
                        i2 += 5;
                    }
                } else {
                    int ix = this.f.j() + 3;
                    while (ix + 3 <= this.f.m()) {
                        int randomInt1 = random.a(5);
                        if (randomInt1 == 0) {
                            MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i(), ix, EnumDirection.e, genDepth + 1);
                        } else if (randomInt1 == 1) {
                            MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i(), ix, EnumDirection.f, genDepth + 1);
                        }
                        ix += 5;
                    }
                }
            }
        }

        @Override
        protected boolean a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, int x2, int y2, int z2, ResourceKey<LootTable> lootTable) {
            BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
            if (box.b(worldPos) && level.a_(worldPos).l() && !level.a_(worldPos.e()).l()) {
                IBlockData blockState = (IBlockData)Blocks.db.m().b(BlockMinecartTrack.c, random.h() ? BlockPropertyTrackPosition.a : BlockPropertyTrackPosition.b);
                this.a(level, blockState, x2, y2, z2, box);
                EntityMinecartChest minecartChest = EntityTypes.z.a(level.a(), EntitySpawnReason.b);
                if (minecartChest != null) {
                    minecartChest.p((double)worldPos.u() + 0.5, (double)worldPos.v() + 0.5, (double)worldPos.w() + 0.5);
                    minecartChest.a(lootTable, random.g());
                    level.b(minecartChest);
                }
                return true;
            }
            return false;
        }

        @Override
        public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            if (!this.a(level, box)) {
                int i6x;
                int i7;
                int i5;
                boolean i2 = false;
                int i1 = 2;
                boolean i22 = false;
                int i3 = 2;
                int i4 = this.h * 5 - 1;
                IBlockData planksState = this.a.d();
                this.a(level, box, 0, 0, 0, 2, 1, i4, StructurePiece.e, StructurePiece.e, false);
                this.a(level, box, random, 0.8f, 0, 2, 0, 2, 2, i4, StructurePiece.e, StructurePiece.e, false, false);
                if (this.c) {
                    this.a(level, box, random, 0.6f, 0, 0, 0, 2, 1, i4, Blocks.bz.m(), StructurePiece.e, false, true);
                }
                for (i5 = 0; i5 < this.h; ++i5) {
                    int i6 = 2 + i5 * 5;
                    this.a(level, box, 0, 0, i6, 2, 2, random);
                    this.a(level, box, random, 0.1f, 0, 2, i6 - 1);
                    this.a(level, box, random, 0.1f, 2, 2, i6 - 1);
                    this.a(level, box, random, 0.1f, 0, 2, i6 + 1);
                    this.a(level, box, random, 0.1f, 2, 2, i6 + 1);
                    this.a(level, box, random, 0.05f, 0, 2, i6 - 2);
                    this.a(level, box, random, 0.05f, 2, 2, i6 - 2);
                    this.a(level, box, random, 0.05f, 0, 2, i6 + 2);
                    this.a(level, box, random, 0.05f, 2, 2, i6 + 2);
                    if (random.a(100) == 0) {
                        this.a(level, box, random, 2, 0, i6 - 1, LootTables.t);
                    }
                    if (random.a(100) == 0) {
                        this.a(level, box, random, 0, 0, i6 + 1, LootTables.t);
                    }
                    if (!this.c || this.d) continue;
                    i7 = 1;
                    int i8 = i6 - 1 + random.a(3);
                    BlockPosition.MutableBlockPosition worldPos = this.b(1, 0, i8);
                    if (!box.b(worldPos) || !this.b(level, 1, 0, i8, box)) continue;
                    this.d = true;
                    this.placeCraftSpawner(level, worldPos, EntityType.CAVE_SPIDER, 2);
                }
                for (i5 = 0; i5 <= 2; ++i5) {
                    for (i6x = 0; i6x <= i4; ++i6x) {
                        this.a(level, box, planksState, i5, -1, i6x);
                    }
                }
                i5 = 2;
                this.a(level, box, 0, -1, 2);
                if (this.h > 1) {
                    i6x = i4 - 2;
                    this.a(level, box, 0, -1, i6x);
                }
                if (this.b) {
                    IBlockData blockState = (IBlockData)Blocks.db.m().b(BlockMinecartTrack.c, BlockPropertyTrackPosition.a);
                    for (i7 = 0; i7 <= i4; ++i7) {
                        IBlockData block = this.a((IBlockAccess)level, 1, -1, i7, box);
                        if (block.l() || !block.s()) continue;
                        float f2 = this.b(level, 1, 0, i7, box) ? 0.7f : 0.9f;
                        this.a(level, box, random, f2, 1, 0, i7, blockState);
                    }
                }
            }
        }

        private void a(GeneratorAccessSeed level, StructureBoundingBox box, int x2, int y2, int z2) {
            IBlockData woodState = this.a.b();
            IBlockData planksState = this.a.d();
            if (this.a((IBlockAccess)level, x2, y2, z2, box).a(planksState.b())) {
                this.c(level, woodState, x2, y2, z2, box);
            }
            if (this.a((IBlockAccess)level, x2 + 2, y2, z2, box).a(planksState.b())) {
                this.c(level, woodState, x2 + 2, y2, z2, box);
            }
        }

        @Override
        protected void b(GeneratorAccessSeed level, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
            if (box.b(worldPos)) {
                int y1 = worldPos.v();
                while (this.a(level.a_(worldPos)) && worldPos.v() > level.K_() + 1) {
                    worldPos.c(EnumDirection.a);
                }
                if (this.a(level, worldPos, level.a_(worldPos))) {
                    while (worldPos.v() < y1) {
                        worldPos.c(EnumDirection.b);
                        level.a((BlockPosition)worldPos, state, 2);
                    }
                }
            }
        }

        protected void c(GeneratorAccessSeed level, IBlockData state, int x2, int y2, int z2, StructureBoundingBox box) {
            BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
            if (box.b(worldPos)) {
                int y1 = worldPos.v();
                int i2 = 1;
                boolean flag = true;
                boolean flag1 = true;
                while (flag || flag1) {
                    boolean flag2;
                    IBlockData blockState;
                    if (flag) {
                        worldPos.q(y1 - i2);
                        blockState = level.a_(worldPos);
                        boolean bl = flag2 = this.a(blockState) && !blockState.a(Blocks.K);
                        if (!flag2 && this.a(level, worldPos, blockState)) {
                            net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(level, state, worldPos, y1 - i2 + 1, y1);
                            return;
                        }
                        boolean bl2 = flag = i2 <= 20 && flag2 && worldPos.v() > level.K_() + 1;
                    }
                    if (flag1) {
                        worldPos.q(y1 + i2);
                        blockState = level.a_(worldPos);
                        flag2 = this.a(blockState);
                        if (!flag2 && this.b(level, worldPos, blockState)) {
                            level.a((BlockPosition)worldPos.q(y1 + 1), this.a.e(), 2);
                            net.minecraft.world.level.levelgen.structure.structures.MineshaftPieces$a.a(level, Blocks.fp.m(), worldPos, y1 + 2, y1 + i2);
                            return;
                        }
                        flag1 = i2 <= 50 && flag2 && worldPos.v() < level.ao();
                    }
                    ++i2;
                }
            }
        }

        private static void a(GeneratorAccessSeed level, IBlockData state, BlockPosition.MutableBlockPosition pos, int minY, int maxY) {
            for (int i2 = minY; i2 < maxY; ++i2) {
                level.a((BlockPosition)pos.q(i2), state, 2);
            }
        }

        private boolean a(IWorldReader level, BlockPosition pos, IBlockData state) {
            return state.c((IBlockAccess)level, pos, EnumDirection.b);
        }

        private boolean b(IWorldReader level, BlockPosition pos, IBlockData state) {
            return Block.a(level, pos, EnumDirection.a) && !(state.b() instanceof BlockFalling);
        }

        private void a(GeneratorAccessSeed level, StructureBoundingBox box, int minX, int minY, int z2, int maxY, int maxX, RandomSource random) {
            if (this.a((IBlockAccess)level, box, minX, maxX, maxY, z2)) {
                IBlockData planksState = this.a.d();
                IBlockData fenceState = this.a.e();
                this.a(level, box, minX, minY, z2, minX, maxY - 1, z2, (IBlockData)fenceState.b(BlockTall.d, true), StructurePiece.e, false);
                this.a(level, box, maxX, minY, z2, maxX, maxY - 1, z2, (IBlockData)fenceState.b(BlockTall.b, true), StructurePiece.e, false);
                if (random.a(4) == 0) {
                    this.a(level, box, minX, maxY, z2, minX, maxY, z2, planksState, StructurePiece.e, false);
                    this.a(level, box, maxX, maxY, z2, maxX, maxY, z2, planksState, StructurePiece.e, false);
                } else {
                    this.a(level, box, minX, maxY, z2, maxX, maxY, z2, planksState, StructurePiece.e, false);
                    this.a(level, box, random, 0.05f, minX + 1, maxY, z2 - 1, (IBlockData)Blocks.cA.m().b(BlockTorchWall.e, EnumDirection.d));
                    this.a(level, box, random, 0.05f, minX + 1, maxY, z2 + 1, (IBlockData)Blocks.cA.m().b(BlockTorchWall.e, EnumDirection.c));
                }
            }
        }

        private void a(GeneratorAccessSeed level, StructureBoundingBox box, RandomSource random, float chance, int x2, int y2, int z2) {
            if (this.b(level, x2, y2, z2, box) && random.i() < chance && this.a(level, box, x2, y2, z2, 2)) {
                this.a(level, Blocks.bz.m(), x2, y2, z2, box);
            }
        }

        private boolean a(GeneratorAccessSeed level, StructureBoundingBox box, int x2, int y2, int z2, int required) {
            BlockPosition.MutableBlockPosition worldPos = this.b(x2, y2, z2);
            int i2 = 0;
            for (EnumDirection direction : EnumDirection.values()) {
                worldPos.c(direction);
                if (box.b(worldPos) && level.a_(worldPos).c((IBlockAccess)level, (BlockPosition)worldPos, direction.g()) && ++i2 >= required) {
                    return true;
                }
                worldPos.c(direction.g());
            }
            return false;
        }
    }

    static abstract class c
    extends StructurePiece {
        protected MineshaftStructure.a a;

        public c(WorldGenFeatureStructurePieceType structurePieceType, int genDepth, MineshaftStructure.a type, StructureBoundingBox boundingBox) {
            super(structurePieceType, genDepth, boundingBox);
            this.a = type;
        }

        public c(WorldGenFeatureStructurePieceType type, NBTTagCompound tag) {
            super(type, tag);
            this.a = MineshaftStructure.a.a(tag.b("MST", 0));
        }

        @Override
        protected boolean a(IWorldReader level, int x2, int y2, int z2, StructureBoundingBox box) {
            IBlockData block = this.a((IBlockAccess)level, x2, y2, z2, box);
            return !block.a(this.a.d().b()) && !block.a(this.a.b().b()) && !block.a(this.a.e().b()) && !block.a(Blocks.fp);
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
            tag.a("MST", this.a.ordinal());
        }

        protected boolean a(IBlockAccess level, StructureBoundingBox box, int xStart, int xEnd, int y2, int z2) {
            for (int i2 = xStart; i2 <= xEnd; ++i2) {
                if (!this.a(level, i2, y2 + 1, z2, box).l()) continue;
                return false;
            }
            return true;
        }

        protected boolean a(GeneratorAccess level, StructureBoundingBox boundingBox) {
            int i1;
            int i2;
            int min2;
            int min1;
            int max = Math.max(this.f.h() - 1, boundingBox.h());
            int max1 = Math.max(this.f.i() - 1, boundingBox.i());
            int max2 = Math.max(this.f.j() - 1, boundingBox.j());
            int min = Math.min(this.f.k() + 1, boundingBox.k());
            BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition((max + min) / 2, (max1 + (min1 = Math.min(this.f.l() + 1, boundingBox.l()))) / 2, (max2 + (min2 = Math.min(this.f.m() + 1, boundingBox.m()))) / 2);
            if (level.u(mutableBlockPos).a(BiomeTags.Y)) {
                return true;
            }
            for (i2 = max; i2 <= min; ++i2) {
                for (i1 = max2; i1 <= min2; ++i1) {
                    if (level.a_(mutableBlockPos.d(i2, max1, i1)).n()) {
                        return true;
                    }
                    if (!level.a_(mutableBlockPos.d(i2, min1, i1)).n()) continue;
                    return true;
                }
            }
            for (i2 = max; i2 <= min; ++i2) {
                for (i1 = max1; i1 <= min1; ++i1) {
                    if (level.a_(mutableBlockPos.d(i2, i1, max2)).n()) {
                        return true;
                    }
                    if (!level.a_(mutableBlockPos.d(i2, i1, min2)).n()) continue;
                    return true;
                }
            }
            for (i2 = max2; i2 <= min2; ++i2) {
                for (i1 = max1; i1 <= min1; ++i1) {
                    if (level.a_(mutableBlockPos.d(max, i1, i2)).n()) {
                        return true;
                    }
                    if (!level.a_(mutableBlockPos.d(min, i1, i2)).n()) continue;
                    return true;
                }
            }
            return false;
        }

        protected void a(GeneratorAccessSeed level, StructureBoundingBox box, IBlockData plankState, int x2, int y2, int z2) {
            BlockPosition.MutableBlockPosition worldPos;
            IBlockData blockState;
            if (this.b(level, x2, y2, z2, box) && !(blockState = level.a_(worldPos = this.b(x2, y2, z2))).c((IBlockAccess)level, (BlockPosition)worldPos, EnumDirection.b)) {
                level.a((BlockPosition)worldPos, plankState, 2);
            }
        }
    }

    public static class d
    extends c {
        private final List<StructureBoundingBox> b = Lists.newLinkedList();

        public d(int genDepth, RandomSource random, int x2, int z2, MineshaftStructure.a type) {
            super(WorldGenFeatureStructurePieceType.c, genDepth, type, new StructureBoundingBox(x2, 50, z2, x2 + 7 + random.a(6), 54 + random.a(6), z2 + 7 + random.a(6)));
            this.a = type;
        }

        public d(NBTTagCompound tag) {
            super(WorldGenFeatureStructurePieceType.c, tag);
            this.b.addAll(tag.a("Entrances", StructureBoundingBox.a.listOf()).orElse(List.of()));
        }

        @Override
        public void a(StructurePiece piece, StructurePieceAccessor pieces, RandomSource random) {
            StructureBoundingBox boundingBox;
            c mineShaftPiece;
            int i1;
            int genDepth = this.g();
            int i2 = this.f.e() - 3 - 1;
            if (i2 <= 0) {
                i2 = 1;
            }
            for (i1 = 0; i1 < this.f.d() && (i1 += random.a(this.f.d())) + 3 <= this.f.d(); i1 += 4) {
                mineShaftPiece = MineshaftPieces.a(piece, pieces, random, this.f.h() + i1, this.f.i() + random.a(i2) + 1, this.f.j() - 1, EnumDirection.c, genDepth);
                if (mineShaftPiece == null) continue;
                boundingBox = mineShaftPiece.f();
                this.b.add(new StructureBoundingBox(boundingBox.h(), boundingBox.i(), this.f.j(), boundingBox.k(), boundingBox.l(), this.f.j() + 1));
            }
            for (i1 = 0; i1 < this.f.d() && (i1 += random.a(this.f.d())) + 3 <= this.f.d(); i1 += 4) {
                mineShaftPiece = MineshaftPieces.a(piece, pieces, random, this.f.h() + i1, this.f.i() + random.a(i2) + 1, this.f.m() + 1, EnumDirection.d, genDepth);
                if (mineShaftPiece == null) continue;
                boundingBox = mineShaftPiece.f();
                this.b.add(new StructureBoundingBox(boundingBox.h(), boundingBox.i(), this.f.m() - 1, boundingBox.k(), boundingBox.l(), this.f.m()));
            }
            for (i1 = 0; i1 < this.f.f() && (i1 += random.a(this.f.f())) + 3 <= this.f.f(); i1 += 4) {
                mineShaftPiece = MineshaftPieces.a(piece, pieces, random, this.f.h() - 1, this.f.i() + random.a(i2) + 1, this.f.j() + i1, EnumDirection.e, genDepth);
                if (mineShaftPiece == null) continue;
                boundingBox = mineShaftPiece.f();
                this.b.add(new StructureBoundingBox(this.f.h(), boundingBox.i(), boundingBox.j(), this.f.h() + 1, boundingBox.l(), boundingBox.m()));
            }
            for (i1 = 0; i1 < this.f.f() && (i1 += random.a(this.f.f())) + 3 <= this.f.f(); i1 += 4) {
                c structurePiece = MineshaftPieces.a(piece, pieces, random, this.f.k() + 1, this.f.i() + random.a(i2) + 1, this.f.j() + i1, EnumDirection.f, genDepth);
                if (structurePiece == null) continue;
                boundingBox = structurePiece.f();
                this.b.add(new StructureBoundingBox(this.f.k() - 1, boundingBox.i(), boundingBox.j(), this.f.k(), boundingBox.l(), boundingBox.m()));
            }
        }

        @Override
        public void a(GeneratorAccessSeed level, StructureManager structureManager, ChunkGenerator generator, RandomSource random, StructureBoundingBox box, ChunkCoordIntPair chunkPos, BlockPosition pos) {
            if (!this.a(level, box)) {
                this.a(level, box, this.f.h(), this.f.i() + 1, this.f.j(), this.f.k(), Math.min(this.f.i() + 3, this.f.l()), this.f.m(), StructurePiece.e, StructurePiece.e, false);
                for (StructureBoundingBox boundingBox : this.b) {
                    this.a(level, box, boundingBox.h(), boundingBox.l() - 2, boundingBox.j(), boundingBox.k(), boundingBox.l(), boundingBox.m(), StructurePiece.e, StructurePiece.e, false);
                }
                this.a(level, box, this.f.h(), this.f.i() + 4, this.f.j(), this.f.k(), this.f.l(), this.f.m(), StructurePiece.e, false);
            }
        }

        @Override
        public void a(int x2, int y2, int z2) {
            super.a(x2, y2, z2);
            for (StructureBoundingBox boundingBox : this.b) {
                boundingBox.a(x2, y2, z2);
            }
        }

        @Override
        protected void a(StructurePieceSerializationContext context, NBTTagCompound tag) {
            super.a(context, tag);
            tag.a("Entrances", StructureBoundingBox.a.listOf(), this.b);
        }
    }
}

