/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.templatesystem;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.RegistryBlockID;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.BlockAccessAir;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockJigsaw;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessor;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockEntityState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockState;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftBlockStates;
import org.bukkit.craftbukkit.v1_21_R4.block.CraftLootable;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataContainer;
import org.bukkit.craftbukkit.v1_21_R4.persistence.CraftPersistentDataTypeRegistry;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftStructureTransformer;
import org.bukkit.craftbukkit.v1_21_R4.util.TransformerGeneratorAccess;

public class DefinedStructure {
    public static final String a = "palette";
    public static final String b = "palettes";
    public static final String c = "entities";
    public static final String d = "blocks";
    public static final String e = "pos";
    public static final String f = "state";
    public static final String g = "nbt";
    public static final String h = "pos";
    public static final String i = "blockPos";
    public static final String j = "nbt";
    public static final String k = "size";
    public final List<b> l = Lists.newArrayList();
    public final List<EntityInfo> m = Lists.newArrayList();
    private BaseBlockPosition n = BaseBlockPosition.i;
    private String o = "?";
    private static final CraftPersistentDataTypeRegistry DATA_TYPE_REGISTRY = new CraftPersistentDataTypeRegistry();
    public CraftPersistentDataContainer persistentDataContainer = new CraftPersistentDataContainer(DATA_TYPE_REGISTRY);

    public BaseBlockPosition a() {
        return this.n;
    }

    public void a(String author) {
        this.o = author;
    }

    public String b() {
        return this.o;
    }

    public void a(World level, BlockPosition pos, BaseBlockPosition size, boolean withEntities, @Nullable Block toIgnore) {
        if (size.u() >= 1 && size.v() >= 1 && size.w() >= 1) {
            BlockPosition blockPos = pos.a(size).b(-1, -1, -1);
            ArrayList list = Lists.newArrayList();
            ArrayList list1 = Lists.newArrayList();
            ArrayList list2 = Lists.newArrayList();
            BlockPosition blockPos1 = new BlockPosition(Math.min(pos.u(), blockPos.u()), Math.min(pos.v(), blockPos.v()), Math.min(pos.w(), blockPos.w()));
            BlockPosition blockPos2 = new BlockPosition(Math.max(pos.u(), blockPos.u()), Math.max(pos.v(), blockPos.v()), Math.max(pos.w(), blockPos.w()));
            this.n = size;
            for (BlockPosition blockPos3 : BlockPosition.c(blockPos1, blockPos2)) {
                BlockPosition blockPos4 = blockPos3.b(blockPos1);
                IBlockData blockState = level.a_(blockPos3);
                if (toIgnore != null && blockState.a(toIgnore)) continue;
                TileEntity blockEntity = level.c_(blockPos3);
                BlockInfo structureBlockInfo = blockEntity != null ? new BlockInfo(blockPos4, blockState, blockEntity.c(level.J_())) : new BlockInfo(blockPos4, blockState, null);
                DefinedStructure.a(structureBlockInfo, list, list1, list2);
            }
            List<BlockInfo> list3 = DefinedStructure.a(list, list1, list2);
            this.l.clear();
            this.l.add(new b(list3));
            if (withEntities) {
                this.a(level, blockPos1, blockPos2);
            } else {
                this.m.clear();
            }
        }
    }

    private static void a(BlockInfo blockInfo, List<BlockInfo> normalBlocks, List<BlockInfo> blocksWithNbt, List<BlockInfo> blocksWithSpecialShape) {
        if (blockInfo.c != null) {
            blocksWithNbt.add(blockInfo);
        } else if (!blockInfo.b.b().n() && blockInfo.b.m(BlockAccessAir.a, BlockPosition.c)) {
            normalBlocks.add(blockInfo);
        } else {
            blocksWithSpecialShape.add(blockInfo);
        }
    }

    private static List<BlockInfo> a(List<BlockInfo> normalBlocks, List<BlockInfo> blocksWithNbt, List<BlockInfo> blocksWithSpecialShape) {
        Comparator<BlockInfo> comparator = Comparator.comparingInt(structureBlockInfo -> structureBlockInfo.a.v()).thenComparingInt(structureBlockInfo -> structureBlockInfo.a.u()).thenComparingInt(structureBlockInfo -> structureBlockInfo.a.w());
        normalBlocks.sort(comparator);
        blocksWithSpecialShape.sort(comparator);
        blocksWithNbt.sort(comparator);
        ArrayList list = Lists.newArrayList();
        list.addAll(normalBlocks);
        list.addAll(blocksWithSpecialShape);
        list.addAll(blocksWithNbt);
        return list;
    }

    private void a(World level, BlockPosition startPos, BlockPosition endPos) {
        List<Entity> entitiesOfClass = level.a(Entity.class, AxisAlignedBB.a(startPos, endPos), (? super T entity1) -> !(entity1 instanceof EntityHuman));
        this.m.clear();
        for (Entity entity : entitiesOfClass) {
            Vec3D vec3 = new Vec3D(entity.dA() - (double)startPos.u(), entity.dC() - (double)startPos.v(), entity.dG() - (double)startPos.w());
            NBTTagCompound compoundTag = new NBTTagCompound();
            entity.g(compoundTag);
            BlockPosition blockPos = entity instanceof EntityPainting ? ((EntityPainting)entity).i().b(startPos) : BlockPosition.a(vec3);
            this.m.add(new EntityInfo(vec3, blockPos, compoundTag.l()));
        }
    }

    public List<BlockInfo> a(BlockPosition pos, DefinedStructureInfo settings, Block block) {
        return this.a(pos, settings, block, true);
    }

    public List<a> a(BlockPosition pos, EnumBlockRotation rotation) {
        if (this.l.isEmpty()) {
            return new ArrayList<a>();
        }
        DefinedStructureInfo structurePlaceSettings = new DefinedStructureInfo().a(rotation);
        List<a> list = structurePlaceSettings.a(this.l, pos).a();
        ArrayList<a> list1 = new ArrayList<a>(list.size());
        for (a jigsawBlockInfo : list) {
            BlockInfo structureBlockInfo = jigsawBlockInfo.a;
            list1.add(jigsawBlockInfo.b(new BlockInfo(DefinedStructure.a(structurePlaceSettings, structureBlockInfo.a()).a(pos), structureBlockInfo.b.a(structurePlaceSettings.d()), structureBlockInfo.c)));
        }
        return list1;
    }

    public ObjectArrayList<BlockInfo> a(BlockPosition pos, DefinedStructureInfo settings, Block block, boolean relativePosition) {
        ObjectArrayList list = new ObjectArrayList();
        StructureBoundingBox boundingBox = settings.g();
        if (this.l.isEmpty()) {
            return list;
        }
        for (BlockInfo structureBlockInfo : settings.a(this.l, pos).a(block)) {
            BlockPosition blockPos;
            BlockPosition blockPosition = blockPos = relativePosition ? DefinedStructure.a(settings, structureBlockInfo.a).a(pos) : structureBlockInfo.a;
            if (boundingBox != null && !boundingBox.b(blockPos)) continue;
            list.add((Object)new BlockInfo(blockPos, structureBlockInfo.b.a(settings.d()), structureBlockInfo.c));
        }
        return list;
    }

    public BlockPosition a(DefinedStructureInfo decorator, BlockPosition start, DefinedStructureInfo settings, BlockPosition end) {
        BlockPosition blockPos = DefinedStructure.a(decorator, start);
        BlockPosition blockPos1 = DefinedStructure.a(settings, end);
        return blockPos.b(blockPos1);
    }

    public static BlockPosition a(DefinedStructureInfo decorator, BlockPosition pos) {
        return DefinedStructure.a(pos, decorator.c(), decorator.d(), decorator.e());
    }

    public boolean a(WorldAccess serverLevel, BlockPosition offset, BlockPosition pos, DefinedStructureInfo settings, RandomSource random, int flags) {
        List<BlockInfo> list;
        if (this.l.isEmpty()) {
            return false;
        }
        WorldAccess wrappedAccess = serverLevel;
        CraftStructureTransformer structureTransformer = null;
        if (wrappedAccess instanceof TransformerGeneratorAccess) {
            TransformerGeneratorAccess transformerAccess = (TransformerGeneratorAccess)wrappedAccess;
            serverLevel = transformerAccess.getDelegate();
            structureTransformer = transformerAccess.getStructureTransformer();
            if (structureTransformer != null && !structureTransformer.canTransformBlocks()) {
                structureTransformer = null;
            }
        }
        if (!((list = settings.a(this.l, offset).b()).isEmpty() && (settings.f() || this.m.isEmpty()) || this.n.u() < 1 || this.n.v() < 1 || this.n.w() < 1)) {
            StructureBoundingBox boundingBox = settings.g();
            ArrayList list1 = Lists.newArrayListWithCapacity((int)(settings.j() ? list.size() : 0));
            ArrayList list2 = Lists.newArrayListWithCapacity((int)(settings.j() ? list.size() : 0));
            ArrayList list3 = Lists.newArrayListWithCapacity((int)list.size());
            int i2 = Integer.MAX_VALUE;
            int i1 = Integer.MAX_VALUE;
            int i22 = Integer.MAX_VALUE;
            int i3 = Integer.MIN_VALUE;
            int i4 = Integer.MIN_VALUE;
            int i5 = Integer.MIN_VALUE;
            for (BlockInfo structureBlockInfo : DefinedStructure.a(serverLevel, offset, pos, settings, list)) {
                TileEntity blockEntity;
                BlockPosition blockPos = structureBlockInfo.a;
                if (boundingBox != null && !boundingBox.b(blockPos)) continue;
                Fluid fluidState = settings.j() ? serverLevel.b_(blockPos) : null;
                IBlockData blockState = structureBlockInfo.b.a(settings.c()).a(settings.d());
                if (structureBlockInfo.c != null) {
                    serverLevel.a(blockPos, Blocks.iy.m(), 820);
                }
                if (structureTransformer != null) {
                    NBTTagCompound nBTTagCompound;
                    CraftBlockState craftBlockState = (CraftBlockState)CraftBlockStates.getBlockState((IWorldReader)serverLevel, blockPos, blockState, null);
                    if (structureBlockInfo.c != null && craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState entityState = (CraftBlockEntityState)craftBlockState;
                        entityState.loadData(structureBlockInfo.c);
                        if (craftBlockState instanceof CraftLootable) {
                            CraftLootable craftLootable = (CraftLootable)craftBlockState;
                            craftLootable.setSeed(random.g());
                        }
                    }
                    craftBlockState = structureTransformer.transformCraftState(craftBlockState);
                    blockState = craftBlockState.getHandle();
                    if (craftBlockState instanceof CraftBlockEntityState) {
                        CraftBlockEntityState craftBlockEntityState = (CraftBlockEntityState)craftBlockState;
                        nBTTagCompound = craftBlockEntityState.getSnapshotNBT();
                    } else {
                        nBTTagCompound = null;
                    }
                    structureBlockInfo = new BlockInfo(blockPos, blockState, nBTTagCompound);
                }
                if (!serverLevel.a(blockPos, blockState, flags)) continue;
                i2 = Math.min(i2, blockPos.u());
                i1 = Math.min(i1, blockPos.v());
                i22 = Math.min(i22, blockPos.w());
                i3 = Math.max(i3, blockPos.u());
                i4 = Math.max(i4, blockPos.v());
                i5 = Math.max(i5, blockPos.w());
                list3.add(Pair.of((Object)blockPos, (Object)structureBlockInfo.c));
                if (structureBlockInfo.c != null && (blockEntity = serverLevel.c_(blockPos)) != null) {
                    if (structureTransformer == null && blockEntity instanceof RandomizableContainer) {
                        structureBlockInfo.c.a("LootTableSeed", random.g());
                    }
                    blockEntity.c(structureBlockInfo.c, serverLevel.J_());
                }
                if (fluidState == null) continue;
                if (blockState.y().b()) {
                    list2.add(blockPos);
                    continue;
                }
                if (!(blockState.b() instanceof IFluidContainer)) continue;
                ((IFluidContainer)((Object)blockState.b())).a(serverLevel, blockPos, blockState, fluidState);
                if (fluidState.b()) continue;
                list1.add(blockPos);
            }
            boolean flag = true;
            EnumDirection[] directions = new EnumDirection[]{EnumDirection.b, EnumDirection.c, EnumDirection.f, EnumDirection.d, EnumDirection.e};
            while (flag && !list1.isEmpty()) {
                flag = false;
                Iterator iterator = list1.iterator();
                while (iterator.hasNext()) {
                    IBlockData blockState1;
                    Object block;
                    BlockPosition blockPos1 = (BlockPosition)iterator.next();
                    Fluid fluidState1 = serverLevel.b_(blockPos1);
                    for (int i6 = 0; i6 < directions.length && !fluidState1.b(); ++i6) {
                        BlockPosition blockPos2 = blockPos1.a(directions[i6]);
                        Fluid fluidState2 = serverLevel.b_(blockPos2);
                        if (!fluidState2.b() || list2.contains(blockPos2)) continue;
                        fluidState1 = fluidState2;
                    }
                    if (!fluidState1.b() || !((block = (blockState1 = serverLevel.a_(blockPos1)).b()) instanceof IFluidContainer)) continue;
                    ((IFluidContainer)block).a(serverLevel, blockPos1, blockState1, fluidState1);
                    flag = true;
                    iterator.remove();
                }
            }
            if (i2 <= i3) {
                if (!settings.h()) {
                    VoxelShapeBitSet discreteVoxelShape = new VoxelShapeBitSet(i3 - i2 + 1, i4 - i1 + 1, i5 - i22 + 1);
                    int i7 = i2;
                    int i8 = i1;
                    int i6x = i22;
                    for (Pair pair : list3) {
                        BlockPosition blockPos3 = (BlockPosition)pair.getFirst();
                        ((VoxelShapeDiscrete)discreteVoxelShape).c(blockPos3.u() - i7, blockPos3.v() - i8, blockPos3.w() - i6x);
                    }
                    DefinedStructure.a(serverLevel, flags, discreteVoxelShape, i7, i8, i6x);
                }
                for (Pair pair1 : list3) {
                    TileEntity blockEntity;
                    BlockPosition blockPos4 = (BlockPosition)pair1.getFirst();
                    if (!settings.h()) {
                        IBlockData blockState2;
                        IBlockData blockState1 = serverLevel.a_(blockPos4);
                        if (blockState1 != (blockState2 = Block.b(blockState1, serverLevel, blockPos4))) {
                            serverLevel.a(blockPos4, blockState2, flags & 0xFFFFFFFE | 0x10);
                        }
                        serverLevel.a(blockPos4, blockState2.b());
                    }
                    if (pair1.getSecond() == null || (blockEntity = serverLevel.c_(blockPos4)) == null || serverLevel instanceof GeneratorAccessSeed) continue;
                    blockEntity.e();
                }
            }
            if (!settings.f()) {
                this.a(wrappedAccess, offset, settings.c(), settings.d(), settings.e(), boundingBox, settings.k());
            }
            return true;
        }
        return false;
    }

    public static void a(GeneratorAccess level, int flags, VoxelShapeDiscrete shape, BlockPosition pos) {
        DefinedStructure.a(level, flags, shape, pos.u(), pos.v(), pos.w());
    }

    public static void a(GeneratorAccess level, int flags, VoxelShapeDiscrete shape, int x2, int y2, int z2) {
        BlockPosition.MutableBlockPosition mutableBlockPos = new BlockPosition.MutableBlockPosition();
        BlockPosition.MutableBlockPosition mutableBlockPos1 = new BlockPosition.MutableBlockPosition();
        shape.a((EnumDirection direction, int faceX, int faceY, int faceZ) -> {
            IBlockData blockState3;
            mutableBlockPos.d(x2 + faceX, y2 + faceY, z2 + faceZ);
            mutableBlockPos1.a((BaseBlockPosition)mutableBlockPos, direction);
            IBlockData blockState = level.a_(mutableBlockPos);
            IBlockData blockState1 = level.a_(mutableBlockPos1);
            IBlockData blockState2 = blockState.a(level, level, mutableBlockPos, direction, mutableBlockPos1, blockState1, level.G_());
            if (blockState != blockState2) {
                level.a((BlockPosition)mutableBlockPos, blockState2, flags & 0xFFFFFFFE);
            }
            if (blockState1 != (blockState3 = blockState1.a(level, level, mutableBlockPos1, direction.g(), mutableBlockPos, blockState2, level.G_()))) {
                level.a((BlockPosition)mutableBlockPos1, blockState3, flags & 0xFFFFFFFE);
            }
        });
    }

    public static List<BlockInfo> a(WorldAccess serverLevel, BlockPosition offset, BlockPosition pos, DefinedStructureInfo settings, List<BlockInfo> blockInfos) {
        ArrayList<BlockInfo> list = new ArrayList<BlockInfo>();
        List<BlockInfo> list1 = new ArrayList<BlockInfo>();
        for (BlockInfo structureBlockInfo : blockInfos) {
            BlockPosition blockPos = DefinedStructure.a(settings, structureBlockInfo.a).a(offset);
            BlockInfo structureBlockInfo1 = new BlockInfo(blockPos, structureBlockInfo.b, structureBlockInfo.c != null ? structureBlockInfo.c.l() : null);
            Iterator<DefinedStructureProcessor> iterator = settings.i().iterator();
            while (structureBlockInfo1 != null && iterator.hasNext()) {
                structureBlockInfo1 = iterator.next().a((IWorldReader)serverLevel, offset, pos, structureBlockInfo, structureBlockInfo1, settings);
            }
            if (structureBlockInfo1 == null) continue;
            list1.add(structureBlockInfo1);
            list.add(structureBlockInfo);
        }
        for (DefinedStructureProcessor structureProcessor : settings.i()) {
            list1 = structureProcessor.a(serverLevel, offset, pos, list, list1, settings);
        }
        return list1;
    }

    private void a(WorldAccess serverLevel, BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition offset, @Nullable StructureBoundingBox boundingBox, boolean withEntities) {
        for (EntityInfo structureEntityInfo : this.m) {
            BlockPosition blockPos = DefinedStructure.a(structureEntityInfo.b, mirror, rotation, offset).a(pos);
            if (boundingBox != null && !boundingBox.b(blockPos)) continue;
            NBTTagCompound compoundTag = structureEntityInfo.c.l();
            Vec3D vec3 = DefinedStructure.a(structureEntityInfo.a, mirror, rotation, offset);
            Vec3D vec31 = vec3.b(pos.u(), pos.v(), pos.w());
            NBTTagList listTag = new NBTTagList();
            listTag.add(NBTTagDouble.a(vec31.d));
            listTag.add(NBTTagDouble.a(vec31.e));
            listTag.add(NBTTagDouble.a(vec31.f));
            compoundTag.a("Pos", listTag);
            compoundTag.r("UUID");
            DefinedStructure.a(serverLevel, compoundTag).ifPresent(entity -> {
                float f2 = entity.a(rotation);
                entity.b(vec31.d, vec31.e, vec31.f, f2 += entity.a(mirror) - entity.dL(), entity.dN());
                if (withEntities && entity instanceof EntityInsentient) {
                    ((EntityInsentient)entity).a(serverLevel, serverLevel.d_(BlockPosition.a(vec31)), EntitySpawnReason.d, null);
                }
                serverLevel.a_((Entity)entity);
            });
        }
    }

    private static Optional<Entity> a(WorldAccess level, NBTTagCompound tag) {
        return EntityTypes.create(tag, level.a(), EntitySpawnReason.d, true);
    }

    public BaseBlockPosition a(EnumBlockRotation rotation) {
        switch (rotation) {
            case d: 
            case b: {
                return new BaseBlockPosition(this.n.w(), this.n.v(), this.n.u());
            }
        }
        return this.n;
    }

    public static BlockPosition a(BlockPosition targetPos, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition offset) {
        int x2 = targetPos.u();
        int y2 = targetPos.v();
        int z2 = targetPos.w();
        boolean flag = true;
        switch (mirror) {
            case b: {
                z2 = -z2;
                break;
            }
            case c: {
                x2 = -x2;
                break;
            }
            default: {
                flag = false;
            }
        }
        int x1 = offset.u();
        int z1 = offset.w();
        switch (rotation) {
            case d: {
                return new BlockPosition(x1 - z1 + z2, y2, x1 + z1 - x2);
            }
            case b: {
                return new BlockPosition(x1 + z1 - z2, y2, z1 - x1 + x2);
            }
            case c: {
                return new BlockPosition(x1 + x1 - x2, y2, z1 + z1 - z2);
            }
        }
        return flag ? new BlockPosition(x2, y2, z2) : targetPos;
    }

    public static Vec3D a(Vec3D target, EnumBlockMirror mirror, EnumBlockRotation rotation, BlockPosition centerOffset) {
        double d2 = target.d;
        double d1 = target.e;
        double d22 = target.f;
        boolean flag = true;
        switch (mirror) {
            case b: {
                d22 = 1.0 - d22;
                break;
            }
            case c: {
                d2 = 1.0 - d2;
                break;
            }
            default: {
                flag = false;
            }
        }
        int x2 = centerOffset.u();
        int z2 = centerOffset.w();
        switch (rotation) {
            case d: {
                return new Vec3D((double)(x2 - z2) + d22, d1, (double)(x2 + z2 + 1) - d2);
            }
            case b: {
                return new Vec3D((double)(x2 + z2 + 1) - d22, d1, (double)(z2 - x2) + d2);
            }
            case c: {
                return new Vec3D((double)(x2 + x2 + 1) - d2, d1, (double)(z2 + z2 + 1) - d22);
            }
        }
        return flag ? new Vec3D(d2, d1, d22) : target;
    }

    public BlockPosition a(BlockPosition targetPos, EnumBlockMirror mirror, EnumBlockRotation rotation) {
        return DefinedStructure.a(targetPos, mirror, rotation, this.a().u(), this.a().w());
    }

    public static BlockPosition a(BlockPosition pos, EnumBlockMirror mirror, EnumBlockRotation rotation, int sizeX, int sizeZ) {
        int i2 = mirror == EnumBlockMirror.c ? --sizeX : 0;
        int i1 = mirror == EnumBlockMirror.b ? --sizeZ : 0;
        BlockPosition blockPos = pos;
        switch (rotation) {
            case d: {
                blockPos = pos.b(i1, 0, sizeX - i2);
                break;
            }
            case b: {
                blockPos = pos.b(sizeZ - i1, 0, i2);
                break;
            }
            case c: {
                blockPos = pos.b(sizeX - i2, 0, sizeZ - i1);
                break;
            }
            case a: {
                blockPos = pos.b(i2, 0, i1);
            }
        }
        return blockPos;
    }

    public StructureBoundingBox b(DefinedStructureInfo settings, BlockPosition startPos) {
        return this.a(startPos, settings.d(), settings.e(), settings.c());
    }

    public StructureBoundingBox a(BlockPosition startPos, EnumBlockRotation rotation, BlockPosition pivotPos, EnumBlockMirror mirror) {
        return DefinedStructure.a(startPos, rotation, pivotPos, mirror, this.n);
    }

    @VisibleForTesting
    protected static StructureBoundingBox a(BlockPosition startPos, EnumBlockRotation rotation, BlockPosition pivotPos, EnumBlockMirror mirror, BaseBlockPosition size) {
        BaseBlockPosition vec3i = size.c(-1, -1, -1);
        BlockPosition blockPos = DefinedStructure.a(BlockPosition.c, mirror, rotation, pivotPos);
        BlockPosition blockPos1 = DefinedStructure.a(BlockPosition.c.a(vec3i), mirror, rotation, pivotPos);
        return StructureBoundingBox.a(blockPos, blockPos1).a((BaseBlockPosition)startPos);
    }

    public NBTTagCompound a(NBTTagCompound tag) {
        if (this.l.isEmpty()) {
            tag.a(d, new NBTTagList());
            tag.a(a, new NBTTagList());
        } else {
            ArrayList list = Lists.newArrayList();
            c simplePalette = new c();
            list.add(simplePalette);
            for (int i2 = 1; i2 < this.l.size(); ++i2) {
                list.add(new c());
            }
            NBTTagList listTag = new NBTTagList();
            List<BlockInfo> list1 = this.l.get(0).b();
            for (int i1 = 0; i1 < list1.size(); ++i1) {
                BlockInfo structureBlockInfo = list1.get(i1);
                NBTTagCompound compoundTag = new NBTTagCompound();
                compoundTag.a("pos", this.a(structureBlockInfo.a.u(), structureBlockInfo.a.v(), structureBlockInfo.a.w()));
                int i2 = simplePalette.a(structureBlockInfo.b);
                compoundTag.a(f, i2);
                if (structureBlockInfo.c != null) {
                    compoundTag.a("nbt", structureBlockInfo.c);
                }
                listTag.add(compoundTag);
                for (int i3 = 1; i3 < this.l.size(); ++i3) {
                    c simplePalette1 = (c)list.get(i3);
                    simplePalette1.a(this.l.get((int)i3).b().get((int)i1).b, i2);
                }
            }
            tag.a(d, listTag);
            if (list.size() == 1) {
                listTag1 = new NBTTagList();
                for (IBlockData blockState : simplePalette) {
                    listTag1.add(GameProfileSerializer.a(blockState));
                }
                tag.a(a, listTag1);
            } else {
                listTag1 = new NBTTagList();
                for (c simplePalette2 : list) {
                    NBTTagList listTag2 = new NBTTagList();
                    for (IBlockData blockState1 : simplePalette2) {
                        listTag2.add(GameProfileSerializer.a(blockState1));
                    }
                    listTag1.add(listTag2);
                }
                tag.a(b, listTag1);
            }
        }
        NBTTagList listTag3 = new NBTTagList();
        for (EntityInfo structureEntityInfo : this.m) {
            NBTTagCompound compoundTag1 = new NBTTagCompound();
            compoundTag1.a("pos", this.a(structureEntityInfo.a.d, structureEntityInfo.a.e, structureEntityInfo.a.f));
            compoundTag1.a(i, this.a(structureEntityInfo.b.u(), structureEntityInfo.b.v(), structureEntityInfo.b.w()));
            if (structureEntityInfo.c != null) {
                compoundTag1.a("nbt", structureEntityInfo.c);
            }
            listTag3.add(compoundTag1);
        }
        tag.a(c, listTag3);
        tag.a(k, this.a(this.n.u(), this.n.v(), this.n.w()));
        if (!this.persistentDataContainer.isEmpty()) {
            tag.a("BukkitValues", this.persistentDataContainer.toTagCompound());
        }
        return GameProfileSerializer.e(tag);
    }

    public void a(HolderGetter<Block> blockGetter, NBTTagCompound tag) {
        this.l.clear();
        this.m.clear();
        NBTTagList listOrEmpty = tag.p(k);
        this.n = new BaseBlockPosition(listOrEmpty.a(0, 0), listOrEmpty.a(1, 0), listOrEmpty.a(2, 0));
        NBTTagList listOrEmpty1 = tag.p(d);
        Optional<NBTTagList> list = tag.o(b);
        if (list.isPresent()) {
            for (int i2 = 0; i2 < list.get().size(); ++i2) {
                this.a(blockGetter, list.get().f(i2), listOrEmpty1);
            }
        } else {
            this.a(blockGetter, tag.p(a), listOrEmpty1);
        }
        tag.p(c).j().forEach(compoundTag -> {
            NBTTagList listOrEmpty2 = compoundTag.p("pos");
            Vec3D vec3 = new Vec3D(listOrEmpty2.a(0, 0.0), listOrEmpty2.a(1, 0.0), listOrEmpty2.a(2, 0.0));
            NBTTagList listOrEmpty3 = compoundTag.p(i);
            BlockPosition blockPos = new BlockPosition(listOrEmpty3.a(0, 0), listOrEmpty3.a(1, 0), listOrEmpty3.a(2, 0));
            compoundTag.m("nbt").ifPresent(compoundTag1 -> this.m.add(new EntityInfo(vec3, blockPos, (NBTTagCompound)compoundTag1)));
        });
        NBTBase nBTBase = tag.a("BukkitValues");
        if (nBTBase instanceof NBTTagCompound) {
            NBTTagCompound compoundTag2 = (NBTTagCompound)nBTBase;
            this.persistentDataContainer.putAll(compoundTag2);
        }
    }

    private void a(HolderGetter<Block> blockGetter, NBTTagList paletteTag, NBTTagList blocksTag) {
        c simplePalette = new c();
        for (int i2 = 0; i2 < paletteTag.size(); ++i2) {
            simplePalette.a(GameProfileSerializer.a(blockGetter, paletteTag.b(i2)), i2);
        }
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        blocksTag.j().forEach(compoundTag -> {
            NBTTagList listOrEmpty = compoundTag.p("pos");
            BlockPosition blockPos = new BlockPosition(listOrEmpty.a(0, 0), listOrEmpty.a(1, 0), listOrEmpty.a(2, 0));
            IBlockData blockState = simplePalette.a(compoundTag.b(f, 0));
            NBTTagCompound compoundTag1 = compoundTag.m("nbt").orElse(null);
            BlockInfo structureBlockInfo = new BlockInfo(blockPos, blockState, compoundTag1);
            DefinedStructure.a(structureBlockInfo, list, list1, list2);
        });
        List<BlockInfo> list3 = DefinedStructure.a(list, list1, list2);
        this.l.add(new b(list3));
    }

    private NBTTagList a(int ... values) {
        NBTTagList listTag = new NBTTagList();
        for (int i2 : values) {
            listTag.add(NBTTagInt.a(i2));
        }
        return listTag;
    }

    private NBTTagList a(double ... values) {
        NBTTagList listTag = new NBTTagList();
        for (double d2 : values) {
            listTag.add(NBTTagDouble.a(d2));
        }
        return listTag;
    }

    public static TileEntityJigsaw.JointType a(NBTTagCompound tag, IBlockData state) {
        return tag.a("joint", TileEntityJigsaw.JointType.c).orElseGet(() -> DefinedStructure.a(state));
    }

    public static TileEntityJigsaw.JointType a(IBlockData state) {
        return BlockJigsaw.o(state).o().d() ? TileEntityJigsaw.JointType.b : TileEntityJigsaw.JointType.a;
    }

    public record BlockInfo(BlockPosition a, IBlockData b, @Nullable NBTTagCompound c) {
        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<StructureBlockInfo | %s | %s | %s>", this.a, this.b, this.c);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{BlockInfo.class, "pos;state;nbt", "a", "b", "c"}, this, o2);
        }
    }

    public static final class b {
        private final List<BlockInfo> a;
        private final Map<Block, List<BlockInfo>> b = Maps.newConcurrentMap();
        @Nullable
        private List<a> c;

        b(List<BlockInfo> blocks) {
            this.a = blocks;
        }

        public List<a> a() {
            if (this.c == null) {
                this.c = this.a(Blocks.pH).stream().map(a::a).toList();
            }
            return this.c;
        }

        public List<BlockInfo> b() {
            return this.a;
        }

        public List<BlockInfo> a(Block block) {
            return this.b.computeIfAbsent(block, block1 -> this.a.stream().filter(structureBlockInfo -> structureBlockInfo.b.a((Block)block1)).collect(Collectors.toList()));
        }
    }

    public static class EntityInfo {
        public final Vec3D a;
        public final BlockPosition b;
        public final NBTTagCompound c;

        public EntityInfo(Vec3D pos, BlockPosition blockPos, NBTTagCompound nbt) {
            this.a = pos;
            this.b = blockPos;
            this.c = nbt;
        }
    }

    public record a(BlockInfo a, TileEntityJigsaw.JointType b, MinecraftKey c, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> d, MinecraftKey e, int f, int g) {
        public static a a(BlockInfo structureBlockInfo) {
            NBTTagCompound compoundTag = Objects.requireNonNull(structureBlockInfo.c(), () -> String.valueOf(structureBlockInfo) + " nbt was null");
            return new a(structureBlockInfo, DefinedStructure.a(compoundTag, structureBlockInfo.b()), compoundTag.a("name", MinecraftKey.a).orElse(TileEntityJigsaw.b), compoundTag.a("pool", TileEntityJigsaw.a).orElse(WorldGenFeaturePieces.a), compoundTag.a("target", MinecraftKey.a).orElse(TileEntityJigsaw.b), compoundTag.b("placement_priority", 0), compoundTag.b("selection_priority", 0));
        }

        @Override
        public String toString() {
            return String.format(Locale.ROOT, "<JigsawBlockInfo | %s | %s | name: %s | pool: %s | target: %s | placement: %d | selection: %d | %s>", this.a.a, this.a.b, this.c, this.d.a(), this.e, this.f, this.g, this.a.c);
        }

        public a b(BlockInfo info) {
            return new a(info, this.b, this.c, this.d, this.e, this.f, this.g);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "info;jointType;name;pool;target;placementPriority;selectionPriority", "a", "b", "c", "d", "e", "f", "g"}, this, o2);
        }
    }

    static class c
    implements Iterable<IBlockData> {
        public static final IBlockData a = Blocks.a.m();
        private final RegistryBlockID<IBlockData> b = new RegistryBlockID(16);
        private int c;

        c() {
        }

        public int a(IBlockData state) {
            int id = this.b.a(state);
            if (id == -1) {
                id = this.c++;
                this.b.a(state, id);
            }
            return id;
        }

        @Nullable
        public IBlockData a(int id) {
            IBlockData blockState = this.b.a(id);
            return blockState == null ? a : blockState;
        }

        @Override
        public Iterator<IBlockData> iterator() {
            return this.b.iterator();
        }

        public void a(IBlockData state, int id) {
            this.b.a(state, id);
        }
    }
}

