/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.synth;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import java.util.stream.IntStream;
import net.minecraft.util.KeyDispatchDataCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorOctaves;
import net.minecraft.world.level.levelgen.synth.NoiseGeneratorPerlin;

public class BlendedNoise
implements DensityFunction.d {
    private static final Codec<Double> e = Codec.doubleRange((double)0.001, (double)1000.0);
    private static final MapCodec<BlendedNoise> f = RecordCodecBuilder.mapCodec(instance -> instance.group((App)e.fieldOf("xz_scale").forGetter(blendedNoise -> blendedNoise.p), (App)e.fieldOf("y_scale").forGetter(blendedNoise -> blendedNoise.q), (App)e.fieldOf("xz_factor").forGetter(blendedNoise -> blendedNoise.l), (App)e.fieldOf("y_factor").forGetter(blendedNoise -> blendedNoise.m), (App)Codec.doubleRange((double)1.0, (double)8.0).fieldOf("smear_scale_multiplier").forGetter(blendedNoise -> blendedNoise.n)).apply((Applicative)instance, BlendedNoise::a));
    public static final KeyDispatchDataCodec<BlendedNoise> a = KeyDispatchDataCodec.a(f);
    private final NoiseGeneratorOctaves g;
    private final NoiseGeneratorOctaves h;
    private final NoiseGeneratorOctaves i;
    private final double j;
    private final double k;
    private final double l;
    private final double m;
    private final double n;
    private final double o;
    private final double p;
    private final double q;

    public static BlendedNoise a(double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        return new BlendedNoise(new XoroshiroRandomSource(0L), xzScale, yScale, xzFactor, yFactor, smearScaleMultiplier);
    }

    private BlendedNoise(NoiseGeneratorOctaves minLimitNoise, NoiseGeneratorOctaves maxLimitNoise, NoiseGeneratorOctaves mainNoise, double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        this.g = minLimitNoise;
        this.h = maxLimitNoise;
        this.i = mainNoise;
        this.p = xzScale;
        this.q = yScale;
        this.l = xzFactor;
        this.m = yFactor;
        this.n = smearScaleMultiplier;
        this.j = 684.412 * this.p;
        this.k = 684.412 * this.q;
        this.o = minLimitNoise.a(this.k);
    }

    @VisibleForTesting
    public BlendedNoise(RandomSource random, double xzScale, double yScale, double xzFactor, double yFactor, double smearScaleMultiplier) {
        this(NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-15, 0)), NoiseGeneratorOctaves.a(random, IntStream.rangeClosed(-7, 0)), xzScale, yScale, xzFactor, yFactor, smearScaleMultiplier);
    }

    public BlendedNoise a(RandomSource random) {
        return new BlendedNoise(random, this.p, this.q, this.l, this.m, this.n);
    }

    @Override
    public double a(DensityFunction.b context) {
        double d2 = (double)context.a() * this.j;
        double d1 = (double)context.b() * this.k;
        double d22 = (double)context.c() * this.j;
        double d3 = d2 / this.l;
        double d4 = d1 / this.m;
        double d5 = d22 / this.l;
        double d6 = this.k * this.n;
        double d7 = d6 / this.m;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        boolean flag = true;
        double d11 = 1.0;
        for (int i2 = 0; i2 < 8; ++i2) {
            NoiseGeneratorPerlin octaveNoise = this.i.a(i2);
            if (octaveNoise != null) {
                d10 += octaveNoise.a(NoiseGeneratorOctaves.b(d3 * d11), NoiseGeneratorOctaves.b(d4 * d11), NoiseGeneratorOctaves.b(d5 * d11), d7 * d11, d4 * d11) / d11;
            }
            d11 /= 2.0;
        }
        double d12 = (d10 / 10.0 + 1.0) / 2.0;
        boolean flag1 = d12 >= 1.0;
        boolean flag2 = d12 <= 0.0;
        d11 = 1.0;
        for (int i1 = 0; i1 < 16; ++i1) {
            NoiseGeneratorPerlin octaveNoise1;
            double d13 = NoiseGeneratorOctaves.b(d2 * d11);
            double d14 = NoiseGeneratorOctaves.b(d1 * d11);
            double d15 = NoiseGeneratorOctaves.b(d22 * d11);
            double d16 = d6 * d11;
            if (!flag1 && (octaveNoise1 = this.g.a(i1)) != null) {
                d8 += octaveNoise1.a(d13, d14, d15, d16, d1 * d11) / d11;
            }
            if (!flag2 && (octaveNoise1 = this.h.a(i1)) != null) {
                d9 += octaveNoise1.a(d13, d14, d15, d16, d1 * d11) / d11;
            }
            d11 /= 2.0;
        }
        return MathHelper.b(d8 / 512.0, d9 / 512.0, d12) / 128.0;
    }

    @Override
    public double a() {
        return -this.b();
    }

    @Override
    public double b() {
        return this.o;
    }

    @VisibleForTesting
    public void a(StringBuilder builder) {
        builder.append("BlendedNoise{minLimitNoise=");
        this.g.a(builder);
        builder.append(", maxLimitNoise=");
        this.h.a(builder);
        builder.append(", mainNoise=");
        this.i.a(builder);
        builder.append(String.format(Locale.ROOT, ", xzScale=%.3f, yScale=%.3f, xzMainScale=%.3f, yMainScale=%.3f, cellWidth=4, cellHeight=8", 684.412, 684.412, 8.555150000000001, 4.277575000000001)).append('}');
    }

    @Override
    public KeyDispatchDataCodec<? extends DensityFunction> c() {
        return a;
    }
}

