/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.pathfinder;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.level.ChunkCache;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathDestination;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import net.minecraft.world.level.pathfinder.PathfinderAbstract;

public class Pathfinder {
    private static final float a = 1.5f;
    private final PathPoint[] b = new PathPoint[32];
    private int c;
    public final PathfinderAbstract d;
    private static final boolean e = false;
    private final Path f = new Path();

    public Pathfinder(PathfinderAbstract nodeEvaluator, int maxVisitedNodes) {
        this.d = nodeEvaluator;
        this.c = maxVisitedNodes;
    }

    public void a(int maxVisitedNodes) {
        this.c = maxVisitedNodes;
    }

    @Nullable
    public PathEntity a(ChunkCache region, EntityInsentient mob, Set<BlockPosition> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        this.f.a();
        this.d.a(region, mob);
        PathPoint start = this.d.a();
        if (start == null) {
            return null;
        }
        ArrayList map = Lists.newArrayList();
        for (BlockPosition pos : targetPositions) {
            map.add(new AbstractMap.SimpleEntry<PathDestination, BlockPosition>(this.d.a(pos.u(), pos.v(), pos.w()), pos));
        }
        PathEntity path = this.findPath(start, map, maxRange, accuracy, searchDepthMultiplier);
        this.d.b();
        return path;
    }

    @Nullable
    private PathEntity findPath(PathPoint node, List<Map.Entry<PathDestination, BlockPosition>> positions, float maxRange, int accuracy, float searchDepthMultiplier) {
        GameProfilerFiller profilerFiller = Profiler.a();
        profilerFiller.a("find_path");
        profilerFiller.a(MetricCategory.a);
        node.e = 0.0f;
        node.g = node.f = this.getBestH(node, positions);
        this.f.a();
        this.f.a(node);
        int i2 = 0;
        ArrayList entryList = Lists.newArrayListWithExpectedSize((int)positions.size());
        int i1 = (int)((float)this.c * searchDepthMultiplier);
        while (!this.f.e() && ++i2 < i1) {
            PathPoint node1 = this.f.c();
            node1.i = true;
            int size = positions.size();
            for (int positionIndex = 0; positionIndex < size; ++positionIndex) {
                Map.Entry entry = (Map.Entry)positions.get(positionIndex);
                PathDestination target = (PathDestination)entry.getKey();
                if (!(node1.d(target) <= (float)accuracy)) continue;
                target.e();
                entryList.add(entry);
            }
            if (!entryList.isEmpty()) break;
            if (node1.a(node) >= maxRange) continue;
            int neighbors = this.d.a(this.b, node1);
            for (int i22 = 0; i22 < neighbors; ++i22) {
                PathPoint node2 = this.b[i22];
                float f2 = this.a(node1, node2);
                node2.j = node1.j + f2;
                float f1 = node1.e + f2 + node2.k;
                if (!(node2.j < maxRange) || node2.c() && !(f1 < node2.e)) continue;
                node2.h = node1;
                node2.e = f1;
                node2.f = this.getBestH(node2, positions) * 1.5f;
                if (node2.c()) {
                    this.f.a(node2, node2.e + node2.f);
                    continue;
                }
                node2.g = node2.e + node2.f;
                this.f.a(node2);
            }
        }
        PathEntity best = null;
        boolean entryListIsEmpty = entryList.isEmpty();
        Comparator<PathEntity> comparator = entryListIsEmpty ? Comparator.comparingInt(PathEntity::e) : Comparator.comparingDouble(PathEntity::m).thenComparingInt(PathEntity::e);
        for (Map.Entry entry : entryListIsEmpty ? positions : entryList) {
            PathEntity path = this.a(((PathDestination)entry.getKey()).d(), (BlockPosition)entry.getValue(), !entryListIsEmpty);
            if (best != null && comparator.compare(path, best) >= 0) continue;
            best = path;
        }
        profilerFiller.c();
        return best;
    }

    protected float a(PathPoint first, PathPoint second) {
        return first.a(second);
    }

    private float getBestH(PathPoint node, List<Map.Entry<PathDestination, BlockPosition>> targets) {
        float f2 = Float.MAX_VALUE;
        int targetsSize = targets.size();
        for (int i2 = 0; i2 < targetsSize; ++i2) {
            PathDestination target = targets.get(i2).getKey();
            float f1 = node.a(target);
            target.a(f1, node);
            f2 = Math.min(f1, f2);
        }
        return f2;
    }

    private PathEntity a(PathPoint point, BlockPosition targetPos, boolean reachesTarget) {
        ArrayList list = Lists.newArrayList();
        PathPoint node = point;
        list.add(0, point);
        while (node.h != null) {
            node = node.h;
            list.add(0, node);
        }
        return new PathEntity(list, targetPos, reachesTarget);
    }
}

